local metadata = {
"## Interface:FS15 1.4.2.0 1.4.2RC1",
"## Title: AutoLoadWood",
"## Notes: AutoLoadWood",
"## Author: Marhu - edited by kenny456",
"## Version: 0.3.0-162",
"## Date: 14.10.2017",
"## Web: http://marhu.net"
} 
--[[changes by kenny456:
-you can change number of logs piles on your trailer from 1 to 3 (12m trailer 1 to 2)
-you can show unload area to see where logs will be unloaded
-you can move, resize and rotate unload area

Controls:
KEY_B - start autoload
KEY_Z - start unload
KEY_O - change side (left / right)
KEY_KP_enter - change number of piles
KEY_KP_minus - shift unload position
KEY_KP_plus - resize unload position
KEY_KP_multiply - rotate unload position
KEY_KP_divide - show / hide unload position]]
local function L(name)
	return g_i18n:hasText("AutoLoadWood_"..name) and g_i18n:getText("AutoLoadWood_"..name) or name;
end

AutoLoadWood = {};
AutoLoadWood.Dir = g_currentModDirectory;
		
function AutoLoadWood.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(DynamicMountAttacher, specializations)
end;

function AutoLoadWood:load(savegame)
	local xmlFile = self.xmlFile

    self.toggleState = SpecializationUtil.callSpecializationsFunction("toggleState");
	
	self.doCheckSpeedLimit = Utils.overwrittenFunction(self.doCheckSpeedLimit, AutoLoadWood.doCheckSpeedLimit)
	self.dynamicMountTriggerCallback =  Utils.overwrittenFunction(self.dynamicMountTriggerCallback, AutoLoadWood.dynamicMountTriggerCallback)
	
	self.trailer = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.size#length"),15);
	self.woodLoad = {};
	self.autoload = false;
	self.rightSide = false;
	self.unload = false;
	self.numPiles = 2;
	self.markerVisible = false;
	self.unloadRot = false;
	self.shiftZ = 7.7;
	self.shiftZMax = -3.8;
	self.woodFinderPosZ = 8;
	self.fXRot = false;
	self.unloadShiftMax = 4;
	self.rootShiftRotX = 6;
	self.rootShiftRotXMax = 9;
	self.trailerEmpty = true;
	self.timer = 0;
	if self.trailer == 15 then
		self.maxLength = 7.5;
		self.startPosZ = 3.85;
		self.maxPiles = 3;
	else
		self.maxLength = 6;
		self.startPosZ = 3;
		self.maxPiles = 2;
	end
	self.searchSizeY = 3
	self.searchSizeZ = 10
	self.autoLoadSpeed = 500
	self.autoLoadElaps = 0;
	
	if self.isServer then
		local key = "vehicle.AutoLoadWood.woodTrigger";
		local woodTriggerXOff = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#xOff"),1.1);
		local woodTriggerYOff = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#yOff"),-3);
		local woodTriggerZOff = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#zOff"),1.5);
		
		local key = "vehicle.AutoLoadWood.fillPose";
		local fillPoseXOff = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#xOff"),0.7);
		local fillPoseYOff = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#yOff"),1.8);
		local fillPoseZOff = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#zOff"),4.1);
		
		local key = "vehicle.AutoLoadWood.unloadPose";
		local unloadPoseXOff = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#xOff"),0);
		--local unloadPoseYOff = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#yOff"),15);
		local unloadPoseYOff = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#yOff"),3);
		local unloadPoseZOff = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#zOff"),0);
		
		local linkNode = getParent(self.dynamicMountAttacherTrigger.triggerNode)
		local x,y,z = getTranslation(self.dynamicMountAttacherTrigger.triggerNode)
		
		self.woodTrigger = {createTransformGroup("woodTrigger1"),
							createTransformGroup("woodTrigger2"),
							createTransformGroup("woodTrigger3"),
							createTransformGroup("woodTrigger4")};
		local rot = math.rad(90)
		for i = 1, 4 do					
			link(linkNode, self.woodTrigger[i]);
			setTranslation(self.woodTrigger[i], x + woodTriggerXOff, y + woodTriggerYOff, z + woodTriggerZOff)
			setRotation(self.woodTrigger[i], 0, rot, 0);
			woodTriggerZOff = woodTriggerZOff * -1;
			if i == 2 then 
				woodTriggerXOff = woodTriggerXOff * -1;
				rot = math.rad(-90)
			end
		end
			
		self.fillPoseNode = createTransformGroup("fillPoseNode");
		link(linkNode,self.fillPoseNode);
		self.fillPoseNodeX = x + fillPoseXOff
		self.fillPoseNodeY = y + fillPoseYOff
		self.fillPoseNodeZ = self.startPosZ
		setTranslation(self.fillPoseNode, x + fillPoseXOff, y + fillPoseYOff, self.fillPoseNodeZ)
		setRotation(self.fillPoseNode,math.rad(-90),0,0)
		
		self.unloadPoseRoot = {	createTransformGroup("unloadPoseRoot1"),
								createTransformGroup("unloadPoseRoot2")};
		self.unloadPoseNode = {	createTransformGroup("unloadPoseNode1"),
								createTransformGroup("unloadPoseNode2")};
		self.unloadPoseRootX = 3
		self.unloadPoseRootY = 0
		self.unloadPoseRootZ = z
		for i = 1, 2 do
			link(linkNode, self.unloadPoseRoot[i]);
			setTranslation(self.unloadPoseRoot[i],self.unloadPoseRootX,0,0)
			setRotation(self.unloadPoseRoot[i],math.rad(0),math.rad(0),0)
			self.unloadPoseRootX = self.unloadPoseRootX * -1;
		end
		
		self.unloadPoseNodeX =  unloadPoseXOff
		self.unloadPoseNodeY  = y + unloadPoseYOff
		self.unloadPoseNodeZ  = unloadPoseZOff
		for i = 1, 2 do					
			link(self.unloadPoseRoot[i], self.unloadPoseNode[i]);
			setTranslation(self.unloadPoseNode[i], self.unloadPoseNodeX, self.unloadPoseNodeY, self.unloadPoseNodeZ)
			setRotation(self.unloadPoseNode[i],math.rad(-90),math.rad(0),0)
			unloadPoseXOff = unloadPoseXOff * -1;
		end
		
		self.woodFinder = {createTransformGroup("woodFinder1"),
							createTransformGroup("woodFinder2"),
							createTransformGroup("woodFinder3"),
							createTransformGroup("woodFinder4"),
							createTransformGroup("woodFinder5"),
							createTransformGroup("woodFinder6"),
							createTransformGroup("woodFinder7"),
							createTransformGroup("woodFinder8")};
		self.woodFinderX = -1.54
		self.woodFinderY = y - 0.28
		self.woodFinderZ = self.woodFinderPosZ
		local rot = math.rad(90)
		local j = 1
		for i = 1, 8 do
			link(self.unloadPoseRoot[j], self.woodFinder[i]);
			if i == 1 or i == 4 or i == 5 or i == 8 then
				self.woodFinderZ = self.woodFinderPosZ * 2
			else
				self.woodFinderZ = self.woodFinderPosZ
			end
			if i == 3  or i == 4 or i == 7 or i == 8 then
				self.woodFinderZ = self.woodFinderZ * -1;
			end
			setTranslation(self.woodFinder[i], self.woodFinderX, self.woodFinderY, self.woodFinderZ)
			setRotation(self.woodFinder[i], 0, rot, 0);
			if i == 4 then 
				self.woodFinderX = self.woodFinderX * -1;
				rot = math.rad(-90)
				j = j + 1
			end
		end
		self.woodFinderX = self.woodFinderX * -1;
		self.marker = Utils.indexToObject(self.components,getXMLString(xmlFile, "vehicle.marker2#index"));
		if self.marker ~= nil then
			self.markerX, self.markerY, self.markerZ = getTranslation(self.marker)
			setVisibility(self.marker, false);
			setScale(self.marker, self.maxLength,1,1)
			link(self.unloadPoseRoot[1], self.marker);
		end
	end;
end;

function AutoLoadWood:postLoad(savegame) 
	if savegame ~= nil then
		self.numPiles = Utils.getNoNil(getXMLFloat(savegame.xmlFile, savegame.key .. "#numPiles"), self.numPiles);
		if self.numPiles == 1 then
			self.shiftZ = 0;
			self.shiftZMax = self.fillPoseNodeZ;
			if self.trailer == 15 then
				self.maxLength = 15;
				self.startPosZ = 0;
			else
				self.maxLength = 12;
				self.startPosZ = 0;
			end
			self.woodFinderPosZ = 12;
		elseif self.numPiles == 2 then
			if self.trailer == 15 then
				self.maxLength = 7.5;
				self.startPosZ = 3.85;
				self.shiftZ = 7.7;
				self.shiftZMax = -3.8;
				self.woodFinderPosZ = 8;
				self.maxPiles = 3;
			else
				self.maxLength = 6;
				self.startPosZ = 3;
				self.shiftZ = 6.3;
				self.shiftZMax = -3.2;
				self.woodFinderPosZ = 6.5;
				self.maxPiles = 2;
			end
		else
			self.maxLength = 5;
			self.shiftZ = 5.3;
			self.shiftZMax = -5.6;
			self.startPosZ = 4.8;
			self.woodFinderPosZ = 5;
		end
		setTranslation(self.fillPoseNode, self.fillPoseNodeX, self.fillPoseNodeY, self.startPosZ)
		for i = 1, 8 do					
			if i == 1 or i == 4 or i == 5 or i == 8 then
				self.woodFinderZ = self.woodFinderPosZ * 2
			else
				self.woodFinderZ = self.woodFinderPosZ
			end
			if i == 3  or i == 4 or i == 7 or i == 8 then
				self.woodFinderZ = self.woodFinderZ * -1;
			end
			setTranslation(self.woodFinder[i], self.woodFinderX, self.woodFinderY, self.woodFinderZ)
			if i == 4 then 
				self.woodFinderX = self.woodFinderX * -1;
			end
		end
		self.woodFinderX = self.woodFinderX * -1;
		setScale(self.marker, self.maxLength,1,1)
	end
end;


function AutoLoadWood:delete()
end;

function AutoLoadWood:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AutoLoadWood:keyEvent(unicode, sym, modifier, isDown)
end;

function AutoLoadWood:update(dt)
	self.timer = self.timer + dt
	if self:getIsActiveForInput() then
	
	
		if InputBinding.hasEvent(InputBinding.WAL_TOGGLE_AUTO) then
			self:toggleState(not self.autoload, self.rightSide, false, self.numPiles, self.markerVisible, self.unloadRot)
		end;
		if InputBinding.hasEvent(InputBinding.WAL_TOGGLE_UNLOAD) then
			self:toggleState(false, self.rightSide, not self.unload, self.numPiles, self.markerVisible, self.unloadRot)
		end
		if InputBinding.hasEvent(InputBinding.WAL_TOGGLE_SIDE) then
			local triggerNum = (self.rightSide and 2 or 1);
			unlink(self.marker)
			rotate(self.marker, 0,math.rad(180),0)
			local mX,mY,mZ = getTranslation(self.marker)
			mX = mX * -1
			setTranslation(self.marker, mX,mY,mZ)
			link(self.unloadPoseRoot[self.rightSide and 1 or 2], self.marker);
			self:toggleState(false, not self.rightSide, false, self.numPiles, self.markerVisible, self.unloadRot)
			local mX,mY,mZ = getTranslation(self.marker)
		end
		if InputBinding.hasEvent(InputBinding.WAL_TOGGLE_PILES) then
			if self.trailerEmpty == false then
				self.timer = 0
				self.msgShow = true
			else
				if self.numPiles < self.maxPiles then
					piles = self.numPiles + 1;
				else
					piles = 1;
				end;
				if piles == 1 then
					self.rootShiftRotX = 9
					self.rootShiftRotXMax = 12
				else
					self.rootShiftRotX = 6
					self.rootShiftRotXMax = 9
				end
				local j = 1
				for i = 1, 2 do
						setTranslation(self.unloadPoseRoot[i], (self.unloadRot and self.rootShiftRotX or self.unloadPoseRootX) * j, self.unloadPoseRootY, (self.unloadRot and 3 or self.unloadPoseRootZ))
						j = j * -1
				end
				self:toggleState(false, self.rightSide, false, piles, self.markerVisible, self.unloadRot)
				setTranslation(self.fillPoseNode, self.fillPoseNodeX, self.fillPoseNodeY, self.startPosZ)
				for i = 1, 8 do					
					if i == 1 or i == 4 or i == 5 or i == 8 then
						self.woodFinderZ = self.woodFinderPosZ * 2
					else
						self.woodFinderZ = self.woodFinderPosZ
					end
					if i == 3  or i == 4 or i == 7 or i == 8 then
						self.woodFinderZ = self.woodFinderZ * -1;
					end
					setTranslation(self.woodFinder[i], self.woodFinderX, self.woodFinderY, self.woodFinderZ)
					if i == 4 then 
						self.woodFinderX = self.woodFinderX * -1;
					end
				end
				self.woodFinderX = self.woodFinderX * -1;
				setScale(self.marker, self.maxLength,1,1)
				self.unloadShiftMax = 4
			end
		end
		if InputBinding.hasEvent(InputBinding.WAL_TOGGLE_MARKER) then
			setVisibility(self.marker, not getVisibility(self.marker));
			self:toggleState(self.autoload, self.rightSide, self.unload, self.numPiles, not self.markerVisible, self.unloadRot)
		end
		if InputBinding.hasEvent(InputBinding.WAL_TOGGLE_ROTATE) then
			local j = 1
			for i = 1, 2 do
				setRotation(self.unloadPoseRoot[i], 0,(self.unloadRot and math.rad(0) or math.rad(90)) * j,0)
				setTranslation(self.unloadPoseRoot[i], (self.unloadRot and self.unloadPoseRootX or self.rootShiftRotX) * j, 0, (self.unloadRot and self.unloadPoseRootZ or 3))
				setTranslation(self.unloadPoseNode[i], self.unloadPoseNodeX, self.unloadPoseNodeY, self.unloadPoseNodeZ)
				j = j * -1
			end
			setTranslation(self.marker, self.markerX, self.markerY, self.markerZ)
			self:toggleState(false, self.rightSide, false, self.numPiles, self.markerVisible, not self.unloadRot)
		end
		if InputBinding.hasEvent(InputBinding.WAL_MARKER_MOVE) then
			local rX,rY,rZ = getTranslation(self.unloadPoseRoot[1])
			if self.unloadRot == true then
				rX = math.abs(rX)
				if rX < self.rootShiftRotXMax then
					rX = rX + 1
				else
					rX = self.rootShiftRotX
				end
				local j = 1
				for i = 1, 2 do
					setTranslation(self.unloadPoseRoot[i], rX * j, self.unloadPoseRootY, 3)
					j = j * -1
				end
			else
				rX = math.abs(rX)
				if rX < 6 then
					rX = rX + 1
				else
					rX = self.unloadPoseRootX
				end
				local j = 1
				for i = 1, 2 do
					setTranslation(self.unloadPoseRoot[i], j * rX, self.unloadPoseRootY, self.unloadPoseRootZ)
					j = j * -1
				end
			end
			local j = 1
			for i = 1, 2 do
				j = j * -1
			end
		end
		if InputBinding.hasEvent(InputBinding.WAL_MARKER_SCALE) then
			local msX,msY,msZ = getScale(self.marker)
			if msZ < 2 then
				msZ = msZ + 0.2
			else
				msZ = 1
			end
			self.unloadShiftMax = msZ * 4
			setScale(self.marker, msX,msY,msZ)
		end
	local xW,yW,zW = getWorldTranslation(self.woodFinder[1]);
	--drawDebugPoint(xW,yW,zW,1,0.5,1,1);
	end;
	
	if false then
		for i = 1, 4 do
			local x,y,z = getWorldTranslation(self.woodTrigger[i])
			local nx, ny, nz = localDirectionToWorld(self.woodTrigger[i], 1, 0, 0)
			local yx, yy, yz = localDirectionToWorld(self.woodTrigger[i], 0, self.searchSizeY, 0)
			local zx, zy, zz = localDirectionToWorld(self.woodTrigger[i], 0, 0, self.searchSizeZ)
			drawDebugLine(x,y,z, 1, 0, 0, x + nx, y + ny, z + nz, 1, 0, 0);
			drawDebugLine(x,y,z, 0, 1, 0, x + yx, y + yy, z + yz, 0, 1, 0);
			drawDebugLine(x,y,z, 0, 0, 1, x + zx, y + zy, z + zz, 0, 0, 1);
		end
		
		local x,y,z = getWorldTranslation(self.fillPoseNode)
		local nx, ny, nz = localDirectionToWorld(self.fillPoseNode, 1, 0, 0)
		local yx, yy, yz = localDirectionToWorld(self.fillPoseNode, 0, 1, 0)
		local zx, zy, zz = localDirectionToWorld(self.fillPoseNode, 0, 0, 1)
		drawDebugLine(x,y,z, 1, 0, 0, x + nx, y + ny, z + nz, 1, 0, 0);
		drawDebugLine(x,y,z, 0, 1, 0, x + yx, y + yy, z + yz, 0, 1, 0);
		drawDebugLine(x,y,z, 0, 0, 1, x + zx, y + zy, z + zz, 0, 0, 1);
		
		for i = 1, 2 do
			local x,y,z = getWorldTranslation(self.unloadPoseNode[i])
			local nx, ny, nz = localDirectionToWorld(self.unloadPoseNode[i], 1, 0, 0)
			local yx, yy, yz = localDirectionToWorld(self.unloadPoseNode[i], 0, 1, 0)
			local zx, zy, zz = localDirectionToWorld(self.unloadPoseNode[i], 0, 0, 1)
			drawDebugLine(x,y,z, 1, 0, 0, x + nx, y + ny, z + nz, 1, 0, 0);
			drawDebugLine(x,y,z, 0, 1, 0, x + yx, y + yy, z + yz, 0, 1, 0);
			drawDebugLine(x,y,z, 0, 0, 1, x + zx, y + zy, z + zz, 0, 0, 1);
		end
		
		if self.lastWoodShapes ~= nil and entityExists(self.lastWoodShapes) then
			local x,y,z = getWorldTranslation(self.lastWoodShapes)
			local nx, ny, nz = localDirectionToWorld(self.lastWoodShapes, 10, 0, 0)
			local yx, yy, yz = localDirectionToWorld(self.lastWoodShapes, 0, 10, 0)
			local zx, zy, zz = localDirectionToWorld(self.lastWoodShapes, 0, 0, 10)
			drawDebugLine(x,y,z, 1, 0, 0, x + nx, y + ny, z + nz, 1, 0, 0);
			drawDebugLine(x,y,z, 0, 1, 0, x + yx, y + yy, z + yz, 0, 1, 0);
			drawDebugLine(x,y,z, 0, 0, 1, x + zx, y + zy, z + zz, 0, 0, 1);
		end
		
		for i = 1, 8 do
			local x,y,z = getWorldTranslation(self.woodFinder[i])
			local nx, ny, nz = localDirectionToWorld(self.woodFinder[i], 1, 0, 0)
			local yx, yy, yz = localDirectionToWorld(self.woodFinder[i], 0, 1, 0)
			local zx, zy, zz = localDirectionToWorld(self.woodFinder[i], 0, 0, 1)
			drawDebugLine(x,y,z, 1, 0, 0, x + nx, y + ny, z + nz, 1, 0, 0);
			drawDebugLine(x,y,z, 0, 1, 0, x + yx, y + yy, z + yz, 0, 1, 0);
			drawDebugLine(x,y,z, 0, 0, 1, x + zx, y + zy, z + zz, 0, 0, 1);
		end
		for i = 1, 2 do
			local x,y,z = getWorldTranslation(self.unloadPoseRoot[i])
			local nx, ny, nz = localDirectionToWorld(self.unloadPoseRoot[i], 1, 0, 0)
			local yx, yy, yz = localDirectionToWorld(self.unloadPoseRoot[i], 0, 1, 0)
			local zx, zy, zz = localDirectionToWorld(self.unloadPoseRoot[i], 0, 0, 1)
			drawDebugLine(x,y,z, 1, 0, 0, x + nx, y + ny, z + nz, 1, 0, 0);
			drawDebugLine(x,y,z, 0, 1, 0, x + yx, y + yy, z + yz, 0, 1, 0);
			drawDebugLine(x,y,z, 0, 0, 1, x + zx, y + zy, z + zz, 0, 0, 1);
		end
	end
end;

function AutoLoadWood:updateTick(dt)
	if self.autoload then
		self.autoLoadElaps = self.autoLoadElaps + dt;
		if self.autoLoadElaps >= self.autoLoadSpeed then
			self.autoLoadElaps = 0;
			if self.isServer then
				local fX,fY,fZ = getTranslation(self.fillPoseNode)
				if entityExists(self.lastWoodShapes) and self.woodLoad[self.lastWoodShapes] == nil then
					if fZ > self.shiftZMax then
						fZ = fZ - self.shiftZ
						fX = 0.7
						setTranslation(self.fillPoseNode, fX, fY, fZ)
					else
						fZ = self.startPosZ
						setTranslation(self.fillPoseNode,fX, fY, fZ)
						self:toggleState(false, self.rightSide, self.unload, self.numPiles, self.markerVisible, self.unloadRot)
						return;
					end;
				end;
				local triggerNum = (self.rightSide and 2 or 0) + 1;
				local x,y,z = getWorldTranslation(self.woodTrigger[triggerNum])
				local nx, ny, nz = localDirectionToWorld(self.woodTrigger[triggerNum], 1, 0, 0)
				local yx, yy, yz = localDirectionToWorld(self.woodTrigger[triggerNum], 0, 1, 0)
				local shape, minY, maxY, minZ, maxZ = findSplitShape(x, y, z, nx, ny, nz, yx, yy, yz, self.searchSizeY, self.searchSizeZ)
				if shape == nil or not entityExists(shape) or getRigidBodyType(shape) ~= "Dynamic" then
					triggerNum = triggerNum + 1;
					x,y,z = getWorldTranslation(self.woodTrigger[triggerNum])
					nx, ny, nz = localDirectionToWorld(self.woodTrigger[triggerNum], 1, 0, 0)
					yx, yy, yz = localDirectionToWorld(self.woodTrigger[triggerNum], 0, 1, 0)
					shape, minY, maxY, minZ, maxZ = findSplitShape(x, y, z, nx, ny, nz, yx, yy, yz, self.searchSizeY, self.searchSizeZ)
				end	
				if shape ~= nil and entityExists(shape) and getRigidBodyType(shape) == "Dynamic" then
					print('found')
					local sizeX, sizeY, sizeZ, numConvexes = getSplitShapeStats(shape)
					if fX < 0.5 then
						fX = fX + 0.5;
					else
						fX = -0.8;
						if sizeX < self.maxLength + 0.2 and sizeX > self.maxLength - 0.2 then
							rotate(self.fillPoseNode, 0, math.rad(180), 0)
							self.fXRot = not self.fXRot
						end
					end
					setTranslation(self.fillPoseNode, fX, fY, fZ)
					if sizeY > sizeX then
						sizeX, sizeY = sizeY, sizeX
					end;
					--if sizeX >= 0.5 and sizeY > 0.2 and sizeZ > 0.2 then
						local a, b, c = localToWorld(self.woodTrigger[triggerNum], 0, (minY + maxY)*0.5, (minZ + maxZ)*0.5)
						local sx,sy,sz = getWorldTranslation(shape)
						local dist = Utils.vector3Length(a - sx, b - sy, c - sz)
						local nx, ny, nz = localDirectionToWorld(shape, 0, 1, 0)
						local lenBelow, lenAbove = getSplitShapePlaneExtents(shape, a, b, c, nx, ny, nz);
						dist = dist - lenBelow
						local diffX = (self.maxLength - sizeX) * 0.5 * (self.fXRot and -1 or 1)
						local wx,wy,wz = localToWorld(self.fillPoseNode,0,-dist - (sizeX/2) - diffX,0)
						local dx,dy,dz = worldToLocal(getParent(shape),wx,wy,wz)
						local nx, ny, nz = localDirectionToWorld(self.fillPoseNode, 1, 0, 0)
						local yx, yy, yz = localDirectionToWorld(self.fillPoseNode, 0, 1, 0)
						local x, y, z = worldDirectionToLocal(getParent(shape), nx, ny, nz)
						local xdir, ydir, zdir = worldDirectionToLocal(getParent(shape), yx, yy, yz)
						removeFromPhysics(shape)
						setTranslation(shape,dx,dy,dz)
						setDirection(shape, x, y, z, xdir, ydir, zdir)
						addToPhysics(shape)
						self.lastWoodShapes = shape
					--end
				end
			end
		end
	elseif self.unload then
		self.autoLoadElaps = self.autoLoadElaps + dt;
		if self.autoLoadElaps >= self.autoLoadSpeed then
			self.autoLoadElaps = 0;
			if self.isServer then
				setTranslation(self.fillPoseNode, self.fillPoseNodeX, self.fillPoseNodeY, self.startPosZ)
				local side = self.rightSide and 2 or 1;
				local uX,uY,uZ = getTranslation(self.unloadPoseNode[side])
				
				local x,y,z = getWorldTranslation(self.fillPoseNode)
				local findWood = false;
				for k, shape in pairs(self.woodLoad) do
					if entityExists(shape) then
						local sx,sy,sz = getWorldTranslation(shape)
						local dist = Utils.vector2Length(x - sx, z - sz)
						local WfX = 0
						uX = math.abs(uX)
						if uX < self.unloadPoseNodeX + self.unloadShiftMax then
							uX = uX + 0.6
							if uX > 2 then
								if side == 1 then
									WfX = uX - 1.5
								else
									WfX = -uX + 1.5
								end
							else
								if side == 1 then
									WfX = -1.5
								else
									WfX = 1.5
								end
							end
						else
							WfX = (uX - 1.5) * (self.rightSide and -1 or 1)
							uX = self.unloadPoseNodeX
						end
						setTranslation(self.unloadPoseNode[side], (self.rightSide and -1 or 1) * uX, uY, uZ)
						for i = 1, 4 do
							local wfX,wfY,wfZ = getTranslation(self.woodFinder[(self.rightSide and 4 or 0) + i])
							--[[if side == 1 then
								if wfX < self.woodFinderX + self.unloadShiftMax + 0.5 then
									wfX = wfX + 0.6
								else
									wfX = self.woodFinderX
								end
							elseif side == 2 then
								if wfX > -self.woodFinderX - self.unloadShiftMax - 0.5 then
									wfX = wfX - 0.6
								else
									wfX = -self.woodFinderX
								end
							end]]
							setTranslation(self.woodFinder[(self.rightSide and 4 or 0) + i], WfX, wfY, wfZ)
							print(WfX ..','.. wfY..','.. wfZ)
						end
						
						if dist < 100 then
							local wx,wy,wz = localToWorld(self.unloadPoseNode[side],0,-dist,0)
							local dx,dy,dz = worldToLocal(getParent(shape),wx,wy,wz)
							local nx, ny, nz = localDirectionToWorld(self.unloadPoseNode[side], 1, 0, 0)
							local yx, yy, yz = localDirectionToWorld(self.unloadPoseNode[side], 0, 1, 0)
							local x, y, z = worldDirectionToLocal(getParent(shape), nx, ny, nz)
							local xdir, ydir, zdir = worldDirectionToLocal(getParent(shape), yx, yy, yz)
							setVisibility(shape, false)
							removeFromPhysics(shape)
							setTranslation(shape,dx,dy,dz)
							setDirection(shape, x, y, z, xdir, ydir, zdir)
							addToPhysics(shape)
							local triggerNum = (self.rightSide and 4 or 0) + 1;
							local wx,wy,wz = getWorldTranslation(self.woodFinder[triggerNum])
							local nx, ny, nz = localDirectionToWorld(self.woodFinder[triggerNum], 1, 0, 0)
							local yx, yy, yz = localDirectionToWorld(self.woodFinder[triggerNum], 0, 1, 0)
							self.shape1, minY, maxY, minZ, maxZ = findSplitShape(wx, wy, wz, nx, ny, nz, yx, yy, yz, 5, 15)
							triggerNum = triggerNum + 1
							local wx,wy,wz = getWorldTranslation(self.woodFinder[triggerNum])
							local nx, ny, nz = localDirectionToWorld(self.woodFinder[triggerNum], 1, 0, 0)
							local yx, yy, yz = localDirectionToWorld(self.woodFinder[triggerNum], 0, 1, 0)
							self.shape2, minY, maxY, minZ, maxZ = findSplitShape(wx, wy, wz, nx, ny, nz, yx, yy, yz, 5, 15)
							triggerNum = triggerNum + 1
							local wx,wy,wz = getWorldTranslation(self.woodFinder[triggerNum])
							local nx, ny, nz = localDirectionToWorld(self.woodFinder[triggerNum], 1, 0, 0)
							local yx, yy, yz = localDirectionToWorld(self.woodFinder[triggerNum], 0, 1, 0)
							self.shape3, minY, maxY, minZ, maxZ = findSplitShape(wx, wy, wz, nx, ny, nz, yx, yy, yz, 5, 15)
							triggerNum = triggerNum + 1
							local wx,wy,wz = getWorldTranslation(self.woodFinder[triggerNum])
							local nx, ny, nz = localDirectionToWorld(self.woodFinder[triggerNum], 1, 0, 0)
							local yx, yy, yz = localDirectionToWorld(self.woodFinder[triggerNum], 0, 1, 0)
							self.shape4, minY, maxY, minZ, maxZ = findSplitShape(wx, wy, wz, nx, ny, nz, yx, yy, yz, 5, 15)
							local lx,ly,lz = getTranslation(self.woodFinder[1]);
							if self.lastShape ~= nil then
								setVisibility(self.lastShape, true)
								if self.shape1 ~= nil and entityExists(self.shape1) and self.shape1 == self.lastShape then
									removeFromPhysics(self.lastShape)
									local wx,wy,wz = localToWorld(self.unloadPoseNode[side],0.5,-self.lastDist+(self.shiftZ*2),0)
									local dx,dy,dz = worldToLocal(getParent(self.lastShape),wx,wy,wz)
									setTranslation(self.lastShape,dx,dy,dz)
									addToPhysics(self.lastShape)
								end
								if self.shape2 ~= nil and entityExists(self.shape2) and self.shape2 == self.lastShape then
									removeFromPhysics(self.lastShape)
									local wx,wy,wz = localToWorld(self.unloadPoseNode[side],0.5,-self.lastDist+self.shiftZ,0)
									local dx,dy,dz = worldToLocal(getParent(self.lastShape),wx,wy,wz)
									setTranslation(self.lastShape,dx,dy,dz)
									addToPhysics(self.lastShape)
								end
								if self.shape3 ~= nil and entityExists(self.shape3) and self.shape3 == self.lastShape then
									removeFromPhysics(self.lastShape)
									local wx,wy,wz = localToWorld(self.unloadPoseNode[side],0.5,-self.lastDist-self.shiftZ,0)
									local dx,dy,dz = worldToLocal(getParent(self.lastShape),wx,wy,wz)
									setTranslation(self.lastShape,dx,dy,dz)
									addToPhysics(self.lastShape)
								end
								if self.shape4 ~= nil and entityExists(self.shape4) and self.shape4 == self.lastShape then
									removeFromPhysics(self.lastShape)
									local wx,wy,wz = localToWorld(self.unloadPoseNode[side],0.5,-self.lastDist-(self.shiftZ*2),0)
									local dx,dy,dz = worldToLocal(getParent(self.lastShape),wx,wy,wz)
									setTranslation(self.lastShape,dx,dy,dz)
									addToPhysics(self.lastShape)
								end
							end
							self.lastShape = shape
							self.delShape = shape
							self.lastDist = dist
							self:dynamicMountTriggerCallback(self.dynamicMountAttacherTrigger.triggerNode, shape, false, true, false, shape)
							findWood = true;
							break;
						else
							self.woodLoad[k] = nil
						end
					else
						self.woodLoad[k] = nil
					end
				end
				if findWood == false then
					self:toggleState(self.autoload, self.rightSide, false, self.numPiles, self.markerVisible, self.unloadRot)
					if side == 2 then
						setTranslation(self.unloadPoseNode[side], 0, uY, uZ)
					else
						setTranslation(self.unloadPoseNode[side], 0, uY, uZ)
					end
					setTranslation(self.fillPoseNode, self.fillPoseNodeX, self.fillPoseNodeY, self.startPosZ)
					self.trailerEmpty = true;
					delete(self.delShape)
				end;
			end;
		end;
	end
end

function AutoLoadWood:readStream(streamId, connection)
end;

function AutoLoadWood:writeStream(streamId, connection)
end;

function AutoLoadWood:readUpdateStream(streamId, timestamp, connection)
end;

function AutoLoadWood:writeUpdateStream(streamId, connection, dirtyMask)
end;

function AutoLoadWood:draw()
	if self.isClient and self:getIsActiveForInput() then
		if self.autoload then
			g_currentMission:addHelpButtonText(L("OFF"), InputBinding.WAL_TOGGLE_AUTO);
		else
			g_currentMission:addHelpButtonText(L("ON"), InputBinding.WAL_TOGGLE_AUTO);
		end
		if self.unload then
			g_currentMission:addHelpButtonText(L("stopUnload"), InputBinding.WAL_TOGGLE_UNLOAD);
		else
			g_currentMission:addHelpButtonText(L("unload"), InputBinding.WAL_TOGGLE_UNLOAD);
		end
		if self.rightSide then
			g_currentMission:addHelpButtonText(L("right"), InputBinding.WAL_TOGGLE_SIDE);
		else
			g_currentMission:addHelpButtonText(L("left"), InputBinding.WAL_TOGGLE_SIDE);
		end
		g_currentMission:addHelpButtonText(g_i18n:getText("WAL_TOGGLE_PILES") .. " : " .. string.format(" %s",self.numPiles) .. " (max." .. string.format(" %s",self.maxLength) .. " m)", InputBinding.WAL_TOGGLE_PILES);
		if self.markerVisible == true then
			g_currentMission:addHelpButtonText(g_i18n:getText("AutoLoadWood_markerOff"),InputBinding.WAL_TOGGLE_MARKER);
			g_currentMission:addHelpButtonText(g_i18n:getText("WAL_TOGGLE_ROTATE"),InputBinding.WAL_TOGGLE_ROTATE);
			g_currentMission:addHelpButtonText(g_i18n:getText("WAL_MARKER_SCALE"),InputBinding.WAL_MARKER_SCALE);
			g_currentMission:addHelpButtonText(g_i18n:getText("WAL_MARKER_MOVE"),InputBinding.WAL_MARKER_MOVE);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("AutoLoadWood_markerOn"),InputBinding.WAL_TOGGLE_MARKER);
		end
		if self.timer < 2000 and self.msgShow == true and self.trailerEmpty == false then
				setTextColor(1,0.1,0.1,1); setTextBold(true);
				renderText(0.3, 0.72, 0.03, g_i18n:getText("WAL_EMPTY"))
				setTextColor(1,1,1,1); setTextBold(false);
		else
			 self.msgShow = false
		end
	end;
end;

function AutoLoadWood:onAttach()
end; 

function AutoLoadWood:onDetach()
end;

function AutoLoadWood:onLeave()
end

function AutoLoadWood:getSaveAttributesAndNodes(nodeIdent)

	local attributes = 'numPiles="' .. tostring(self.numPiles) .. '"';
	return attributes;
end

function AutoLoadWood:toggleState(autoload, rightSide, unload, piles, markerVisible, unloadRot, noEventSend)

	AutoLoadWoodToggleEvent.sendEvent(self, autoload, rightSide, unload, piles, markerVisible, unloadRot, noEventSend)
	self.lastWoodShapes = 0;
	self.autoload = autoload;
	self.rightSide = rightSide;
	self.unload = unload;
	self.numPiles = piles;
	self.markerVisible = markerVisible;
	self.unloadRot = unloadRot;
	if self.numPiles == 1 then
		self.shiftZ = 0;
		self.shiftZMax = self.fillPoseNodeZ;
		if self.trailer == 15 then
			self.maxLength = 15;
			self.startPosZ = 0;
		else
			self.maxLength = 12;
			self.startPosZ = 0;
		end
		self.woodFinderPosZ = 12;
	elseif self.numPiles == 2 then
		if self.trailer == 15 then
			self.maxLength = 7.5;
			self.startPosZ = 3.85;
			self.shiftZ = 7.7;
			self.shiftZMax = -3.8;
			self.woodFinderPosZ = 8;
			self.maxPiles = 3;
		else
			self.maxLength = 6;
			self.startPosZ = 3;
			self.shiftZ = 6.3;
			self.shiftZMax = -3.2;
			self.woodFinderPosZ = 6.5;
			self.maxPiles = 2;
		end
	else
		self.maxLength = 5;
		self.shiftZ = 5.3;
		self.shiftZMax = -5.6;
		self.startPosZ = 4.8;
		self.woodFinderPosZ = 5;
	end
	self.lastShape = nil
	self.lastDist = nil
end;

function AutoLoadWood:doCheckSpeedLimit(superFunc)
	local parent = true

	if superFunc ~= nil then
		parent = superFunc(self)
	end
	
	return parent and (self.autoload or self.unload);
end

function AutoLoadWood:getDefaultSpeedLimit()
	return 10
end

function AutoLoadWood:dynamicMountTriggerCallback(superFunc,triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	local splitType = SplitUtil.splitTypes[getSplitType(otherActorId)]
	if splitType ~= nil then
		if onEnter then
			self.woodLoad[otherActorId] = otherActorId
			self.trailerEmpty = false;
		elseif onLeave then
			self.woodLoad[otherActorId] = nil;
		end
	end
	superFunc(self, triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
end

--- Event ---

AutoLoadWoodToggleEvent = {};
AutoLoadWoodToggleEvent_mt = Class(AutoLoadWoodToggleEvent, Event);

InitEventClass(AutoLoadWoodToggleEvent, "AutoLoadWoodToggleEvent");

function AutoLoadWoodToggleEvent:emptyNew()
    local self = Event:new(AutoLoadWoodToggleEvent_mt);
    return self;
end;
    
function AutoLoadWoodToggleEvent:new(object, autoload, rightSide, unload, piles, markerVisible, unloadRot)
	local self = AutoLoadWoodToggleEvent:emptyNew()
	self.object = object;
	self.autoload = autoload;
	self.rightSide = rightSide;
	self.unload = unload;
	self.numPiles = piles;
	self.markerVisible = markerVisible;
	self.unloadRot = unloadRot;
	return self;
end;

function AutoLoadWoodToggleEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.autoload = streamReadBool(streamId);
	self.rightSide = streamReadBool(streamId);
	self.unload = streamReadBool(streamId);
	self.numPiles = streamReadInt32(streamId);
	self.markerVisible = streamReadBool(streamId);
	self.unloadRot = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function AutoLoadWoodToggleEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.autoload);
	streamWriteBool(streamId, self.rightSide);
	streamWriteBool(streamId, self.unload);
	streamWriteInt32(streamId, self.numPiles);
	streamWriteBool(streamId, self.markerVisible);
	streamWriteBool(streamId, self.unloadRot);
end;

function AutoLoadWoodToggleEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:toggleState(self.autoload, self.rightSide, self.unload, self.piles, self.markerVisible, self.unloadRot, true);
	end;
end;

function AutoLoadWoodToggleEvent.sendEvent(vehicle, autoload, rightSide, unload, piles, markerVisible, unloadRot, noEventSend)
	if autoload ~= vehicle.autoload or rightSide ~= vehicle.rightSide or unload ~= vehicle.unload or piles ~= vehicle.piles or markerVisible ~= vehicle.markerVisible or unloadRot ~= vehicle.unloadRot then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(AutoLoadWoodToggleEvent:new(vehicle, autoload, rightSide, unload, piles, markerVisible, unloadRot), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(AutoLoadWoodToggleEvent:new(vehicle, autoload, rightSide, unload, piles, markerVisible, unloadRot));
			end;
		end;
	end;
end;