--
-- Additional license plates specialization 
-- Script by Blacky_BPG
--
-- Version 1.4.4.0 C    09.09.2017    fix error for connected numberplates
-- Version 1.4.4.0 B    08.09.2017    fix error for german EURO plate
-- Version 1.4.4.0 A    05.09.2017    fix error for austria numberplates
-- Version 1.4.4.0      02.09.2017    combine all numberPlates
-- Version 1.3.1.0 D    14.01.2017    fixed light workability
-- Version 1.3.1.0 C    07.01.2017    fixed wrong variable
-- Version 1.3.1.0 B    07.01.2017    fixed active lights
-- Version 1.3.1.0 A    04.01.2017    
-- Version 1.3.1.0      04.01.2017    convert script to FS17
-- Version 1.1.1                      added Austria license plate
-- Version 1.0.0                      initial version
-- 
numberPlatesConnect = {} numberPlatesConnect.modDir = g_currentModDirectory function numberPlatesConnect.prerequisitesPresent(specializations) return true end function numberPlatesConnect:preLoad(savegame) self.setLightsTypesMask = Utils.prependedFunction(self.setLightsTypesMask, numberPlatesConnect.setLightsTypesMask) end function numberPlatesConnect:load(savegame) local xmlFile = self.xmlFile self.platesC = {} self.platesC.registered = false self.platesC.hasRegistered = false self.platesC.sign1Char = 32 self.platesC.sign2Char = 32 self.platesC.sign3Char = 32 self.platesC.sign4Char = 32 self.platesC.sign5Char = 32 self.platesC.sign6Char = 32 self.platesC.sign7Char = 32 self.platesC.sign8Char = 32 self.platesC.signMinusChar = 32 self.platesC.tuevChar = 0 self.platesC.stateChar = 0 self.platesC.isAustria = false self.platesC.isDIN = false self.platesC.color = 0 self.resetPlate = SpecializationUtil.callSpecializationsFunction("resetPlate") local i = 0 local platePath = string.format("vehicle.numberplatesConnect.plate(%d)",i) local plateFound = getXMLString(xmlFile, platePath .. "#index") if plateFound ~= nil then self.isSelectable = true while true do local platePath = string.format("vehicle.numberplatesConnect.plate(%d)",i) local plateIndex = getXMLString(xmlFile, platePath .. "#index") if plateIndex == nil then break end local index = Utils.indexToObject(self.components, plateIndex) if index == nil or index == 0 then print(" Error: No plate index "..tostring(platePath).." found in vehicle "..tostring(self.name)) break end self.platesC[i+1] = {} self.platesC[i+1].id = index self.platesC[i+1].hasLight = Utils.getNoNil(getUserAttribute(index, "hasLight"), false) self.platesC[i+1].emptyHolder = Utils.indexToObject(index,getUserAttribute(index, "emptyHolder")) self.platesC[i+1].stateSealActive = Utils.getNoNil(getXMLBool(xmlFile, platePath .. "#stateSeal"), true) self.platesC[i+1].tuevSealActive = Utils.getNoNil(getXMLBool(xmlFile, platePath .. "#tuevSeal"), true) local gerDIN_group = getUserAttribute(index, "gerDIN_group") if gerDIN_group ~= nil then local groupId = Utils.indexToObject(index, gerDIN_group) if groupId ~= nil then self.platesC[i+1].gerDIN = {} self.platesC[i+1].gerDIN.id = groupId local plateId = getUserAttribute(index, "plateId") if plateId == nil then print(" Error: Plate index not assigned for GER-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexPlateId = Utils.indexToObject(groupId, plateId) if indexPlateId == nil or indexPlateId == 0 then print(" Error: PlateId index for GER-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerDIN.plateId = indexPlateId local sealStateId = getUserAttribute(index, "sealStateId")  if sealStateId == nil then print(" Error: State Seal index not assigned for GER-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexSealStateId = Utils.indexToObject(groupId, sealStateId) if indexSealStateId == nil or indexSealStateId == 0 then print(" Error: State Seal Id index for GER-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerDIN.stateId = indexSealStateId local sealTuevId = getUserAttribute(index, "sealTuevId") if sealTuevId == nil then print(" Error: TUEV Seal index not assigned for GER-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexSealTuevId = Utils.indexToObject(groupId, sealTuevId) if indexSealTuevId == nil or indexSealTuevId == 0 then print(" Error: TUEV Seal Id index for GER-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerDIN.tuevId = indexSealTuevId local sign1Id = getUserAttribute(index, "sign1Id") if sign1Id == nil then print(" Error: Sign1 index not assigned for GER-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexSign1Id = Utils.indexToObject(groupId, sign1Id) if indexSign1Id == nil or indexSign1Id == 0 then print(" Error: Sign1 Id index for GER-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerDIN.sign1 = indexSign1Id local sign2Id = getUserAttribute(index, "sign2Id") if sign2Id == nil then print(" Error: Sign2 index not assigned for GER-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign2Id = Utils.indexToObject(groupId, sign2Id) if indexsign2Id == nil or indexsign2Id == 0 then print(" Error: Sign2 Id index for GER-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerDIN.sign2 = indexsign2Id local sign3Id = getUserAttribute(index, "sign3Id") if sign3Id == nil then print(" Error: sign3 index not assign3ed for GER-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign3Id = Utils.indexToObject(groupId, sign3Id) if indexsign3Id == nil or indexsign3Id == 0 then print(" Error: sign3 Id index for GER-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerDIN.sign3 = indexsign3Id local sign4Id = getUserAttribute(index, "sign4Id") if sign4Id == nil then print(" Error: sign4 index not assigned for GER-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign4Id = Utils.indexToObject(groupId, sign4Id) if indexsign4Id == nil or indexsign4Id == 0 then print(" Error: sign4 Id index for GER-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerDIN.sign4 = indexsign4Id local sign5Id = getUserAttribute(index, "sign5Id") if sign5Id == nil then print(" Error: sign5 index not assigned for GER-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign5Id = Utils.indexToObject(groupId, sign5Id) if indexsign5Id == nil or indexsign5Id == 0 then print(" Error: sign5 Id index for GER-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerDIN.sign5 = indexsign5Id local sign6Id = getUserAttribute(index, "sign6Id") if sign6Id == nil then print(" Error: sign6 index not assigned for GER-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign6Id = Utils.indexToObject(groupId, sign6Id) if indexsign6Id == nil or indexsign6Id == 0 then print(" Error: sign6 Id index for GER-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerDIN.sign6 = indexsign6Id local sign7Id = getUserAttribute(index, "sign7Id") if sign7Id == nil then print(" Error: sign7 index not assigned for GER-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign7Id = Utils.indexToObject(groupId, sign7Id) if indexsign7Id == nil or indexsign7Id == 0 then print(" Error: sign7 Id index for GER-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerDIN.sign7 = indexsign7Id local sign8Id = getUserAttribute(index, "sign8Id") if sign8Id == nil then print(" Error: sign8 index not assigned for GER-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign8Id = Utils.indexToObject(groupId, sign8Id) if indexsign8Id == nil or indexsign8Id == 0 then print(" Error: sign8 Id index for GER-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerDIN.sign8 = indexsign8Id local signMinusId = getUserAttribute(index, "signMinusId") local indexsignMinusId = nil if signMinusId ~= nil then indexsignMinusId = Utils.indexToObject(groupId, signMinusId) if indexsignMinusId == nil or indexsignMinusId == 0 then indexsignMinusId = nil end end self.platesC[i+1].gerDIN.signMinus = indexsignMinusId if self.platesC[i+1].hasLight then local plateLightId = getUserAttribute(index, "plateLightId") local indexplateLightId = nil if plateLightId ~= nil then indexplateLightId = Utils.indexToObject(groupId, plateLightId) if indexplateLightId == nil or indexplateLightId == 0 then indexplateLightId = nil end end self.platesC[i+1].gerDIN.plateIdLight = indexplateLightId end end end local gerEURO_group = getUserAttribute(index, "gerEURO_group") if gerEURO_group ~= nil then local groupId = Utils.indexToObject(index, gerEURO_group) if groupId ~= nil then self.platesC[i+1].gerEURO = {} self.platesC[i+1].gerEURO.id = groupId local plateId = getUserAttribute(index, "plateId") if plateId == nil then print(" Error: Plate index not assigned for GER-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexPlateId = Utils.indexToObject(groupId, plateId) if indexPlateId == nil or indexPlateId == 0 then print(" Error: PlateId index for GER-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerEURO.plateId = indexPlateId local sealStateId = getUserAttribute(index, "sealStateId")  if sealStateId == nil then print(" Error: State Seal index not assigned for GER-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexSealStateId = Utils.indexToObject(groupId, sealStateId) if indexSealStateId == nil or indexSealStateId == 0 then print(" Error: State Seal Id index for GER-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerEURO.stateId = indexSealStateId local sealTuevId = getUserAttribute(index, "sealTuevId") if sealTuevId == nil then print(" Error: TUEV Seal index not assigned for GER-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexSealTuevId = Utils.indexToObject(groupId, sealTuevId) if indexSealTuevId == nil or indexSealTuevId == 0 then print(" Error: TUEV Seal Id index for GER-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerEURO.tuevId = indexSealTuevId local sign1Id = getUserAttribute(index, "sign1Id") if sign1Id == nil then print(" Error: Sign1 index not assigned for GER-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexSign1Id = Utils.indexToObject(groupId, sign1Id) if indexSign1Id == nil or indexSign1Id == 0 then print(" Error: Sign1 Id index for GER-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerEURO.sign1 = indexSign1Id local sign2Id = getUserAttribute(index, "sign2Id") if sign2Id == nil then print(" Error: Sign2 index not assigned for GER-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign2Id = Utils.indexToObject(groupId, sign2Id) if indexsign2Id == nil or indexsign2Id == 0 then print(" Error: Sign2 Id index for GER-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerEURO.sign2 = indexsign2Id local sign3Id = getUserAttribute(index, "sign3Id") if sign3Id == nil then print(" Error: sign3 index not assign3ed for GER-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign3Id = Utils.indexToObject(groupId, sign3Id) if indexsign3Id == nil or indexsign3Id == 0 then print(" Error: sign3 Id index for GER-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerEURO.sign3 = indexsign3Id local sign4Id = getUserAttribute(index, "sign4Id") if sign4Id == nil then print(" Error: sign4 index not assigned for GER-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign4Id = Utils.indexToObject(groupId, sign4Id) if indexsign4Id == nil or indexsign4Id == 0 then print(" Error: sign4 Id index for GER-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerEURO.sign4 = indexsign4Id local sign5Id = getUserAttribute(index, "sign5Id") if sign5Id == nil then print(" Error: sign5 index not assigned for GER-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign5Id = Utils.indexToObject(groupId, sign5Id) if indexsign5Id == nil or indexsign5Id == 0 then print(" Error: sign5 Id index for GER-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerEURO.sign5 = indexsign5Id local sign6Id = getUserAttribute(index, "sign6Id") if sign6Id == nil then print(" Error: sign6 index not assigned for GER-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign6Id = Utils.indexToObject(groupId, sign6Id) if indexsign6Id == nil or indexsign6Id == 0 then print(" Error: sign6 Id index for GER-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerEURO.sign6 = indexsign6Id local sign7Id = getUserAttribute(index, "sign7Id") if sign7Id == nil then print(" Error: sign7 index not assigned for GER-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign7Id = Utils.indexToObject(groupId, sign7Id) if indexsign7Id == nil or indexsign7Id == 0 then print(" Error: sign7 Id index for GER-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerEURO.sign7 = indexsign7Id local sign8Id = getUserAttribute(index, "sign8Id") if sign8Id == nil then print(" Error: sign8 index not assigned for GER-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign8Id = Utils.indexToObject(groupId, sign8Id) if indexsign8Id == nil or indexsign8Id == 0 then print(" Error: sign8 Id index for GER-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].gerEURO.sign8 = indexsign8Id if self.platesC[i+1].hasLight then local plateLightId = getUserAttribute(index, "plateLightId") local indexplateLightId = nil if plateLightId ~= nil then indexplateLightId = Utils.indexToObject(groupId, plateLightId) if indexplateLightId == nil or indexplateLightId == 0 then indexplateLightId = nil end end self.platesC[i+1].gerEURO.plateIdLight = indexplateLightId end end end local ausDIN_group = getUserAttribute(index, "ausDIN_group") if ausDIN_group ~= nil then local groupId = Utils.indexToObject(index, ausDIN_group) if groupId ~= nil then self.platesC[i+1].ausDIN = {} self.platesC[i+1].ausDIN.id = groupId local plateId = getUserAttribute(index, "plateId") if plateId == nil then print(" Error: Plate index not assigned for AUS-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexPlateId = Utils.indexToObject(groupId, plateId) if indexPlateId == nil or indexPlateId == 0 then print(" Error: PlateId index for AUS-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausDIN.plateId = indexPlateId local sealStateId = getUserAttribute(index, "sealStateId")  if sealStateId == nil then print(" Error: State Seal index not assigned for AUS-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexSealStateId = Utils.indexToObject(groupId, sealStateId) if indexSealStateId == nil or indexSealStateId == 0 then print(" Error: State Seal Id index for AUS-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausDIN.stateId = indexSealStateId local sign1Id = getUserAttribute(index, "sign1Id") if sign1Id == nil then print(" Error: Sign1 index not assigned for AUS-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexSign1Id = Utils.indexToObject(groupId, sign1Id)  if indexSign1Id == nil or indexSign1Id == 0 then print(" Error: Sign1 Id index for AUS-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausDIN.sign1 = indexSign1Id local sign2Id = getUserAttribute(index, "sign2Id") if sign2Id == nil then print(" Error: Sign2 index not assigned for AUS-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign2Id = Utils.indexToObject(groupId, sign2Id) if indexsign2Id == nil or indexsign2Id == 0 then print(" Error: Sign2 Id index for AUS-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausDIN.sign2 = indexsign2Id local sign3Id = getUserAttribute(index, "sign3Id") if sign3Id == nil then print(" Error: sign3 index not assign3ed for AUS-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign3Id = Utils.indexToObject(groupId, sign3Id) if indexsign3Id == nil or indexsign3Id == 0 then print(" Error: sign3 Id index for AUS-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausDIN.sign3 = indexsign3Id local sign4Id = getUserAttribute(index, "sign4Id") if sign4Id == nil then print(" Error: sign4 index not assigned for AUS-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign4Id = Utils.indexToObject(groupId, sign4Id) if indexsign4Id == nil or indexsign4Id == 0 then print(" Error: sign4 Id index for AUS-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausDIN.sign4 = indexsign4Id local sign5Id = getUserAttribute(index, "sign5Id") if sign5Id == nil then print(" Error: sign5 index not assigned for AUS-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign5Id = Utils.indexToObject(groupId, sign5Id) if indexsign5Id == nil or indexsign5Id == 0 then print(" Error: sign5 Id index for AUS-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausDIN.sign5 = indexsign5Id local sign6Id = getUserAttribute(index, "sign6Id") if sign6Id == nil then print(" Error: sign6 index not assigned for AUS-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign6Id = Utils.indexToObject(groupId, sign6Id) if indexsign6Id == nil or indexsign6Id == 0 then print(" Error: sign6 Id index for AUS-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausDIN.sign6 = indexsign6Id local sign7Id = getUserAttribute(index, "sign7Id") if sign7Id == nil then print(" Error: sign7 index not assigned for AUS-DIN plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign7Id = Utils.indexToObject(groupId, sign7Id) if indexsign7Id == nil or indexsign7Id == 0 then print(" Error: sign7 Id index for AUS-DIN plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausDIN.sign7 = indexsign7Id if self.platesC[i+1].hasLight then local plateLightId = getUserAttribute(index, "plateLightId") local indexplateLightId = nil if plateLightId ~= nil then indexplateLightId = Utils.indexToObject(groupId, plateLightId) if indexplateLightId == nil or indexplateLightId == 0 then indexplateLightId = nil end end self.platesC[i+1].ausDIN.plateIdLight = indexplateLightId end end end local ausEURO_group = getUserAttribute(index, "ausEURO_group") if ausEURO_group ~= nil then local groupId = Utils.indexToObject(index, ausEURO_group) if groupId ~= nil then self.platesC[i+1].ausEURO = {} self.platesC[i+1].ausEURO.id = groupId local plateId = getUserAttribute(index, "plateId") if plateId == nil then print(" Error: Plate index not assigned for AUS-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexPlateId = Utils.indexToObject(groupId, plateId) if indexPlateId == nil or indexPlateId == 0 then print(" Error: PlateId index for AUS-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausEURO.plateId = indexPlateId local sealStateId = getUserAttribute(index, "sealStateId")  if sealStateId == nil then print(" Error: State Seal index not assigned for AUS-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexSealStateId = Utils.indexToObject(groupId, sealStateId) if indexSealStateId == nil or indexSealStateId == 0 then print(" Error: State Seal Id index for AUS-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausEURO.stateId = indexSealStateId local sign1Id = getUserAttribute(index, "sign1Id") if sign1Id == nil then print(" Error: Sign1 index not assigned for AUS-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexSign1Id = Utils.indexToObject(groupId, sign1Id) if indexSign1Id == nil or indexSign1Id == 0 then print(" Error: Sign1 Id index for AUS-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausEURO.sign1 = indexSign1Id local sign2Id = getUserAttribute(index, "sign2Id") if sign2Id == nil then print(" Error: Sign2 index not assigned for AUS-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign2Id = Utils.indexToObject(groupId, sign2Id) if indexsign2Id == nil or indexsign2Id == 0 then print(" Error: Sign2 Id index for AUS-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausEURO.sign2 = indexsign2Id local sign3Id = getUserAttribute(index, "sign3Id") if sign3Id == nil then print(" Error: sign3 index not assign3ed for AUS-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign3Id = Utils.indexToObject(groupId, sign3Id) if indexsign3Id == nil or indexsign3Id == 0 then print(" Error: sign3 Id index for AUS-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausEURO.sign3 = indexsign3Id local sign4Id = getUserAttribute(index, "sign4Id") if sign4Id == nil then print(" Error: sign4 index not assigned for AUS-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign4Id = Utils.indexToObject(groupId, sign4Id) if indexsign4Id == nil or indexsign4Id == 0 then print(" Error: sign4 Id index for AUS-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausEURO.sign4 = indexsign4Id local sign5Id = getUserAttribute(index, "sign5Id") if sign5Id == nil then print(" Error: sign5 index not assigned for AUS-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign5Id = Utils.indexToObject(groupId, sign5Id) if indexsign5Id == nil or indexsign5Id == 0 then print(" Error: sign5 Id index for AUS-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausEURO.sign5 = indexsign5Id local sign6Id = getUserAttribute(index, "sign6Id") if sign6Id == nil then print(" Error: sign6 index not assigned for AUS-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign6Id = Utils.indexToObject(groupId, sign6Id) if indexsign6Id == nil or indexsign6Id == 0 then print(" Error: sign6 Id index for AUS-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausEURO.sign6 = indexsign6Id local sign7Id = getUserAttribute(index, "sign7Id") if sign7Id == nil then print(" Error: sign7 index not assigned for AUS-EURO plate "..tostring(i+1).." for vehicle "..tostring(self.name)) break end local indexsign7Id = Utils.indexToObject(groupId, sign7Id) if indexsign7Id == nil or indexsign7Id == 0 then print(" Error: sign7 Id index for AUS-EURO plate "..tostring(i+1).." not found in vehicle "..tostring(self.name)) break end self.platesC[i+1].ausEURO.sign7 = indexsign7Id if self.platesC[i+1].hasLight then local plateLightId = getUserAttribute(index, "plateLightId") local indexplateLightId = nil if plateLightId ~= nil then indexplateLightId = Utils.indexToObject(groupId, plateLightId) if indexplateLightId == nil or indexplateLightId == 0 then indexplateLightId = nil end end self.platesC[i+1].ausEURO.plateIdLight = indexplateLightId end end end i=i+1 end self:resetPlate() end end function numberPlatesConnect:resetPlate() if table.getn(self.platesC) > 0 then self.platesC.registered = false self.platesC.hasRegistered = false for a=1, table.getn(self.platesC) do setVisibility(self.platesC[a].id, true) setVisibility(self.platesC[a].emptyHolder, true) if self.platesC[a].gerDIN ~= nil then setVisibility(self.platesC[a].gerDIN.id, false) end if self.platesC[a].gerEURO ~= nil then setVisibility(self.platesC[a].gerEURO.id, false) end if self.platesC[a].ausDIN ~= nil then setVisibility(self.platesC[a].ausDIN.id, false) end if self.platesC[a].ausEURO ~= nil then setVisibility(self.platesC[a].ausEURO.id, false) end end end end function numberPlatesConnect:onDetach() self:resetPlate() end function numberPlatesConnect:update(dt) if self.attacherVehicle ~= nil then if not self.platesC.registered then if self.attacherVehicle.plates ~= nil and self.attacherVehicle.plates.sign1Char ~= nil and self.attacherVehicle.plates.registered then self.platesC.isAustria = self.attacherVehicle.plates.isAustria self.platesC.color = Utils.getNoNil(self.attacherVehicle.plates.color,0) self.platesC.isDIN = Utils.getNoNil(self.attacherVehicle.plates.isDIN,false) self.platesC.sign1Char = self.attacherVehicle.plates.sign1Char self.platesC.sign2Char = self.attacherVehicle.plates.sign2Char self.platesC.sign3Char = self.attacherVehicle.plates.sign3Char self.platesC.sign4Char = self.attacherVehicle.plates.sign4Char self.platesC.sign5Char = self.attacherVehicle.plates.sign5Char self.platesC.sign6Char = self.attacherVehicle.plates.sign6Char self.platesC.sign7Char = self.attacherVehicle.plates.sign7Char self.platesC.registered = true if self.platesC.isAustria then self.platesC.sign8Char = 32 else 					self.platesC.sign8Char = self.attacherVehicle.plates.sign8Char end elseif self.attacherVehicle.platesC ~= nil and self.attacherVehicle.platesC.sign1Char ~= nil and self.attacherVehicle.platesC.registered then self.platesC.isAustria = self.attacherVehicle.platesC.isAustria self.platesC.color = Utils.getNoNil(self.attacherVehicle.platesC.color,0) self.platesC.isDIN = Utils.getNoNil(self.attacherVehicle.platesC.isDIN,false) self.platesC.sign1Char = self.attacherVehicle.platesC.sign1Char self.platesC.sign2Char = self.attacherVehicle.platesC.sign2Char self.platesC.sign3Char = self.attacherVehicle.platesC.sign3Char self.platesC.sign4Char = self.attacherVehicle.platesC.sign4Char self.platesC.sign5Char = self.attacherVehicle.platesC.sign5Char self.platesC.sign6Char = self.attacherVehicle.platesC.sign6Char self.platesC.sign7Char = self.attacherVehicle.platesC.sign7Char self.platesC.registered = true if self.platesC.isAustria then self.platesC.sign8Char = 32 else 					self.platesC.sign8Char = self.attacherVehicle.platesC.sign8Char end end end else 		if self.platesC.registered then self:resetPlate() end end end function numberPlatesConnect:setLightsTypesMask(lightsTypesMask, force, noEventSend) if lightsTypesMask ~= nil and self.platesC.registered then if lightsTypesMask > 0 then if table.getn(self.platesC) > 0 then for a=1, table.getn(self.platesC) do if self.platesC[a].hasLight then if self.platesC[a].gerDIN ~= nil and self.platesC[a].gerDIN.plateIdLight ~= nil then setVisibility(self.platesC[a].gerDIN.plateId, false) setVisibility(self.platesC[a].gerDIN.plateIdLight, true) end if self.platesC[a].gerEURO ~= nil and self.platesC[a].gerEURO.plateIdLight ~= nil then setVisibility(self.platesC[a].gerEURO.plateId, false) setVisibility(self.platesC[a].gerEURO.plateIdLight, true) end if self.platesC[a].ausDIN ~= nil and self.platesC[a].ausDIN.plateIdLight ~= nil then setVisibility(self.platesC[a].ausDIN.plateId, false) setVisibility(self.platesC[a].ausDIN.plateIdLight, true) end if self.platesC[a].ausEURO ~= nil and self.platesC[a].ausEURO.plateIdLight ~= nil then setVisibility(self.platesC[a].ausEURO.plateId, false) setVisibility(self.platesC[a].ausEURO.plateIdLight, true) end end end end else 			if table.getn(self.platesC) > 0 then for a=1, table.getn(self.platesC) do if self.platesC[a].hasLight then if self.platesC[a].gerDIN ~= nil and self.platesC[a].gerDIN.plateIdLight ~= nil then setVisibility(self.platesC[a].gerDIN.plateId, true) setVisibility(self.platesC[a].gerDIN.plateIdLight, false) end if self.platesC[a].gerEURO ~= nil and self.platesC[a].gerEURO.plateIdLight ~= nil then setVisibility(self.platesC[a].gerEURO.plateId, true) setVisibility(self.platesC[a].gerEURO.plateIdLight, false) end if self.platesC[a].ausDIN ~= nil and self.platesC[a].ausDIN.plateIdLight ~= nil then setVisibility(self.platesC[a].ausDIN.plateId, true) setVisibility(self.platesC[a].ausDIN.plateIdLight, false) end if self.platesC[a].ausEURO ~= nil and self.platesC[a].ausEURO.plateIdLight ~= nil then setVisibility(self.platesC[a].ausEURO.plateId, true) setVisibility(self.platesC[a].ausEURO.plateIdLight, false) end end end end end end end function numberPlatesConnect:updateTick(dt) if self.platesC.registered and not self.platesC.hasRegistered then self.platesC.hasRegistered = true if table.getn(self.platesC) > 0 then for a=1, table.getn(self.platesC) do setVisibility(self.platesC[a].emptyHolder, false) local plate = self.platesC[a].gerDIN if self.platesC.isAustria then plate = self.platesC[a].ausEURO if self.platesC.isDIN then plate = self.platesC[a].ausDIN end else 					if not self.platesC.isDIN then plate = self.platesC[a].gerEURO end end setVisibility(plate.id, true) setVisibility(plate.plateId, true) setVisibility(plate.sign1, true) setVisibility(plate.sign2, true) setVisibility(plate.sign3, true) setVisibility(plate.sign4, true) setVisibility(plate.sign5, true) setVisibility(plate.sign6, true) setVisibility(plate.sign7, true) if plate.sign8 ~= nil then setVisibility(plate.sign8, true) end if plate.signMinus ~= nil then setVisibility(plate.signMinus, true) end if plate.plateIdLight ~= nil then setVisibility(plate.plateIdLight, false) end setShaderParameter(plate.sign1, "TexturePosition", 0 - (getTexPos(self.platesC.sign1Char) * 0.02417), self.platesC.color*0.25, 0, 0, false) setShaderParameter(plate.sign2, "TexturePosition", 0 - (getTexPos(self.platesC.sign2Char) * 0.02417), self.platesC.color*0.25, 0, 0, false) setShaderParameter(plate.sign3, "TexturePosition", 0 - (getTexPos(self.platesC.sign3Char) * 0.02417), self.platesC.color*0.25, 0, 0, false) setShaderParameter(plate.sign4, "TexturePosition", 0 - (getTexPos(self.platesC.sign4Char) * 0.02417), self.platesC.color*0.25, 0, 0, false) setShaderParameter(plate.sign5, "TexturePosition", 0 - (getTexPos(self.platesC.sign5Char) * 0.02417), self.platesC.color*0.25, 0, 0, false) setShaderParameter(plate.sign6, "TexturePosition", 0 - (getTexPos(self.platesC.sign6Char) * 0.02417), self.platesC.color*0.25, 0, 0, false) setShaderParameter(plate.sign7, "TexturePosition", 0 - (getTexPos(self.platesC.sign7Char) * 0.02417), self.platesC.color*0.25, 0, 0, false) if plate.sign8 ~= nil then setShaderParameter(plate.sign8, "TexturePosition", 0 - (getTexPos(self.platesC.sign8Char) * 0.02417), self.platesC.color*0.25, 0, 0, false) end if plate.stateId ~= nil then if self.platesC[a].stateSealActive then setShaderParameter(plate.stateId, "TexturePosition", 0 - (self.platesC.stateChar * 0.0625), 0, 0, 0, false) setVisibility(plate.stateId, true) else setVisibility(plate.stateId, false) end end if plate.tuevId ~= nil then if self.platesC[a].tuevSealActive then setShaderParameter(plate.tuevId, "TexturePosition", 0 - (self.platesC.tuevChar * 0.0625), 0, 0, 0, false) setVisibility(plate.tuevId, true) else setVisibility(plate.tuevId, false) end end if plate.signMinus ~= nil then setShaderParameter(plate.signMinus, "TexturePosition", 0 - (26 * 0.02417), self.platesC.color*0.25, 0, 0, false) end end end end end function numberPlatesConnect:draw() end function getTexPos(char) if char == 32 then char = -1 elseif char > 64 and char < 91 then char = char - 65 elseif char > 47 and char < 58 then char = char - 21 elseif char == 45 then char = 26 elseif char == 142 then char = 38 elseif char == 154 then char = 37 elseif char == 153 then char = 39 else char = -1 end return char end function numberPlatesConnect:delete() end function numberPlatesConnect:mouseEvent(posX, posY, isDown, isUp, button) end function numberPlatesConnect:keyEvent(unicode, sym, modifier, isDown) end
