--[[
SupportWheelFix

Script to change the support wheel according the current wheel configuration

@Author:	Ifko[nator]
@Date:		24.11.2017

@Version:	1.0 - initial release in FS 17
]]

SupportWheelFix = {};

function SupportWheelFix.prerequisitesPresent(specializations)
    return true; 
end;

function SupportWheelFix:load(savegame)
    self.supportWheels = {};
    
    local supportWheels = 0;
    
    while true do
        local supportWheelKey = "vehicle.dynamicallyLoadedWheels.dynamicallyLoadedWheel(" .. tostring(supportWheels) .. ")";
        
        if not hasXMLProperty(self.xmlFile, supportWheelKey) then
            break;
        end;
        
        local supportWheel = {};
        
        supportWheel.linkNode = Utils.indexToObject(self.components, getXMLString(self.xmlFile, supportWheelKey .. "#linkNode"));
        
        if supportWheel.linkNode ~= nil then
			setVisibility(supportWheel.linkNode, false);
		
            supportWheel.activeConfigs = getXMLString(self.xmlFile, supportWheelKey .. "#activeWheelConfigs");
        	
            if supportWheel.activeConfigs ~= nil and supportWheel.activeConfigs ~= "" then
                table.insert(self.supportWheels, supportWheel);
            end;
        end;
        
        supportWheels = supportWheels + 1;
    end;
    
    if #self.supportWheels > 0 then
        local storeItem = StoreItemsUtil.storeItemsByXMLFilename[self.configFileName:lower()];
        
        for _, supportWheel in pairs(self.supportWheels) do
            if storeItem.configurations ~= nil then
                local activeConfigs = Utils.splitString(" ", supportWheel.activeConfigs);
                local wheelConfigurations = storeItem.configurations["wheel"];
                local wheelConfig = wheelConfigurations[self.configurations["wheel"]];
                
                for _, activeConfig in pairs(activeConfigs) do
					if wheelConfig.name == g_i18n:getText(activeConfig) then	
						setVisibility(supportWheel.linkNode, true);
						
						break;
					end;
                end;
            end;
        end;
    end;
end;

function SupportWheelFix:update(dt)end;
function SupportWheelFix:delete()end;
function SupportWheelFix:mouseEvent(posX, posY, isDown, isUp, button)end;
function SupportWheelFix:keyEvent(unicode, sym, modifier, isDown)end;
function SupportWheelFix:draw()end;