-- Filllevel Anzeige
-- Version: 1.0.1 WAL
--
-- initial version by: Killabot / HOT team
-- improved script by HoFFi (moddwin-welt.com)
--
-- Changelog:
--		- added alignment to display resolution
--		- move hud to top of engine-hud
--		- added text based on state of folding-parts
--
SFL2 = {};

function SFL2.prerequisitesPresent(specializations)
    return true;
end;

function SFL2:load(savegame)
    -- HUD
    self.file = Utils.getFilename("Textur/counter.png", self.baseDirectory);
    --self.HUDx = 0.8485;
    --self.HUDy = 0.164;
    --self.HUDWidth = 0.220;
    --self.HUDHeight = 0.320;
	
	self.HUDx = g_currentMission.vehicleHudBg.x;
    self.HUDy = g_currentMission.vehicleHudBg.y + g_currentMission.vehicleHudBg.height;
    self.HUDWidth = g_currentMission.vehicleHudBg.width;
    --self.HUDHeight = 0.320;
	self.HUDHeight = g_currentMission.vehicleHudBg.width * 2;
    self.HUD = false;
    
    self.cX = self.HUDx + 0.03;
    self.cY = self.HUDy + 0.015;
    
    self.APHUD = Overlay:new("APHUD", self.file, self.HUDx, self.HUDy, self.HUDWidth, self.HUDHeight);
	
	
end;

function SFL2:delete()
end;

function SFL2:readStream(streamId, connection)
end;

function SFL2:writeStream(streamId, connection)
end;

function SFL2:readUpdateStream(streamId, timestamp, connection)
end;

function SFL2:writeUpdateStream(streamId, connection, dirtyMask)
end;

function SFL2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SFL2:keyEvent(unicode, sym, modifier, isDown)
end;

function SFL2:update(dt)
    if self:getIsActiveForInput() and self:getIsActive() then
        if InputBinding.hasEvent(InputBinding.fillLevel) then
            self.HUD = not self.HUD;
        end;
    end;
end;

function SFL2:draw()
	if self.isClient and self:getIsActiveForInput() then
		if self.HUD then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_OFF"), self.typeDesc), InputBinding.fillLevel);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_ON"), self.typeDesc), InputBinding.fillLevel);
		end;
		if self.HUD then
			self.APHUD:render();
			setTextColor(1, 1, 1, 1.0);
			setTextAlignment(RenderText.ALIGN_LEFT);
			if self.foldAnimTime == 1 then
			renderText(self.cX, self.cY, 0.015, string.format(g_i18n:getText("input_LogLenght"), self.typeDesc) .. " 7m" );
			else
			renderText(self.cX, self.cY, 0.015, string.format(g_i18n:getText("input_LogLenght"), self.typeDesc) .. " 8,5m" );
			end;
		end;
	end;
end;

function SFL2:onDetach()
end;
