-- CaseIH.lua
-- Script for Fendt Farmer 310/312 LSA
--
-- Author Rival renamed
-- 05.01.2016
-- Version 1.1 @26.10.2016
	--> converted to FS17
-- Version 1.2 @05.11.2016
	--> added indoorsound change when door/windows are open
	--> changes for CaseIH
	
CaseIH = {};

function CaseIH.prerequisitesPresent(specializations)
    return true;
end;

function CaseIH:load(savegame)
    self.blinkerLight0 = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.IHCDisplay.blinkerLight0#index"));
    self.blinkerLight1 = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.IHCDisplay.blinkerLight1#index"));
    self.blinkerLight2 = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.IHCDisplay.blinkerLight2#index"));
    self.warnBlinkLight = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.IHCDisplay.warnBlinkLight#index"));
    setVisibility(self.blinkerLight0, false);
    setVisibility(self.blinkerLight1, false);
    setVisibility(self.blinkerLight2, false);
    self.hasAttachedTrailers = 0;
	
	self.soundAdj = {};
	local i=0;
    while true do
        local key = string.format("vehicle.indoorsoundAdjustment.animation(%d)", i);
        if not hasXMLProperty(self.xmlFile, key) then
            break;
        end;
        local animName = getXMLString(self.xmlFile, key.."#name");
        local lowpassGain = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#lowpassGain"), 0.5);
        local volumeFactor = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#volumeFactor"), 0.5);
		self.soundAdj[i] = {};
		self.soundAdj[i].animName = animName;
		self.soundAdj[i].volumeFactor = volumeFactor;
		self.soundAdj[i].lowpassGain = lowpassGain;
        i = i +1;
    end;
	
	if self.isClient then
		self.sampleOpenDoorL = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/tuer_auf.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseDoorL = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/tuer_zu2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenDoorR = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/tuer_auf.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseDoorR = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/tuer_zu2.wav", self.baseDirectory, self.components[1].node);
		self.sampleWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.windowSound", "sounds/window.wav", self.baseDirectory, self.components[1].node);
	end;
end;
--function CaseIH:postLoad(savegame)
--	for k,v in pairs(self.sampleMotor) do print(k,v) end
--end;
function CaseIH:delete()
	if self.sampleOpenDoorL ~= nil then
		SoundUtil.deleteSample(self.sampleOpenDoorL);
	end;
	if self.sampleOpenDoorR ~= nil then
		SoundUtil.deleteSample(self.sampleOpenDoorR);
	end;
	if self.sampleCloseDoorL ~= nil then
		SoundUtil.deleteSample(self.sampleCloseDoorL);
	end;
	if self.sampleCloseDoorR ~= nil then
		SoundUtil.deleteSample(self.sampleCloseDoorR);
	end;
	if self.sampleWindow ~= nil then
		SoundUtil.deleteSample(self.sampleWindow);
	end;
end;
function CaseIH:mouseEvent(posX, posY, isDown, isUp, button)
end;
function CaseIH:keyEvent(unicode, sym, modifier, isDown)
end;
function CaseIH:update(dt)
    if self:getIsActive() and self.isClient then
        if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
            self.hasAttachedTrailers = 0;
            for i=1, table.getn(self.attachedImplements) do  
                if self.attachedImplements[i].object.hasTurnLights and self.attachedImplements[i].object.hasTurnLights then 
                    self.hasAttachedTrailers = self.hasAttachedTrailers + 1;
                end;
                if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then
                    for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
                        if self.attachedImplements[i].object.attachedImplements[r].object.hasTurnLights and self.attachedImplements[i].object.attachedImplements[r].object.hasTurnLights then
                            self.hasAttachedTrailers = self.hasAttachedTrailers + 1;
                        end;
                    end;
                end;
            end;
        end;
        
		if self.hasAttachedTrailers == 0 then
            setVisibility(self.blinkerLight0, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight1, false);
            setVisibility(self.blinkerLight2, false);
        elseif self.hasAttachedTrailers == 1 then
            setVisibility(self.blinkerLight0, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight1, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight2, false);
        elseif self.hasAttachedTrailers == 2 then
            setVisibility(self.blinkerLight0, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight1, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight2, self.turnLightState ~= Lights.TURNLIGHT_OFF);
        end;
        if self.turnLightState == Lights.TURNLIGHT_HAZARD then
            setVisibility(self.warnBlinkLight, true);
        else
            setVisibility(self.warnBlinkLight, false);
        end;
		
		if self.isEntered then
			if self:getIsAnimationPlaying("leftDoor") and self:getIsActiveForSound() then
				if self.animations["leftDoor"].currentSpeed > 0 and self.animations["leftDoor"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorL, 2.0*dt) then
						SoundUtil.playSample(self.sampleOpenDoorL,1,1,nil);
					end;
				elseif self.animations["leftDoor"].currentSpeed < 0 and self.animations["leftDoor"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorL, 2.0*dt) then
						SoundUtil.playSample(self.sampleCloseDoorL,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("rightDoor") and self:getIsActiveForSound() then
				if self.animations["rightDoor"].currentSpeed > 0 and self.animations["rightDoor"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorR, 2.0*dt) then
						SoundUtil.playSample(self.sampleOpenDoorR,1,1,nil);
					end;
				elseif self.animations["rightDoor"].currentSpeed < 0 and self.animations["rightDoor"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorR, 2.0*dt) then
						SoundUtil.playSample(self.sampleCloseDoorR,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("frontWindow") and self:getIsActiveForSound() then
				if self.animations["frontWindow"].currentSpeed > 0 and self.animations["frontWindow"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleWindow, 2.0*dt) then
						SoundUtil.playSample(self.sampleWindow,1,1,nil);
					end;
				elseif self.animations["frontWindow"].currentSpeed < 0 and self.animations["frontWindow"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleWindow, 2.0*dt) then
						SoundUtil.playSample(self.sampleWindow,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("backWindow") and self:getIsActiveForSound() then
				if self.animations["backWindow"].currentSpeed > 0 and self.animations["backWindow"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleWindow, 2.0*dt) then
						SoundUtil.playSample(self.sampleWindow,1,1,nil);
					end;
				elseif self.animations["backWindow"].currentSpeed < 0 and self.animations["backWindow"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleWindow, 2.0*dt) then
						SoundUtil.playSample(self.sampleWindow,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("sideLeft") and self:getIsActiveForSound() then
				if self.animations["sideLeft"].currentSpeed > 0 and self.animations["sideLeft"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorR, 2.0*dt) then
						SoundUtil.playSample(self.sampleOpenDoorR,1,1,nil);
					end;
				elseif self.animations["sideLeft"].currentSpeed < 0 and self.animations["sideLeft"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorR, 2.0*dt) then
						SoundUtil.playSample(self.sampleCloseDoorR,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("sideRight") and self:getIsActiveForSound() then
				if self.animations["sideRight"].currentSpeed > 0 and self.animations["sideRight"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorR, 2.0*dt) then
						SoundUtil.playSample(self.sampleOpenDoorR,1,1,nil);
					end;
				elseif self.animations["sideRight"].currentSpeed < 0 and self.animations["sideRight"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorR, 2.0*dt) then
						SoundUtil.playSample(self.sampleCloseDoorR,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("roofhatch") and self:getIsActiveForSound() then
				if self.animations["roofhatch"].currentSpeed > 0 and self.animations["roofhatch"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorR, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenDoorR,1,1,nil);
					end;
				elseif self.animations["roofhatch"].currentSpeed < 0 and self.animations["roofhatch"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorR, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseDoorR,1,1,nil);
					end;
				end;
			end;
			
			local sound=false;
			for i=0, #self.soundAdj do
				if self.animations[self.soundAdj[i].animName] ~= nil and self.animations[self.soundAdj[i].animName].currentTime > 500 then
					self.sampleMotor.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotor.indoorVolumeFactor);
					self.sampleMotor.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotor.indoorLowpassGain);
					self.sampleMotorStart.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStart.indoorVolumeFactor);
					self.sampleMotorStart.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStart.indoorLowpassGain);
					self.sampleMotorStop.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStop.indoorVolumeFactor);
					self.sampleMotorStop.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStop.indoorLowpassGain);
					
					self.sampleMotorRun.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorRun.indoorVolumeFactor);
					self.sampleMotorRun.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorRun.indoorLowpassGain);
					self.sampleMotorLoad.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorLoad.indoorVolumeFactor);
					self.sampleMotorLoad.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorLoad.indoorLowpassGain);
					sound=true;
				else
					if not sound then
						self.sampleMotor.indoorVolumeFactor = 0.55;
						self.sampleMotor.indoorLowpassGain = 0.2;
						self.sampleMotorStart.indoorVolumeFactor = 0.55;
						self.sampleMotorStart.indoorLowpassGain = 0.2;
						self.sampleMotorStop.indoorVolumeFactor = 0.55;
						self.sampleMotorStop.indoorLowpassGain = 0.2;
						
						self.sampleMotorRun.indoorVolumeFactor = 0.6;
						self.sampleMotorRun.indoorLowpassGain = 0.2;
						self.sampleMotorLoad.indoorVolumeFactor = 0.6;
						self.sampleMotorLoad.indoorLowpassGain = 0.2;
					end;
				end;
			end;
			SoundUtil.onCameraSwitched(self.activeCamera.isInside);
		end;
    end;
end;
function CaseIH:updateTick(dt)
end;
function CaseIH:draw()    
end;