--[[
HideNumberPlateHolders

Script to hide the onumber plate holdes, if the vehicle has not registered

@Author:	Ifko[nator]
@Date:		06.10.2017

@Version:	1.0 - intial release in FS 17

]]

HideNumberPlateHolders = {};

function HideNumberPlateHolders.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(numberPlates, specializations) or SpecializationUtil.hasSpecialization(numberPlatesConnect, specializations); 
end;

function HideNumberPlateHolders:load(savegame)
	local count = 0;

	self.numberPlateHolders = {};
	
	while true do
		local xmlString = "vehicle.numberplates.plate(" .. tostring(count) .. ")";
		
		if not hasXMLProperty(self.xmlFile, xmlString) then
            break;
        end;
		
		local numberPlateHolder = {};
		
		numberPlateHolder.node = Utils.indexToObject(self.components, getXMLString(self.xmlFile, xmlString .. "#index"));
		
		if numberPlateHolder.node ~= nil then
			table.insert(self.numberPlateHolders, numberPlateHolder);
		end;
	
		count = count + 1;
	end;
end;

function HideNumberPlateHolders:update(dt)
	for _, numberPlateHolder in pairs(self.numberPlateHolders) do
		setVisibility(numberPlateHolder.node, self.plates.hasRegistered);
	end;
end;

function HideNumberPlateHolders:delete()end;
function HideNumberPlateHolders:mouseEvent(posX, posY, isDown, isUp, button)end;
function HideNumberPlateHolders:keyEvent(unicode, sym, modifier, isDown)end;
function HideNumberPlateHolders:draw()end;