--[[
WheelRadiusFix

Script to fix the wheel raduis from the the ihc's

@Author:	Ifko[nator]
@Date:		22.11.2017
@Version:	1.0 - initial release in FS 17
]]


WheelRadiusFix = {};

function WheelRadiusFix.prerequisitesPresent(specializations)
    return true;
end;

function WheelRadiusFix:load(savegame)
	self.isAllWheels = false;
	
	local storeItem = StoreItemsUtil.storeItemsByXMLFilename[self.configFileName:lower()];
    
	if storeItem.configurations ~= nil then
       if storeItem.configurations["Antrieb"] ~= nil then
            local AntriebConfigurations = storeItem.configurations["Antrieb"];
            local config = AntriebConfigurations[self.configurations["Antrieb"]];
            
			self.isAllWheels = config.name == g_i18n:getText("configuration_Allrad");
        end;
    end;
	
	local wheelCount = 0;

	self.wheelsToFix = {};
	
	while true do
		local wheelKey = "vehicle.wheelsToFix.wheelToFix(" .. tostring(wheelCount) .. ")";
		
		if not hasXMLProperty(self.xmlFile, wheelKey) then
            break;
        end;
		
		local wheelsToFix = {};
		
		wheelsToFix.node = Utils.indexToObject(self.components, getXMLString(self.xmlFile, wheelKey .. "#node"));
		
		if wheelsToFix.node ~= nil then
			table.insert(self.wheelsToFix, wheelsToFix);
		end;
	
		wheelCount = wheelCount + 1;
	end;
	
	if #self.wheelsToFix > 0 then	
		for _, wheelToFix in pairs(self.wheelsToFix) do	
			for _, wheel in pairs(self.wheels) do
				if wheel.driveNode == wheelToFix.node then
					if self.isAllWheels then
						wheel.tireTrackAtlasIndex = 0;
					else
						wheel.tireTrackAtlasIndex = 4;
					end;
					
					wheel.radiusBackup = wheel.radius;
				end;
			end;
		end;
	end;
end

function WheelRadiusFix:update(dt)
	if #self.wheelsToFix > 0 then	
		for _, wheelToFix in pairs(self.wheelsToFix) do	
			for _, wheel in pairs(self.wheels) do
				if wheel.driveNode == wheelToFix.node then
					if self.isAllWheels then
						wheel.radius = 0.001;
						wheel.tireTrackIndex = nil;
					else
						wheel.radius = wheel.radiusBackup;
					end;
				end;
			end;
		end;
	end;
end;

--## Unused but needed functions 

function WheelRadiusFix:delete()end;
function WheelRadiusFix:mouseEvent(posX, posY, isDown, isUp, button)end;
function WheelRadiusFix:keyEvent(unicode, sym, modifier, isDown)end;
function WheelRadiusFix:updateTick(dt)end;
function WheelRadiusFix:draw()end;