-- 
-- Buy on SiloTriggers
-- by Blacky_BPG
-- 
--
-- Version 1.4.0.0      |    08.02.2017    show money change after loading/purchase goods
-- Version 1.3.1.0 B    |    29.01.2017    fixed load game with trailer in trigger
-- Version 1.3.1.0 A    |    29.01.2017    fixed wrong price
-- Version 1.3.1.0      |    28.01.2017    initial Version for FS17, simplified script code for use of original integrated game codes


FillUtil.fertilizerFillTypes = {};
FillUtil.fertilizerFillTypes[FillUtil.FILLTYPE_LIQUIDFERTILIZER]=true;
FillUtil.fertilizerFillTypes[FillUtil.FILLTYPE_FERTILIZER]=true;
FillUtil.fertilizerFillTypes[FillUtil.FILLTYPE_MANURE]=true;
FillUtil.fertilizerFillTypes[FillUtil.FILLTYPE_LIQUIDMANURE]=true;
FillUtil.seedsFillTypes = {};
FillUtil.seedsFillTypes[FillUtil.FILLTYPE_SEEDS]=true;

local oldSiloTriggerUpdate = SiloTrigger.update;
SiloTrigger.update = function(self,dt)
	if self.hasCheckedForSellFunctions == nil then
		self.hasCheckedForSellFunctions = true;
		if self.isSellingPoint then self:minuteChanged() end;
	end;
	if self.isSellingPoint then
		if self.isServer then
			local trailer = self.siloTrailer;
			if self.activeTriggers >= 4 and trailer ~= nil then
				if self.isFilling then
					self.wasLoading = true;
					trailer:resetFillLevelIfNeeded(self.selectedFillType);
					local fillLevel = trailer:getFillLevel(self.selectedFillType);
					local siloAmount = 100000;
					if trailer:allowFillType(self.selectedFillType, false) then
						local deltaFillLevel = math.min(self.fillLitersPerSecond*0.001*dt, siloAmount);
						trailer:setFillLevel(fillLevel+deltaFillLevel, self.selectedFillType, false, self.fillVolumeDischargeInfos);
						local newFillLevel = trailer:getFillLevel(self.selectedFillType);
						if fillLevel ~= newFillLevel then
							local price = (newFillLevel-fillLevel) * self.priceMultipliers[self.selectedFillType] * (self.highestPrice[self.selectedFillType] / 1000);
							g_currentMission.missionStats:updateStats("expenses", price);
							if FillUtil.fertilizerFillTypes[self.selectedFillType] then self.lastMoneyType = "purchaseFertilizer" elseif FillUtil.seedsFillTypes[self.selectedFillType] then self.lastMoneyType = "purchaseSeeds" else self.lastMoneyType = "other" end;
							g_currentMission:addSharedMoney(-price, moneyType)
							self.lastMoneyShown = self.lastMoneyShown - price; 
						else self:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN) end;
					else self:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN) end;
				end;
			elseif self.isFilling then self:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN) end;
			if self.siloTrailerSend ~= self.siloTrailer then self.siloTrailerSend = self.siloTrailer self:raiseDirtyFlags(self.siloTriggerDirtyFlag) end;
		end;
	else oldSiloTriggerUpdate(self,dt) end;
end;

local oldSiloTriggergetFillLevel = SiloTrigger.getFillLevel;
SiloTrigger.getFillLevel = function(self, fillType)
	if self.isSellingPoint then return self.fillLevels[fillType] end;
	return oldSiloTriggergetFillLevel(self, fillType);
end;

local oldSiloTriggersetIsFilling = SiloTrigger.setIsFilling;
SiloTrigger.setIsFilling = function(self, isFilling, fillType, noEventSend)
	if self.isSellingPoint and self.wasLoading and not isFilling then
		if self.lastMoneyType ~= nil and self.lastMoneyShown ~= nil and self.lastMoneyShown ~= 0 then
			if self.lastMoneyType == "other" then self.lastMoneyType = "buyGoods" end;
			g_currentMission:addMoneyChange(self.lastMoneyShown, SiloTrigger.MONEY_TYPE_GOODS, true, g_i18n:getText("finance_"..self.lastMoneyType));
			self.lastMoneyType="other";
			self.lastMoneyShown=0;
			self.wasLoading = false;
		end;
	end;
	oldSiloTriggersetIsFilling(self, isFilling, fillType, noEventSend);
end;

local oldSiloTriggerDelete = SiloTrigger.delete;
SiloTrigger.delete = function(self)
	if self.isSellingPoint then if g_currentMission ~= nil and g_currentMission.environment ~= nil then g_currentMission.environment:removeMinuteChangeListener(self) end end;
	oldSiloTriggerDelete(self);
end;

function SiloTrigger:minuteChanged()
	for fillType,_ in pairs(self.fillTypes) do
		local bPrice, hPrice = 0,0;
		for _, trigger in pairs(g_currentMission.tipTriggers) do
			if trigger:getAllowFillTypeFromTool(fillType, TipTrigger.TOOL_TYPE_TRAILER) or trigger:getAllowFillTypeFromTool(fillType, TipTrigger.TOOL_TYPE_SHOVEL) or trigger:getAllowFillTypeFromTool(fillType, TipTrigger.TOOL_TYPE_PALLET) or trigger:getAllowFillTypeFromTool(fillType, TipTrigger.TOOL_TYPE_PIPE) then
				hPrice = trigger:getEffectiveFillTypePrice(fillType);
				if hPrice ~= nil then
					hPrice = hPrice * 1000;
					if hPrice > bPrice then bPrice = hPrice end;
				end;
			end;
		end;
		if bPrice > 0 and bPrice ~= self.highestPrice[fillType] then self.highestPrice[fillType]=bPrice elseif bPrice == 0 then self.highestPrice[fillType]=FillUtil.fillTypeIndexToDesc[fillType].pricePerLiter * 1000 end;
	end;
end;

local oldSiloTriggerLoad = SiloTrigger.load;
SiloTrigger.load = function(self, id)
	SiloTrigger.MONEY_TYPE_GOODS = getMoneyTypeId();
	self.isSellingPoint = getUserAttribute(id, "isSellingPoint");
	self.saveId = Utils.getNoNil(getUserAttribute(id, "stationName"), "station_farmSilo");
	if self.isSellingPoint then
		self.lastMoneyShown = 0;
		self.lastMoneyType = "other";
		self.wasLoading = false;
		local priceMultipliers = getUserAttribute(id, "priceMultipliers");
		local fillTypes = getUserAttribute(id, "fillTypes");
		if fillTypes ~= nil then
			local types = Utils.splitString(" ", fillTypes);
			local multipliers = Utils.splitString(" ", priceMultipliers);
			local ftCount = 0
			if self.fillTypes == nil then self.fillTypes = {} end;
			self.fillLevels = {};
			self.capacity = 10000000;
			self.priceMultipliers = {};
			self.highestPrice = {};
			for k,v in pairs(types) do
				local desc = FillUtil.fillTypeNameToDesc[v];
				if desc ~= nil then ftCount=ftCount+1 self.fillTypes[desc.index]=desc.index self.priceMultipliers[desc.index]=tonumber(Utils.getNoNil(multipliers[k],1)) self.highestPrice[desc.index]=1 self.fillLevels[desc.index]=1000000 end;
			end;
			if ftCount < 1 then print("Error: Buy function for SiloTrigger "..tostring(getName(id)).." can't be set, no fillTypes assigned") self.isSellingPoint=false else self.siloSources={} self.siloSources[self]=self end;
			g_currentMission.environment:addMinuteChangeListener(self);
		else self.isSellingPoint = false end;
	end;
	return oldSiloTriggerLoad(self, id);
end;

local count = 0;
local modDesc = loadXMLFile("modDesc", g_currentModDirectory .. "modDesc.xml");
while true do
	local baseText = string.format("modDesc.l10n.text(%d)", count);
	if not hasXMLProperty(modDesc, baseText) then
		break;
	end;
	local name = getXMLString(modDesc, baseText .. "#name");
	local entry = getXMLString(modDesc, baseText .. "."..g_languageShort);
	g_i18n.globalI18N.texts[name] = Utils.getNoNil(entry,g_i18n:getText(name));
	count = count + 1;
end;

print(" ++ loading BuyOnSiloTriggers V 1.4.0.0  -  08.02.2017 (by Blacky_BPG)");
