--[[
	FillWeightRegister.lua
	
	Author: 	Ifko[nator]
	Date:		12.03.2017
	Version:	1.0 - intial implementation
]]

SpecializationUtil.registerSpecialization("FillWeight", "FillWeight", g_currentModDirectory .. "FillWeight.lua");

FillWeightRegister = {};

function FillWeightRegister:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("fillable") then
						local v_name_string = v.name;
						local point_location = string.find(v_name_string, ".", nil, true);
						
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							
							if rawget(SpecializationUtil.specializations, string.format("%s.FillWeight", _name)) ~= nil
								or rawget(SpecializationUtil.specializations, string.format("%s.fillWeight", _name)) ~= nil 
								or rawget(SpecializationUtil.specializations, string.format("%s.ubt", _name)) ~= nil 
							then
								allowInsertion = false;
							end;
						end;
						
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("FillWeight"));
						end;
					end;
				end;
			end;	
		end;
	end;
end;

function FillWeightRegister:deleteMap()end;
function FillWeightRegister:keyEvent(unicode, sym, modifier, isDown)end;
function FillWeightRegister:mouseEvent(posX, posY, isDown, isUp, button)end;
function FillWeightRegister:update(dt)end;
function FillWeightRegister:draw()end;

addModEventListener(FillWeightRegister);