--
-- Author: Martin Fabik (aka LoogleCZ)
--
-- version ID   - 1.1
-- version date - 21.2.2016 (21:11)
-- 
--	v. 1.1 - added support for cutters
--
-- Free for non-comerecial usage
--
--[[
	Example XML node:
	
	<threshingAnimation animName="threshing" animSpeed="5"/>
	
]]--

threshingAnimation = {};

function threshingAnimation.prerequisitesPresent(specializations)
	return true;
end;

function threshingAnimation:load(savegame)
	self.LTA = {};
	self.LTA.animation = getXMLString(self.xmlFile, "vehicle.threshingAnimation#animName");
	self.LTA.speed = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.threshingAnimation#animSpeed"), 1);
	self.LTA.transportSafetyCutterDetached = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingAnimation#transportSafetyCutterDetachedNode"));
	self.LTA.transportSafetyCutterAttached = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.threshingAnimation#transportSafetyCutterAttachedNode"));
	
	if savegame == nil and self.setIsStrawEnabled ~= nil then
		self:setIsStrawEnabled(false, true, true);
	end;
end;

function threshingAnimation:delete()
end;

function threshingAnimation:writeStream(streamId, connection)
end;

function threshingAnimation:readStream(streamId, connection)
end;

function threshingAnimation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function threshingAnimation:keyEvent(unicode, sym, modifier, isDown)
end;

function threshingAnimation:update(dt)
	if self.LTA.transportSafetyCutterDetached ~= nil then
		setVisibility(self.LTA.transportSafetyCutterDetached, self.numAttachedCutters == 0);
	end;
	
	if self.LTA.transportSafetyCutterAttached ~= nil then
		setVisibility(self.LTA.transportSafetyCutterAttached, self.numAttachedCutters > 0);
	end;
end;

function threshingAnimation:onStartReel()
	if self.LTA.animation ~= nil then
		self:playAnimation(self.LTA.animation, self.LTA.speed, Utils.clamp(self:getAnimationTime(self.LTA.animation), 0, 1), true);
	end;
end;

function threshingAnimation:onStopReel()
	if self.LTA.animation ~= nil then
		self:stopAnimation(self.LTA.animation, true);
	end;
end;

function threshingAnimation:onTurnedOn()
	if self.LTA.animation ~= nil then
		self:playAnimation(self.LTA.animation, self.LTA.speed, Utils.clamp(self:getAnimationTime(self.LTA.animation), 0, 1), true);
	end;
end;

function threshingAnimation:onTurnedOff()
	if self.LTA.animation ~= nil then
		self:stopAnimation(self.LTA.animation, true);
	end;
end;

function threshingAnimation:updateTick(dt)
end;

function threshingAnimation:draw()
end;