--
-- PipeUnloadingFix
-- Specialization for working of manual PipeUnloading with the Claas Lexion Pack
--
-- @author  	Ifko[nator]
-- @date  		22.09.2017
-- @version		1.0


PipeUnloadingFix = {};

local currentModDirectory = g_currentModDirectory;

local modFilename, _, _ = Utils.removeModDirectory(currentModDirectory);

function PipeUnloadingFix:loadMap(name)
	self.modName = "";
	self.modNamePrint = string.sub(modFilename, 0, (string.len(modFilename) - 1));
	
	for _, mod in pairs(ModsUtil.modList) do
		if SpecializationUtil.getSpecialization(tostring(mod.modName) .. ".pipeUnloading") ~= nil then		
			print("[Info from the PipeUnloadingFix.lua]: Found the PipeUnloading.lua in the '" .. mod.modName ..".zip'.");
			
			if g_modIsLoaded[tostring(mod.modName)] then	
				self.modName = _G[tostring(mod.modName)];
			end;
		end;
	end;
	
	if self.modName ~= "" then
		self.modName.PipeUnloading.load = Utils.overwrittenFunction(self.modName.PipeUnloading.load, PipeUnloadingFix.loadFix);
		
		print("[Info from the PipeUnloadingFix.lua]: Overwrite load function from the PipeUnloading.lua to allow use this with the '" .. self.modNamePrint ..".zip'.");
	else
		print("[Info from the PipeUnloadingFix.lua]: NOT overwrite load function from the PipeUnloading.lua to allow use this with the '" .. self.modNamePrint ..".zip', because the combine addon was not loaded!");
	end;
end;

function PipeUnloadingFix:loadFix(superFunc, savegame)
	local isPipeUnloader = false;
	local fillTypeCategory = "";
	local fillTypeName = "";
	local overloadingCapacity = 0;
	local rootName = getXMLRootName(self.xmlFile)
	local i=0;
	
	while true do
		local key = string.format(rootName..".fillUnits.fillUnit(%d)", i);
		if not hasXMLProperty(self.xmlFile, key) then
			break;
		end;
		
		local fillTypeCategories = getXMLString(self.xmlFile, key .. "#fillTypeCategories");
		if fillTypeCategories == "combine" or fillTypeCategories == "combine combine_grass" or fillTypeCategories == "augerWagon" then
			isPipeUnloader = true;
			fillTypeCategory = fillTypeCategories;
			
			break;
		end;
		
		i = i + 1;
	end;
	
	if self.fillUnits ~= nil and not isPipeUnloader then
		for _,fillUnit in pairs(self.fillUnits) do
			for k,fillTypes in pairs(fillUnit) do
				if k == "fillTypes" then
					for fillType,_ in pairs(fillTypes) do
						if fillType == FillUtil.FILLTYPE_SUGARBEET or fillType == FillUtil.FILLTYPE_POTATO or fillType == FillUtil.FILLTYPE_FERTILIZER or fillType == FillUtil.FILLTYPE_SEEDS then
							isPipeUnloader = true;
							fillTypeName = FillUtil.fillTypeIntToName[fillType];
							break;
						end;
					end;
				end;
			end;
		end;
	end;
	
	if isPipeUnloader then
		isPipeUnloader = self.canUnload == nil and self.unloadingStarted == nil; -- Manuelles Abbunkern von Thomas Heck (Patar)
		if not isPipeUnloader then
			print("Manuelles Abbunkern von Thomas Heck (Patar) is in use! PipeUnloading of CombineAddOn can not be used.")
			
			return;
		end;
	else
		print("has not the right fillTypeCategory/fillType! PipeUnloading of CombineAddOn can not be used.")
	end;
	
	if self.overloading ~= nil and self.overloading.capacity ~= nil then
		overloadingCapacity = self.overloading.capacity;
	end;
	
	self.isPipeUnloader = overloadingCapacity > 0 and isPipeUnloader;
	
	if self.isPipeUnloader then
		self.isPipeUnloadingAllowed = false;
		self.puDischargeToGround = false;
		self.targetFound = false;
		self.setIsPipeUnloadingAllowed = PipeUnloadingFix.modName.PipeUnloading.setIsPipeUnloadingAllowed;
		self.findTrailerRaycastCallback = Utils.overwrittenFunction(self.findTrailerRaycastCallback, PipeUnloadingFix.modName.PipeUnloading.findTrailerRaycastCallback);
		self.getIsOverloadingAllowed = Utils.overwrittenFunction(self.getIsOverloadingAllowed, PipeUnloadingFix.modName.PipeUnloading.getIsOverloadingAllowed);
		self.onStopAiVehicle = Utils.overwrittenFunction(self.onStopAiVehicle, PipeUnloadingFix.modName.PipeUnloading.onStopAiVehicle);
		
		if fillTypeCategory ~= "" then
			print("PipeUnloading -> fillTypeCategory: "..tostring(fillTypeCategory)..", overloadingCapacity: "..tostring(overloadingCapacity));
		else
			print("PipeUnloading -> fillType: "..tostring(fillTypeName)..", overloadingCapacity: "..tostring(overloadingCapacity));
		end;
	end;
end;

--## Unused but needed functions

function PipeUnloadingFix:update(dt)end;
function PipeUnloadingFix:deleteMap()end;
function PipeUnloadingFix:keyEvent(unicode, sym, modifier, isDown)end;
function PipeUnloadingFix:mouseEvent(posX, posY, isDown, isUp, button)end;
function PipeUnloadingFix:draw()end;

addModEventListener(PipeUnloadingFix);