--[[
Spezialisierung die den Cam Zoom aller Fahrzeuge erweitert. In der modDesc der 'zzz_CameraZoomExtension.zip' konfigurierbar. 

<vehicleCam transMax="NEUER_WERT_DEN_DU_WILLST" />

Author:	Ifko[nator]
Datum:	09.12.2016

Version:	v2.0
History:	v1.0 @ 17.07.2015 - initial implementation -- GLOBAL VERSION!
			v2.0 @ 09.12.2016 - convert to FS 17
]]

CameraZoomExtension = {};

local cameraZoomExtension_Directory = g_currentModDirectory;

function CameraZoomExtension.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Drivable, specializations);
end;

function CameraZoomExtension:load(savegame)
	local modDesc = loadXMLFile("modDesc", cameraZoomExtension_Directory .. "modDesc.xml");
	
	self.camZoomMax = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.vehicleCam#transMax"), 60);
	
	self.camZoomMax = math.floor(self.camZoomMax);
	
	local camCount = getXMLFloat(self.xmlFile, "vehicle.cameras#count");
	
	if camCount ~= nil then
		for cam = 1, camCount do
			if self.cameras[cam].transMax ~= nil then
				if self.cameras[cam].transMax > 0 then
					--print("[DEBUG from the CameraZoomExtension.lua]: Found 'transMax'! Value = '" .. self.cameras[cam].transMax .."' in cam: '" .. cam .. "'.");
			
					if self.cameras[cam].transMax < self.camZoomMax then
						self.cameras[cam].transMax = self.camZoomMax;
						
						--print("[DEBUG from the CameraZoomExtension.lua]: Set 'transMax' for cam '" .. cam .. "' to: '" .. self.cameras[cam].transMax .. "'.");
					end;
				end;
			end;
		end;
	else
		print("[WARNING from the CameraZoomExtension.lua]: Missing the TAG 'vehicle.cameras#count' in the XML File: '" .. self.configFileName .. "'!");
		print("[WARNING from the CameraZoomExtension.lua]: This should not happen, but this Script is stopped for this Vehicle!");
	end;
	
	delete(modDesc);
end;

function CameraZoomExtension:delete()
end;

function CameraZoomExtension:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CameraZoomExtension:keyEvent(unicode, sym, modifier, isDown)
end;

function CameraZoomExtension:update(dt)
end;


function CameraZoomExtension:draw()
end;