--[[
	LockSteeringAxlesRegister.lua
	
	Author: 	Ifko[nator]
	Date:		07.05.2017
	Version:	1.0 - intial implementation
]]

SpecializationUtil.registerSpecialization("lockSteeringAxles", "LockSteeringAxles", g_currentModDirectory .. "LockSteeringAxles.lua");

LockSteeringAxlesRegister = {};

function LockSteeringAxlesRegister:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("attachable") then
						local v_name_string = v.name;
						local point_location = string.find(v_name_string, ".", nil, true);
						
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							
							if rawget(SpecializationUtil.specializations, string.format("%s.LockSteeringAxles", _name)) ~= nil
								or rawget(SpecializationUtil.specializations, string.format("%s.lockSteeringAxles", _name)) ~= nil 
							then
								allowInsertion = false;
							end;
						end;
						
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("lockSteeringAxles"));
						end;
					end;
				end;
			end;	
		end;
	end;
end;

function LockSteeringAxlesRegister:deleteMap()end;
function LockSteeringAxlesRegister:keyEvent(unicode, sym, modifier, isDown)end;
function LockSteeringAxlesRegister:mouseEvent(posX, posY, isDown, isUp, button)end;
function LockSteeringAxlesRegister:update(dt)end;
function LockSteeringAxlesRegister:draw()end;

addModEventListener(LockSteeringAxlesRegister);