--[[
RollerTurnedOnRotationNodes

Author:	Ifko[nator]
Datum:	06.08.2017

Version:	v1.0
History:	v1.0 - initial implementation in FS17
]]

RollerTurnedOnRotationNodes = {};
	
function RollerTurnedOnRotationNodes.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Roller, specializations);
end;

function RollerTurnedOnRotationNodes:load(savegame)
	self.RollerTurnedOnRotationNodes = Utils.loadRotationNodes(self.xmlFile, {}, "vehicle.turnedOnRotationNodes.turnedOnRotationNode", "roller", self.components); 
	
	if self.isClient then
		self.sampleMulcher = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.mulcherSound", nil, self.baseDirectory);
	end;
end;

function RollerTurnedOnRotationNodes:update(dt)
	if self.isClient then
        Utils.updateRotationNodes(self, self.RollerTurnedOnRotationNodes, dt, self:getIsActive() and self:getIsTurnedOn());
	end;
end;

function RollerTurnedOnRotationNodes:updateTick(dt)
	if self.isClient then	
		if self:getIsActive() and self:getIsTurnedOn() then
            if self:getIsActiveForSound() then
               SoundUtil.playSample(self.sampleMulcher, 0, 0, nil);
            end;
        else
			SoundUtil.stopSample(self.sampleMulcher);
        end;
	end;
end;

function RollerTurnedOnRotationNodes:delete()
    if self.isClient then
        SoundUtil.deleteSample(self.sampleMulcher);
    end;
end;

function RollerTurnedOnRotationNodes:onDeactivateSounds()
    if self.isClient then
        SoundUtil.stopSample(self.sampleMulcher, true);
    end;
end;

--## unused but needed functions

function RollerTurnedOnRotationNodes:mouseEvent(posX, posY, isDown, isUp, button)end;
function RollerTurnedOnRotationNodes:keyEvent(unicode, sym, modifier, isDown)end;
function RollerTurnedOnRotationNodes:draw()end;