--[[
	SetRadioVolumeDirectlyInGame.lua
	
	Script to set the volume of the ingame radio without open the menu
	
	Author: 	Ifko[nator]
	Datum:		29.07.2017
	Version: 	1.1
	
	History:	V1.0 @ 24.07.2017 - initial implementation in FS 17
				V1.1 @ 29.07.2017 - input bindings will no longer showed in the help window, after 8 sec or when the radio is off
]]

SetRadioVolumeDirectlyInGame = {};

function SetRadioVolumeDirectlyInGame:loadMap(name)
	self.volume = 0;
	self.helpButtonsTimeout = 0;
end;

function SetRadioVolumeDirectlyInGame:update(dt)
	if g_gameSettings ~= nil then	
		if self.isRadioActive ~= g_gameSettings:getValue("radioIsActive") then
			self.helpButtonsTimeout = g_currentMission.time + 8000; --## show help buttons 8 sec after turn on radio
			
			self.isRadioActive = g_gameSettings:getValue("radioIsActive");
		end;
		
		if (g_currentMission.controlledVehicle ~= nil or not g_gameSettings:getValue("radioVehicleOnly")) and g_gameSettings:getValue("radioIsActive") then	
			if g_gameSettings:getValue("radioVolume") <= 0.9 then
				if self.helpButtonsTimeout > g_currentMission.time then
					g_currentMission:addHelpButtonText(g_i18n:getText("input_RADIO_VOLUME_UP"), InputBinding.RADIO_VOLUME_UP, nil, GS_PRIO_VERY_HIGH);
				end;
				
				if InputBinding.hasEvent(InputBinding.RADIO_VOLUME_UP)	then
					volume = g_gameSettings:getValue("radioVolume") + 0.1
				end;
			end
			
			if g_gameSettings:getValue("radioVolume") >= 0.1 then
				if self.helpButtonsTimeout > g_currentMission.time then	
					g_currentMission:addHelpButtonText(g_i18n:getText("input_RADIO_VOLUME_DOWN"), InputBinding.RADIO_VOLUME_DOWN, nil, GS_PRIO_VERY_HIGH);
				end;
				
				if InputBinding.hasEvent(InputBinding.RADIO_VOLUME_DOWN) then
					volume = g_gameSettings:getValue("radioVolume") - 0.1
				end;
			end;
			
			if volume ~= nil and self.volume ~= volume then
				--print("set radio volume to " .. volume);
				
				g_gameSettings:setValue("radioVolume", volume, true);
				g_currentMission:setRadioVolume(volume);
				
				self.volume = volume;
			end;
		end;
	end;
end;

--## unused but needed functions

function SetRadioVolumeDirectlyInGame:deleteMap()end;
function SetRadioVolumeDirectlyInGame:keyEvent(unicode, sym, modifier, isDown)end;
function SetRadioVolumeDirectlyInGame:mouseEvent(posX, posY, isDown, isUp, button)end;
function SetRadioVolumeDirectlyInGame:draw()end;

addModEventListener(SetRadioVolumeDirectlyInGame);