--[[
	CutterFix.lua
	
	Fix to prevent turned a combine on, when the frontshield is attached and fix for the choppedStraw Mod (expected workAreas!)
  
  	@author: 	 Ifko[nator]
  	@version:	 v1.0
	@history:	 v1.0 @ 22.07.2017 - Initial implementation
]]

CutterFix = {};

function CutterFix.prerequisitesPresent(specializations)
    return true;
end;

function CutterFix:preLoad(savegame)
    self.loadWorkAreaFromXML = CutterFix.loadWorkAreaFromXML;
end;

function CutterFix:load(savegame)
	self.workAreas = {};
    
	local i = 0;
    
	while true do
        local key = string.format("vehicle.workAreas.workArea(%d)", i);
        
		if not hasXMLProperty(self.xmlFile, key) then
            break;
        end;
        
		local workArea = {};
        
		if self:loadWorkAreaFromXML(workArea, self.xmlFile, key) then
            table.insert(self.workAreas, workArea);
        end;
        
		i = i + 1;
    end;
end;

function CutterFix:loadWorkAreaFromXML(workArea, xmlFile, key)
    local start = Utils.indexToObject(self.components, getXMLString(self.xmlFile, key .. "#startIndex"));
    local width = Utils.indexToObject(self.components, getXMLString(self.xmlFile, key .. "#widthIndex"));
    local height = Utils.indexToObject(self.components, getXMLString(self.xmlFile, key .. "#heightIndex"));

    if start ~= nil and width ~= nil and height ~= nil then
	   if self.groundReferenceNodes ~= nil and table.getn(self.groundReferenceNodes) == 1 then
            workArea.refNode = self.groundReferenceNodes[1];
        end;

        local areaTypeStr = getXMLString(self.xmlFile, key .."#type");
        
		if areaTypeStr == nil then
            workArea.type = WorkArea.AREATYPE_DEFAULT;
        else
            local areaType = WorkArea.areaTypeNameToInt[areaTypeStr];
            assert(areaType ~= nil, "Invalid workarea-type '" .. areaTypeStr .. "' (" .. key .. ")");
            workArea.type = areaType;
        end;

        workArea.disableBackwards = Utils.getNoNil(getXMLBool(self.xmlFile, key .. "#disableBackwards"), true);
        workArea.start = start;
        workArea.width = width;
        workArea.height = height;
        
		return true;
    end;
	
    return false;
end;

function CutterFix:update(dt)
	local rootAttacherVehicle = self:getRootAttacherVehicle();
	
	if rootAttacherVehicle ~= nil and rootAttacherVehicle.numAttachedCutters ~= nil then
		if rootAttacherVehicle.numAttachedCutters > 0 then
			rootAttacherVehicle.numAttachedCutters = 0;
		end;
	end;
end;


function CutterFix:delete()end;
function CutterFix:mouseEvent(posX, posY, isDown, isUp, button)end;
function CutterFix:keyEvent(unicode, sym, modifier, isDown)end;
function CutterFix:draw()end;