CoverKotte = {};

function CoverKotte.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end

function CoverKotte:preLoad(savegame)
    self.getIsToggleCoverAllowed = CoverKotte.getIsToggleCoverAllowed;
    self.allowFillType = Utils.overwrittenFunction(self.allowFillType, CoverKotte.allowFillType);
    self.getAllowFillFromAir = Utils.overwrittenFunction(self.getAllowFillFromAir, CoverKotte.getAllowFillFromAir);
    self.setCoverState = CoverKotte.setCoverState;
end

function CoverKotte:load(savegame)
    --self.addFillTrigger = Utils.overwrittenFunction(self.addFillTrigger, CoverKotte.addFillTrigger);
   -- self.removeFillTrigger = Utils.overwrittenFunction(self.removeFillTrigger, CoverKotte.removeFillTrigger);
    self.coverAnimation = getXMLString(self.xmlFile, "vehicle.cover#animationName");
    if self.coverAnimation ~= nil then
        local isOpen = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.cover#openOnBuy"), false);
        if savegame ~= nil then
            isOpen = Utils.getNoNil(getXMLBool(savegame.xmlFile, savegame.key.."#isCoverOpen"), isOpen);
        end
        self:setCoverState(isOpen, true);
        self.forceOpenOnTip = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.cover#forceOpenOnTip"), true);
        self.autoReactToTrigger = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.cover#autoReactToTrigger"), false);
    else
        self.isCoverOpen = true;
    end
end

function CoverKotte:getSaveAttributesAndNodes(nodeIdent)
    if self.coverAnimation ~= nil then
        local attributes = 'isCoverOpen="'..tostring(self.isCoverOpen)..'"';
        return attributes, nil;
    end
    return nil;
end

function CoverKotte:readStream(streamId, connection)
    if connection:getIsServer() then
        if self.coverAnimation ~= nil then
            local isOpen = streamReadBool(streamId);
            self:setCoverState(isOpen, true);
        end
    end
end

function CoverKotte:writeStream(streamId, connection)
    if not connection:getIsServer() then
        if self.coverAnimation ~= nil then
            streamWriteBool(streamId, self.isCoverOpen);
        end
    end
end

function CoverKotte:update(dt)
    if self:getIsActiveForInput() then
        if self.coverAnimation ~= nil then
            if InputBinding.hasEvent(InputBinding.TOGGLE_COVER) then
                if self:getIsToggleCoverAllowed(not self.isCoverOpen) then
                    self:setCoverState(not self.isCoverOpen);
                end
            end
        end
    end
end

function CoverKotte:draw()
    if self.isClient and self:getIsActiveForInput(true) then
        if self.coverAnimation ~= nil and self:getIsToggleCoverAllowed(not self.isCoverOpen) then
            if self.isCoverOpen then
                g_currentMission:addHelpButtonText(g_i18n:getText("action_closeCoverKotte"), InputBinding.TOGGLE_COVER, nil, GS_PRIO_NORMAL);
            else                                                                                                  
                g_currentMission:addHelpButtonText(g_i18n:getText("action_openCoverKotte"), InputBinding.TOGGLE_COVER, nil, GS_PRIO_NORMAL);
            end
        end
    end
    if self.isServer then
        if self.autoReactToTrigger then
            if shouldOpen ~= self.isCoverOpen then
                self:setCoverState(shouldOpen);
            end
        end
    end
end

function CoverKotte:getIsToggleCoverAllowed(isCoverOpen)
    if self.tipState ~= nil then
        return self.tipState == Trailer.TIPSTATE_CLOSED;
    end
    return true;
end

function CoverKotte:allowFillType(superFunc, fillType, allowEmptying)
    if not self.isCoverOpen then
        return false;
    end
    if superFunc ~= nil then
        return superFunc(self, fillType, allowEmptying);
    end
    return true;
end

function CoverKotte:setCoverState(isOpen, noEventSend)
    if self.coverAnimation ~= nil then
        SetCoverStateEvent.sendEvent(self, isOpen, noEventSend);
        self.isCoverOpen = isOpen;
        if isOpen then
            self:playAnimation(self.coverAnimation, -1, self:getAnimationTime(self.coverAnimation), true);
        else
            self:playAnimation(self.coverAnimation, 1, self:getAnimationTime(self.coverAnimation), true);
        end
    end
end

function CoverKotte:getAllowFillFromAir(superFunc)
    if not self.isCoverOpen then
        return false;
    end
    if superFunc ~= nil then
        return superFunc(self);
    end
    return true
end

--[[
function CoverKotte:addFillTrigger(superFunc, trigger)
    if superFunc ~= nil then
        superFunc(self, trigger);
    end
    if self.fillTriggers ~= nil and table.getn(self.fillTriggers) > 0 then
        self:setCoverState(true);
    end
end

function CoverKotte:removeFillTrigger(superFunc, trigger)
    if superFunc ~= nil then
        superFunc(self, trigger);
    end
    if self.fillTriggers ~= nil and table.getn(self.fillTriggers) == 0 then
        self:setCoverState(false);
    end
end

function CoverKotte:onStartTip(tipTrigger, tipReferencePointIndex, noEventSend)
    if self.coverAnimation ~= nil then
        if self.forceOpenOnTip then
           self:setCoverState(true, true);
        end
    end
end
]]
--## unused but needed functions

function CoverKotte:mouseEvent(posX, posY, isDown, isUp, button)end;
function CoverKotte:keyEvent(unicode, sym, modifier, isDown)end;
function CoverKotte:delete()end;