--[[
Specialization to fix the input for eviscerating the bales with the BaleEviscerator.lua from the goeweil lt master

Author:		Ifko[nator]
Datum:		22.06.2017

Version:	1.0

History:	v1.0 @ 22.06.2017 - initial implementation
]]

BaleEviscerator_InputFix = {};

function BaleEviscerator_InputFix:loadMap(name)
	self.modName = "";
	
	for _, mod in pairs(ModsUtil.modList) do
		if SpecializationUtil.getSpecialization(tostring(mod.modName) .. ".ltmaster") ~= nil then		
			if g_modIsLoaded[tostring(mod.modName)] then	
				self.modName = _G[tostring(mod.modName)];
			end;
		end;
	end;
	
	if self.modName ~= "" then
		self.modName.BaleEviscerator.update = Utils.overwrittenFunction(self.modName.BaleEviscerator.update, BaleEviscerator_InputFix.updateFix);
		
		print("[Info from the BaleEviscerator_InputFix.lua]: Overwrite upadte function from the BaleEviscerator.lua to fix the input for eviscerating the bales.");
	else
		print("[Info from the BaleEviscerator_InputFix.lua]: NOT overwrite upadte function from the BaleEviscerator.lua to fix the input for eviscerating the bales, because the goeweil lt master was not loaded!");
	end;
end;

function BaleEviscerator_InputFix:updateFix(superFunc, dt)
	if not g_currentMission.missionDynamicInfo.isMultiplayer then
        self.baleObject = nil;
        self.eviHud:setIsVisible(false, true);
		
        if g_currentMission.player ~= nil and g_currentMission.controlledVehicle == nil and g_currentMission.player.lastFoundBale ~= nil and g_currentMission.player.currentToolId == 0 then
            self.baleObject = g_currentMission.player.lastFoundBale;
            self.eviHud:setIsVisible(true, true);
        end;
		
        if self.baleObject ~= nil then
            g_currentMission:addHelpButtonText(g_i18n:getText("input_EVIBALE"), InputBinding.TOGGLE_COVER, nil, GS_PRIO_VERY_HIGH);
            if InputBinding.hasEvent(InputBinding.TOGGLE_COVER) then
				BaleEviscerator_InputFix.modName.BaleEvisceratorEvent:sendEvent(self.baleObject);
                
				self:evisceratesBale(self.baleObject, true);
            end;
        end;
    end;
end;

--## Unused but needed functions

function BaleEviscerator_InputFix:update(dt)end;
function BaleEviscerator_InputFix:deleteMap()end;
function BaleEviscerator_InputFix:keyEvent(unicode, sym, modifier, isDown)end;
function BaleEviscerator_InputFix:mouseEvent(posX, posY, isDown, isUp, button)end;
function BaleEviscerator_InputFix:draw()end;

addModEventListener(BaleEviscerator_InputFix);