--[[
	KroneUltimaExtension_Register.lua
	
	Autor: Ifko[nator]
	Datum: 14.06.2017
]]

SpecializationUtil.registerSpecialization("KroneUltimaExtension", "KroneUltimaExtension", g_currentModDirectory .. "KroneUltimaExtension.lua")

KroneUltimaExtension_Register = {};

function KroneUltimaExtension_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = false;
				
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					
					-- Standard lua's
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("fillable") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							
							-- Mod lua's (nicht im dataS Ordner!)
							if rawget(SpecializationUtil.specializations, string.format("%s.Ultima", _name)) ~= nil then
								allowInsertion = true;
							end;
						end;
						
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("KroneUltimaExtension"));
						end;
					end;
				end;
			end;	
		end;
	end;
end;

function KroneUltimaExtension_Register:deleteMap()end;
function KroneUltimaExtension_Register:keyEvent(unicode, sym, modifier, isDown)end;
function KroneUltimaExtension_Register:mouseEvent(posX, posY, isDown, isUp, button)end;
function KroneUltimaExtension_Register:update(dt)end;
function KroneUltimaExtension_Register:draw()end;

--## Double Filename fix for mods. Inspired from the 'BaleExtension' Mod by Upsidedown.

local fixLoadSharedI3DFile = Utils.loadSharedI3DFile;
local currentModName = g_currentModName;
local modsDirectory = g_modsDirectory;

function Utils.loadSharedI3DFile(filename, baseDir, ...)
	local pos = string.find(filename, ":/", 1);
	if pos ~= nil then	
		baseDir = "";
	end;
	
	pos = string.find(filename, ":/", 3);
	
	if pos ~= nil then		
		filename = string.sub(filename, pos - 1);
	end;
	
	pos = string.find(filename, "/" .. currentModName .. "/bales/");
	if pos ~= nil then
		if not fileExists(Utils.getNoNil(baseDir, "") .. filename) then
			baseDir = "";
			filename = modsDirectory .. string.sub(filename, pos + 1);
		end;
	end;
	
	local fixedFilename = fixLoadSharedI3DFile(filename, baseDir, ...);

	return fixedFilename;
end;

addModEventListener(KroneUltimaExtension_Register);