--[[
Spezialisierung zum rendern der Anzahl von verbleibenden Ballen für Folie und Garn auf den Bildschirm.

Author:		Ifko[nator]
Datum:		16.06.2017

Version:	4.0

History:	v1.0 @ 18.09.2015 - initial implementation
			-------------------------------------------------------------------------------------------------------------------------
			v2.0 @ 29.09.2015 - the timing of the net wrap consumption has been adjusted, little bit dirty but it works
							  -	set correct rotation for the bale in the bale chamber --## removed in v3.5!
							  - bales will now added to the ingame stats, also the already pressed bales --## removed in v3.5!
			-------------------------------------------------------------------------------------------------------------------------
			v3.0 @ 03.10.2015 - set correct rotation for the middle net roll --## removed in v3.5!
							  - animated pickup roll when baler is filling --## removed in v3.5!
							  - bug fix for the case, the main chamber door is opening and the wrapper table is not rotated forwards --## removed in v3.5!
							  - bug fix for load the wrong bale size, little bit dirty but it works --## removed in v3.5!
			-------------------------------------------------------------------------------------------------------------------------
			v3.5 @ 22.07.2016 - support for the V2 of the Krone Ultima and removed some fixes, they are not longer needed here
			-------------------------------------------------------------------------------------------------------------------------
			v3.6 @ 28.07.2016 - add multifruit support for klee_windrow, luzerene_windrow, triticale_windrow, oat_windrow, rye_windrow, dinkel_windrow, sunflower_windrow and rape_windrow when avaiable on the current Map --## removed in v4.0!
								info: more windrows can be in the modDesc file added --## removed in v4.0!
								fix for the pickup roll.. Now they will only rotate on filling
			-------------------------------------------------------------------------------------------------------------------------
			v4.0 @ 16.06.2017 - convert to FS 17
								fix the color from the reverse real light
]]

KroneUltimaExtension = {};

local kroneUltimaExtension_directory = g_currentModDirectory;

local modDesc = loadXMLFile("modDesc", kroneUltimaExtension_directory .. "modDesc.xml");
local version = Utils.getNoNil(getXMLString(modDesc, "modDesc.version"), "!!! --->>> Missing 'version' attribute in modDesc file! <<<--- !!!");

print("### Krone Ultima Extension by Ifko[nator] in der Version: '" .. version .. "' erfolgreich geladen!");

delete(modDesc);

function KroneUltimaExtension.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Ultima, specializations);
end;

function KroneUltimaExtension:preLoad(savegame)
	self.loadSpeedRotatingPartFromXML = Utils.overwrittenFunction(self.loadSpeedRotatingPartFromXML, KroneUltimaExtension.loadSpeedRotatingPartFromXML);
end;

function KroneUltimaExtension:load(savegame)
	local modDesc = loadXMLFile("modDesc", kroneUltimaExtension_directory .. "modDesc.xml");
	local allowWrapStrawBales = Utils.getNoNil(getXMLBool(modDesc, "modDesc.ultima#allowWrapStrawBales"), true);
	
	if allowWrapStrawBales then
		local straw = FillUtil.fillTypeNameToInt["straw"];
		local grass_windrow = FillUtil.fillTypeNameToInt["grass_windrow"];
		
		local fileNameForWrapping = {
			Utils.getFilename("bales/Bale130StrawWrap.i3d", kroneUltimaExtension_directory),
			Utils.getFilename("bales/Bale140StrawWrap.i3d", kroneUltimaExtension_directory),
			Utils.getFilename("bales/Bale150StrawWrap.i3d", kroneUltimaExtension_directory)
		};
		
		if (fileNameForWrapping[1] and fileNameForWrapping[2] and fileNameForWrapping[3]) ~= nil then	
			for size = 1, 3 do	
				self.baleSizes[size].fillTypes[straw].isWrapAble = true;
				self.baleSizes[size].fillTypes[straw].fileNameForWrapping = fileNameForWrapping[size];
				self.baleSizes[size].fillTypes[straw].wrappedFileName = self.baleSizes[size].fillTypes[grass_windrow].wrappedFileName;

				--print("[INFO from the KroneUltimaExtension.lua]: self.baleSizes[".. size .. "].fillTypes[straw].wrappedFileName = " .. tostring(self.baleSizes[size].fillTypes[straw].wrappedFileName));
			end;
			
			print("[INFO from the KroneUltimaExtension.lua]: Enable wrapping now for straw bales with the Krone Ultima.");
		else
			print("[ERROR from the KroneUltimaExtension.lua]: Cant load bales for straw wrapping! Disable wrapping for straw bales now!");
		end;
	end;
	
	delete(modDesc);
	
	self.getIsSpeedRotatingPartActive = Utils.overwrittenFunction(self.getIsSpeedRotatingPartActive, KroneUltimaExtension.getIsSpeedRotatingPartActive);

	self.showFoilAndNetHud = true;
	
	if savegame ~= nil and not savegame.resetVehicles then
		self.showFoilAndNetHud = Utils.getNoNil(getXMLBool(savegame.xmlFile, savegame.key .. "#showFoilAndNetHud"), self.showFoilAndNetHud);
	end;
	
	for _, workArea in pairs(self.workAreas) do
		--print("--## set Tanslation for workArea start");
		setTranslation(workArea.start, 1.5, 0, 0);
		--print("--## set Tanslation for workArea width");
		setTranslation(workArea.width, -1.5, 0, 0);
		--print("--## set Tanslation for workArea height");
		setTranslation(workArea.height, 1.5, 0, -0.75);
	end;
	
	local reverseRealLight = Utils.indexToObject(self.components, "0>0|2|2|1|3");
	local oldLightSetting = {getLightColor(reverseRealLight)};
	
	if oldLightSetting[1] == 0.5 then
		print("[INFO from the KroneUltimaExtension.lua]: Found wrong settings for the reverse real light. Fix it now.");
		
		local reverseRealLight2 = Utils.indexToObject(self.components, "0>0|2|2|1|4");
		
		setLightColor(reverseRealLight, 1, 1, 1);
		setLightColor(reverseRealLight2, 1, 1, 1);
	end;
	
	--## delete the original hud from the ultima
	
	if self.hud ~= nil then
		self.hud:delete();
	end;
	
	--## deactivate the texts from the original ultima hud
	
	self.baleCounterSingleText.textSize = 0;
	self.baleCounterAllText.textSize = 0;
	self.baleCounterSingleText.textSize = 0;
	self.mainPressChamberText.textSize = 0;
	self.prePressChamberText.textSize = 0;
	
	--## load the hud from the ultima new in FS 17 Style
	
	self.uiScale = g_uiScale;
    
	if g_gameSettings ~= nil then
        self.uiScale = g_gameSettings:getValue("uiScale")
    end
	
	local width, height = getNormalizedScreenValues(225 * self.uiScale, 20 * self.uiScale);
	local w, h = getNormalizedScreenValues(0, 145 * self.uiScale);
	
	local startX = 1 - g_safeFrameOffsetX - (width / 2);
	local startY = h + g_safeFrameOffsetY;
	
	local hudWidth, hudHeight = getNormalizedScreenValues(38 * self.uiScale, 43 * self.uiScale);
	local iconWidth = width / 4;
	local iconHeight = iconWidth * g_screenAspectRatio;
	local scaleX, scaleY = 0.92 * self.uiScale, 0.92 * self.uiScale;
	
	--## foil and net row
	
	self.hudFoilPosX = startX - hudWidth * 2.965;
	self.hudNetPosX = startX + hudWidth * 0.1;
	
	self.hudPosYHideGUI = startY - iconHeight / 2.65;
	self.hudPosYBackup = startY + iconHeight * 2;
	self.hudPosY = self.hudPosYBackup;
	
	local overlayFilename = Utils.getFilename("huds/baleFoil.dds", kroneUltimaExtension_directory);
	self.hudOverlayFoilOverlay = Overlay:new("hudOverlayFoilOverlay", overlayFilename, self.hudFoilPosX, self.hudPosY, hudWidth, hudHeight * 0.8);
	self.hudOverlayFoilHideGUIOverlay = Overlay:new("hudOverlayFoilHideGUIOverlay", overlayFilename, self.hudFoilPosX, self.hudPosYHideGUI, hudWidth, hudHeight * 0.8);
	
	overlayFilename = Utils.getFilename("huds/baleNet.dds", kroneUltimaExtension_directory);
	self.hudOverlayNetOverlay = Overlay:new("hudOverlayNetOverlay", overlayFilename, self.hudNetPosX, self.hudPosY, hudWidth, hudHeight * 0.8);
	self.hudOverlayNetHideGUIOverlay = Overlay:new("hudOverlayNetHideGUIOverlay", overlayFilename, self.hudNetPosX, self.hudPosYHideGUI, hudWidth, hudHeight * 0.8);
	
	overlayFilename = Utils.getFilename("huds/infinity.dds", kroneUltimaExtension_directory);
	self.hudOverlayNetInfinityOverlay = Overlay:new("hudOverlayNetOverlay", overlayFilename, self.hudNetPosX + hudWidth, self.hudPosY, hudWidth, hudHeight * 0.8);
	self.hudOverlayNetInfinityHideGUIOverlay = Overlay:new("hudOverlayNetHideGUIOverlay", overlayFilename, self.hudNetPosX + hudWidth, self.hudPosYHideGUI, hudWidth, hudHeight * 0.8);
	
	self.hudOverlayFoilInfinityOverlay = Overlay:new("hudOverlayFoilOverlay", overlayFilename, self.hudFoilPosX + hudWidth, self.hudPosY, hudWidth, hudHeight * 0.8);
	self.hudOverlayFoilInfinityHideGUIOverlay = Overlay:new("hudOverlayFoilHideGUIOverlay", overlayFilename, self.hudFoilPosX + hudWidth, self.hudPosYHideGUI, hudWidth, hudHeight * 0.8);
	
	local hudBackgroundWidth = g_currentMission.vehicleSpeedBg.width * 3;
	
	overlayFilename = Utils.getFilename("huds/background.dds", kroneUltimaExtension_directory);
	self.hudOverlayBackground = Overlay:new("hudOverlayBackground", overlayFilename, self.hudFoilPosX, self.hudPosY, hudBackgroundWidth, hudHeight * 0.8);
	self.hudOverlayBackgroundHideGUI = Overlay:new("hudOverlayBackgroundHideGUI", overlayFilename, self.hudFoilPosX, self.hudPosYHideGUI, hudBackgroundWidth, hudHeight * 0.8);
	
	--## bale counter above icon row
	
	self.hudBaleCounterAllPosX = startX - hudWidth * 2.8;
	self.hudBaleCounterSinglePosX = startX + hudWidth * 0.2;
	self.hudBaleCounterPosY = startY + iconHeight * 1.4;
	
	overlayFilename = Utils.getFilename("huds/background.dds", kroneUltimaExtension_directory);
	self.blackBackGroundOverlay = Overlay:new("blackBackGroundOverlay", overlayFilename, startX - hudWidth * 2.965, startY + iconHeight / 2, hudBackgroundWidth, hudHeight * 2);
	
	overlayFilename = Utils.getFilename("huds/baleCounter_all.dds", kroneUltimaExtension_directory);
	self.baleCounterAllOverlay = Overlay:new("baleCounterAllOverlay", overlayFilename, self.hudBaleCounterAllPosX, self.hudBaleCounterPosY, hudWidth * 0.8, hudHeight * 0.8);
	
	overlayFilename = Utils.getFilename("huds/baleCounter_single.dds", kroneUltimaExtension_directory);
	self.baleCounterSingleOverlay = Overlay:new("baleCounterSingleOverlay", overlayFilename, self.hudBaleCounterSinglePosX, self.hudBaleCounterPosY, hudWidth * 0.8, hudHeight * 0.8);
	
	--## icon row
	
	overlayFilename = Utils.getFilename("huds/F4_2.dds", kroneUltimaExtension_directory);
	self.ppcOpenOverlay = Overlay:new("ppcOpenOverlay", overlayFilename, startX - hudWidth * 2.95, startY - (iconHeight / 2.8), hudWidth * 1.5, hudHeight * 1.11);
	
	overlayFilename = Utils.getFilename("huds/F4_1.dds", kroneUltimaExtension_directory);
	self.ppcClosedOverlay = Overlay:new("ppcClosedOverlay", overlayFilename, startX - hudWidth * 2.95, startY - (iconHeight / 2.8), hudWidth * 1.5, hudHeight * 1.11);
	
	overlayFilename = Utils.getFilename("huds/F1_2.dds", kroneUltimaExtension_directory);
	self.netBindingActiveOverlay = Overlay:new("netBindingActiveOverlay", overlayFilename, startX - hudWidth * 1.5, startY - (iconHeight / 2.8), hudWidth * 1.5, hudHeight * 1.11);
	
	overlayFilename = Utils.getFilename("huds/F1_1.dds", kroneUltimaExtension_directory);
	self.netBindingPassiveOverlay = Overlay:new("netBindingPassiveOverlay", overlayFilename, startX - hudWidth * 1.5, startY - (iconHeight / 2.8), hudWidth * 1.5, hudHeight * 1.11);
	
	overlayFilename = Utils.getFilename("huds/F5_2.dds", kroneUltimaExtension_directory);
	self.baleDoorOpeningOverlay = Overlay:new("baleDoorOpeningOverlay", overlayFilename, startX + hudWidth * 0.000001, startY - (iconHeight / 2.8), hudWidth * 1.5, hudHeight * 1.11);
	
	overlayFilename = Utils.getFilename("huds/F5_1.dds", kroneUltimaExtension_directory);
	self.baleDoorClosedOverlay = Overlay:new("baleDoorClosedOverlay", overlayFilename, startX + hudWidth * 0.000001, startY - (iconHeight / 2.8), hudWidth * 1.5, hudHeight * 1.11);
	
	overlayFilename = Utils.getFilename("huds/F6_2.dds", kroneUltimaExtension_directory);
	self.wrapperActiveOverlay = Overlay:new("wrapperActiveOverlay", overlayFilename, startX + hudWidth * 1.45, startY - (iconHeight / 2.8), hudWidth * 1.5, hudHeight * 1.11);
	
	overlayFilename = Utils.getFilename("huds/F6_1.dds", kroneUltimaExtension_directory);
	self.wrapperPassiveOverlay = Overlay:new("wrapperPassiveOverlay", overlayFilename, startX + hudWidth * 1.45, startY - (iconHeight / 2.8), hudWidth * 1.5, hudHeight * 1.11);
end;

function KroneUltimaExtension:loadSpeedRotatingPartFromXML(superFunc, speedRotatingPart, xmlFile, key)
    --print("--## using: 'KroneUltimaExtension:loadSpeedRotatingPartFromXML'.");
	
	if superFunc ~= nil then
        if not superFunc(self, speedRotatingPart, xmlFile, key) then
            return false;
        end;
    end;
	
    speedRotatingPart.rotateOnlyIfFillLevelIncreased = Utils.getNoNil(getXMLBool(xmlFile, key .. "#rotateOnlyIfFillLevelIncreased"), false);
    
	return true;
end

function KroneUltimaExtension:getIsSpeedRotatingPartActive(superFunc, speedRotatingPart)
    --print("--## using: 'KroneUltimaExtension:getIsSpeedRotatingPartActive'.");
	
	if speedRotatingPart.rotateOnlyIfFillLevelIncreased ~= nil and speedRotatingPart.rotateOnlyIfFillLevelIncreased then
		--renderText(0.5, 0.5, 0.02, "self.pickupEffectActive = " .. tostring(self.pickupEffectActive));
		
		return self.pickupEffectActive;
    end;
	
    if superFunc ~= nil then
        return superFunc(self, speedRotatingPart);
    end;
	
    return true;
end;

function KroneUltimaExtension:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_FOIL_AND_NET_COUNTER_HUD) then
			self.showFoilAndNetHud = not self.showFoilAndNetHud;
		end;
	end;
end;

function KroneUltimaExtension:getSaveAttributesAndNodes(nodeIdent)
   return 'showFoilAndNetHud="' .. tostring(self.showFoilAndNetHud) .. '"', nil;
end;

function getPercent(value)
    return tostring(math.floor(value * 100));
end;

function KroneUltimaExtension:draw()
	if self:getIsActive() then
		local textSize = 0.028 * self.uiScale;
		local offsetX, offsetY = getNormalizedScreenValues(45 * self.uiScale, 12 * self.uiScale);
		
		if self.hud ~= nil and not self.hud.hideGUI then
			self.blackBackGroundOverlay:render();
			self.baleCounterAllOverlay:render();
			self.baleCounterSingleOverlay:render();
			
			if self.currentBalerState == 2 then
				self.netBindingActiveOverlay:render();
			else
				self.netBindingPassiveOverlay:render();
			end;
			
			if self.currentBalerState == 3 then
				self.baleDoorOpeningOverlay:render();
			else
				self.baleDoorClosedOverlay:render();
			end;
			
			if self.currentWrapperState == 4 then
				self.wrapperActiveOverlay:render();
			else
				self.wrapperPassiveOverlay:render();
			end;
			
			if self.currentBalerState == 2 or self.currentBalerState == 3 then
				self.ppcOpenOverlay:render();
			elseif self.currentBalerState == 4 or self.currentBalerState == 1 then
				self.ppcClosedOverlay:render();
			end;
			
			renderText(self.hudBaleCounterAllPosX + offsetX, self.hudBaleCounterPosY + offsetY, textSize, tostring(self.baleCountLifetime));
			renderText(self.hudBaleCounterSinglePosX + offsetX, self.hudBaleCounterPosY + offsetY, textSize, tostring(self.baleCountDay));
			
			offsetX, offsetY = getNormalizedScreenValues(8 * self.uiScale, 20 * self.uiScale);
			setTextAlignment(RenderText.ALIGN_CENTER);
			textSize = 0.022 * self.uiScale;
			
			for fillUnitIndex, fillUnit in pairs(self.fillUnits) do			
				if fillUnitIndex == self.preChamberUnitIndex then
					renderText(self.hudBaleCounterSinglePosX - offsetX, self.hudBaleCounterPosY - offsetY, textSize, string.gsub(g_i18n:getText("prePressChamber"), "percent", getPercent(fillUnit.fillLevel/self:getUnitCapacity(fillUnitIndex))));
				elseif fillUnitIndex == self.mainChamberUnitIndex then
					renderText(self.hudBaleCounterSinglePosX - offsetX, self.hudBaleCounterPosY - offsetY * 2, textSize, string.gsub(g_i18n:getText("mainPressChamber"), "percent", getPercent(fillUnit.fillLevel/self:getUnitCapacity(fillUnitIndex))));
				end;
			end;
		end;
	
		if self.showFoilAndNetHud then
			g_currentMission:addHelpButtonText(g_i18n:getText("HIDE_FOIL_AND_NET_COUNTER_HUD"), InputBinding.TOGGLE_FOIL_AND_NET_COUNTER_HUD);
			
			if self.hud ~= nil and not self.hud.hideGUI then	
				self.hudOverlayBackground:render();
				self.hudOverlayFoilOverlay:render();
				self.hudOverlayNetOverlay:render();
				
				if not self.manualNetRoleRefill then	
					self.hudOverlayNetInfinityOverlay:render();
				end;
				
				if not self.manualFoilRoleRefill then	
					self.hudOverlayFoilInfinityOverlay:render();
				end;
				
				self.hudPosY = self.hudPosYBackup;
			else
				self.hudOverlayBackgroundHideGUI:render();
				self.hudOverlayFoilHideGUIOverlay:render();
				self.hudOverlayNetHideGUIOverlay:render();
				
				if not self.manualNetRoleRefill then	
					self.hudOverlayNetInfinityHideGUIOverlay:render();
				end;
				
				if not self.manualFoilRoleRefill then	
					self.hudOverlayFoilInfinityHideGUIOverlay:render();
				end;

				self.hudPosY = self.hudPosYHideGUI;
			end;
		
			offsetX, offsetY = getNormalizedScreenValues(50 * self.uiScale, 10 * self.uiScale);
			textSize = 0.028 * self.uiScale;
			setTextAlignment(RenderText.ALIGN_LEFT);
			
			if self.manualFoilRoleRefill then
				local foilLength = self.wrapperFoilHolders[1].remainingFoilLength * 2;
				local foilPerBale = self.baseFoilUsePerBale * self.baleSizes[self.baleSizeIndex].size;		
				local numLeftBalesFoil = math.ceil(foilLength / foilPerBale);
				
				if numLeftBalesFoil <= 5 then
					setTextColor(0.95, 0, 0, 1);
				else
					setTextColor(1, 1, 1, 1);
				end;
	
				renderText(self.hudFoilPosX + offsetX, self.hudPosY + offsetY, textSize, tostring(numLeftBalesFoil));
			end;
	
			if self.manualNetRoleRefill then
				local netPerBale = math.max(1, self.baleSizes[self.baleSizeIndex].size * math.pi * self.numNetWraps);
				local numLeftBalesNet = math.floor(self.netRoleTop.length / netPerBale);
				
				if numLeftBalesNet <= 5 then
					setTextColor(0.95, 0, 0, 1);
				else
					setTextColor(1, 1, 1, 1);
				end;
				
				setVisibility(self.netRoleTop.role, numLeftBalesNet > 0);
				
				if numLeftBalesNet == 0 then
					self.netRoleTop.length = 0;
					
					g_currentMission:addExtraPrintText(g_i18n:getText("YOU_CAN_REFILL_THE_NET_NOW"));
				end;
				
				renderText(self.hudNetPosX + offsetX, self.hudPosY + offsetY, textSize, tostring(numLeftBalesNet));
			end;
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("SHOW_FOIL_AND_NET_COUNTER_HUD"), InputBinding.TOGGLE_FOIL_AND_NET_COUNTER_HUD);
		end;
	end;
	
	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextColor(1, 1, 1, 1);
end;

function KroneUltimaExtension:delete()end;
function KroneUltimaExtension:mouseEvent(posX, posY, isDown, isUp, button)end;
function KroneUltimaExtension:keyEvent(unicode, sym, modifier, isDown)end;