--[[
	KroneUltimaBugFix.lua
	
	Autor: Ifko[nator]
	Datum: 17.06.2017

	Fix error:
 
	'Error:Running LUA method 'loadSharedI3DFileFinished'.
	C:/User/USER_NAME/Documents/MyGames/FarmingSimulator2017/mods/FS17_KroneUltimaCF155XC/specializations/Ultima.lua:1624:attempt to index field 'balerCurrentBale' (a nil value)'
]]
	
for index = 1, 20 do --## go through all 20 possible savgames ..
	savegameFolderPath = string.format("%ssavegame%d", getUserProfileAppPath(), index);

	if fileExists(savegameFolderPath .. "/vehicles.xml") then
		--print("found vehicles.xml: " .. savegameFolderPath .. "/vehicles.xml :)");
		local vehicles = loadXMLFile("vehicles", savegameFolderPath .. "/vehicles.xml", "careerVehicles");
		
		local i = 0;
	
		while true do
			local baseString = string.format("careerVehicles.vehicle(%d)", i);
			
			if not hasXMLProperty(vehicles, baseString) then
				break;
			end;
			
			local id = getXMLInt(vehicles, baseString .. "#id");
			local filename = getXMLString(vehicles, baseString .. "#filename");
			
			--[[
			print("----------------------------------- vehicle " .. i .. " -----------------------------------");
			print("id is " .. id);
			print("filename is " .. tostring(filename));
			]]
			
			if string.find(filename, "KroneUltimaCF155XC.xml") then
				local balerState = Utils.getNoNil(getXMLInt(vehicles,  baseString .. "#balerState"), 1);
				
				--print("balerState is " .. balerState);
				
				if balerState ~= 1 then
					setXMLInt(vehicles,  baseString .. "#balerState", 1);
					
					saveXMLFile(vehicles);
					--[[	
					print("set balerState to " .. getXMLInt(vehicles,  baseString .. "#balerState") .. " in " .. savegameFolderPath .. "/vehicles.xml");
				else
					print("set balerState not to 1");
					]]
				end;
			end;
			
			--print("");
			
			i = i + 1;
		end;
	end;
end;