﻿MPEvent = {};
MPEvent_mt = Class(MPEvent, Event);

InitEventClass(MPEvent, "MPEvent");

function MPEvent:emptyNew()
    local self = Event:new(MPEvent_mt);
    self.className="MPEvent";
    return self;
end;

function MPEvent:new(vehicle, mode, bool, state, dif, olddif)
    local self = MPEvent:emptyNew()
    self.vehicle = vehicle;
    self.state = state;
    self.dif = dif;
    self.old_dif = olddif;
    self.mode = mode;
    self.bool = bool;
    return self;
end;

function MPEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.state = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
    self.old_dif = streamReadFloat32(streamId);
    self.dif = streamReadFloat32(streamId);
    self.mode = streamReadInt32(streamId);
    self.bool = streamReadBool(streamId);
    self:run(connection);
end;

function MPEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
    streamWriteInt32(streamId, self.state);
    streamWriteFloat32(streamId, self.old_dif);
    streamWriteFloat32(streamId, self.dif);
    streamWriteInt32(streamId, self.mode);
    streamWriteBool(streamId, self.bool);
end;

function MPEvent:run(connection)   
    self.vehicle:MPCode(self.mode, self.bool, self.state, self.dif, self.old_dif, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(MPEvent:new(self.vehicle, self.mode, self.bool, self.state, self.dif, self.old_dif), nil, connection, self.vehicle);
    end;
end;

function MPEvent.sendEvent(vehicle, mode, bool, state, dif, olddif, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(MPEvent:new(vehicle, mode, bool, state, dif, olddif), nil, nil, vehicle);
        else
            g_client:getServerConnection():sendEvent(MPEvent:new(vehicle, mode, bool, state, dif, olddif));
        end;
    end;
end;