--[[
AutomaticUnloadForBaleWrappers
Spezialisierung damit man zwischen manuellen und automatischen Abladen eines Ballenwicklers hin und her schalten kann.

Author:	Ifko[nator]
Datum:	16.02.2016

Version:	v2.0
History:	v1.0 @ 21.02.2015 - initial implementation -- GLOBAL VERSION! -- support for the 'FollowMe Mod'. Means, added a function to switch between automatic and manuell unload for the balewrapper. :)
			v2.0 @ 16.02.2016 - convert to FS 17
]]

AutomaticUnloadForBaleWrappers = {};

local AutomaticUnloadForBaleWrappersDirectory = g_currentModDirectory;

function AutomaticUnloadForBaleWrappers.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(BaleWrapper, specializations);
end;

function AutomaticUnloadForBaleWrappers:load(savegame)
	self.update = Utils.appendedFunction(self.update, AutomaticUnloadForBaleWrappers.baleWrapperUpdate);

	if savegame ~= nil then
		self.automaticUnload = Utils.getNoNil(getXMLBool(savegame.xmlFile, savegame.key .. "#automaticUnload"), true);
	else
		self.automaticUnload = false;
	end;
end;

function AutomaticUnloadForBaleWrappers:delete()
end;

function AutomaticUnloadForBaleWrappers:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AutomaticUnloadForBaleWrappers:keyEvent(unicode, sym, modifier, isDown)
end;

function AutomaticUnloadForBaleWrappers:baleWrapperUpdate(dt)	
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.TOGGLE_AUTOMAIC_UNLOAD_BUTTON) then
				self.automaticUnload = not self.automaticUnload;
			end;
		end;
		
		if self.baleWrapperState == BaleWrapper.STATE_WRAPPER_FINSIHED then
			if self.automaticUnload then
				g_client:getServerConnection():sendEvent(BaleWrapperStateEvent:new(self, BaleWrapper.CHANGE_BUTTON_EMPTY));
			end;
		end;
	end;
end;

function AutomaticUnloadForBaleWrappers:update(dt)
end;

function AutomaticUnloadForBaleWrappers:draw()
	if self.automaticUnload then
		g_currentMission:addHelpButtonText(BaleWrapper.STOP_AUTOMATIC_UNLOAD, InputBinding.TOGGLE_AUTOMAIC_UNLOAD_BUTTON);
	else
		g_currentMission:addHelpButtonText(BaleWrapper.START_AUTOMATIC_UNLOAD, InputBinding.TOGGLE_AUTOMAIC_UNLOAD_BUTTON);
	end;
end

function AutomaticUnloadForBaleWrappers:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'automaticUnload="' .. tostring(self.automaticUnload) .. '"';
	
	return attributes, nil;
end;