--[[
	AutoTurnOffTurnLights_Register.lua
	
	Author: 	Ifko[nator]
	Date:		31.10.2016
	Version:	1.0 - intial implementation in FS17
]]

SpecializationUtil.registerSpecialization("autoTurnOffTurnLights", "AutoTurnOffTurnLights", g_currentModDirectory .. "AutoTurnOffTurnLights.lua");

AutoTurnOffTurnLights_Register = {};

function AutoTurnOffTurnLights_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("drivable") then
						local v_name_string = v.name;
						local point_location = string.find(v_name_string, ".", nil, true);
						
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							
							if rawget(SpecializationUtil.specializations, string.format("%s.AutoTurnOffTurnLights", _name)) ~= nil
								or rawget(SpecializationUtil.specializations, string.format("%s.autoTurnOffTurnLights", _name)) ~= nil 
							then
								allowInsertion = false;
							end;
						end;
						
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("autoTurnOffTurnLights"));
						end;
					end;
				end;
			end;	
		end;
	end;
end;

function AutoTurnOffTurnLights_Register:deleteMap()end;
function AutoTurnOffTurnLights_Register:keyEvent(unicode, sym, modifier, isDown)end;
function AutoTurnOffTurnLights_Register:mouseEvent(posX, posY, isDown, isUp, button)end;
function AutoTurnOffTurnLights_Register:update(dt)end;
function AutoTurnOffTurnLights_Register:draw()end;

addModEventListener(AutoTurnOffTurnLights_Register);