--[[
Spezialisierung damit die Blinker nach dem Abbiegen automatisch abgeschalten werden.

Author:		Ifko[nator]
Datum:		31.01.2016
Version:	v1.0

History:	v1.0 @ 31.01.2016 - initial implementation in FS17
]]

AutoTurnOffTurnLights = {};

function AutoTurnOffTurnLights.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Drivable, specializations)
end;

function AutoTurnOffTurnLights:load(savegame)
	self.hasSteerToTurnLightDirection = false;
end;

function AutoTurnOffTurnLights:update(dt)
	if self:getIsActive() and self.steering ~= nil then
		local _, steeringRotY, _ = getRotation(self.steering);
		steeringRotY = Utils.round(steeringRotY, 2);
		
		if self.hasSteerToTurnLightDirection then
			if steeringRotY == -0 then
				self:setTurnLightState(Lights.TURNLIGHT_OFF);
				
				self.hasSteerToTurnLightDirection = false;
			end;
		elseif self.turnLightState == Lights.TURNLIGHT_LEFT then
			self.hasSteerToTurnLightDirection = steeringRotY > 0.1;
		elseif self.turnLightState == Lights.TURNLIGHT_RIGHT then
			self.hasSteerToTurnLightDirection = steeringRotY < -0.1;
		end;
	end;
end;

function AutoTurnOffTurnLights:draw()end;
function AutoTurnOffTurnLights:delete()end;
function AutoTurnOffTurnLights:mouseEvent(posX, posY, isDown, isUp, button)end;
function AutoTurnOffTurnLights:keyEvent(unicode, sym, modifier, isDown)end;