WorkStateEvent = {};
WorkStateEvent_mt = Class(WorkStateEvent, Event);

InitEventClass(WorkStateEvent, "WorkStateEvent");

function WorkStateEvent:emptyNew()
    local self = Event:new(WorkStateEvent_mt);
    self.className="WorkStateEvent";
    return self;
end;

function WorkStateEvent:new(vehicle, isCoupled)
    local self = WorkStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.isCoupled = isCoupled;
    return self;
end;

function WorkStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isCoupled = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function WorkStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isCoupled);
end;

function WorkStateEvent:run(connection)   
	self.vehicle:setWorkState(self.isCoupled, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(WorkStateEvent:new(self.vehicle, self.isCoupled), nil, connection, self.vehicle);
    end;
end;

function WorkStateEvent.sendEvent(vehicle, isCoupled, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(WorkStateEvent:new(vehicle, isCoupled), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(WorkStateEvent:new(vehicle, isCoupled));
		end;
	end;
end;