﻿-- 
-- Universal AutoLoad
-- © 2015 HoT online Team
--
-- free to use when header stays as is

UAL = {};

function UAL.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function UAL:load(xmlFile)

	self.state = 1;
	
	self.FiHeBa= SpecializationUtil.callSpecializationsFunction("FiHeBa");
	self.FiDi= SpecializationUtil.callSpecializationsFunction("FiDi");
	self.MPCode = SpecializationUtil.callSpecializationsFunction("MPCode");	
	
	self.balesJoint = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.balesJoint#index"));
	self.roundsJoint = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.balesJoint#rounds"));
	self.centerJoint = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.balesJoint#center"));
	self.woolJoint = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.balesJoint#wool"));
	self.woodJoint = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.balesJoint#wood"));
	self.saplingsJoint = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.balesJoint#saplings"));
	self.washpotJoint = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.balesJoint#washpot"));
	self.fruitsJoint = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.balesJoint#fruits"));
	self.hmilkJoint = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.balesJoint#hmilk"));
	
	self.balesToLoad = {};
	self.rbalesToLoad = {};
	self.woolToLoad = {};
	self.woodToLoad = {};
	self.saplingsToLoad = {};
	self.washpotToLoad = {};
	self.fruitsToLoad = {};
	self.hmilkToLoad = {};
	self.balesToMount = {};
	self.rbalesToMount = {};
	self.woolToMount = {};
	self.woodToMount = {};
	self.saplingsToMount = {};
	self.washpotToMount = {};
	self.fruitsToMount = {};
	self.hmilkToMount = {};
	
	self.baleTypes = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.baleTypes.bale(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local filename = getXMLString(xmlFile, key.."#type");
		if filename ~= nil then
			table.insert(self.baleTypes, filename);
		end;
		i = i + 1;
	end;

	self.hayBales = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.hayBales.bale(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local entry = {};
		local index = Utils.indexToObject(self.components,getXMLString(xmlFile, key.."#index"));
		if index ~= nil then
			entry.node = index;
			entry.baleId = nil;
			table.insert(self.hayBales, entry);
		end;
		i = i + 1;
	end;
	self.numMaxSquare = i;
	
	self.hayRounds = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.hayRounds.bale(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local entry = {};
		local index = Utils.indexToObject(self.components,getXMLString(xmlFile, key.."#index"));
		if index ~= nil then
			entry.node = index;
			entry.baleId = nil;
			table.insert(self.hayRounds, entry);
		end;
		i = i + 1;
	end;
	self.numMaxRound = i;
	
	self.wool = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.wool.place(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local entry = {};
		local index = Utils.indexToObject(self.components,getXMLString(xmlFile, key.."#index"));
		if index ~= nil then
			entry.node = index;
			entry.baleId = nil;
			table.insert(self.wool, entry);
		end;
		i = i + 1;
	end;
	self.numMaxWool = i;
	
	self.wood = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.wood.place(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local entry = {};
		local index = Utils.indexToObject(self.components,getXMLString(xmlFile, key.."#index"));
		if index ~= nil then
			entry.node = index;
			entry.baleId = nil;
			table.insert(self.wood, entry);
		end;
		i = i + 1;
	end;
	self.numMaxWood = i;
	
	self.saplings = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.saplings.place(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local entry = {};
		local index = Utils.indexToObject(self.components,getXMLString(xmlFile, key.."#index"));
		if index ~= nil then
			entry.node = index;
			entry.baleId = nil;
			table.insert(self.saplings, entry);
		end;
		i = i + 1;
	end;
	self.numMaxSaplings = i;
	
	self.washpot = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.washpot.place(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local entry = {};
		local index = Utils.indexToObject(self.components,getXMLString(xmlFile, key.."#index"));
		if index ~= nil then
			entry.node = index;
			entry.baleId = nil;
			table.insert(self.washpot, entry);
		end;
		i = i + 1;
	end;
	self.numMaxWashpot = i;
	
	self.fruits = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.fruits.place(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local entry = {};
		local index = Utils.indexToObject(self.components,getXMLString(xmlFile, key.."#index"));
		if index ~= nil then
			entry.node = index;
			entry.baleId = nil;
			table.insert(self.fruits, entry);
		end;
		i = i + 1;
	end;
	self.numMaxFruits = i;
	
	self.hmilk = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.hmilk.place(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local entry = {};
		local index = Utils.indexToObject(self.components,getXMLString(xmlFile, key.."#index"));
		if index ~= nil then
			entry.node = index;
			entry.baleId = nil;
			table.insert(self.hmilk, entry);
		end;
		i = i + 1;
	end;
	self.numMaxHmilk = i;
	
	self.i = {};
	self.workMode = false;
	
	self.counter = 0;
	self.foundIt = false;
	self.baleId = nil;
	
	self.firstTime = true;
	
	self.bales = {};
	
	self.fillLevel = 0;
    self.fillLevelMax = self.numMaxSquare;
	
	self.marker = Utils.indexToObject(self.components,getXMLString(xmlFile, "vehicle.marker#index"));
	setVisibility(self.marker, false);
	self.mLeft = Utils.indexToObject(self.components,getXMLString(xmlFile, "vehicle.marker#left"));
	self.mRight = Utils.indexToObject(self.components,getXMLString(xmlFile, "vehicle.marker#right"));
	self.mBack = Utils.indexToObject(self.components,getXMLString(xmlFile, "vehicle.marker#back"));
	self.unloadPos = 0;
	
	self.loadTypes = {}
	local loadType = g_i18n:getText("squarebales");	
	if loadType == nil then
		loadType = "squarebales"
	end;
	local entry = {};
	entry.text = loadType;
	table.insert(self.loadTypes, entry);
	local loadType = g_i18n:getText("roundbales");	
	if loadType == nil then
		loadType = "roundbales"
	end;
	local entry = {};
	entry.text = loadType;
	table.insert(self.loadTypes, entry);
	local loadType = g_i18n:getText("woolpallet");	
	if loadType == nil then
		loadType = "woolpallet"
	end;
	local entry = {};
	entry.text = loadType;
	table.insert(self.loadTypes, entry);
	local loadType = g_i18n:getText("woodpallet");	
	if loadType == nil then
		loadType = "woodpallet"
	end;
	local entry = {};
	entry.text = loadType;
	table.insert(self.loadTypes, entry);
	local loadType = g_i18n:getText("saplings");	
	if loadType == nil then
		loadType = "saplings"
	end;
	local entry = {};
	entry.text = loadType;
	table.insert(self.loadTypes, entry);
	local loadType = g_i18n:getText("washpot");	
	if loadType == nil then
		loadType = "washpot"
	end;
	local entry = {};
	entry.text = loadType;
	table.insert(self.loadTypes, entry);
	local loadType = g_i18n:getText("fruits");	
	if loadType == nil then
		loadType = "fruits"
	end;
	local entry = {};
	entry.text = loadType;
	table.insert(self.loadTypes, entry);
	local loadType = g_i18n:getText("kuhsaft");	
	if loadType == nil then
		loadType = "kuhsaft"
	end;
	local entry = {};
	entry.text = loadType;
	table.insert(self.loadTypes, entry);
end;

function UAL:delete()
	for i, balePlace in pairs(self.hayBales) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
                bale:unmount();
            end;
        end;
	end;
	for i, balePlace in pairs(self.hayRounds) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
				bale:unmount();
            end;
        end;
	end;
	for i, balePlace in pairs(self.wool) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
				bale:unmount();
            end;
        end;
	end;
	for i, balePlace in pairs(self.wood) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
				bale:unmount();
            end;
        end;
	end;
	for i, balePlace in pairs(self.saplings) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
				bale:unmount();
            end;
        end;
	end;
	for i, balePlace in pairs(self.washpot) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
				bale:unmount();
            end;
        end;
	end;
	for i, balePlace in pairs(self.fruits) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
				bale:unmount();
            end;
        end;
	end;for i, balePlace in pairs(self.fruits) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
				bale:unmount();
            end;
        end;
	end;
end;

function UAL:mouseEvent(posX, posY, isDown, isUp, button)
end;

function UAL:keyEvent(unicode, sym, modifier, isDown)
end;

function UAL:update(dt)
	if self.firstTime then
		self.firstTime = false;
        for k,v in pairs(self.balesToLoad) do
            local baleObject = Bale:new(self.isServer, self.isClient);
            local x,y,z = unpack(v.translation);
            local rx,ry,rz = unpack(v.rotation);
            baleObject:load(v.filename, x,y,z,rx,ry,rz, v.fillLevel);
            baleObject:mount(self, self.hayBales[k].node, x,y,z, rx,ry,rz);
            if v.baleValueScale ~= nil then
                baleObject.baleValueScale = v.baleValueScale;
            end
            if v.wrappingState ~= nil and baleObject.setWrappingState ~= nil then
                baleObject:setWrappingState(v.wrappingState);
            end
            baleObject:register();
            v.baleId = networkGetObjectId(baleObject);
            self.balesToLoad[k] = nil;
			self.hayBales[k].baleId = v.baleId;
		end;
		for k,v in pairs(self.rbalesToLoad) do
            local baleObject = Bale:new(self.isServer, self.isClient);
            local x,y,z = unpack(v.translation);
            local rx,ry,rz = unpack(v.rotation);
            baleObject:load(v.filename, x,y,z,rx,ry,rz, v.fillLevel);
			baleObject:mount(self, self.hayRounds[k].node, x,y,z, rx,ry,rz);
            if v.baleValueScale ~= nil then
                baleObject.baleValueScale = v.baleValueScale;
            end
            if v.wrappingState ~= nil and baleObject.setWrappingState ~= nil then
                baleObject:setWrappingState(v.wrappingState);
            end
            baleObject:register();
			v.baleId = networkGetObjectId(baleObject);
            self.rbalesToLoad[k] = nil;
			self.hayRounds[k].baleId = v.baleId;
		end;
		for k,v in pairs(self.woolToLoad) do
            local baleObject = FillablePallet:new(self.isServer, self.isClient);
            local x,y,z = unpack(v.translation);
            local rx,ry,rz = unpack(v.rotation);
            baleObject:load(v.filename, x,y,z,rx,ry,rz);
            baleObject:setFillLevel(v.fillLevel, false)
			baleObject:mount(self, self.wool[k].node, x,y,z, rx,ry,rz);
            if v.baleValueScale ~= nil then
                baleObject.fillablePalletValueScale = v.baleValueScale;
            end
            baleObject:register();
			v.baleId = networkGetObjectId(baleObject);
            self.woolToLoad[k] = nil;
			self.wool[k].baleId = v.baleId;
		end;
		for k,v in pairs(self.woodToLoad) do
            local baleObject = FillablePallet:new(self.isServer, self.isClient);
            local x,y,z = unpack(v.translation);
            local rx,ry,rz = unpack(v.rotation);
            baleObject:load(v.filename, x,y,z,rx,ry,rz);
            baleObject:setFillLevel(v.fillLevel, false)
			baleObject:mount(self, self.wood[k].node, x,y,z, rx,ry,rz);
            if v.baleValueScale ~= nil then
                baleObject.fillablePalletValueScale = v.baleValueScale;
            end
            baleObject:register();
			v.baleId = networkGetObjectId(baleObject);
            self.woodToLoad[k] = nil;
			self.wood[k].baleId = v.baleId;
		end;
		for k,v in pairs(self.saplingsToLoad) do
            local baleObject = SaplingPallet:new(self.isServer, self.isClient);
            local x,y,z = unpack(v.translation);
            local rx,ry,rz = unpack(v.rotation);
            baleObject:load(v.filename, x,y,z,rx,ry,rz);
            baleObject:setFillLevel(v.fillLevel, false)
			baleObject:mount(self, self.saplings[k].node, x,y,z, rx,ry,rz);
            if v.baleValueScale ~= nil then
                baleObject.fillablePalletValueScale = v.baleValueScale;
            end
            baleObject:register();
			v.baleId = networkGetObjectId(baleObject);
            self.saplingsToLoad[k] = nil;
			self.saplings[k].baleId = v.baleId;
		end;
		for k,v in pairs(self.washpotToLoad) do
            local baleObject = FillablePallet:new(self.isServer, self.isClient);
            local x,y,z = unpack(v.translation);
            local rx,ry,rz = unpack(v.rotation);
            baleObject:load(v.filename, x,y,z,rx,ry,rz);
            baleObject:setFillLevel(v.fillLevel, false)
			baleObject:mount(self, self.washpot[k].node, x,y,z, rx,ry,rz);
            if v.baleValueScale ~= nil then
                baleObject.fillablePalletValueScale = v.baleValueScale;
            end
            baleObject:register();
			v.baleId = networkGetObjectId(baleObject);
            self.washpotToLoad[k] = nil;
			self.washpot[k].baleId = v.baleId;
		end;
		for k,v in pairs(self.fruitsToLoad) do
            local baleObject = FillablePallet:new(self.isServer, self.isClient);
            local x,y,z = unpack(v.translation);
            local rx,ry,rz = unpack(v.rotation);
            baleObject:load(v.filename, x,y,z,rx,ry,rz);
            baleObject:setFillLevel(v.fillLevel, false)
			baleObject:mount(self, self.fruits[k].node, x,y,z, rx,ry,rz);
            if v.baleValueScale ~= nil then
                baleObject.fillablePalletValueScale = v.baleValueScale;
            end
            baleObject:register();
			v.baleId = networkGetObjectId(baleObject);
            self.fruitsToLoad[k] = nil;
			self.fruits[k].baleId = v.baleId;
		end;
		for k,v in pairs(self.hmilkToLoad) do
            local baleObject = FillablePallet:new(self.isServer, self.isClient);
            local x,y,z = unpack(v.translation);
            local rx,ry,rz = unpack(v.rotation);
            baleObject:load(v.filename, x,y,z,rx,ry,rz);
            baleObject:setFillLevel(v.fillLevel, false)
			baleObject:mount(self, self.hmilk[k].node, x,y,z, rx,ry,rz);
            if v.baleValueScale ~= nil then
                baleObject.fillablePalletValueScale = v.baleValueScale;
            end
            baleObject:register();
			v.baleId = networkGetObjectId(baleObject);
            self.hmilkToLoad[k] = nil;
			self.hmilk[k].baleId = v.baleId;
		end;
		
		for k, baleToMount in pairs(self.balesToMount) do
            local bale = networkGetObject(baleToMount.serverId);
            if bale ~= nil then
                local x,y,z = unpack(baleToMount.trans);
                local rx,ry,rz = unpack(baleToMount.rot);
                bale:mount(self, baleToMount.linkNode, x,y,z, rx,ry,rz);
                self.balesToMount[k] = nil;
            end;
		end;
		for k, baleToMount in pairs(self.rbalesToMount) do
            local bale = networkGetObject(baleToMount.serverId);
            if bale ~= nil then
                local x,y,z = unpack(baleToMount.trans);
                local rx,ry,rz = unpack(baleToMount.rot);
                bale:mount(self, baleToMount.linkNode, x,y,z, rx,ry,rz);
                self.balesToMount[k] = nil;
            end;
		end;
		for k, baleToMount in pairs(self.woolToMount) do
            local bale = networkGetObject(baleToMount.serverId);
            if bale ~= nil then
                local x,y,z = unpack(baleToMount.trans);
                local rx,ry,rz = unpack(baleToMount.rot);
                bale:mount(self, baleToMount.linkNode, x,y,z, rx,ry,rz);
                self.woolToMount[k] = nil;
            end;
		end;
		for k, baleToMount in pairs(self.woodToMount) do
            local bale = networkGetObject(baleToMount.serverId);
            if bale ~= nil then
                local x,y,z = unpack(baleToMount.trans);
                local rx,ry,rz = unpack(baleToMount.rot);
                bale:mount(self, baleToMount.linkNode, x,y,z, rx,ry,rz);
                self.woodToMount[k] = nil;
            end;
		end;
		for k, baleToMount in pairs(self.saplingsToMount) do
            local bale = networkGetObject(baleToMount.serverId);
            if bale ~= nil then
                local x,y,z = unpack(baleToMount.trans);
                local rx,ry,rz = unpack(baleToMount.rot);
                bale:mount(self, baleToMount.linkNode, x,y,z, rx,ry,rz);
                self.saplingsToMount[k] = nil;
            end;
		end;
		for k, baleToMount in pairs(self.washpotToMount) do
            local bale = networkGetObject(baleToMount.serverId);
            if bale ~= nil then
                local x,y,z = unpack(baleToMount.trans);
                local rx,ry,rz = unpack(baleToMount.rot);
                bale:mount(self, baleToMount.linkNode, x,y,z, rx,ry,rz);
                self.washpotToMount[k] = nil;
            end;
		end;
		for k, baleToMount in pairs(self.fruitsToMount) do
            local bale = networkGetObject(baleToMount.serverId);
            if bale ~= nil then
                local x,y,z = unpack(baleToMount.trans);
                local rx,ry,rz = unpack(baleToMount.rot);
                bale:mount(self, baleToMount.linkNode, x,y,z, rx,ry,rz);
                self.fruitsToMount[k] = nil;
            end;
		end;
		for k, baleToMount in pairs(self.hmilkToMount) do
            local bale = networkGetObject(baleToMount.serverId);
            if bale ~= nil then
                local x,y,z = unpack(baleToMount.trans);
                local rx,ry,rz = unpack(baleToMount.rot);
                bale:mount(self, baleToMount.linkNode, x,y,z, rx,ry,rz);
                self.hmilkToMount[k] = nil;
            end;
		end;
	end;

	if self:getIsActiveForInput() and self:getIsActive() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			if self.counter ~= self.fillLevelMax then
				setVisibility(self.marker, false);
				self.unloadPos = 0;
				self:MPCode(99, not self.workMode);
			end;
		end;
	
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA4) then
			if self.counter == 0 and not self.workMode then
				self.state = self.state + 1;
				if self.state > 8 then
					self.state = 1;
				end
				self:MPCode(98, nil, self.state);
			end
		end
		
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			if self.counter >= 1 and not self.workMode then
				self.unloadPos = self.unloadPos + 1;
				if self.unloadPos > 3 then
					self.unloadPos = 0;
				end

				if self.unloadPos == 0 then
					setVisibility(self.marker, false);
					local x,y,z = getTranslation(self.centerJoint)
					setTranslation(self.marker, x,y,z)
				elseif  self.unloadPos == 1 then
					setVisibility(self.marker, true);
					local x,y,z = getTranslation(self.mLeft)
					setTranslation(self.marker, x,y,z)
				elseif  self.unloadPos == 2 then
					setVisibility(self.marker, true);
					local x,y,z = getTranslation(self.mRight)
					setTranslation(self.marker, x,y,z)
				elseif  self.unloadPos == 3 then
					setVisibility(self.marker, true);
					local x,y,z = getTranslation(self.mBack)
					setTranslation(self.marker, x,y,z)
				end;
			end;
		end
	
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			if self.counter >= 1 and not self.workMode then
				self:MPCode(24, nil, self.unloadPos);
			end;
		end;
	end;
	
	if self.isServer then
		if self.workMode then
			if self.foundIt then
				self:MPCode(21, nil, self.state, self.baleId);
			else
				self:FiHeBa(self.balesJoint);
			end;
		end;
	end;
	if self.counter == self.fillLevelMax then
			self:MPCode(99, false);
	end;
end;

function UAL:draw()


	if self.counter < self.fillLevelMax then
		if not self.workMode then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("WORKMODE_on"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("WORKMODE_off"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		end;
	end;
	
	if self.counter >= 1 and not self.workMode then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("UNLOAD"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		if self.unloadPos == 0 then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("UNLOAD_C"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
		elseif self.unloadPos == 1 then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("UNLOAD_L"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
		elseif self.unloadPos == 2 then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("UNLOAD_R"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
		elseif self.unloadPos == 3 then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("UNLOAD_B"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
		end
	end;
	
	if self.counter == 0 and not self.workMode then
		g_currentMission:addHelpButtonText(string.format(self.loadTypes[self.state].text, self.typeDesc), InputBinding.IMPLEMENT_EXTRA4);
	end
end;

function UAL:MPCode(mode, bool, state, dif, olddif, noEventSend)
	MPEvent.sendEvent(self, mode, bool, state, dif, olddif, noEventSend);
	if mode == 21 then	
		
		self.baleId = dif;
		local object = networkGetObject(self.baleId);
		if object == nil then
			return;
		end;
		self.counter = self.counter + 1;		
		self.fillLevel = self.counter;

		if state==1 then
			object:mount(self, self.hayBales[self.counter].node, 0,0,0, 0,0,0);
			self.hayBales[self.counter].baleId = self.baleId;
		elseif state==2 then
			object:mount(self, self.hayRounds[self.counter].node, 0,0,0, 0,0,0);
			self.hayRounds[self.counter].baleId = self.baleId;
		elseif state==3 then
			object:mount(self, self.wool[self.counter].node, 0,0,0, 0,0,0);
			self.wool[self.counter].baleId = self.baleId;
		elseif state==4 then
			object:mount(self, self.wood[self.counter].node, 0,0,0, 0,0,0);
			self.wood[self.counter].baleId = self.baleId;
		elseif state==5 then
			object:mount(self, self.saplings[self.counter].node, 0,0,0, 0,0,0);
			self.saplings[self.counter].baleId = self.baleId;
		elseif state==6 then
			object:mount(self, self.washpot[self.counter].node, 0,0,0, 0,0,0);
			self.washpot[self.counter].baleId = self.baleId;
		elseif state==7 then
			object:mount(self, self.fruits[self.counter].node, 0,0,0, 0,0,0);
			self.fruits[self.counter].baleId = self.baleId;
		elseif state==8 then
			object:mount(self, self.hmilk[self.counter].node, 0,0,0, 0,0,0);
			self.hmilk[self.counter].baleId = self.baleId;
		end;
		
		self.fillLevelMax = self.numMaxSquare;
		if state == 2 then
			self.fillLevelMax = self.numMaxRound;
		end
		if state == 3 then
			self.fillLevelMax = self.numMaxWool;
		end
		if state == 4 then
			self.fillLevelMax = self.numMaxWood;
		end
		if state == 5 then
			self.fillLevelMax = self.numMaxSaplings;
		end
		if state == 6 then
			self.fillLevelMax = self.numMaxWashpot;
		end
		if state == 7 then
			self.fillLevelMax = self.numMaxFruits;
		end
		if state == 8 then
			self.fillLevelMax = self.numMaxHmilk;
		end
		self.capacity = self.fillLevelMax;
		
		self.foundIt = false;
		self.baleId = nil;

	elseif mode == 24 then
		
		if state == 0 then
			local x,y,z = getTranslation(self.centerJoint)
			setTranslation(self.balesJoint, x,y,z)
			setTranslation(self.roundsJoint, x,y,z)
			setTranslation(self.woolJoint, x,y,z)
			setTranslation(self.woodJoint, x,y,z)
			setTranslation(self.saplingsJoint, x,y,z)
			setTranslation(self.washpotJoint, x,y,z)
			setTranslation(self.fruitsJoint, x,y,z)
			setTranslation(self.hmilkJoint, x,y,z)
		elseif state == 1 then
			local x,y,z = getTranslation(self.mLeft)
			setTranslation(self.balesJoint, x,y-1.1,z)
			setTranslation(self.roundsJoint, x,y-1.1,z)
			setTranslation(self.woolJoint, x,y-1.1,z)
			setTranslation(self.woodJoint, x,y-1.1,z)
			setTranslation(self.saplingsJoint, x,y-1.1,z)
			setTranslation(self.washpotJoint, x,y-1.1,z)
			setTranslation(self.fruitsJoint, x,y-1.1,z)
			setTranslation(self.hmilkJoint, x,y-1.1,z)
		elseif state == 2 then
			local x,y,z = getTranslation(self.mRight)
			setTranslation(self.balesJoint, x,y-1.1,z)
			setTranslation(self.roundsJoint, x,y-1.1,z)
			setTranslation(self.woolJoint, x,y-1.1,z)
			setTranslation(self.woodJoint, x,y-1.1,z)
			setTranslation(self.saplingsJoint, x,y-1.1,z)
			setTranslation(self.washpotJoint, x,y-1.1,z)
			setTranslation(self.fruitsJoint, x,y-1.1,z)
			setTranslation(self.hmilkJoint, x,y-1.1,z)
		elseif state == 3 then
			local x,y,z = getTranslation(self.mBack)
			setTranslation(self.balesJoint, x,y-1.1,z)
			setTranslation(self.roundsJoint, x,y-1.1,z)
			setTranslation(self.woolJoint, x,y-1.1,z)
			setTranslation(self.woodJoint, x,y-1.1,z)
			setTranslation(self.saplingsJoint, x,y-1.1,z)
			setTranslation(self.washpotJoint, x,y-1.1,z)
			setTranslation(self.fruitsJoint, x,y-1.1,z)
			setTranslation(self.hmilkJoint, x,y-1.1,z)
		end
		
		for _, balePlace in pairs(self.hayBales) do
            if balePlace.baleId ~= nil then
                local baleServerId = balePlace.baleId
                local bale = networkGetObject(baleServerId);
                if bale ~= nil then
                    bale:unmount();
                end;
                balePlace.baleId = nil;
            end;
		end;
	
		for _, balePlace in pairs(self.hayRounds) do
            if balePlace.baleId ~= nil then
                local baleServerId = balePlace.baleId
                local bale = networkGetObject(baleServerId);
                if bale ~= nil then
                    bale:unmount();
                end;
                balePlace.baleId = nil;
			end;
		end;
		for _, balePlace in pairs(self.wool) do
            if balePlace.baleId ~= nil then
                local baleServerId = balePlace.baleId
                local bale = networkGetObject(baleServerId);
                if bale ~= nil then
                    bale:unmount();
                end;
                balePlace.baleId = nil;
			end;
		end;
		for _, balePlace in pairs(self.wood) do
            if balePlace.baleId ~= nil then
                local baleServerId = balePlace.baleId
                local bale = networkGetObject(baleServerId);
                if bale ~= nil then
                    bale:unmount();
                end;
                balePlace.baleId = nil;
			end;
		end;
		for _, balePlace in pairs(self.saplings) do
            if balePlace.baleId ~= nil then
                local baleServerId = balePlace.baleId
                local bale = networkGetObject(baleServerId);
                if bale ~= nil then
                    bale:unmount();
                end;
                balePlace.baleId = nil;
			end;
		end;
		for _, balePlace in pairs(self.washpot) do
            if balePlace.baleId ~= nil then
                local baleServerId = balePlace.baleId
                local bale = networkGetObject(baleServerId);
                if bale ~= nil then
                    bale:unmount();
                end;
                balePlace.baleId = nil;
			end;
		end;
		for _, balePlace in pairs(self.fruits) do
            if balePlace.baleId ~= nil then
                local baleServerId = balePlace.baleId
                local bale = networkGetObject(baleServerId);
                if bale ~= nil then
                    bale:unmount();
                end;
                balePlace.baleId = nil;
			end;
		end;
		for _, balePlace in pairs(self.hmilk) do
            if balePlace.baleId ~= nil then
                local baleServerId = balePlace.baleId
                local bale = networkGetObject(baleServerId);
                if bale ~= nil then
                    bale:unmount();
                end;
                balePlace.baleId = nil;
			end;
		end;
	
		self.counter = 0;
		self.fillLevel = 0;

		setVisibility(self.marker, false);
		local x,y,z = getTranslation(self.centerJoint)
		setTranslation(self.marker, x,y,z)
		self.unloadPos = 0;
		local x,y,z = getTranslation(self.centerJoint)
		setTranslation(self.balesJoint, x,y,z)
		setTranslation(self.roundsJoint, x,y,z)
		setTranslation(self.woolJoint, x,y,z)
		setTranslation(self.woodJoint, x,y,z)
		setTranslation(self.saplingsJoint, x,y,z)
		setTranslation(self.washpotJoint, x,y,z)
		setTranslation(self.fruitsJoint, x,y,z)
		setTranslation(self.hmilkJoint, x,y,z)
		
	elseif mode == 98 then
		self.state = state;
		
	elseif mode == 99 then
		self.workMode = bool;
	end;
end;

function UAL:updateTick(dt)
end;

function UAL:FiDi(node,noEventSend)
	local x,y,z = localDirectionToWorld(node, 0, 0, 1);
	local length = Utils.vector2Length(x,z);
	local dX = x/length;
	local dZ = z/length;
	local JointDir = math.deg(math.atan2(dX,dZ)); 
	if JointDir < 0 then
		JointDir = 360 - (JointDir * -1);
	end;
	self.objDir = JointDir;

end;

function UAL:FiHeBa(LoadJoint,noEventSend)
	
	local px, py, pz = getWorldTranslation(LoadJoint);
	local nearestDistance = 7;
	local nearestBale = nil;
	
	for index, item in pairs(g_currentMission.itemsToSave) do
		if item.item:isa(Bale) or item.item:isa(FillablePallet) then
			--print(tostring(getName(item.item.nodeId)))
			for i, baleType in pairs(self.baleTypes) do
				if getName(item.item.nodeId) == baleType then
					local bx, by, bz = getWorldTranslation(item.item.nodeId);
					local distance = Utils.vector3Length(px-bx, py-by, pz-bz);
					if distance < nearestDistance then
						self.baleId = item.item.nodeId;
						self:FiDi(self.baleId);
						self.baleDir = self.objDir;
						self:FiDi(LoadJoint);
						self.spikeDir = self.objDir;
						self.dif = self.spikeDir - self.baleDir;

						self.foundIt = false;
						self.baleId = nil;
						if  (self.state == 2 and baleType:lower():find("round") ~= nil) or
						  (self.state == 1 and (baleType:lower():find("round") == nil) and (baleType:lower():find("bale") ~= nil))  or
						  (self.state == 3 and baleType:lower():find("wool") ~= nil) or
						  (self.state == 5 and baleType:lower():find("sapling") ~= nil) or
						  (self.state == 6 and baleType:lower():find("washedpotato") ~= nil) or
						  (self.state == 8 and baleType:lower():find("behaelter") ~= nil) or
						  (self.state == 7 and ((baleType:lower():find("tomato") ~= nil) or 
							(baleType:lower():find("tomate") ~= nil) or 
							(baleType:lower():find("berry") ~= nil) or 
							(baleType:lower():find("cauliflower") ~= nil) or 
							(baleType:lower():find("lettuce") ~= nil) or 
							(baleType:lower():find("mushroom") ~= nil) or 
							(baleType:lower():find("cherry") ~= nil) or 
							(baleType:lower():find("plum") ~= nil) or 
							(baleType:lower():find("egg") ~= nil) or 
							(baleType:lower():find("pallet") ~= nil) or 
							(baleType:lower():find("cardboardPallet") ~= nil) or 
							(baleType:lower():find("food1") ~= nil) or 
							(baleType:lower():find("meat") ~= nil) or 
							(baleType:lower():find("food2") ~= nil)) ) or
						(self.state == 4 and baleType:lower():find("board") ~= nil) then
							self.foundIt = true;
							self.baleId = networkGetObjectId(item.item);
						else
							break;	
						end;
					end;
					break;
				end;
			end;
			if self.foundIt then
				break;
			end;
		end;
	end;
end;

function UAL:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	self.counter = Utils.getNoNil(getXMLInt(xmlFile, key.."#numBales"),0);
	self.state = Utils.getNoNil(getXMLInt(xmlFile, key.."#baleMode"),0);
	self.fillLevel = self.counter;
	self.capacity = self.numMaxSquare;
	if self.state == 2 then
		self.capacity = self.numMaxRound;
	end
	if self.state == 3 then
		self.capacity = self.numMaxWool;
	end
	if self.state == 4 then
		self.capacity = self.numMaxWood;
	end
	if self.state == 5 then
		self.capacity = self.numMaxSaplings;
	end
	if self.state == 6 then
		self.capacity = self.numMaxWashpot;
	end
	if self.state == 7 then
		self.capacity = self.numMaxFruits;
	end
	if self.state == 8 then
		self.capacity = self.numMaxHmilk;
	end
	self.fillLevelMax = self.capacity;
		
	local i=0;
    while true do
        local baleKey = key..string.format(".bale(%d)", i);
        if not hasXMLProperty(xmlFile, baleKey) then
            break;
        end;
        local filename = getXMLString(xmlFile, baleKey.."#filename");
        if filename ~= nil then
            filename = Utils.convertFromNetworkFilename(filename);
            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#position"));
            local xRot,yRot,zRot = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#rotation"));
            local fillLevel = getXMLFloat(xmlFile, baleKey.."#fillLevel");
            local balePlace = getXMLInt(xmlFile, baleKey.."#balePlace");
            local helper = getXMLInt(xmlFile, baleKey.."#helper");
            if balePlace == nil or (balePlace > 0 and (x == nil or y == nil or z == nil or xRot == nil or yRot == nil or zRot == nil)) or (balePlace < 1 and helper == nil) then
                print("Warning: Corrupt savegame, bale "..filename.." could not be loaded");
            else
                local translation;
                local rotation;
                if balePlace > 0 then
                    translation = {x,y,z};
                    rotation={xRot, yRot, zRot};
                else
                    translation = {0,0,0};
                    rotation={0,0,0};
                end;
                local parentNode = nil;
                local bales = nil;
                if balePlace < 1 then
                    
                elseif balePlace <= table.getn(self.hayBales) then
                    parentNode = self.hayBales[balePlace].node;
                    bales = self.hayBales[balePlace].baleId;
                end;
                if parentNode ~= nil then
                    local baleValueScale = getXMLFloat(xmlFile, baleKey.."#baleValueScale");
                    local wrappingState = getXMLFloat(xmlFile, baleKey.."#wrappingState");
                    table.insert(self.balesToLoad, {parentNode=parentNode, filename=filename, bales=bales, translation=translation, rotation=rotation, fillLevel=fillLevel, baleValueScale=baleValueScale, wrappingState=wrappingState});
                end;
            end;
        end;
        i = i +1;
	end;
		
	local i=0;
    while true do
        local baleKey = key..string.format(".rbale(%d)", i);
        if not hasXMLProperty(xmlFile, baleKey) then
            break;
        end;
        local filename = getXMLString(xmlFile, baleKey.."#filename");
        if filename ~= nil then
            filename = Utils.convertFromNetworkFilename(filename);
            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#position"));
            local xRot,yRot,zRot = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#rotation"));
            local fillLevel = getXMLFloat(xmlFile, baleKey.."#fillLevel");
            local balePlace = getXMLInt(xmlFile, baleKey.."#balePlace");
            local helper = getXMLInt(xmlFile, baleKey.."#helper");
            if balePlace == nil or (balePlace > 0 and (x == nil or y == nil or z == nil or xRot == nil or yRot == nil or zRot == nil)) or (balePlace < 1 and helper == nil) then
                print("Warning: Corrupt savegame, rbale "..filename.." could not be loaded");
            else
                local translation;
                local rotation;
                if balePlace > 0 then
                    translation = {x,y,z};
                    rotation={xRot, yRot, zRot};
                else
                    translation = {0,0,0};
                    rotation={0,0,0};
                end;
                local parentNode = nil;
                local bales = nil;
                if balePlace < 1 then
                    
                elseif balePlace <= table.getn(self.hayRounds) then
                    parentNode = self.hayRounds[balePlace].node;
                    bales = self.hayRounds[balePlace].baleId;
                end;
                if parentNode ~= nil then
                    local baleValueScale = getXMLFloat(xmlFile, baleKey.."#baleValueScale");
                    local wrappingState = getXMLFloat(xmlFile, baleKey.."#wrappingState");
                    table.insert(self.rbalesToLoad, {parentNode=parentNode, filename=filename, bales=bales, translation=translation, rotation=rotation, fillLevel=fillLevel, baleValueScale=baleValueScale, wrappingState=wrappingState});
                end;
            end;
        end;
        i = i +1;
	end;
	
	local i=0;
    while true do
        local baleKey = key..string.format(".wool(%d)", i);
        if not hasXMLProperty(xmlFile, baleKey) then
            break;
        end;
        local filename = getXMLString(xmlFile, baleKey.."#filename");
        if filename ~= nil then
            filename = Utils.convertFromNetworkFilename(filename);
            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#position"));
            local xRot,yRot,zRot = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#rotation"));
            local fillLevel = getXMLFloat(xmlFile, baleKey.."#fillLevel");
            local balePlace = getXMLInt(xmlFile, baleKey.."#balePlace");
            local helper = getXMLInt(xmlFile, baleKey.."#helper");
            if balePlace == nil or (balePlace > 0 and (x == nil or y == nil or z == nil or xRot == nil or yRot == nil or zRot == nil)) or (balePlace < 1 and helper == nil) then
                print("Warning: Corrupt savegame, wool "..filename.." could not be loaded");
            else
                local translation;
                local rotation;
                if balePlace > 0 then
                    translation = {x,y,z};
                    rotation={xRot, yRot, zRot};
                else
                    translation = {0,0,0};
                    rotation={0,0,0};
                end;
                local parentNode = nil;
                local bales = nil;
                if balePlace < 1 then
                    
                elseif balePlace <= table.getn(self.wool) then
                    parentNode = self.wool[balePlace].node;
                    bales = self.wool[balePlace].baleId;
                end;
                if parentNode ~= nil then
                    local baleValueScale = getXMLFloat(xmlFile, baleKey.."#baleValueScale");
                    local wrappingState = getXMLFloat(xmlFile, baleKey.."#wrappingState");
                    table.insert(self.woolToLoad, {parentNode=parentNode, filename=filename, bales=bales, translation=translation, rotation=rotation, fillLevel=fillLevel, baleValueScale=baleValueScale, wrappingState=wrappingState});
                end;
            end;
        end;
        i = i +1;
	end;
	
	local i=0;
    while true do
        local baleKey = key..string.format(".wood(%d)", i);
        if not hasXMLProperty(xmlFile, baleKey) then
            break;
        end;
        local filename = getXMLString(xmlFile, baleKey.."#filename");
        if filename ~= nil then
            filename = Utils.convertFromNetworkFilename(filename);
            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#position"));
            local xRot,yRot,zRot = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#rotation"));
            local fillLevel = getXMLFloat(xmlFile, baleKey.."#fillLevel");
            local balePlace = getXMLInt(xmlFile, baleKey.."#balePlace");
            local helper = getXMLInt(xmlFile, baleKey.."#helper");
            if balePlace == nil or (balePlace > 0 and (x == nil or y == nil or z == nil or xRot == nil or yRot == nil or zRot == nil)) or (balePlace < 1 and helper == nil) then
                print("Warning: Corrupt savegame, wood "..filename.." could not be loaded");
            else
                local translation;
                local rotation;
                if balePlace > 0 then
                    translation = {x,y,z};
                    rotation={xRot, yRot, zRot};
                else
                    translation = {0,0,0};
                    rotation={0,0,0};
                end;
                local parentNode = nil;
                local bales = nil;
                if balePlace < 1 then
                    
                elseif balePlace <= table.getn(self.wood) then
                    parentNode = self.wood[balePlace].node;
                    bales = self.wood[balePlace].baleId;
                end;
                if parentNode ~= nil then
                    local baleValueScale = getXMLFloat(xmlFile, baleKey.."#baleValueScale");
                    local wrappingState = getXMLFloat(xmlFile, baleKey.."#wrappingState");
                    table.insert(self.woodToLoad, {parentNode=parentNode, filename=filename, bales=bales, translation=translation, rotation=rotation, fillLevel=fillLevel, baleValueScale=baleValueScale, wrappingState=wrappingState});
                end;
            end;
        end;
        i = i +1;
	end;
	
	local i=0;
    while true do
        local baleKey = key..string.format(".sapling(%d)", i);
        if not hasXMLProperty(xmlFile, baleKey) then
            break;
        end;
        local filename = getXMLString(xmlFile, baleKey.."#filename");
        if filename ~= nil then
            filename = Utils.convertFromNetworkFilename(filename);
            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#position"));
            local xRot,yRot,zRot = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#rotation"));
            local fillLevel = getXMLFloat(xmlFile, baleKey.."#fillLevel");
            local balePlace = getXMLInt(xmlFile, baleKey.."#balePlace");
            local helper = getXMLInt(xmlFile, baleKey.."#helper");
            if balePlace == nil or (balePlace > 0 and (x == nil or y == nil or z == nil or xRot == nil or yRot == nil or zRot == nil)) or (balePlace < 1 and helper == nil) then
                print("Warning: Corrupt savegame, sapling "..filename.." could not be loaded");
            else
                local translation;
                local rotation;
                if balePlace > 0 then
                    translation = {x,y,z};
                    rotation={xRot, yRot, zRot};
                else
                    translation = {0,0,0};
                    rotation={0,0,0};
                end;
                local parentNode = nil;
                local bales = nil;
                if balePlace < 1 then
                    
                elseif balePlace <= table.getn(self.saplings) then
                    parentNode = self.saplings[balePlace].node;
                    bales = self.saplings[balePlace].baleId;
                end;
                if parentNode ~= nil then
                    local baleValueScale = getXMLFloat(xmlFile, baleKey.."#baleValueScale");
                    local wrappingState = getXMLFloat(xmlFile, baleKey.."#wrappingState");
                    table.insert(self.saplingsToLoad, {parentNode=parentNode, filename=filename, bales=bales, translation=translation, rotation=rotation, fillLevel=fillLevel, baleValueScale=baleValueScale, wrappingState=wrappingState});
                end;
            end;
        end;
        i = i +1;
	end;

	local i=0;
    while true do
        local baleKey = key..string.format(".washpot(%d)", i);
        if not hasXMLProperty(xmlFile, baleKey) then
            break;
        end;
        local filename = getXMLString(xmlFile, baleKey.."#filename");
        if filename ~= nil then
            filename = Utils.convertFromNetworkFilename(filename);
            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#position"));
            local xRot,yRot,zRot = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#rotation"));
            local fillLevel = getXMLFloat(xmlFile, baleKey.."#fillLevel");
            local balePlace = getXMLInt(xmlFile, baleKey.."#balePlace");
            local helper = getXMLInt(xmlFile, baleKey.."#helper");
            if balePlace == nil or (balePlace > 0 and (x == nil or y == nil or z == nil or xRot == nil or yRot == nil or zRot == nil)) or (balePlace < 1 and helper == nil) then
                print("Warning: Corrupt savegame, washpot "..filename.." could not be loaded");
            else
                local translation;
                local rotation;
                if balePlace > 0 then
                    translation = {x,y,z};
                    rotation={xRot, yRot, zRot};
                else
                    translation = {0,0,0};
                    rotation={0,0,0};
                end;
                local parentNode = nil;
                local bales = nil;
                if balePlace < 1 then
                    
                elseif balePlace <= table.getn(self.washpot) then
                    parentNode = self.washpot[balePlace].node;
                    bales = self.washpot[balePlace].baleId;
                end;
                if parentNode ~= nil then
                    local baleValueScale = getXMLFloat(xmlFile, baleKey.."#baleValueScale");
                    local wrappingState = getXMLFloat(xmlFile, baleKey.."#wrappingState");
                    table.insert(self.washpotToLoad, {parentNode=parentNode, filename=filename, bales=bales, translation=translation, rotation=rotation, fillLevel=fillLevel, baleValueScale=baleValueScale, wrappingState=wrappingState});
                end;
            end;
        end;
        i = i +1;
	end;
	
	local i=0;
    while true do
        local baleKey = key..string.format(".fruits(%d)", i);
        if not hasXMLProperty(xmlFile, baleKey) then
            break;
        end;
        local filename = getXMLString(xmlFile, baleKey.."#filename");
        if filename ~= nil then
            filename = Utils.convertFromNetworkFilename(filename);
            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#position"));
            local xRot,yRot,zRot = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#rotation"));
            local fillLevel = getXMLFloat(xmlFile, baleKey.."#fillLevel");
            local balePlace = getXMLInt(xmlFile, baleKey.."#balePlace");
            local helper = getXMLInt(xmlFile, baleKey.."#helper");
            if balePlace == nil or (balePlace > 0 and (x == nil or y == nil or z == nil or xRot == nil or yRot == nil or zRot == nil)) or (balePlace < 1 and helper == nil) then
                print("Warning: Corrupt savegame, fruits "..filename.." could not be loaded");
            else
                local translation;
                local rotation;
                if balePlace > 0 then
                    translation = {x,y,z};
                    rotation={xRot, yRot, zRot};
                else
                    translation = {0,0,0};
                    rotation={0,0,0};
                end;
                local parentNode = nil;
                local bales = nil;
                if balePlace < 1 then
                    
                elseif balePlace <= table.getn(self.fruits) then
                    parentNode = self.fruits[balePlace].node;
                    bales = self.fruits[balePlace].baleId;
                end;
                if parentNode ~= nil then
                    local baleValueScale = getXMLFloat(xmlFile, baleKey.."#baleValueScale");
                    local wrappingState = getXMLFloat(xmlFile, baleKey.."#wrappingState");
                    table.insert(self.fruitsToLoad, {parentNode=parentNode, filename=filename, bales=bales, translation=translation, rotation=rotation, fillLevel=fillLevel, baleValueScale=baleValueScale, wrappingState=wrappingState});
                end;
            end;
        end;
        i = i +1;
	end;
	
	local i=0;
    while true do
        local baleKey = key..string.format(".hmilk(%d)", i);
        if not hasXMLProperty(xmlFile, baleKey) then
            break;
        end;
        local filename = getXMLString(xmlFile, baleKey.."#filename");
        if filename ~= nil then
            filename = Utils.convertFromNetworkFilename(filename);
            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#position"));
            local xRot,yRot,zRot = Utils.getVectorFromString(getXMLString(xmlFile, baleKey.."#rotation"));
            local fillLevel = getXMLFloat(xmlFile, baleKey.."#fillLevel");
            local balePlace = getXMLInt(xmlFile, baleKey.."#balePlace");
            local helper = getXMLInt(xmlFile, baleKey.."#helper");
            if balePlace == nil or (balePlace > 0 and (x == nil or y == nil or z == nil or xRot == nil or yRot == nil or zRot == nil)) or (balePlace < 1 and helper == nil) then
                print("Warning: Corrupt savegame, hmilk "..filename.." could not be loaded");
            else
                local translation;
                local rotation;
                if balePlace > 0 then
                    translation = {x,y,z};
                    rotation={xRot, yRot, zRot};
                else
                    translation = {0,0,0};
                    rotation={0,0,0};
                end;
                local parentNode = nil;
                local bales = nil;
                if balePlace < 1 then
                    
                elseif balePlace <= table.getn(self.hmilk) then
                    parentNode = self.hmilk[balePlace].node;
                    bales = self.hmilk[balePlace].baleId;
                end;
                if parentNode ~= nil then
                    local baleValueScale = getXMLFloat(xmlFile, baleKey.."#baleValueScale");
                    local wrappingState = getXMLFloat(xmlFile, baleKey.."#wrappingState");
                    table.insert(self.hmilkToLoad, {parentNode=parentNode, filename=filename, bales=bales, translation=translation, rotation=rotation, fillLevel=fillLevel, baleValueScale=baleValueScale, wrappingState=wrappingState});
                end;
            end;
        end;
        i = i +1;
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

function UAL:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'numBales="'..tostring(self.counter)..'"'..' baleMode="'..tostring(self.state)..'"';
	local nodes = "";
	local baleNum = 0;
	
	for i, balePlace in pairs(self.hayBales) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
                local nodeId = bale.nodeId;
                local x,y,z = getTranslation(nodeId);
                local rx,ry,rz = getRotation(nodeId);
                if baleNum>0 then
                    nodes = nodes.."\n";
                end;
                local wrappingState = Utils.getNoNil(bale.wrappingState, 0);
                local baleValueScale = Utils.getNoNil(bale.baleValueScale, 1);
                nodes = nodes..nodeIdent..'<bale filename="'..Utils.encodeToHTML(Utils.convertToNetworkFilename(bale.i3dFilename))..'" fillLevel="'..bale:getFillLevel()..'" position="'..x..' '..y..' '..z..'" rotation="'..rx..' '..ry..' '..rz..'" wrappingState="'..wrappingState..'" baleValueScale="'..baleValueScale..'" balePlace="'..i..'" />';
                baleNum = baleNum+1;
            end;
        end;
    end;
	
	local baleNum = 0;
	for i, balePlace in pairs(self.hayRounds) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
                local nodeId = bale.nodeId;
                local x,y,z = getTranslation(nodeId);
                local rx,ry,rz = getRotation(nodeId);
                if baleNum>0 then
                    nodes = nodes.."\n";
                end;
                local wrappingState = Utils.getNoNil(bale.wrappingState, 0);
                local baleValueScale = Utils.getNoNil(bale.baleValueScale, 1);
                nodes = nodes..nodeIdent..'<rbale filename="'..Utils.encodeToHTML(Utils.convertToNetworkFilename(bale.i3dFilename))..'" fillLevel="'..bale:getFillLevel()..'" position="'..x..' '..y..' '..z..'" rotation="'..rx..' '..ry..' '..rz..'" wrappingState="'..wrappingState..'" baleValueScale="'..baleValueScale..'" balePlace="'..i..'" />';
                baleNum = baleNum+1;
            end;
        end;
    end;
	
	local baleNum = 0;
	for i, balePlace in pairs(self.wool) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
                local nodeId = bale.nodeId;
                local x,y,z = getTranslation(nodeId);
                local rx,ry,rz = getRotation(nodeId);
                if baleNum>0 then
                    nodes = nodes.."\n";
                end;
                local wrappingState = Utils.getNoNil(bale.wrappingState, 0);
                local baleValueScale = Utils.getNoNil(bale.baleValueScale, 1);
                nodes = nodes..nodeIdent..'<wool filename="'..Utils.encodeToHTML(Utils.convertToNetworkFilename(bale.i3dFilename))..'" fillLevel="'..bale:getFillLevel()..'" position="'..x..' '..y..' '..z..'" rotation="'..rx..' '..ry..' '..rz..'" wrappingState="'..wrappingState..'" baleValueScale="'..baleValueScale..'" balePlace="'..i..'" />';
                baleNum = baleNum+1;
            end;
        end;
    end;
	
	local baleNum = 0;
	for i, balePlace in pairs(self.wood) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
                local nodeId = bale.nodeId;
                local x,y,z = getTranslation(nodeId);
                local rx,ry,rz = getRotation(nodeId);
                if baleNum>0 then
                    nodes = nodes.."\n";
                end;
                local wrappingState = Utils.getNoNil(bale.wrappingState, 0);
                local baleValueScale = Utils.getNoNil(bale.baleValueScale, 1);
                nodes = nodes..nodeIdent..'<wood filename="'..Utils.encodeToHTML(Utils.convertToNetworkFilename(bale.i3dFilename))..'" fillLevel="'..bale:getFillLevel()..'" position="'..x..' '..y..' '..z..'" rotation="'..rx..' '..ry..' '..rz..'" wrappingState="'..wrappingState..'" baleValueScale="'..baleValueScale..'" balePlace="'..i..'" />';
                baleNum = baleNum+1;
            end;
        end;
    end;
	
	local baleNum = 0;
	for i, balePlace in pairs(self.saplings) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
                local nodeId = bale.nodeId;
                local x,y,z = getTranslation(nodeId);
                local rx,ry,rz = getRotation(nodeId);
                if baleNum>0 then
                    nodes = nodes.."\n";
                end;
                local wrappingState = Utils.getNoNil(bale.wrappingState, 0);
                local baleValueScale = Utils.getNoNil(bale.baleValueScale, 1);
                nodes = nodes..nodeIdent..'<sapling filename="'..Utils.encodeToHTML(Utils.convertToNetworkFilename(bale.i3dFilename))..'" fillLevel="'..bale:getFillLevel()..'" position="'..x..' '..y..' '..z..'" rotation="'..rx..' '..ry..' '..rz..'" wrappingState="'..wrappingState..'" baleValueScale="'..baleValueScale..'" balePlace="'..i..'" />';
                baleNum = baleNum+1;
            end;
        end;
    end;
	
	local baleNum = 0;
	for i, balePlace in pairs(self.washpot) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
                local nodeId = bale.nodeId;
                local x,y,z = getTranslation(nodeId);
                local rx,ry,rz = getRotation(nodeId);
                if baleNum>0 then
                    nodes = nodes.."\n";
                end;
                local wrappingState = Utils.getNoNil(bale.wrappingState, 0);
                local baleValueScale = Utils.getNoNil(bale.baleValueScale, 1);
                nodes = nodes..nodeIdent..'<washpot filename="'..Utils.encodeToHTML(Utils.convertToNetworkFilename(bale.i3dFilename))..'" fillLevel="'..bale:getFillLevel()..'" position="'..x..' '..y..' '..z..'" rotation="'..rx..' '..ry..' '..rz..'" wrappingState="'..wrappingState..'" baleValueScale="'..baleValueScale..'" balePlace="'..i..'" />';
                baleNum = baleNum+1;
            end;
        end;
    end;
	
	local baleNum = 0;
	for i, balePlace in pairs(self.fruits) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
                local nodeId = bale.nodeId;
                local x,y,z = getTranslation(nodeId);
                local rx,ry,rz = getRotation(nodeId);
                if baleNum>0 then
                    nodes = nodes.."\n";
                end;
                local wrappingState = Utils.getNoNil(bale.wrappingState, 0);
                local baleValueScale = Utils.getNoNil(bale.baleValueScale, 1);
                nodes = nodes..nodeIdent..'<fruits filename="'..Utils.encodeToHTML(Utils.convertToNetworkFilename(bale.i3dFilename))..'" fillLevel="'..bale:getFillLevel()..'" position="'..x..' '..y..' '..z..'" rotation="'..rx..' '..ry..' '..rz..'" wrappingState="'..wrappingState..'" baleValueScale="'..baleValueScale..'" balePlace="'..i..'" />';
                baleNum = baleNum+1;
            end;
        end;
    end;
	
	local baleNum = 0;
	for i, balePlace in pairs(self.hmilk) do
        if balePlace.baleId ~= nil then
            local bale = networkGetObject(balePlace.baleId);
            if bale ~= nil then
                local nodeId = bale.nodeId;
                local x,y,z = getTranslation(nodeId);
                local rx,ry,rz = getRotation(nodeId);
                if baleNum>0 then
                    nodes = nodes.."\n";
                end;
                local wrappingState = Utils.getNoNil(bale.wrappingState, 0);
                local baleValueScale = Utils.getNoNil(bale.baleValueScale, 1);
                nodes = nodes..nodeIdent..'<hmilk filename="'..Utils.encodeToHTML(Utils.convertToNetworkFilename(bale.i3dFilename))..'" fillLevel="'..bale:getFillLevel()..'" position="'..x..' '..y..' '..z..'" rotation="'..rx..' '..ry..' '..rz..'" wrappingState="'..wrappingState..'" baleValueScale="'..baleValueScale..'" balePlace="'..i..'" />';
                baleNum = baleNum+1;
            end;
        end;
    end;

	return attributes,nodes;
end;

function UAL:readStream(streamId, connection)
	self.workMode = streamReadBool(streamId);
	self.counter = streamReadInt32(streamId);
	
	self.fillLevel = streamReadFloat32(streamId);
	self.state = streamReadInt32(streamId);
	
	for i=1, table.getn(self.hayBales) do
        local baleServerId = streamReadFloat32(streamId);
        self.hayBales[i].baleId = baleServerId;
		self.balesToMount[baleServerId] = {serverId=baleServerId, linkNode=self.hayBales[i].node, trans={ 0,0,0}, rot={0,0,0} };
    end;
	for i=1, table.getn(self.hayRounds) do
        local baleServerId = streamReadFloat32(streamId);
        self.hayRounds[i].baleId = baleServerId;
		self.rbalesToMount[baleServerId] = {serverId=baleServerId, linkNode=self.hayRounds[i].node, trans={ 0,0,0}, rot={0,0,0} };
    end;
	for i=1, table.getn(self.wool) do
        local baleServerId = streamReadFloat32(streamId);
        self.wool[i].baleId = baleServerId;
		self.woolToMount[baleServerId] = {serverId=baleServerId, linkNode=self.wool[i].node, trans={ 0,0,0}, rot={0,0,0} };
    end;
	for i=1, table.getn(self.wood) do
        local baleServerId = streamReadFloat32(streamId);
        self.wood[i].baleId = baleServerId;
		self.woodToMount[baleServerId] = {serverId=baleServerId, linkNode=self.wood[i].node, trans={ 0,0,0}, rot={0,0,0} };
    end;
	for i=1, table.getn(self.saplings) do
        local baleServerId = streamReadFloat32(streamId);
        self.saplings[i].baleId = baleServerId;
		self.saplingsToMount[baleServerId] = {serverId=baleServerId, linkNode=self.saplings[i].node, trans={ 0,0,0}, rot={0,0,0} };
    end;
	for i=1, table.getn(self.washpot) do
        local baleServerId = streamReadFloat32(streamId);
        self.washpot[i].baleId = baleServerId;
		self.washpotToMount[baleServerId] = {serverId=baleServerId, linkNode=self.washpot[i].node, trans={ 0,0,0}, rot={0,0,0} };
    end;
	for i=1, table.getn(self.fruits) do
        local baleServerId = streamReadFloat32(streamId);
        self.fruits[i].baleId = baleServerId;
		self.fruitsToMount[baleServerId] = {serverId=baleServerId, linkNode=self.fruits[i].node, trans={ 0,0,0}, rot={0,0,0} };
    end;
	for i=1, table.getn(self.hmilk) do
        local baleServerId = streamReadFloat32(streamId);
        self.hmilk[i].baleId = baleServerId;
		self.hmilkToMount[baleServerId] = {serverId=baleServerId, linkNode=self.hmilk[i].node, trans={ 0,0,0}, rot={0,0,0} };
    end;
end;

function UAL:writeStream(streamId, connection)

	streamWriteBool(streamId, self.workMode);
	streamWriteInt32(streamId, self.counter);

	streamWriteFloat32(streamId, self.fillLevel);
	streamWriteInt32(streamId, self.state);
	
	for i=1, table.getn(self.hayBales) do
        local baleServerId = self.hayBales[i].baleId;
		streamWriteFloat32(streamId, baleServerId);
	end;
	for i=1, table.getn(self.hayRounds) do
        local baleServerId = self.hayRounds[i].baleId;
		streamWriteFloat32(streamId, baleServerId);
	end;
	for i=1, table.getn(self.wool) do
        local baleServerId = self.wool[i].baleId;
		streamWriteFloat32(streamId, baleServerId);
	end;
	for i=1, table.getn(self.wood) do
        local baleServerId = self.wood[i].baleId;
		streamWriteFloat32(streamId, baleServerId);
	end;
	for i=1, table.getn(self.saplings) do
        local baleServerId = self.saplings[i].baleId;
		streamWriteFloat32(streamId, baleServerId);
	end;
	for i=1, table.getn(self.washpot) do
        local baleServerId = self.washpot[i].baleId;
		streamWriteFloat32(streamId, baleServerId);
	end;
	for i=1, table.getn(self.fruits) do
        local baleServerId = self.fruits[i].baleId;
		streamWriteFloat32(streamId, baleServerId);
	end;
	for i=1, table.getn(self.hmilk) do
        local baleServerId = self.hmilk[i].baleId;
		streamWriteFloat32(streamId, baleServerId);
	end;
end;