setWorkState = {};
setWorkState_mt = Class(setWorkState, Event);

InitEventClass(setWorkState, "setWorkState");

function setWorkState:emptyNew()
    local self = Event:new(setWorkState_mt);
    self.className="setWorkState";
    return self;
end;

function setWorkState:new(object, isCoupling)
    local self = setWorkState:emptyNew()
    self.object = object;
	self.isCoupling = isCoupling;
    return self;
end;

function setWorkState:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isCoupling = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function setWorkState:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isCoupling);
end;

function setWorkState:run(connection)   
	self.object:setWorkState(self.isCoupling, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(setWorkState:new(self.object, self.isCoupling), nil, connection, self.object);
    end;
end;

function setWorkState.sendEvent(vehicle, isCoupling, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setWorkState:new(vehicle, isCoupling), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setWorkState:new(vehicle, isCoupling));
		end;
	end;
end;

