local metadata = {
"## Interface:FS15 1.1.0.0 RC12",
"## Title: MilchTrailerToggleEmptyStateEvent",
"## Notes: to send MilkTruck ToggleEmptyState for MilkTrailer",
"## Author: Marhu",
"## Version: 1.0.1",
"## Date: 23.12.2014",
"## Web: http://marhu.net"
}
 
MilchTrailerToggleEmptyStateEvent = {};
MilchTrailerToggleEmptyStateEvent_mt = Class(MilchTrailerToggleEmptyStateEvent, Event);

InitEventClass(MilchTrailerToggleEmptyStateEvent, "MilchTrailerToggleEmptyStateEvent");

function MilchTrailerToggleEmptyStateEvent:emptyNew()
    local self = Event:new(MilchTrailerToggleEmptyStateEvent_mt);
    return self;
end;
    
function MilchTrailerToggleEmptyStateEvent:new(object)
	local self = MilchTrailerToggleEmptyStateEvent:emptyNew();
	self.object = object;
	return self;
end;

function MilchTrailerToggleEmptyStateEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function MilchTrailerToggleEmptyStateEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
end;

function MilchTrailerToggleEmptyStateEvent:run(connection)
	if self.object ~= nil then
		self.object:toggleEmptyState(true)
	end;
end;

function MilchTrailerToggleEmptyStateEvent.sendEvent(vehicle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server == nil then
			g_client:getServerConnection():sendEvent(MilchTrailerToggleEmptyStateEvent:new(vehicle));
		end;
	end;
end;