--***************************************************************
--
-- LinkToGlobalScripts
-- 
-- version 1.00 by mogli (biedens)
-- 2015/12/01
--
--***************************************************************
--***************************************************************
-- empty default functions
--***************************************************************
LinkToGlobalScripts = {}
LinkToGlobalScripts.debug = false
--********************************
-- prerequisitesPresent
--********************************
function LinkToGlobalScripts.prerequisitesPresent(specializations) 
	return true
end 
--********************************
-- load
--********************************
function LinkToGlobalScripts:load(xmlFile)
	for n,f in pairs( LinkToGlobalScripts ) do
		if type(f) == "function" and string.sub( n, 1, 4 ) == "l2gs" then
			self[n] = f
		end
	end
end
--********************************
-- delete
--********************************
function LinkToGlobalScripts:delete()
end
--********************************
-- mouseEvent
--********************************
function LinkToGlobalScripts:mouseEvent(posX, posY, isDown, isUp, button)
end
--********************************
-- keyEvent
--********************************
function LinkToGlobalScripts:keyEvent(unicode, sym, modifier, isDown)
end
--********************************
-- update
--********************************
function LinkToGlobalScripts:update(dt)
end
--********************************
-- updateTick
--********************************
function LinkToGlobalScripts:updateTick(dt)	
end
--********************************
-- draw
--********************************
function LinkToGlobalScripts:draw()	
end  
--********************************
-- getSaveAttributesAndNodes
--********************************
function LinkToGlobalScripts:l2gsGetSaveAttributesAndNodes(nodeIdent)
	local attributes = ""
	local nodes      = ""					
	return attributes, nodes
end;
--********************************
-- loadFromAttributesAndNodes
--********************************
function LinkToGlobalScripts:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	return BaseMission.VEHICLE_LOAD_OK
end 
--***************************************************************
--***************************************************************
-- warning
--***************************************************************
function LinkToGlobalScripts.warning( text, ms )
	g_currentMission:showBlinkingWarning( text, Utils.getNoNil( ms, 5000 ) )
	if LinkToGlobalScripts.debug then
		print( text )
	end
end
--**********************************************************************************************************	
-- LinkToGlobalScripts:l2gsToggleAutoTractorOn
--**********************************************************************************************************	
function LinkToGlobalScripts:l2gsToggleAITractorOn( force )
	local enable = force
	if force == nil then
		enable = not ( self.isAITractorActivated )
	end
  if self.isAITractorActivated and not ( enable ) then
    self:stopAITractor()
  elseif AITractor.canStartAITractor(self) and enable then
    self:startAITractor()
  end
end
--**********************************************************************************************************	
-- toggleAutoTractorEnabled
--**********************************************************************************************************	
function LinkToGlobalScripts:l2gsToggleAutoTractorEnabled( force )
	if     AutoTractor          == nil 
			or self.acParameters    == nil 
			or AutoTractor.onEnable == nil then
		LinkToGlobalScripts.warning( "LinkToGlobalScripts:setAutoTractorOn: mod zzzAutoTractor is missing!" )
		return
	end
	local enable
	if force == nil then
		enable = not ( self.acParameters.enabled )
	else
		enable = force
	end
	AutoTractor.onEnable( self, enable ) 
	if AutoTractor.sendParameters ~= nil then
		AutoTractor.sendParameters(self)
	end
end
--**********************************************************************************************************	
-- toggleAutoTractorEnabled
--**********************************************************************************************************	
function LinkToGlobalScripts:l2gsToggleAutoTractorLeftRight( force )
	if     AutoTractor             == nil 
			or self.acParameters       == nil 
			or AutoTractor.setAreaLeft == nil then
		LinkToGlobalScripts.warning( "LinkToGlobalScripts: mod zzzAutoTractor is missing!" )
		return
	end
	local enable
	if force == nil then
		enable = not ( self.acParameters.leftAreaActive )
	else
		enable = force
	end
	AutoTractor.setAreaLeft( self, enable ) 
	if AutoTractor.sendParameters ~= nil then
		AutoTractor.sendParameters(self)
	end
end
--**********************************************************************************************************	
-- toggleAutoTractorEnabled
--**********************************************************************************************************	
function LinkToGlobalScripts:l2gsToggleAutoTractorUTurn( force )
	if     AutoTractor          == nil 
			or self.acParameters    == nil 
			or AutoTractor.setUTurn == nil then
		LinkToGlobalScripts.warning( "LinkToGlobalScripts: mod zzzAutoTractor is missing!" )
		return
	end
	local enable
	if force == nil then
		enable = not ( self.acParameters.upNDown )
	else
		enable = force
	end
	AutoTractor.setUTurn( self, enable ) 
	if AutoTractor.sendParameters ~= nil then
		AutoTractor.sendParameters(self)
	end
end
--**********************************************************************************************************	
-- getAutoTractorWorkingWidth
--**********************************************************************************************************	
function LinkToGlobalScripts:l2gsGetAutoTractorWorkingWidth()
	if     AutoTractor                     == nil 
			or AutoTractor.calculateDimensions == nil 
			or self.acParameters               == nil then
		return 0
	end
	if     self.acDimensions                   == nil 
			or self.acDimensions.distance          == nil then
		AutoTractor.calculateDimensions( self )
	end
	if     self.acDimensions                   == nil 
			or self.acDimensions.distance          == nil then
		return 0
	end
	return self.acDimensions.distance + self.acDimensions.distance
end
--**********************************************************************************************************	
-- getAutoTractorHeadland
--**********************************************************************************************************	
function LinkToGlobalScripts:l2gsGetAutoTractorHeadland()
	if     AutoTractor                     == nil 
			or AutoTractor.calculateDimensions == nil 
			or self.acParameters               == nil then
		return 0
	end
	if     not ( self.acParameters.upNDown ) 
			or not ( self.acParameters.headland ) then
		return 0
	end
	if     self.acDimensions                                == nil 
			or self.acDimensions.self.acDimensions.headlandDist == nil then
		AutoTractor.calculateDimensions( self )
	end
	if     self.acDimensions                                == nil 
			or self.acDimensions.self.acDimensions.headlandDist == nil then
		return 0
	end
	return self.acDimensions.self.acDimensions.headlandDist
end
--**********************************************************************************************************	
-- toggleGearboxOnOff
--**********************************************************************************************************	
function LinkToGlobalScripts:l2gsToggleGearboxOnOff()
	if     self.mrGbMSetIsOnOff  == nil 
			or self.mrGbMGetIsOnOff  == nil then
		-- show blinking warning
		LinkToGlobalScripts.warning( "LinkToGlobalScripts: mod zzzMrGearboxAddon is missing!" )
		return
	end
	if self.mrGbMS.NoDisable then
		return 
	end
	local target
	if force == nil then
		traget = not ( self:mrGbMGetIsOnOff() )
	else
		target = force
	end
	if target == self:mrGbMGetIsOnOff() then
		return
	end
	if      self.isMotorStarted
			and ( ( self.dCcheckModule ~= nil
					and self:dCcheckModule("manMotorStart") )
				 or ( self.setManualIgnitionMode ~= nil ) ) then
		LinkToGlobalScripts.warning( "Cannot exchange gearbox while motor is running" )
	else	
		self:mrGbMSetIsOnOff( target ) 
	end
end
--**********************************************************************************************************	
-- toggleDC4WD
--**********************************************************************************************************	
function LinkToGlobalScripts:l2gsToggleDC4WD()
	if     self.dCcheckModule == nil
			or self.driveControl == nil then
		LinkToGlobalScripts.warning( "LinkToGlobalScripts: mod ZZZ_driveControl is missing!" )
		return 
	end
	if      self:dCcheckModule("fourWDandDifferentials") 
			and self.driveControl.fourWDandDifferentials ~= nil
			and not ( self.driveControl.fourWDandDifferentials.isSurpressed ) then
		local enable 
		if force == nil then
			enable = not ( self.driveControl.fourWDandDifferentials.fourWheel )
		else
			enable = force
		end
		self.driveControl.fourWDandDifferentials.fourWheel = enable
		driveControlInputEvent.sendEvent(self)
	end
end
--**********************************************************************************************************	
-- toggleDCDiffLockFront 
--**********************************************************************************************************	
function LinkToGlobalScripts:l2gsToggleDCDiffLockFront()
	if     self.dCcheckModule == nil
			or self.driveControl == nil then
		LinkToGlobalScripts.warning( "LinkToGlobalScripts: mod ZZZ_driveControl is missing!" )
		return 
	end
	if      self:dCcheckModule("fourWDandDifferentials") 
			and self.driveControl.fourWDandDifferentials ~= nil
			and not ( self.driveControl.fourWDandDifferentials.isSurpressed ) then
		local enable 
		if force == nil then
			enable = not ( self.driveControl.fourWDandDifferentials.diffLockFront )
		else
			enable = force
		end
		self.driveControl.fourWDandDifferentials.diffLockFront = enable
		driveControlInputEvent.sendEvent(self)
	end
end
--**********************************************************************************************************	
-- toggleDCDiffLockBack
--**********************************************************************************************************	
function LinkToGlobalScripts:l2gsToggleDCDiffLockBack()
	if     self.dCcheckModule == nil
			or self.driveControl == nil then
		LinkToGlobalScripts.warning( "LinkToGlobalScripts: mod ZZZ_driveControl is missing!" )
		return 
	end
	if      self:dCcheckModule("fourWDandDifferentials") 
			and self.driveControl.fourWDandDifferentials ~= nil
			and not ( self.driveControl.fourWDandDifferentials.isSurpressed ) then
		local enable 
		if force == nil then
			enable = not ( self.driveControl.fourWDandDifferentials.diffLockBack )
		else
			enable = force
		end
		self.driveControl.fourWDandDifferentials.diffLockBack = enable
		driveControlInputEvent.sendEvent(self)
	end
end
--**********************************************************************************************************	
-- toggleMotorIsStarted
--**********************************************************************************************************	
function LinkToGlobalScripts:l2gsToggleMotorIsStarted( force )
	if     self.dCcheckModule == nil
			or self.driveControl  == nil then
		LinkToGlobalScripts.warning( "LinkToGlobalScripts: mod ZZZ_driveControl is missing!" )
		return 
	end
	local enable 
	if force == nil then
		enable = not ( self.isMotorStarted )
	else
		enable = force
	end	
	if      self:dCcheckModule("manMotorStart") 
			and self.driveControl.manMotorStart ~= nil then
		self.driveControl.manMotorStart.isMotorStarted = enable
		driveControlInputEvent.sendEvent(self)
	end
end
--**********************************************************************************************************	
-- toggleHandBrake
--**********************************************************************************************************	
function LinkToGlobalScripts:l2gsToggleHandBrake( force )
	if     self.dCcheckModule == nil
			or self.driveControl  == nil then
		LinkToGlobalScripts.warning( "LinkToGlobalScripts: mod ZZZ_driveControl is missing!" )
		return 
	end
	if      self:dCcheckModule("handBrake") 
			and self.driveControl.handBrake ~= nil then
		local enable 
		if force == nil then
			enable = not ( self.driveControl.handBrake.isActive )
		else
			enable = force
		end
		self.driveControl.handBrake.isActive = enable
		driveControlInputEvent.sendEvent(self)
	end
end
--**********************************************************************************************************	
-- LinkToGlobalScriptsTest 
--**********************************************************************************************************	
function LinkToGlobalScripts:LinkToGlobalScriptsTest()
	local self = g_currentMission.controlledVehicle
	for n,f in pairs( LinkToGlobalScripts ) do
		if type(f) == "function" and string.sub( n, 1, 4 ) == "l2gs" then
			print("Calling "..tostring(n).."...")
			local state, result = pcall( f, self )
			if state then
				print("Result of "..tostring(n)..": "..tostring(result))
			else
				print("Failed: "..tostring(result))
			end
		end
	end
end

if LinkToGlobalScripts.debug then
	addConsoleCommand("LinkToGlobalScriptsTest", "Call all functions of LinkToGlobalScripts", "LinkToGlobalScriptsTest", LinkToGlobalScripts);
end