--Name: FarmingTabletPlaceable
--Author: kevink98
--Date: 17.04.2016
--Version: 1.0
--Description: Platierbares Obkjekt für den Kauf vom Tablet

--Versionen: 
--				1.0: Release

FarmingTabletPlaceable = {};
FarmingTabletPlaceable.modPath = g_currentModDirectory;

FarmingTabletPlaceable_mt = Class(FarmingTabletPlaceable, Placeable);
InitObjectClass(FarmingTabletPlaceable, "FarmingTabletPlaceable");

function FarmingTabletPlaceable:new(isServer, isClient, customMt)
	local mt = customMt;
	if mt == nil then
		mt = FarmingTabletPlaceable_mt;
	end;
	
	local self = Placeable:new(isServer, isClient, mt);
	
	registerObjectClassName(self, "FarmingTabletPlaceable");
		
	return self;
end;

function FarmingTabletPlaceable:delete()
	
    unregisterObjectClassName(self);

	FarmingTabletPlaceable:superClass().delete(self);
	
	if self.trigger then
		removeTrigger(self.trigger);
	end;
end;

function FarmingTabletPlaceable:deleteFinal()
	FarmingTabletPlaceable:superClass().deleteFinal(self);
end;

function FarmingTabletPlaceable:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not FarmingTabletPlaceable:superClass().load(self, xmlFilename, x, y, z, rx, ry, rz, moveMode, initRandom) then
		return false;
	end;
	
	self.triggerActiveOn = false;
	self.load = false;
	self.on = false;
	a = 0;
    return true;
end;

function FarmingTabletPlaceable:finalizePlacement()
	FarmingTabletPlaceable:superClass().finalizePlacement(self);
	
	g_currentMission.FarmingTablet = {};
	g_currentMission.FarmingTablet.Verwaltung = {};
	g_currentMission.FarmingTablet.Verwaltung.isBuy = true;
	
	g_currentMission.FarmingTablet.Appstore = {};
	g_currentMission.FarmingTablet.Appstore.apps = {};
	g_currentMission.FarmingTablet.Appstore.apps[1] = false;
	g_currentMission.FarmingTablet.Appstore.apps[2] = false;
	g_currentMission.FarmingTablet.Appstore.apps[3] = false;
	g_currentMission.FarmingTablet.Appstore.apps[4] = false;
	
	g_currentMission.FarmingTablet.Bank = {};
	g_currentMission.FarmingTablet.Bank.Kredit1 = {};
	g_currentMission.FarmingTablet.Bank.Kredit2 = {};
	g_currentMission.FarmingTablet.Bank.Kredit3 = {};
	g_currentMission.FarmingTablet.Bank.Anlegen = {};
	
	g_currentMission.FarmingTablet.SoilExtension = {};
	g_currentMission.FarmingTablet.SoilExtension.daten = {};
	g_currentMission.FarmingTablet.SoilExtension.daten.fields = {};
	
	--for i = 1, 12 do 
	--	g_currentMission.FarmingTablet.SoilExtension.daten.fields[i] = {};
	--end;
	
	g_currentMission.FarmingTablet.Calendar = {};
	g_currentMission.FarmingTablet.Calendar.Termine = {};
	g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay] = {};
	g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1] = {};
	g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2] = {};
	
	local displays = Utils.getNoNil(getUserAttribute(self.nodeId, "Displays"), 1);
	local anzeigeAkku = Utils.getNoNil(getUserAttribute(self.nodeId, "AnzeigeAkku"), 2);
	local trigger = Utils.getNoNil(getUserAttribute(self.nodeId, "PlayerTrigger"), 3);
	
	local displayId = Utils.indexToObject(self.nodeId, displays);
	if displayId then
		local numChildren = getNumOfChildren(displayId);
		if 0 >= numChildren then
			print("FarmingTablet: Error: No Displays!");
			return false;
		end;
		self.displays = {};
		
		local child1 = getChildAt(displayId, 0);
		local child2 = getChildAt(displayId, 1);
		local child3 = getChildAt(displayId, 2);
		local child4 = getChildAt(displayId, 3);
		
		local displayOnOff = Utils.getNoNil(getUserAttribute(child1, "on_off"), 0);
		local display1 = Utils.getNoNil(getUserAttribute(child2, "display1"), 1);
		local display2 = Utils.getNoNil(getUserAttribute(child3, "display2"), 2);
		local display3 = Utils.getNoNil(getUserAttribute(child4, "display3"), 3);

		self.displayOnOff = Utils.indexToObject(displayId, displayOnOff);
		self.display1 = Utils.indexToObject(displayId, display1);
		self.display2 = Utils.indexToObject(displayId, display2);
		self.display3 = Utils.indexToObject(displayId, display3);
	end;
	
	local anzeigeAkkuId = Utils.indexToObject(self.nodeId, anzeigeAkku);
	if anzeigeAkkuId then
		local numChildren = getNumOfChildren(anzeigeAkkuId);
		if 0 >= numChildren then
			print("FarmingTablet: Error: No bar in Akku!");
			return false;
		end;
		self.anzeigeAkku = {};
		
		local child1 = getChildAt(anzeigeAkkuId, 0);
		local child2 = getChildAt(anzeigeAkkuId, 1);
		local child3 = getChildAt(anzeigeAkkuId, 2);
		local child4 = getChildAt(anzeigeAkkuId, 3);
		
		local akku1 = Utils.getNoNil(getUserAttribute(child1, "akku1"), 0);
		local akku2 = Utils.getNoNil(getUserAttribute(child2, "akku2"), 1);
		local akku3 = Utils.getNoNil(getUserAttribute(child3, "akku3"), 2);
		local akku4 = Utils.getNoNil(getUserAttribute(child4, "akku4"), 3);
		
		self.akku1 = Utils.indexToObject(anzeigeAkkuId, akku1);
		self.akku2 = Utils.indexToObject(anzeigeAkkuId, akku2);
		self.akku3 = Utils.indexToObject(anzeigeAkkuId, akku3);
		self.akku4 = Utils.indexToObject(anzeigeAkkuId, akku4);
		
	end;
	
	self.trigger = Utils.indexToObject(self.nodeId, trigger);
	
	local x, _, z = getWorldTranslation(self.trigger);
	self.mapHotspot = g_currentMission.ingameMap:createMapHotspot("Ladestation Tablet", FarmingTabletPlaceable.modPath .. "hudsAll/huds/hud_pda.png", x, z, nil, nil, false, false, true, 0, true);

	if self.trigger ~= nil then
		addTrigger(self.trigger, "PlayerTriggerCallback", self);
	end;
	
	setVisibility(self.display1, false);
	setVisibility(self.display2, false);
	setVisibility(self.display3, false);
	setVisibility(self.displayOnOff, false);
	setVisibility(self.akku1, false);
	setVisibility(self.akku2, false);
	setVisibility(self.akku3, false);
	setVisibility(self.akku4, false);
	
end;

function FarmingTabletPlaceable:PlayerTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if (g_currentMission.controlPlayer and g_currentMission.player and otherId == g_currentMission.player.rootNode) then
		
		if (onEnter) then 
			self.triggerActiveOn = true;
		elseif (onLeave) then
            self.load = false;
			setVisibility(self.displayOnOff, false);
			setVisibility(self.display1, false);
			setVisibility(self.display2, false);
			setVisibility(self.display3, false);
			setVisibility(self.akku1, false);
			setVisibility(self.akku2, false);
			setVisibility(self.akku3, false);
			setVisibility(self.akku4, false);
			self.triggerActiveOn = false;
        end;
	end;
	
end;

function FarmingTabletPlaceable:triggerSend()
	
	if self.triggerActiveOn then
		if g_currentMission.controlledVehicle == nil then
			if self.on == false then
				g_currentMission:addHelpButtonText(g_i18n:getText("FTturnOn"), InputBinding.FTturnOn);
			elseif self.on then
				g_currentMission:addHelpButtonText(g_i18n:getText("FTturnOff"), InputBinding.FTturnOn);
				if self.load == false then
					g_currentMission:addHelpButtonText(g_i18n:getText("FTloadTab"), InputBinding.FTloadTab);
				end;
			end;
			if InputBinding.hasEvent(InputBinding.FTturnOn)then
				if self.on then
					self.on = false;
				elseif self.on == false then
					self.on = true;
				end;
			end;
			if InputBinding.hasEvent(InputBinding.FTloadTab) and self.on then
				if self.load then
					self.load = false;
				elseif self.load == false then
					self.load = true;
				end;
			end;
		end;
	end;
	
	if self.on then
		setVisibility(self.displayOnOff, true);
		if self.load then 
			g_currentMission:addHelpButtonText(g_i18n:getText("FTbreakTab"), InputBinding.FTloadTab);
			setVisibility(self.display1, false);
			setVisibility(self.display2, true);
			setVisibility(self.display3, false);
			
			if g_currentMission.FarmingTablet.Settings.akkuFuel < 162000 then
				if a < 10 then
					setVisibility(self.akku1, true);
				else 
					setVisibility(self.akku1, false);
				end;
				a = a + 1;
				if a == 20 then
					a = 0;
				end;
			elseif g_currentMission.FarmingTablet.Settings.akkuFuel >= 162000 and g_currentMission.FarmingTablet.Settings.akkuFuel < 324000 then
				setVisibility(self.akku1, true);
				if a < 10 then
					setVisibility(self.akku2, true);
				else 
					setVisibility(self.akku2, false);
				end;
				a = a + 1;
				if a == 20 then
					a = 0;
				end;
			elseif g_currentMission.FarmingTablet.Settings.akkuFuel >= 324000 and g_currentMission.FarmingTablet.Settings.akkuFuel < 486000 then
				setVisibility(self.akku1, true);
				setVisibility(self.akku2, true);
				if a < 10 then
					setVisibility(self.akku3, true);
				else 
					setVisibility(self.akku3, false);
				end;
				a = a + 1;
				if a == 20 then
					a = 0;
				end;
				
			elseif g_currentMission.FarmingTablet.Settings.akkuFuel >= 324000 and g_currentMission.FarmingTablet.Settings.akkuFuel < 648000 then
				setVisibility(self.akku1, true);
				setVisibility(self.akku2, true);
				setVisibility(self.akku3, true);
				if a < 10 then
					setVisibility(self.akku4, true);
				else 
					setVisibility(self.akku4, false);
				end;
				a = a + 1;
				if a == 20 then
					a = 0;
				end;
				if g_currentMission.FarmingTablet.Settings.akkuFuel == 648000 then
					self.load = false;
				end;
			end;
			if g_currentMission.FarmingTablet.Settings.akkuFuel ~= nil then
				g_currentMission.FarmingTablet.Settings.akkuFuel = g_currentMission.FarmingTablet.Settings.akkuFuel + 648;
				if g_currentMission.FarmingTablet.Settings.akkuFuel >= 648000 then
					g_currentMission.FarmingTablet.Settings.akkuFuel = 648000
					self.load = false;
				end;
			end;
		elseif self.load == false and g_currentMission.FarmingTablet.Settings.akkuFuel == 648000 then	
				a = 0;
				setVisibility(self.akku1, true);
				setVisibility(self.akku2, true);
				setVisibility(self.akku3, true);
				setVisibility(self.akku4, true);
				setVisibility(self.display2, false);
				setVisibility(self.display3, true);
		elseif self.load == false and g_currentMission.FarmingTablet.Settings.akkuFuel ~= 648000 then
				setVisibility(self.display1, true);
				setVisibility(self.display2, false);
				setVisibility(self.display3, false);
				a = 0;
				if g_currentMission.FarmingTablet.Settings.akkuFuel >= 162000 and g_currentMission.FarmingTablet.Settings.akkuFuel < 324000 then
					setVisibility(self.akku1, true);
					
				elseif g_currentMission.FarmingTablet.Settings.akkuFuel >= 324000 and g_currentMission.FarmingTablet.Settings.akkuFuel < 486000 then
					setVisibility(self.akku1, true);
					setVisibility(self.akku2, true);
					
					
				elseif g_currentMission.FarmingTablet.Settings.akkuFuel >= 324000 and g_currentMission.FarmingTablet.Settings.akkuFuel < 648000 then
					setVisibility(self.akku1, true);
					setVisibility(self.akku2, true);
					setVisibility(self.akku3, true);
				end;
			end;
						
	elseif self.on == false then
		setVisibility(self.displayOnOff, false);
		setVisibility(self.display1, false);
		setVisibility(self.display2, false);
		setVisibility(self.display3, false);
		setVisibility(self.akku1, false);
		setVisibility(self.akku2, false);
		setVisibility(self.akku3, false);
		setVisibility(self.akku4, false);
	end;
	
end;

function FarmingTabletPlaceable:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not FarmingTabletPlaceable:superClass().loadFromAttributesAndNodes(self, xmlFile, key, resetVehicles) then
		return false;
	end;
	
	return true;
end;

function FarmingTabletPlaceable:getSaveAttributesAndNodes(nodeIdent)
	local attributes, nodes = "","";
			
	attributes, nodes = FarmingTabletPlaceable:superClass().getSaveAttributesAndNodes(self, nodeIdent);
	
	return attributes, nodes; 
end;

function FarmingTabletPlaceable:writeAllStream(streamId, connection)
		
end;
function FarmingTabletPlaceable:readAllStream(streamId, connection)
	
end; 
function FarmingTabletPlaceable:writeStream(streamId, connection)
	FarmingTabletPlaceable:superClass().writeStream(self, streamId, connection)
	if not connection:getIsServer() then
		--self:writeAllStream(streamId, connection)
	end;
end
function FarmingTabletPlaceable:readStream(streamId, connection)
	FarmingTabletPlaceable:superClass().readStream(self, streamId, connection)
	if connection:getIsServer() then
		--self:readAllStream(streamId, connection)
	end;
end;
function FarmingTabletPlaceable:writeUpdateStream(streamId, connection, dirtyMask)
	FarmingTabletPlaceable:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	if not connection:getIsServer() then
		--self:writeAllStream(streamId, connection)
	end;
end;
function FarmingTabletPlaceable:readUpdateStream(streamId, timestamp, connection)
	FarmingTabletPlaceable:superClass().readUpdateStream(self, streamId, timestamp, connection);
	if connection:getIsServer() then
		--self:readAllStream(streamId, connection)
	end;
end;

function FarmingTabletPlaceable:update(dt)
	self:triggerSend();
end;

function FarmingTabletPlaceable:updateTick(dt)
	
end;

registerPlaceableType("FarmingTabletPlaceable", FarmingTabletPlaceable);