--Name: FarmingTablet
--Author: kevink98
--Date: 17.04.2016
--Version: 1.0

--Versionen: 
--				0.1: Release
--				1.0: ...


	
--Keine Änderung ohne meine Erlaubnis!
--No modification without my permission!

FarmingTablet = {};
FarmingTablet_directory = g_currentModDirectory;
FarmingTablet_directoryMods = g_modsDirectory;

addModEventListener(FarmingTablet);

print("++FarmingTablet v 1.0 loaded! Support on Marhu.net++");

function FarmingTablet:loadMap()

	self.posDebug = false;
	self.version = 1;
	self.buy = false;
	self.active = false;
	self.hudOn = false;
	self.first = 1;
	self.allAppsClose = true;
	dedi = false;
	self.i=1;
	self.akkuFull = true;
	self.firstUpdate = true;
	
end;

function FarmingTablet:update(dt)
	if self.isClient then
		if self.firstUpdate then
			self.firstUpdate = false;
			if g_server == nil then
				g_client:getServerConnection():sendEvent(Client:new());
			end;
		end;
	end;
	if g_currentMission.FarmingTablet ~= nil then
		if g_currentMission.FarmingTablet.Verwaltung.isBuy ~= nil and g_currentMission.FarmingTablet.Verwaltung.isBuy and self.first == 1 then
			self.active = true;
			self.first = 2;
		elseif g_currentMission.FarmingTablet.buy ~= nil or g_currentMission.FarmingTablet.buy == false then 
			self.active = false;
			self.first = 1;
		end;
		if g_currentMission.FarmingTablet.Settings ~= nil then
			if g_currentMission.FarmingTablet.Settings.akkuFuel ~= nil and self.hudOn then
				if g_currentMission.FarmingTablet.Settings.akkuFuel == 0 then
					self.akkuFull = false;
				else
					self.akkuFull = true;
					g_currentMission.FarmingTablet.Settings.akkuFuel = g_currentMission.FarmingTablet.Settings.akkuFuel -3;
					if g_currentMission.FarmingTablet.Settings.akkuFuel <= 0 then
						g_currentMission.FarmingTablet.Settings.akkuFuel = 0;
						self.akkuFull = false;
					end;
				end;
			end;
		end;
	end;
	if self.first == 2 then
		if self.active then
			self.hudOn = false;
			
			--App-Klickzonen--
			FarmingTablet.kz = {};
			FarmingTablet.kz.app1 = false; -- Bank--
			FarmingTablet.kz.app2 = false; -- FabrikscriptExtension--
			FarmingTablet.kz.app3 = false; -- SoilExtension--
			FarmingTablet.kz.app4 = false; -- Kalender--
			
			FarmingTablet.kz.app99 = false; -- Appstore--
			FarmingTablet.kz.app100 = false; -- Settings--
			
			source(FarmingTablet_directory.."Scripts/actions/loads.lua");
			
			loads:overlay();
			loads:scripts();
			loads:scriptsRegister ();
			
			
			self.isServer = g_server ~= nil;
			self.isClient = g_client ~= nil;

			if self.isServer and self.isClient then
				self.isClient = self.isClient and not g_currentMission.connectedToDedicatedServer;
			end;

			if self.isServer then
					
				
				local savegameIndex = g_currentMission.missionInfo.savegameIndex;
				local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory;
				if savegameFolderPath == nil then
					savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), savegameIndex);
				end;
				
				if fileExists(savegameFolderPath .. '/FarmingTablet.xml') then
					local xml = loadXMLFile("FarmingTablet",savegameFolderPath .. '/FarmingTablet.xml', "FarmingTablet");
					
					Appstore:loadXml(xml);
					Bank:loadXml(xml);
					SoilExtension:loadXml(xml);
					Calendar:loadXml(xml);
					delete(xml);
				else
				
					Appstore:loadXmlFirst(xml);
					Bank:loadXmlFirst();
					--SoilExtension:loadXmlFirst();
				end;
			end;
			
			if fileExists(getUserProfileAppPath() .. '/FarmingTabletConfig.xml') then
				local xmlConfig = loadXMLFile("FarmingTablet", getUserProfileAppPath() .. '/FarmingTabletConfig.xml', "FarmingTablet");
				
				Settings:loadXml(xmlConfig);
				
				delete(xmlConfig);
			else
				Settings:loadXmlFirst();
				
			end;
		end;
		self.first = 3;
	end;
	
	if self.active then
		local dediready = g_currentMission:getIsServer() or g_currentMission.isMasterUser;
		
		if g_currentMission.clientPermissionSettings.ownMoney or dediready then
			dedi = true;
		else
			dedi = false;
		end;
		
		if g_currentMission.controlledVehicle == nil then
			if InputBinding.isPressed(InputBinding.FTopen1) then
				if InputBinding.hasEvent(InputBinding.FTopen2) and self.hudOn == false then
					self:tapopen(true);
				end;
			end;
		end;
		if g_currentMission.controlledVehicle == nil then	
			if InputBinding.isPressed(InputBinding.FTclose1) then
				if InputBinding.isPressed(InputBinding.FTclose2) and self.hudOn then	
					self:tapclosed(true);
				end;
			end;
		end;
				
		if FarmingTablet.kz.app1 then 
			Bank:updateBank (dt);
		end;
		if FarmingTablet.kz.app2 then 
			FabrikscriptExtension:updateFabrikscriptExtension (dt);
		end;
		if FarmingTablet.kz.app3 then
			SoilExtension:updateSoilExtension (dt);
		end;
		if FarmingTablet.kz.app4 then
			Calendar:updateCalendar (dt);
		end;
		if FarmingTablet.kz.app99 then
			Appstore:updateAppstore (dt);
		end;
		if FarmingTablet.kz.app100 then
			Settings:updateSettings (dt);
		end;
	end;
	if g_currentMission.environment.currentHour < 10 then
		self.uhr1 = tostring("0"..g_currentMission.environment.currentHour);
	else
		self.uhr1 = tostring(g_currentMission.environment.currentHour);
	end;
	if g_currentMission.environment.currentMinute < 10 then
		self.uhr2 = tostring("0"..g_currentMission.environment.currentMinute);
	else
		self.uhr2 = tostring(g_currentMission.environment.currentMinute);
	end;
end;

function FarmingTablet:saveMap()
	if g_server ~= nil and g_currentMission.FarmingTablet ~= nil then
		--local savegameIndex = g_currentMission.missionInfo.savegameIndex;
		--local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory;
		--if savegameFolderPath == nil then
		--	savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), savegameIndex);
		--end;
		
		local file = getUserProfileAppPath()..'/FarmingTabletConfig.xml';
		local xmlConfig = createXMLFile("FarmingTablet_XML", file, "FarmingTablet");
			
		Settings:saveXml(xmlConfig);
		
			
		saveXMLFile(xmlConfig);
		delete(xmlConfig);
		
		local savegameIndex = g_currentMission.missionInfo.savegameIndex;
		local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory;
		if savegameFolderPath == nil then
			savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), savegameIndex);
		end;
		
		if fileExists(savegameFolderPath .. '/careerSavegame.xml') then
			local file = savegameFolderPath..'/FarmingTablet.xml';
			local xml = createXMLFile("FarmingTablet_XML", file, "FarmingTablet");
			
			Bank:saveXml(xml);
			Appstore:saveXml(xml);
			SoilExtension:saveXml(xml);
			Calendar:saveXml(xml);
			saveXMLFile(xml);
			delete(xml);
		end;
	end;
end;

function FarmingTablet:tapopen(open) 
	if open then
		self.showHelpText = g_currentMission.showHelpText;
		self.isPlayerFrozen = g_currentMission.isPlayerFrozen;
		self.renderTime = g_currentMission.renderTime;
		self.showVehicleSchema = g_currentMission.showVehicleSchema;
		self.ingameMap = g_currentMission.ingameMap.isVisible;
		self.showHudEnv = g_currentMission.showHudEnv;
		self.showWeatherForecast = g_currentMission.showWeatherForecast;
		if g_gui.currentGui ~= nil  then
			g_currentMission.showHelpText = self.showHelpText;
			g_currentMission.isPlayerFrozen = self.isPlayerFrozen;
			g_currentMission.renderTime = self.renderTime;
			g_currentMission.showVehicleSchema = self.showVehicleSchema;
			g_currentMission.ingameMap.isVisible = self.ingameMap;
			g_currentMission.showHudEnv = self.showHudEnv;
			g_currentMission.showWeatherForecast = self.showWeatherForecast;
			InputBinding.setShowMouseCursor(false);
			self.hudOn = false;
			g_gui.currentGui = nil;
		end;
		g_currentMission.showHelpText = false;
		g_currentMission.renderTime = false;
		g_currentMission.showVehicleSchema = false;
		g_currentMission.ingameMap.isVisible = false;
		g_currentMission.showHudEnv = false;
		g_currentMission.showWeatherForecast = false; 
		g_currentMission.isPlayerFrozen = true;
		InputBinding.setShowMouseCursor(true);
		g_gui.currentGui = self;
		self.hudOn = true;
	end;
end;

function FarmingTablet:tapclosed(closed) 
	g_currentMission.showHelpText = self.showHelpText;
	g_currentMission.isPlayerFrozen = self.isPlayerFrozen;
	g_currentMission.renderTime = self.renderTime;
	g_currentMission.showVehicleSchema = self.showVehicleSchema;
	g_currentMission.ingameMap.isVisible = self.ingameMap;
	g_currentMission.showHudEnv = self.showHudEnv;
	g_currentMission.showWeatherForecast = self.showWeatherForecast;
	InputBinding.setShowMouseCursor(false);
	self.hudOn = false;
	g_gui.currentGui = nil;
end;

function FarmingTablet:mouseEvent(posX, posY, isDown, isUp, button)
	if self.active then
		if FarmingTablet.kz.app1 then
			Bank:StartscreenAppBank(posX, posY, isDown, button);
		end;
		if FarmingTablet.kz.app2 then
			FabrikscriptExtension:StartscreenAppFabrikscriptExtension(posX, posY, isDown, button);
		end;
		if FarmingTablet.kz.app3 then
			SoilExtension:StartscreenApp(posX, posY, isDown, button);
		end;
		if FarmingTablet.kz.app4 then
			Calendar:StartscreenApp(posX, posY, isDown, button);
		end;
		
		if FarmingTablet.kz.app99 then
			Appstore:StartscreenApp(posX, posY, isDown, button);
		end;
		if FarmingTablet.kz.app100 then
			Settings:StartscreenApp(posX, posY, isDown, button);
		end;
		
		
		if self.hudOn then
			if self.posDebug then
				print(posX .." " .. posY);
			end;
		end;	
		
		--App-Klickzonen--
		
		if FarmingTablet.kz.app1 == false and FarmingTablet.kz.app3 == false and FarmingTablet.kz.app2 == false and FarmingTablet.kz.app100 == false and FarmingTablet.kz.app4 == false and FarmingTablet.kz.app99 == false then
			self.allAppsClose = true;
		else
			self.allAppsClose = false;
		end;
		
		if self.allAppsClose then
			if posX > 0.394 and posX < 0.463 and posY >0.558 and posY < 0.657 and isDown and button == 1 and g_currentMission.FarmingTablet.Appstore.apps[1] and dedi then
				--Bank
				FarmingTablet.kz.app1 = true;
			elseif posX > 0.475 and posX < 0.545 and posY >0.667 and posY < 0.767 and isDown and button == 1 and g_currentMission.FarmingTablet.Appstore.apps[2] then
				--FabrikscriptExtension
				FarmingTablet.kz.app2 = true;
			elseif posX > 0.25 and posX < 0.39 and posY >0.558 and posY < 0.657 and isDown and button == 1 and g_currentMission.FarmingTablet.Appstore.apps[3] then
				--SoilExtension
				FarmingTablet.kz.app3 = true;
			elseif posX > 0.32 and posX < 0.463 and posY >0.667 and posY < 0.767 and isDown and button == 1 and g_currentMission.FarmingTablet.Appstore.apps[4] then
				--Kalender
				FarmingTablet.kz.app4 = true;
			elseif posX > 0.095 and posX < 0.216 and posY >0.181 and posY < 0.205 and isDown and button == 1 then
				--Tablet schließen
				self:tapclosed(true);
			elseif posX > 0.25 and posX < 0.32 and posY >0.667 and posY < 0.767 and isDown and button == 1 and dedi then
				--Appstore
				FarmingTablet.kz.app99 = true;
			elseif posX > 0.095 and posX < 0.216 and posY >0.235 and posY < 0.256 and isDown and button == 1 then
				--Einstellungen
				FarmingTablet.kz.app100 = true;
			end;
		elseif posX > 0.488 and posX < 0.519 and posY >0.102 and posY < 0.141 and isDown and button == 1 then
			FarmingTablet.kz.app1 = false; 
			FarmingTablet.kz.app2 = false;
			FarmingTablet.kz.app3 = false; 
			FarmingTablet.kz.app4 = false;
			
			FarmingTablet.kz.app99 = false; 
			FarmingTablet.kz.app100 = false; 
		end;
	end;
end;

function FarmingTablet:keyEvent(unicode, sym, modifier, isDown)
	if self.active then
		if FarmingTablet.kz.app3 then
			SoilExtension:keyEventSoilExtension(unicode, sym, modifier, isDown);
		end;
		if FarmingTablet.kz.app4 then
			Calendar:keyEventCalendar(unicode, sym, modifier, isDown);
		end;
	end;
end;

function FarmingTablet:draw()
	if self.active then 
		if self.hudOn and self.akkuFull then
			setTextColor(0, 0, 0, 1);
			
		
			
			if g_currentMission.FarmingTablet.Settings.activeOverlay == 1 then
				renderOverlay(FarmingTablet.overlay.backScreenBlue, 0.01, 0.01, 1, 1.5);
			elseif g_currentMission.FarmingTablet.Settings.activeOverlay == 2 then
				renderOverlay(FarmingTablet.overlay.backScreenGreen, 0.01, 0.01, 1, 1.5);
			elseif g_currentMission.FarmingTablet.Settings.activeOverlay == 3 then
				renderOverlay(FarmingTablet.overlay.backScreenRed, 0.01, 0.01, 1, 1.5);
			elseif g_currentMission.FarmingTablet.Settings.activeOverlay == 4 then
				renderOverlay(FarmingTablet.overlay.backScreenGrayLight, 0.01, 0.01, 1, 1.5);
			elseif g_currentMission.FarmingTablet.Settings.activeOverlay == 5 then
				renderOverlay(FarmingTablet.overlay.backScreenGray, 0.01, 0.01, 1, 1.5);
			elseif g_currentMission.FarmingTablet.Settings.activeOverlay == 6 then
				renderOverlay(FarmingTablet.overlay.backScreenGrayDark, 0.01, 0.01, 1, 1.5);
			end;
			--!!! Kaufbar hier!!!--
			renderOverlay(FarmingTablet.overlay.Appscreen, 0.01, 0.01, 1, 1.5);
			if g_currentMission.FarmingTablet.Appstore.apps[1] then
				renderOverlay(FarmingTablet.overlay.AppBank, 0.395, 0.556, 0.07, 0.1);
			end;
			if g_currentMission.FarmingTablet.Appstore.apps[2] then
				renderOverlay(FarmingTablet.overlay.AppFabrikscriptExtension, 0.478, 0.666, 0.07, 0.1);
			end;
			if g_currentMission.FarmingTablet.Appstore.apps[3] then
				renderOverlay(FarmingTablet.overlay.AppSoil, 0.25, 0.556, 0.14, 0.1);
			end;
			if g_currentMission.FarmingTablet.Appstore.apps[4] then
				renderOverlay(FarmingTablet.overlay.AppKalender, 0.33, 0.667, 0.14, 0.1);
			end;
			if self.allAppsClose then
				setTextColor(1, 1, 1, 1);
				renderText(0.728, 0.833, 0.03, tostring(self.uhr1..":"..self.uhr2));
				if g_currentMission.FarmingTablet.Settings.akkuFuel < 162000 then
					renderOverlay(FarmingTablet.overlay.akkuRed, 0.8, 0.815, 0.05, 0.06);
					renderOverlay(FarmingTablet.overlay.akku1, 0.8, 0.815, 0.05, 0.06);
				elseif g_currentMission.FarmingTablet.Settings.akkuFuel >= 162000 and g_currentMission.FarmingTablet.Settings.akkuFuel < 324000 then
					renderOverlay(FarmingTablet.overlay.akku, 0.8, 0.815, 0.05, 0.06);
					renderOverlay(FarmingTablet.overlay.akku1, 0.8, 0.815, 0.05, 0.06);
					renderOverlay(FarmingTablet.overlay.akku2, 0.8, 0.815, 0.05, 0.06);	
				elseif g_currentMission.FarmingTablet.Settings.akkuFuel >= 324000 and g_currentMission.FarmingTablet.Settings.akkuFuel < 486000 then	
					renderOverlay(FarmingTablet.overlay.akku, 0.8, 0.815, 0.05, 0.06);
					renderOverlay(FarmingTablet.overlay.akku1, 0.8, 0.815, 0.05, 0.06);
					renderOverlay(FarmingTablet.overlay.akku2, 0.8, 0.815, 0.05, 0.06);	
					renderOverlay(FarmingTablet.overlay.akku3, 0.8, 0.815, 0.05, 0.06);	
				elseif g_currentMission.FarmingTablet.Settings.akkuFuel >= 324000 and g_currentMission.FarmingTablet.Settings.akkuFuel < 648000 then	
					renderOverlay(FarmingTablet.overlay.akku, 0.8, 0.815, 0.05, 0.06);
					renderOverlay(FarmingTablet.overlay.akku1, 0.8, 0.815, 0.05, 0.06);
					renderOverlay(FarmingTablet.overlay.akku2, 0.8, 0.815, 0.05, 0.06);	
					renderOverlay(FarmingTablet.overlay.akku3, 0.8, 0.815, 0.05, 0.06);	
					renderOverlay(FarmingTablet.overlay.akku4, 0.8, 0.815, 0.05, 0.06);
				end;
				renderText(0.86, 0.833, 0.03, tostring(string.format("%.f", g_currentMission.FarmingTablet.Settings.akkuFuel/6480))..tostring("%"));
				setTextColor(0, 0, 0, 1);
			end;
			
			
			if dedi == false and self.allAppsClose then
				setTextColor(1, 1, 1, 1);
				renderText(0.6, 0.18, 0.025, tostring("Eingeschränkter Modus!"));
				setTextColor(0, 0, 0, 1);
			end;
			if FarmingTablet.kz.app1 then
				Bank:drawBank();
			end;
			if FarmingTablet.kz.app2 then
				FabrikscriptExtension:drawFabrikscriptExtension ();
			end;
			if FarmingTablet.kz.app3 then
				SoilExtension:drawSoilExtension ();
			end;
			if FarmingTablet.kz.app4 then
				Calendar:drawCalendar ();
			end;
			if FarmingTablet.kz.app99 then
				Appstore:drawAppstore ();
			end;
			if FarmingTablet.kz.app100 then
				Settings:drawSettings ();
			end;
			
			renderOverlay(self.overlay.tablet, 0.01, 0.01, 1, 1.5);
		elseif self.hudOn and self.akkuFull == false then
			renderOverlay(FarmingTablet.overlay.backScreenBlack, 0.01, 0.01, 1, 1.5);
			renderOverlay(self.overlay.tablet, 0.01, 0.01, 1, 1.5);
			renderOverlay(FarmingTablet.overlay.akkuRed, 0.8, 0.815, 0.05, 0.06);
		end;
		
	end;
end;
function FarmingTablet:deleteMap()
	if self.hudOn then
		self.hudOn  = false;
		FarmingTablet.kz.app1 = false; 
		FarmingTablet.kz.app2 = false;
		FarmingTablet.kz.app3 = false; 
		FarmingTablet.kz.app4 = false; 
		
		FarmingTablet.kz.app99 = false;
		FarmingTablet.kz.app100 = false;
	end;

end;
 
function FarmingTablet:delete() end;

g_careerScreen.saveSavegame = Utils.appendedFunction(g_careerScreen.saveSavegame, FarmingTablet.saveMap);
 
 
 