--Name: FabrikscriptExtension
--Author: kevink98
--Date: 17.04.2016
--Version: 0.9

--Versionen: nothing
	
--Keine Änderung ohne meine Erlaubnis!
--No modification without my permission!

FabrikscriptExtension = {};
FabrikscriptExtension_directory = g_currentModDirectory;


print("FabrikscriptExtension v0.9.1 loaded! Support on Marhu.net");

function FabrikscriptExtension:appStore ()
	local appStore = {};
	appStore.version = 0.9;
	appStore.titel = "FabrikscriptExtension";
	appStore.author = "kevink98";
	appStore.icon = createImageOverlay(FarmingTablet_directory.."hudsAll/huds_Appstore/shop_FabrikscriptExtension.dds");
	appStore.price = 15000;
	appStore.description = {};
	appStore.description.z1 = "Auf der Map sind Gebäude mit dem Fabrikscript verbaut?";
	appStore.description.z2 = "Hier haben Sie Überblick über alle Gebäude!";
	appStore.description.z3 = "Zusätzlich kann ein Modul im Modordner beigelegt werden.";
	return appStore;
end;

function FabrikscriptExtension:loadFabrikscriptExtension()

	
	self.file = FarmingTablet_directoryMods.."zzz_FabrikscriptExtensionModul/FabrikscriptExtensionModul.lua"
	
	if fileExists(self.file) then
		source(FarmingTablet_directoryMods.."zzz_FabrikscriptExtensionModul/FabrikscriptExtensionModul.lua");
		FabrikscriptExtensionModul:loadXml(FarmingTablet_directoryMods);
		self.file = true;
	else
		print("FarmingTablet/FabrikscriptExtension: No Modul loaded");
		self.file = false;
	end;
		
	self.version = 0.91;
	j = -1;
	
	self.tap1header = g_i18n:getText("tap1header");
	self.tap2header = g_i18n:getText("tap2header");
	self.tap3header = g_i18n:getText("tap3header");
	self.info1 = g_i18n:getText("info1");	
	self.pos = 100;
	self.hudOn = false;
	self.tab2show = 25;
	--self.hud = {};
	
	self.builds = {};
	self.buildsName = {};
	self.tab1 = {};
	self.tab2 = {};
	self.tab3 = {};
	self.tab1Vis = true;
	self.tab2Vis = false;
	self.tab3Vis = false;
	self.tab1.pfeilL = false;
	self.tab1.pfeilR = false;
	self.tab1.siteKlick = 1;
	self.tab1.site1 = true;
	self.tab1.site2 = false;
	self.tab1.site3 = false;
	self.tab1.site4 = false;
	self.tab1.site5 = false;
	self.tab1.site6 = false;
	
	self.tab1.site1Vis = true;
	self.tab1.site2Vis = false;
	self.tab1.site3Vis = false;	
	self.tab1.site4Vis = false;
	self.tab1.site5Vis = false;
	self.tab1.site6Vis = false;	
	
	self.tab1.site = 1;
	--self.tab1.benutzt = false;
	
	self.tab1.kz = {};
	
--Tab2--
	self.tab2 = {};
	
	i=0;
	self.obAnz = -1;
	
	
	
	--Gebäude--
	self.mapper = false;
end;
function FabrikscriptExtension:loadl18n (nameln, pos, name)
	local Xml
	local tableName = {};
	local tableInfo = {};
	if self.file then
		if nameln == "Rohstoffe" and pos ~= nil and name == false then
			tableInfo = FabrikscriptExtensionModul:getTableInfo();
			if tableInfo[self.buildsName[pos]] ~= nil and tableInfo[self.buildsName[pos]].InputTitel ~= nil then
				Xml = tableInfo[self.buildsName[pos]].InputTitel["Rohstoffe"];
			end;
			if Xml == nil then
				Xml = "Rohstoffe";
			end;
			return Xml;
		elseif nameln == "Produkte" and pos ~= nil and name == false then
			tableInfo = FabrikscriptExtensionModul:getTableInfo();
			if tableInfo[self.buildsName[pos]] ~= nil and tableInfo[self.buildsName[pos]].outputTitel ~= nil then
				Xml = tableInfo[self.buildsName[pos]].outputTitel["Produkte"];
			end;
			if Xml == nil then
				Xml = "Produkte";
			end;
			return Xml;
		elseif nameln ~= nil and pos == nil and name == false then
			tableName = FabrikscriptExtensionModul:getNameTable();
			if tableName[nameln] ~= nil then 
				if tableName[nameln].anzeigenderName == nil then
					Xml = "Missing "..tostring(nameln).." in xml!";
				else
					Xml = tableName[nameln].anzeigenderName;
				end;
				return Xml;
			else
				Xml = nil;
			end;
		elseif nameln ~= nil and pos ~= nil and name == true then
			tableName = FabrikscriptExtensionModul:getNameTable();
			if tableName[nameln] ~= nil then
				if tableName[nameln].anzeigenderName == nil then
					Xml = "Missing "..tostring(nameln).." in xml!";
				else
					Xml = tableName[nameln].anzeigenderName;	
				end;
				return Xml;
			else
				Xml = nil;
			end;	
		elseif nameln ~= nil and pos ~= nil and name == false then
			tableInfo = FabrikscriptExtensionModul:getTableInfo();
			if tableInfo[self.buildsName[pos]] ~= nil then
				if tableInfo[self.buildsName[pos]].Input[nameln] ~= nil then
					Xml = tableInfo[self.buildsName[pos]].Input[nameln];
				elseif tableInfo[self.buildsName[pos]].output[nameln] ~= nil then
					Xml = tableInfo[self.buildsName[pos]].output[nameln];
				end;
				if Xml == nil then
					Xml = "Missing "..tostring(nameln).." in xml!";
				end;
				return Xml;
			else
				Xml = nil;
			end;
		end;
	else
		Xml = nil;
	end;
	if self.file == false and nameln == "Rohstoffe" then
		Xml = "Rohstoffe";
		return Xml;
	elseif self.file == false and nameln == "Produkte" then
		Xml = "Produkte";
		return Xml;
	elseif Xml == nil or self.file == false then
		Xml = g_i18n:getText(nameln);
		return Xml;
	end;
end;


function FabrikscriptExtension:updateFabrikscriptExtension (dt)
	self.obAnz = -1;
	if g_currentMission.onCreateLoadedObjects ~= nil then
		for k, onCreateObject in pairs(g_currentMission.onCreateLoadedObjects) do
			if onCreateObject.FabrikScriptDirtyFlag then
				j = j+1; 
				local name = getName(onCreateObject.nodeId);
				local lenght = #self.buildsName;
				self.buildsName[j] = name;
				self.builds[name] = onCreateObject;	
				self.obAnz = self.obAnz + 1;
				objectTabel = onCreateObject;
				
				objTableRoh = {};
				objTablePro = {};
				--objTableRohstoff = {};
				for k,v in pairs (onCreateObject.Rohstoffe) do
					table.insert(objTableRoh, k);
					local fillLevel = self.builds[name].Rohstoffe[k].fillLevel;
					local capacity = self.builds[name].Rohstoffe[k].capacity;
					local nameI = k;
					self.builds[name].Rohstoffe[nameI].fillLevel = fillLevel;
					self.builds[name].Rohstoffe[nameI].capacity = capacity;
				end;
				for k,v in pairs (onCreateObject.Produkte) do
					table.insert(objTablePro, k);
					local fillLevel = self.builds[name].Produkte[k].fillLevel;
					local capacity = self.builds[name].Produkte[k].capacity;
					local nameI = k;
					self.builds[name].Produkte[nameI].fillLevel = fillLevel;
					self.builds[name].Produkte[nameI].capacity = capacity;
				end;
				
				self.builds[name].RohName = {};
				self.builds[name].ProName = {};
				for i=1, #objTableRoh do
					table.insert(self.builds[name].RohName, objTableRoh[i]);
				end;
				for i=1, #objTablePro do
					table.insert(self.builds[name].ProName, objTablePro[i]);
				end;
				
				--Load Overlay
				self.pfad = FarmingTablet_directory..tostring("hudsFS/")..tostring(name)..tostring(".dds");
				self.pfad2 = FarmingTablet_directoryMods..tostring("zzz_FabrikscriptExtensionModul/huds/")..tostring(self.buildsName[j])..tostring(".dds");
				if fileExists(self.pfad2) then
					self.builds[name].overlay = createImageOverlay(self.pfad2);
				elseif fileExists(self.pfad) then
					self.builds[name].overlay = createImageOverlay(self.pfad);
				else 
					self.builds[name].overlay = self.leerOverlay;
				end;					
			end;
		end;
	end;
		
	j = -1;
	self.builds.lenght = self.obAnz+1;
	if self.obAnz+1 < 9 then
		self.tab1.site1 = true;
		self.tab1.site2 = false;
		self.tab1.site3 = false;
		self.tab1.site4 = false;
		self.tab1.site5 = false;
		self.tab1.site6 = false;
		self.tab1.site = 1;
	elseif self.obAnz+1 >= 9 and self.obAnz+1 < 17 then
		self.tab1.site = 2;
		self.tab1.site1 = true;
		self.tab1.site2 = true;
		self.tab1.site3 = false;
		self.tab1.site4 = false;
		self.tab1.site5 = false;
		self.tab1.site6 = false;
	elseif self.obAnz+1 >= 17 and self.obAnz+1 < 25 then
		self.tab1.site = 3;
		self.tab1.site1 = true;
		self.tab1.site2 = true;
		self.tab1.site3 = true;
		self.tab1.site4 = false;
		self.tab1.site5 = false;
		self.tab1.site6 = false;
	elseif self.obAnz+1 >= 25 and self.obAnz+1 < 33 then
		self.tab1.site = 4;
		self.tab1.site1 = true;
		self.tab1.site2 = true;
		self.tab1.site3 = true;
		self.tab1.site4 = true;
		self.tab1.site5 = false;
		self.tab1.site6 = false;
	elseif self.obAnz+1 >= 33 and self.obAnz+1 < 41 then
		self.tab1.site = 5;
		self.tab1.site1 = true;
		self.tab1.site2 = true;
		self.tab1.site3 = true;
		self.tab1.site4 = true;
		self.tab1.site5 = true;
		self.tab1.site6 = false;
	elseif self.obAnz+1 >= 41 and self.obAnz+1 < 49 then
		self.tab1.site = 6;
		self.tab1.site1 = true;
		self.tab1.site2 = true;
		self.tab1.site3 = true;
		self.tab1.site4 = true;
		self.tab1.site5 = true;
		self.tab1.site6 = true;	
	end;	
end;

function FabrikscriptExtension:keyEventFabrikscriptExtension(unicode, sym, modifier, isDown)end;
function FabrikscriptExtension:StartscreenAppFabrikscriptExtension(posX, posY, isDown, button)
	if posX > 0.08 and posX < 0.28 and posY < 0.86 and posY > 0.82 and isDown and button == 1 then
		self.tab1Vis = true;
		self.tab2Vis = false;
		self.tab3Vis = false;
	elseif posX > 0.29 and posX < 0.485 and posY < 0.86 and posY > 0.82 and isDown and button == 1 then
		self.tab1Vis = false;
		self.tab2Vis = true;
		self.tab3Vis = false;
	elseif posX < 0.69 and posX > 0.49 and posY < 0.86 and posY > 0.82 and isDown and button == 1 then
		self.tab1Vis = false;
		self.tab2Vis = false;
		self.tab3Vis = true;
	elseif	posX > 0.875 and posX < 0.902 and posY > 0.828 and posY < 0.864 and isDown and button == 1 then
		FarmingTablet.kz.app2 = false;
	end;
	if self.tab1Vis then
		if self.tab1.site1 and self.tab1.site2 and self.tab1.site3 == false then		
			if posX > 0.1 and posX < 0.16 and posY <0.23 and posY > 0.2 and isDown and button==1 then
				if self.tab1.site2Vis then
					self.tab1.site1Vis = true;
					self.tab1.site2Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				end;
			elseif posX > 0.5 and posX < 0.57 and posY > 0.2 and posY <0.23 and isDown and button == 1 then
				if self.tab1.site1Vis then
					self.tab1.site2Vis = true;
					self.tab1.site1Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				end;
			end;
		elseif self.tab1.site3 and self.tab1.site4 == false then		
			if posX > 0.1 and posX < 0.16 and posY <0.23 and posY > 0.2 and isDown and button==1 then
				if self.tab1.site2Vis then
					self.tab1.site1Vis = true;
					self.tab1.site2Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				elseif self.tab1.site3Vis then
					self.tab1.site2Vis = true;
					self.tab1.site3Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				end;
			elseif posX > 0.5 and posX < 0.57 and posY > 0.2 and posY <0.23 and isDown and button == 1 then
				if self.tab1.site1Vis then
					self.tab1.site2Vis = true;
					self.tab1.site1Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				elseif self.tab1.site2Vis then
					self.tab1.site3Vis = true;
					self.tab1.site2Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				end;
			end;
		elseif self.tab1.site4 and self.tab1.site5 == false then		
			if posX > 0.1 and posX < 0.16 and posY <0.23 and posY > 0.2 and isDown and button==1 then
				if self.tab1.site2Vis then
					self.tab1.site1Vis = true;
					self.tab1.site2Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				elseif self.tab1.site3Vis then
					self.tab1.site2Vis = true;
					self.tab1.site3Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				elseif self.tab1.site4Vis then
					self.tab1.site3Vis = true;
					self.tab1.site4Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				end;
			elseif posX > 0.5 and posX < 0.57 and posY > 0.2 and posY <0.23 and isDown and button == 1 then
				if self.tab1.site1Vis then
					self.tab1.site2Vis = true;
					self.tab1.site1Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				elseif self.tab1.site2Vis then
					self.tab1.site3Vis = true;
					self.tab1.site2Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				elseif self.tab1.site3Vis then
					self.tab1.site4Vis = true;
					self.tab1.site3Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				end;
			end;
		elseif self.tab1.site5 and self.tab1.site6 == false then		
			if posX > 0.1 and posX < 0.16 and posY <0.23 and posY > 0.2 and isDown and button==1 then
				if self.tab1.site2Vis then
					self.tab1.site1Vis = true;
					self.tab1.site2Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				elseif self.tab1.site3Vis then
					self.tab1.site2Vis = true;
					self.tab1.site3Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				elseif self.tab1.site4Vis then
					self.tab1.site3Vis = true;
					self.tab1.site4Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				elseif self.tab1.site5Vis then
					self.tab1.site4Vis = true;
					self.tab1.site5Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				end;
			elseif posX > 0.5 and posX < 0.57 and posY > 0.2 and posY <0.23 and isDown and button == 1 then
				if self.tab1.site1Vis then
					self.tab1.site2Vis = true;
					self.tab1.site1Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				elseif self.tab1.site2Vis then
					self.tab1.site3Vis = true;
					self.tab1.site2Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				elseif self.tab1.site3Vis then
					self.tab1.site4Vis = true;
					self.tab1.site3Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				elseif self.tab1.site4Vis then
					self.tab1.site5Vis = true;
					self.tab1.site4Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				end;
			end;
		elseif self.tab1.site6 then		
			if posX > 0.1 and posX < 0.16 and posY <0.23 and posY > 0.2 and isDown and button==1 then
				if self.tab1.site2Vis then
					self.tab1.site1Vis = true;
					self.tab1.site2Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				elseif self.tab1.site3Vis then
					self.tab1.site2Vis = true;
					self.tab1.site3Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				elseif self.tab1.site4Vis then
					self.tab1.site3Vis = true;
					self.tab1.site4Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				elseif self.tab1.site5Vis then
					self.tab1.site4Vis = true;
					self.tab1.site5Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				elseif self.tab1.site6Vis then
					self.tab1.site5Vis = true;
					self.tab1.site6Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick -1;
				end;
			elseif posX > 0.5 and posX < 0.57 and posY > 0.2 and posY <0.23 and isDown and button == 1 then
				if self.tab1.site1Vis then
					self.tab1.site2Vis = true;
					self.tab1.site1Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				elseif self.tab1.site2Vis then
					self.tab1.site3Vis = true;
					self.tab1.site2Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				elseif self.tab1.site3Vis then
					self.tab1.site4Vis = true;
					self.tab1.site3Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				elseif self.tab1.site4Vis then
					self.tab1.site5Vis = true;
					self.tab1.site4Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				elseif self.tab1.site5Vis then
					self.tab1.site6Vis = true;
					self.tab1.site5Vis = false;
					self.tab1.siteKlick = self.tab1.siteKlick +1;
				end;
			end;
		end;
		
		if posX > 0.13 and posX < 0.45 and posY > 0.7 and posY < 0.73 and self.obAnz+1 >= (1*self.tab1.siteKlick) and isDown and button == 1 then
			self.tab1.kz[1] = true;
		else
			self.tab1.kz[1] = false;
		end;	
		--2.Zone--
		if posX > 0.13 and posX < 0.45 and posY > 0.65 and posY < 0.68 and self.obAnz+1 >= (2*self.tab1.siteKlick) and isDown and button == 1 then
			self.tab1.kz[2] = true;
		else
			self.tab1.kz[2] = false;
		end;
		--3.Zone--
		if posX > 0.13 and posX < 0.45 and posY > 0.6 and posY < 0.63 and self.obAnz+1 >= (3*self.tab1.siteKlick) and isDown and button == 1 then
			self.tab1.kz[3] = true;
		else
			self.tab1.kz[3] = false;
		end;
		--4.Zone--
		if posX > 0.13 and posX < 0.45 and posY > 0.55 and posY < 0.58 and self.obAnz+1 >= (4*self.tab1.siteKlick) and isDown and button == 1 then
			self.tab1.kz[4] = true;
		else
			self.tab1.kz[4] = false;
		end;
		--5.Zone--
		if posX > 0.13 and posX < 0.45 and posY > 0.5 and posY < 0.53 and self.obAnz+1 >= (5*self.tab1.siteKlick) and isDown and button == 1 then
			self.tab1.kz[5] = true;
		else
			self.tab1.kz[5] = false;
		end;
		--6.Zone--
		if posX > 0.13 and posX < 0.45 and posY > 0.44 and posY < 0.48 and self.obAnz+1 >= (6*self.tab1.siteKlick) and isDown and button == 1 then
			self.tab1.kz[6] = true;
		else
			self.tab1.kz[6] = false;
		end;
		--7.Zone--
		if posX > 0.13 and posX < 0.45 and posY > 0.4 and posY < 0.43 and self.obAnz+1 >= (7*self.tab1.siteKlick) and isDown and button == 1 then
			self.tab1.kz[7] = true;
		else
			self.tab1.kz[7] = false;
		end;
		--8.Zone--
		if posX > 0.13 and posX < 0.45 and posY > 0.34 and posY < 0.38 and self.obAnz+1 >= (8*self.tab1.siteKlick) and isDown and button == 1 then
			self.tab1.kz[8] = true;
		else
			self.tab1.kz[8] = false;
		end;
		self.obAnz = -1;
		for i=1, 8 do
			if self.tab1.kz[i] and self.tab1.site1Vis  then
				self.tab2Vis = true;
				self.tab1Vis = false;
				self.pos = i-1;
				break;
			elseif self.tab1.kz[i] and self.tab1.site2Vis  then
				self.tab2Vis = true;
				self.tab1Vis = false;
				self.pos = i+7;
				break;
			elseif self.tab1.kz[i] and self.tab1.site3Vis  then
				self.tab2Vis = true;
				self.tab1Vis = false;
				self.pos = i+15;
				break;
			elseif self.tab1.kz[i] and self.tab1.site4Vis  then
				self.tab2Vis = true;
				self.tab1Vis = false;
				self.pos = i+23;
				break;
			elseif self.tab1.kz[i] and self.tab1.site5Vis  then
				self.tab2Vis = true;
				self.tab1Vis = false;
				self.pos = i+31;
				break;
			elseif self.tab1.kz[i] and self.tab1.site6Vis  then
				self.tab2Vis = true;
				self.tab1Vis = false;
				self.pos = i+39;
				break;
			end;
		end;
	end;
	if self.tab3Vis then
		if posX > 0.7 and posX < 0.849 and posY > 0.53 and posY < 0.78 and isDown and button == 1 then
			self:getln();
		end;
	end;
end;

function FabrikscriptExtension:getln ()
	if self.mapper == false then
		print("----------------------Mapper Modus aus dem FarmingTablet | App: FabrikscriptExtension----------------------");
		print("Die benötigten Einträge für diese Map (kann kopiert werden!):");
		print("");
		for i=0, #self.buildsName do
			local name = self.buildsName[i];
			local tab = self.builds[name];
			local input = "";
			local output = "";
			
			for k,v in pairs (tab.Rohstoffe) do
				input = input..tostring(k).." ";
			end;
			for k,v in pairs (tab.Produkte) do
				output = output..tostring(k).." ";
			end;
			
			input = string.sub(input, 1, string.len(input)-1);
			output = string.sub(output, 1, string.len(output)-1);
			print("<build name=\""..name.."\" anzeigenderName=\"bitte eintragen!\" input=\""..input.."\" anzeigenderInput=\"bitte eintragen!\" anzeigenderInputTitel=\"bitte eintragen! (default: Rohstoffe)\" output=\""..output.."\" anzeigenderOutput=\"bitte eintragen!\" anzeigenderOutputTitel=\"bitte eintragen! (default: Produkte)\" />");
		end;
		print("");
		print("-----------------------------------------------------------------------------------------------------------");
		self.mapper = true;
	else
		print("Der Mapper Modus wurde schon ausgeführt!");
	end;
end;

function FabrikscriptExtension:drawFabrikscriptExtension()
	
	setTextColor(0, 0, 0, 1);
	--Überschriften--
	renderText(0.1, 0.83, 0.03, self.tap1header);
	renderText(0.3, 0.83, 0.03, self.tap2header);
	renderText(0.5, 0.83, 0.03, self.tap3header);
	
	if self.tab1Vis then
	renderOverlay(FarmingTablet.overlay.tab1O, 0.01, 0.01, 1, 1.5);
	renderOverlay(FarmingTablet.overlay.abbrechen, 0.868, 0.823, 0.04, 0.05);
		--Übersicht Gebäude--
		if self.tab1.site1Vis and self.tab1.site2 then
			renderOverlay(FarmingTablet.overlay.pfeilRO, 0.52, 0.18, 0.05, 0.05);
		elseif self.tab1.site2Vis and self.tab1.site3 then
			renderOverlay(FarmingTablet.overlay.pfeilLO, 0.1, 0.18, 0.05, 0.05);
			renderOverlay(FarmingTablet.overlay.pfeilRO, 0.52, 0.18, 0.05, 0.05);
		elseif self.tab1.site2Vis and self.tab1.site3 == false then
			renderOverlay(FarmingTablet.overlay.pfeilLO, 0.1, 0.18, 0.05, 0.05);
		elseif self.tab1.site3Vis and self.tab1.site4 then
			renderOverlay(FarmingTablet.overlay.pfeilLO, 0.1, 0.18, 0.05, 0.05);
			renderOverlay(FarmingTablet.overlay.pfeilRO, 0.52, 0.18, 0.05, 0.05);
		elseif self.tab1.site3Vis and self.tab1.site4 == false then
			renderOverlay(FarmingTablet.overlay.pfeilLO, 0.1, 0.18, 0.05, 0.05);
		elseif self.tab1.site4Vis and self.tab1.site5 then
			renderOverlay(FarmingTablet.overlay.pfeilLO, 0.1, 0.18, 0.05, 0.05);
			renderOverlay(FarmingTablet.overlay.pfeilRO, 0.52, 0.18, 0.05, 0.05);
		elseif self.tab1.site4Vis and self.tab1.site5 == false then
			renderOverlay(FarmingTablet.overlay.pfeilLO, 0.1, 0.18, 0.05, 0.05);
		elseif self.tab1.site5Vis and self.tab1.site6 then
			renderOverlay(FarmingTablet.overlay.pfeilLO, 0.1, 0.18, 0.05, 0.05);
			renderOverlay(FarmingTablet.overlay.pfeilRO, 0.52, 0.18, 0.05, 0.05);
		elseif self.tab1.site5Vis and self.tab1.site6 == false then
			renderOverlay(FarmingTablet.overlay.pfeilLO, 0.1, 0.18, 0.05, 0.05);	
		elseif self.tab1.site6Vis then
			renderOverlay(FarmingTablet.overlay.pfeilLO, 0.1, 0.18, 0.05, 0.05);
		end;
		--sites
		local leng = self.builds.lenght;
		if self.tab1.site1Vis then
			if leng > 8 then
				leng = 7;
			else
				leng = self.builds.lenght-1;
			end;
			for i=0, leng do
					self.obji18 = self:loadl18n(tostring(self.buildsName[i]), nil, false);
					renderText(0.13, (0.7-i*0.05), 0.035, self.obji18);
			end;
		end;
		if self.tab1.site2Vis then	
			if leng > 16 then
				leng = 15;
			else
				leng = self.builds.lenght-1;
			end;
			for i=8, leng do
					self.obji18 = self:loadl18n(tostring(self.buildsName[i]), nil, false);
					renderText(0.13, (0.7-(i-8)*0.05), 0.035, self.obji18);
			end;
		end;
		if self.tab1.site3Vis then	
			if leng > 24 then
				leng = 23;
			else
				leng = self.builds.lenght-1;
			end;
			for i=16, leng do
					self.obji18 = self:loadl18n(tostring(self.buildsName[i]), nil, false);
					setTextColor(0, 0, 0, 1);
					renderText(0.13, (0.7-(i-16)*0.05), 0.035, self.obji18);
			end;
		end;
		if self.tab1.site4Vis then	
			if leng > 32 then
				leng = 31;
			else
				leng = self.builds.lenght-1;
			end;
			for i=24, leng do
					self.obji18 = self:loadl18n(tostring(self.buildsName[i]), nil, false);
					setTextColor(0, 0, 0, 1);
					renderText(0.13, (0.7-(i-24)*0.05), 0.035, self.obji18);
			end;
		end;
		if self.tab1.site5Vis then		
			if leng > 40 then
				leng = 39;
			else
				leng = self.builds.lenght-1;
			end;
			for i=32, leng do
					self.obji18 = self:loadl18n(tostring(self.buildsName[i]), nil, false);
					setTextColor(0, 0, 0, 1);
					renderText(0.13, (0.7-(i-32)*0.05), 0.035, self.obji18);
			end;
		end;
		if self.tab1.site6Vis then			
			for i=40, leng-1 do
					self.obji18 = self:loadl18n(tostring(self.buildsName[i]), nil, false);
					setTextColor(0, 0, 0, 1);
					renderText(0.13, (0.7-(i-40)*0.05), 0.035, self.obji18);
			end;
		end;
	end;
	
	if self.tab2Vis then
		self.indexName = "";
		renderOverlay(FarmingTablet.overlay.tab2O, 0.01, 0.01, 1, 1.5);
		renderOverlay(FarmingTablet.overlay.abbrechen, 0.868, 0.823, 0.04, 0.05);
		if self.pos == 100 then
			self.pos = 0;
			renderText(0.16, 0.74, 0.04, self:loadl18n(tostring(self.buildsName[self.pos])), self.pos, true);
			self:DrawInOut(0);
		else 
			self.index = self.pos;
			renderText(0.16, 0.74, 0.04, self:loadl18n(tostring(self.buildsName[self.index]), self.pos, true));
			if self.builds[self.buildsName[self.index]].overlay ~= nil then
				renderOverlay(self.builds[self.buildsName[self.index]].overlay, 0.55, 0.3, 0.3, 0.5);
			end;
			self:DrawInOut(self.index);
		end;		
	end;
	
	
	if self.tab3Vis then
		renderOverlay(FarmingTablet.overlay.tab3O, 0.01, 0.01, 1, 1.5);
		renderOverlay(FarmingTablet.overlay.abbrechen, 0.868, 0.823, 0.04, 0.05);
		setTextColor(0,0,0,1);
		renderText(0.1, 0.17, 0.02,(tostring("Version: ") .. self.version));
		renderText(0.2, 0.17, 0.02, (tostring("Author and Scripter: kevink98")));
		renderText(0.1, 0.2, 0.02, self.info1);
		renderOverlay(FarmingTablet.overlay.mapperInfo, 0.7, 0.53, 0.15, 0.25);
		renderText(0.708, 0.736, 0.02,(tostring("Diese Funktion ist für")));
		renderText(0.708, 0.7, 0.02,(tostring("Mapper. Damit werden in")));
		renderText(0.708, 0.664, 0.02,(tostring("der Log alle benötigten")));
		renderText(0.708, 0.628, 0.02,(tostring("Einträge")));
		renderText(0.708, 0.592, 0.02,(tostring("ausgegeben.")));
		
		renderText(0.1, 0.78, 0.02,(tostring("Folgende Gebäude werden ohne externes Modul unterstützt:")));
		renderText(0.1, 0.78, 0.02,(tostring("Folgende Gebäude werden ohne externes Modul unterstützt:")));
		
		for i=0, 9 do
			renderText(0.1, (0.72-(i*0.0366)), 0.02, tostring(g_i18n:getText("support"..i)));
		end;
		for i=10, 16 do
			renderText(0.4, (0.72-((i-10)*0.0366)), 0.02, tostring(g_i18n:getText("support"..i)));
		end;
	end;
	
end;

function FabrikscriptExtension:DrawInOut (index)
	renderText(0.1, 0.7, 0.03, self:loadl18n(tostring("Rohstoffe"), index, false));
	renderText(0.1, 0.42, 0.03, self:loadl18n(tostring("Produkte"), index, false));		
		
	for i=1, #self.builds[self.buildsName[index]].RohName do
		renderText(0.104, 0.670-(i-1)*0.04, 0.025, self:loadl18n(tostring(self.builds[self.buildsName[index]].RohName[i]), index, false));
		renderText(0.285, 0.670-(i-1)*0.04, 0.025, tostring(string.format("%.f", self.builds[self.buildsName[index]].Rohstoffe[self.builds[self.buildsName[index]].RohName[i]].fillLevel)));	
		renderText(0.338, 0.670-(i-1)*0.04, 0.025, tostring("/ ")..tostring(self.builds[self.buildsName[index]].Rohstoffe[self.builds[self.buildsName[index]].RohName[i]].capacity));	
	end;
	for i=1, #self.builds[self.buildsName[index]].ProName do
		renderText(0.104, 0.390-(i-1)*0.04, 0.025, self:loadl18n(tostring(self.builds[self.buildsName[index]].ProName[i]), index, false));
		renderText(0.285, 0.390-(i-1)*0.04, 0.025, tostring(string.format("%.f", self.builds[self.buildsName[index]].Produkte[self.builds[self.buildsName[index]].ProName[i]].fillLevel)));	
		renderText(0.338, 0.390-(i-1)*0.04, 0.025, tostring("/ ")..tostring(self.builds[self.buildsName[index]].Produkte[self.builds[self.buildsName[index]].ProName[i]].capacity));
	end;
	
end;
 
function FabrikscriptExtension:deleteFabrikscriptExtension()end;
 
 
 
 
 