--Name: Calendar
--Author: kevink98
--Date: 13.07.2016
--Version: 1.0

--Versionen: 
--		1.0 @ .. : Release

	
--Keine Änderung ohne meine Erlaubnis!
--No modification without my permission!

Calendar = {};
Calendar_directory = g_currentModDirectory;

print("Kalender v1.0 loaded! Support on Marhu.net");
function Calendar:appStore ()
	local appStore = {};
		appStore.version = 1.0;
		appStore.titel = "Kalender";
		appStore.author = "kevink98";
		appStore.icon = createImageOverlay(FarmingTablet_directory.."hudsAll/huds_Appstore/shop_Kalender.dds");
		appStore.price = 2500;
		appStore.description = {};
		appStore.description.z1 = "Sie wollen ein Überblick, was Sie heute noch erledigen müssen?";
		appStore.description.z2 = "Termine von der Soilapp werden automatisch erstellt. Sie können aber natürlich auch "
		appStore.description.z3 = "welche selbst anlegen! Durch diese Planung kann im MP effizienter gearbeitet werden."
	return appStore;
end;
function Calendar:loadXml(xml)
	local num = getXMLInt(xml, "FarmingTablet.Calendar.heute".."#num");
	local num2 = getXMLInt(xml, "FarmingTablet.Calendar.morgen".."#num2");
	local num3 = getXMLInt(xml, "FarmingTablet.Calendar.umorgen".."#num3");
	if num == nil then
		num = 0;
		num2 = 0;
		num3 = 0;
	end;
	g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay] = {};
	for i = 1, num do
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][i] = {};
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][i].titel = getXMLString(xml, "FarmingTablet.Calendar.".."heute"..".eintrag"..tostring(i).."#titel");
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][i].subtitel = getXMLString(xml, "FarmingTablet.Calendar.".."heute"..".eintrag"..tostring(i).."#subtitel");
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][i].text = {};
		for j = 1, 10 do
			g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][i].text[j] = getXMLString(xml, "FarmingTablet.Calendar.".."heute"..".eintrag"..tostring(i)..".text.zeile"..tostring(j));
		end;
	end;
	g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1] = {};
	for i = 1, num2 do
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][i] = {};
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][i].titel = getXMLString(xml, "FarmingTablet.Calendar.".."morgen"..".eintrag"..tostring(i).."#titel");
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][i].subtitel = getXMLString(xml, "FarmingTablet.Calendar.".."morgen"..".eintrag"..tostring(i).."#subtitel");
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][i].text = {};
		for j = 1, 10 do
			g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][i].text[j] = getXMLString(xml, "FarmingTablet.Calendar.morgen"..".eintrag"..tostring(i)..".text.zeile"..tostring(j));
		end;
	end;
	g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2] = {};
	for i = 1, num3 do
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][i] = {};
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][i].titel = getXMLString(xml, "FarmingTablet.Calendar.".."umorgen"..".eintrag"..tostring(i).."#titel");
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][i].subtitel = getXMLString(xml, "FarmingTablet.Calendar.".."umorgen"..".eintrag"..tostring(i).."#subtitel");
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][i].text = {};
		for j = 1, 10 do
			g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][i].text[j] = getXMLString(xml, "FarmingTablet.Calendar.umorgen"..".eintrag"..tostring(i)..".text.zeile"..tostring(j));
		end;
	end;
	
end;

function Calendar:saveXml(xml)
	setXMLInt(xml, "FarmingTablet.Calendar.heute".."#num", table.getn(g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay]));
	setXMLInt(xml, "FarmingTablet.Calendar.morgen".."#num2", table.getn(g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1]));
	setXMLInt(xml, "FarmingTablet.Calendar.umorgen".."#num3", table.getn(g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2]));
	for i = 1, table.getn(g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay]) do
		setXMLString(xml, "FarmingTablet.Calendar.heute"..".eintrag"..tostring(i).."#titel", g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][i].titel);
		setXMLString(xml, "FarmingTablet.Calendar.heute"..".eintrag"..tostring(i).."#subtitel", g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][i].subtitel);
		for j = 1, 10 do
			setXMLString(xml, "FarmingTablet.Calendar.".."heute"..".eintrag"..tostring(i)..".text.zeile"..tostring(j), g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][i].text[j]);
		end;
	end;
	for i = 1, table.getn(g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1]) do
		setXMLString(xml, "FarmingTablet.Calendar.morgen"..".eintrag"..tostring(i).."#titel", g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][i].titel);
		setXMLString(xml, "FarmingTablet.Calendar.morgen"..".eintrag"..tostring(i).."#subtitel", g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][i].subtitel);
		for j = 1, 10 do
			setXMLString(xml, "FarmingTablet.Calendar.morgen"..".eintrag"..tostring(i)..".text.zeile"..tostring(j), g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][i].text[j]);
		end;
	end;
	for i = 1, table.getn(g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2]) do
		setXMLString(xml, "FarmingTablet.Calendar.umorgen"..".eintrag"..tostring(i).."#titel", g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][i].titel);
		setXMLString(xml, "FarmingTablet.Calendar.umorgen"..".eintrag"..tostring(i).."#subtitel", g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][i].subtitel);
		for j = 1, 10 do
			setXMLString(xml, "FarmingTablet.Calendar.umorgen"..".eintrag"..tostring(i)..".text.zeile"..tostring(j), g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][i].text[j]);
		end;
	end;
end;

function Calendar:loadCalendar ()

	Calendar.days = {};
	Calendar.days[0] = "Sonntag";
	Calendar.days[1] = "Montag";
	Calendar.days[2] = "Dienstag";
	Calendar.days[3] = "Mittwoch";
	Calendar.days[4] = "Donnerstag";
	Calendar.days[5] = "Freitag";
	Calendar.days[6] = "Samstag";
	
	
	Calendar.heute = {};
	Calendar.morgen = {};
	Calendar.ubermorgen = {};
	Calendar.termineShow = true;
	Calendar.termineInhalt = false;
	Calendar.activeTermin = 0;
	Calendar.activeTerminHeute = false;
	Calendar.activeTerminMorgen = false;
	Calendar.activeTerminUmorgen = false;
	buttons = {};
	buttons.up1 = false;
	buttons.add1 = false;
	buttons.down1 = false;
	buttons.up2 = false;
	buttons.add2 = false;
	buttons.down2 = false;
	buttons.up3 = false;
	buttons.add3 = false;
	buttons.down3 = false;
	buttons.close = false;
	buttons.retur = false;
	buttons.titel = true;
	buttons.inhalt = false;
	buttons.windowScreen = false;
	buttons.window1 = false;
	buttons.window2 = false;
	buttons.window3 = false;
	self.titel = "";
	self.inhalt = {};
	for i=1, 10 do
		self.inhalt[i] = {};
		self.inhalt[i].active = false;
		self.inhalt[i].text = "";
	end;
	self.inhalt[1].active = true;
	
	Termine = {};
	Termine.heute = {};
	Termine.morgen = {};
	Termine.umorgen = {};
	
	self.startHeute = 1;
	self.startMorgen = 1;
	self.startUMorgen = 1;
	
end;

function Calendar:StartscreenApp (posX, posY, isDown, button)
	if Calendar.termineShow and Calendar.termineInhalt == false then
		if posX > 0.09 and posX < 0.18 and posY > 0.251 and posY < 0.3 then
			buttons.up1 = true;
			buttons.add1 = false;
			buttons.down1 = false;
			buttons.up2 = false;
			buttons.add2 = false;
			buttons.down2 = false;
			buttons.up3 = false;
			buttons.add3 = false;
			buttons.down3 = false;
		elseif posX > 0.183 and posX < 0.263 and posY > 0.251 and posY < 0.3 then
			buttons.up1 = false;
			buttons.add1 = true;
			buttons.down1 = false;
			buttons.up2 = false;
			buttons.add2 = false;
			buttons.down2 = false;
			buttons.up3 = false;
			buttons.add3 = false;
			buttons.down3 = false;
		elseif posX > 0.264 and posX < 0.356 and posY > 0.251 and posY < 0.3 then
			buttons.up1 = false;
			buttons.add1 = false;
			buttons.down1 = true;
			buttons.up2 = false;
			buttons.add2 = false;
			buttons.down2 = false;
			buttons.up3 = false;
			buttons.add3 = false;
			buttons.down3 = false;
		elseif posX > 0.371 and posX < 0.461 and posY > 0.251 and posY < 0.3 then
			buttons.up1 = false;
			buttons.add1 = false;
			buttons.down1 = false;
			buttons.up2 = true;
			buttons.add2 = false;
			buttons.down2 = false;
			buttons.up3 = false;
			buttons.add3 = false;
			buttons.down3 = false;	
		elseif posX > 0.464 and posX < 0.544 and posY > 0.251 and posY < 0.3 then
			buttons.up1 = false;
			buttons.add1 = false;
			buttons.down1 = false;	
			buttons.up2 = false;
			buttons.add2 = true;
			buttons.down2 = false;
			buttons.up3 = false;
			buttons.add3 = false;
			buttons.down3 = false;
		elseif posX > 0.548 and posX < 0.637 and posY > 0.251 and posY < 0.3 then
			buttons.up1 = false;
			buttons.add1 = false;
			buttons.down1 = false;
			buttons.up2 = false;
			buttons.add2 = false;
			buttons.down2 = true;
			buttons.up3 = false;
			buttons.add3 = false;
			buttons.down3 = false;		
		elseif posX > 0.648 and posX < 0.738 and posY > 0.251 and posY < 0.3 then
			buttons.up1 = false;
			buttons.add1 = false;
			buttons.down1 = false;	
			buttons.up2 = false;
			buttons.add2 = false;
			buttons.down2 = false;
			buttons.up3 = true;
			buttons.add3 = false;
			buttons.down3 = false;
		elseif posX > 0.741 and posX < 0.821 and posY > 0.251 and posY < 0.3 then
			buttons.up1 = false;
			buttons.add1 = false;
			buttons.down1 = false;	
			buttons.up2 = false;
			buttons.add2 = false;
			buttons.down2 = false;
			buttons.up3 = false;
			buttons.add3 = true;
			buttons.down3 = false;
		elseif posX > 0.825 and posX < 0.915 and posY > 0.251 and posY < 0.3 then
			buttons.up1 = false;
			buttons.add1 = false;
			buttons.down1 = false;	
			buttons.up2 = false;
			buttons.add2 = false;
			buttons.down2 = false;
			buttons.up3 = false;
			buttons.add3 = false;
			buttons.down3 = true;
		else
			buttons.up1 = false;
			buttons.add1 = false;
			buttons.down1 = false;
			buttons.up2 = false;
			buttons.add2 = false;
			buttons.down2 = false;
			buttons.up3 = false;
			buttons.add3 = false;
			buttons.down3 = false;
		end;
		if posX > 0.183 and posX < 0.263 and posY > 0.251 and posY < 0.3 and isDown and button==1 then
			Calendar.termineShow = false;
			buttons.window1 = true;
		elseif posX > 0.464 and posX < 0.544 and posY > 0.251 and posY < 0.3 and isDown and button==1 then
			Calendar.termineShow = false;
			buttons.window2 = true;
		elseif posX > 0.741 and posX < 0.821 and posY > 0.251 and posY < 0.3 and isDown and button==1 then
			Calendar.termineShow = false;
			buttons.window3 = true;
		elseif posX > 0.09 and posX < 0.18 and posY > 0.251 and posY < 0.3 and isDown and button==1 then
			self.startHeute = self.startHeute - 1;
			if self.startHeute < 1 then
				self.startHeute = 1;
			end;
		elseif posX > 0.264 and posX < 0.356 and posY > 0.251 and posY < 0.3 and isDown and button==1 then
			self.startHeute = self.startHeute + 1;
			if self.startHeute > table.getn(Termine.heute) then
				self.startHeute = self.startHeute - 1;
			end;
		elseif posX > 0.371 and posX < 0.461 and posY > 0.251 and posY < 0.3 and isDown and button==1 then
			self.startMorgen = self.startMorgen - 1;
			if self.startMorgen < 1 then
				self.startMorgen = 1;
			end;
		elseif posX > 0.548 and posX < 0.637 and posY > 0.251 and posY < 0.3 and isDown and button==1 then
			self.startMorgen = self.startMorgen + 1;
			if self.startMorgen > table.getn(Termine.morgen) then
				self.startMorgen = self.startMorgen - 1;
			end;
		elseif posX > 0.648 and posX < 0.738 and posY > 0.251 and posY < 0.3 and isDown and button==1 then
			self.startUMorgen = self.startUMorgen - 1;
			if self.startUMorgen < 1 then
				self.startUMorgen = 1;
			end;
		elseif posX > 0.825 and posX < 0.915 and posY > 0.251 and posY < 0.3 and isDown and button==1 then
			self.startUMorgen = self.startUMorgen + 1;
			if self.startUMorgen > table.getn(Termine.umorgen) then
				self.startUMorgen = self.startUMorgen - 1;
			end;
		end;
		
		local lengH = table.getn(Termine.heute);
		local lengM = table.getn(Termine.morgen);
		local lengUM = table.getn(Termine.umorgen);
		o = 0;
		for i = self.startHeute, lengH do
			if posX > 0.095 and posX < 0.2 and posY > (0.71-o*0.05) and posY < (0.76-(o-1)*0.05) and isDown and button==1 and Termine.heute[i].text ~= nil then
				Calendar.termineShow = false;
				Calendar.termineInhalt = true;
				Calendar.activeTermin = i;
				Calendar.activeTerminHeute = true;
				Calendar.activeTerminMorgen = false;
				Calendar.activeTerminUmorgen = false;
			end;
			o = o + 1;
		end;
		o = 0;
		for i = self.startMorgen, lengM do
			if posX > 0.373 and posX < 0.58 and posY > (0.71-o*0.05) and posY < (0.76-(o-1)*0.05) and isDown and button==1 and Termine.morgen[i].text ~= nil then
				Calendar.termineShow = false;
				Calendar.termineInhalt = true;
				Calendar.activeTermin = i;
				Calendar.activeTerminHeute = false;
				Calendar.activeTerminMorgen = true;
				Calendar.activeTerminUmorgen = false;
			end;
			o = o + 1;
		end;
		
		o = 0;
		for i = self.startUMorgen, lengUM do
			if posX > 0.651 and posX < 0.79 and posY > (0.71-o*0.05) and posY < (0.76-(o-1)*0.05) and isDown and button==1 and Termine.umorgen[i].text ~= nil then
				Calendar.termineShow = false;
				Calendar.termineInhalt = true;
				Calendar.activeTermin = i;
				Calendar.activeTerminHeute = false;
				Calendar.activeTerminMorgen = false;
				Calendar.activeTerminUmorgen = true;
			end;
			o = o + 1;
		end;
		
		
		
	elseif Calendar.termineShow == false and Calendar.termineInhalt == false then
		if posX > 0.106 and posX < 0.256 and posY > 0.25 and posY < 0.29 then
			buttons.close = true;
			buttons.retur = false;
		elseif posX > 0.266 and posX < 0.416 and posY > 0.25 and posY < 0.29 then
			buttons.close = false;
			buttons.retur = true;
		else
			buttons.close = false;
			buttons.retur = false;
		end;
		if posX > 0.107 and posX < 0.893 and posY > 0.699 and posY < 0.751 and isDown and button==1 then
			buttons.titel = true;
			buttons.inhalt = false
		elseif posX > 0.107 and posX < 0.893 and posY > 0.303 and posY < 0.641 and isDown and button==1 then
			buttons.inhalt = true
			buttons.titel = false;
		end;
		if posX > 0.106 and posX < 0.256 and posY > 0.25 and posY < 0.29 and isDown and button==1 then
			if buttons.window1 then
				local numTermine = table.getn(g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay]);
				g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][numTermine+1] = {};
				g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][numTermine+1].titel = "Termin";
				g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][numTermine+1].subtitel = self.titel;
				g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][numTermine+1].text = {};
				for i=1, 10 do
					g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][numTermine+1].text[i] = self.inhalt[i].text;
				end;
			elseif buttons.window2 then
				local numTermine = table.getn(g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1]);
				g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][numTermine+1] = {};
				g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][numTermine+1].titel = "Termin";
				g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][numTermine+1].subtitel = self.titel;
				g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][numTermine+1].text = {};
				for i=1, 10 do
					g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][numTermine+1].text[i] = self.inhalt[i].text;
				end;
			elseif buttons.window3 then
				local numTermine = table.getn(g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2]);
				g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][numTermine+1] = {};
				g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][numTermine+1].titel = "Termin";
				g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][numTermine+1].subtitel = self.titel;
				g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][numTermine+1].text = {};
				for i=1, 10 do
					g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][numTermine+1].text[i] = self.inhalt[i].text;
				end;
			end;
			self.titel = "";
			for i=1, 10 do
				self.inhalt[i].active = false;
				self.inhalt[i].text = "";
			end;
			self.inhalt[1].active = true;
			Calendar.termineShow = true;
			buttons.window1 = false;
			buttons.window2 = false;
			buttons.window3 = false;
			--CalenderEvent:sendEvent();
		elseif posX > 0.266 and posX < 0.416 and posY > 0.25 and posY < 0.29 and isDown and button==1 then
			for i=1, 10 do
				self.inhalt[i].active = false;
				self.inhalt[i].text = "";
			end;
			self.inhalt[1].active = true;
			Calendar.termineShow = true;
			Calendar.termineInhalt = false;
			buttons.window1 = false;
			buttons.window2 = false;
			buttons.window3 = false;
		end;
	
	elseif Calendar.termineInhalt and Calendar.termineShow == false  then
		if posX > 0.106 and posX < 0.256 and posY > 0.25 and posY < 0.29 then
			buttons.close = true;
			buttons.retur = false;
		elseif posX > 0.266 and posX < 0.416 and posY > 0.25 and posY < 0.29 then
			buttons.close = false;
			buttons.retur = true;
		else
			buttons.close = false;
			buttons.retur = false;
		end;
		if posX > 0.106 and posX < 0.256 and posY > 0.25 and posY < 0.29 and isDown and button==1 then
			Calendar.termineShow = true;
			Calendar.termineInhalt = false;
		end;
	end;
end;

function Calendar:updateCalendar (dt) 
	local lenght = table.getn(g_currentMission.FarmingTablet.SoilExtension.daten.fields);
	
	for i=1, lenght do
		Calendar.heute[i] = {};
		Calendar.morgen[i] = {};
		Calendar.ubermorgen[i] = {};
		local feld = g_currentMission.FarmingTablet.SoilExtension.daten.fields[i];
		Calendar.heute[i].titel = feld.name;
		Calendar.morgen[i].titel = feld.name;
		Calendar.ubermorgen[i].titel = feld.name;
		local tag = g_currentMission.FarmingTablet.SoilExtension.daten.fields[i].tag;
		
		local schritteHeute = feld.schritte[string.format("%f", g_currentMission.environment.currentDay, 7)+tag-1];
		local artHeute = schritteHeute.art;
		local mittelHeute = schritteHeute.mittel;
		Calendar.heute[i].subtitel = artHeute .. " mit " .. mittelHeute;
		if artHeute == "Ernten" then
			Calendar.heute[i].subtitel  = artHeute;
		elseif artHeute == "Ansähen" then
			Calendar.heute[i].subtitel  = artHeute .. " mit " .. g_currentMission.FarmingTablet.SoilExtension.daten.fields[i].frucht;
		end;
		
		local schritteMorgen = feld.schritte[string.format("%f", g_currentMission.environment.currentDay, 7)+tag];
		local artMorgen = schritteMorgen.art;
		local mittelMorgen = schritteMorgen.mittel;
		Calendar.morgen[i].subtitel = artMorgen .. " mit " .. mittelMorgen;
		if artMorgen == "Ernten" then
			Calendar.morgen[i].subtitel = artMorgen;
		elseif artMorgen == "Ansähen" then
			Calendar.morgen[i].subtitel = artMorgen .. " mit " .. g_currentMission.FarmingTablet.SoilExtension.daten.fields[i].frucht;
		end;
		
		local schritteUmorgen = feld.schritte[string.format("%f", g_currentMission.environment.currentDay, 7)+tag+1];
		local artUmorgen= schritteUmorgen.art;
		local mittelUmorgen = schritteUmorgen.mittel;
		Calendar.ubermorgen[i].subtitel = artUmorgen .. " mit " .. mittelUmorgen;
		if artUmorgen == "Ernten" then
			Calendar.ubermorgen[i].subtitel = artUmorgen;
		elseif artUmorgen == "Ansähen" then
			Calendar.ubermorgen[i].subtitel = artUmorgen .. " mit " .. g_currentMission.FarmingTablet.SoilExtension.daten.fields[i].frucht;
		end;
		
			
	end;
	
	Termine.heute = {};
	
	local lengCalenderHeute = table.getn(Calendar.heute);
	local lengTermineHeute = table.getn(g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay]);
	
	if lengTermineHeute ~= 0 then
		for i = 1, lengTermineHeute do
			Termine.heute[i] = {};
			Termine.heute[i].titel = g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][i].titel;
			Termine.heute[i].subtitel = g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][i].subtitel;
			Termine.heute[i].text = {}
			for h = 1, 10 do
				Termine.heute[i].text[h] = g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay][i].text[h];
			end;
			
		end;
		
	end;
	
	local lengHeute = table.getn(Termine.heute);
	if lengCalenderHeute ~= 0 then
		for i = 1, lengCalenderHeute do
			Termine.heute[i+lengHeute] = {};
			Termine.heute[i+lengHeute].titel = Calendar.heute[i].titel;
			Termine.heute[i+lengHeute].subtitel = Calendar.heute[i].subtitel;
			Termine.heute[i+lengHeute].text = nil;
		end;
	end;
	
	Termine.morgen = {};
	
	local lengCalenderMorgen = table.getn(Calendar.morgen);
	local lengTermineMorgen = table.getn(g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1]);
	
	if lengTermineMorgen ~= 0 then
		for i = 1, lengTermineMorgen do
			Termine.morgen[i] = {};
			Termine.morgen[i].titel = g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][i].titel;
			Termine.morgen[i].subtitel = g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][i].subtitel;
			Termine.morgen[i].text = {}
			for h = 1, 10 do
				Termine.morgen[i].text[h] = g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+1][i].text[h];
			end;
			
		end;
		
	end;
	
	local lengMorgen = table.getn(Termine.morgen);
	if lengCalenderMorgen ~= 0 then
		for i = 1, lengCalenderMorgen do
			Termine.morgen[i+lengMorgen] = {};
			Termine.morgen[i+lengMorgen].titel = Calendar.morgen[i].titel;
			Termine.morgen[i+lengMorgen].subtitel = Calendar.morgen[i].subtitel;
			Termine.morgen[i+lengMorgen].text = nil;
		end;
	end;
	
	Termine.umorgen = {};
	
	local lengCalenderUMorgen = table.getn(Calendar.ubermorgen);
	if g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2] == nil then
		g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2] = {};
	end;
	local lengTermineUMorgen = table.getn(g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2]);
	
	if lengTermineUMorgen ~= 0 then
		for i = 1, lengTermineUMorgen do
			Termine.umorgen[i] = {};
			Termine.umorgen[i].titel = g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][i].titel;
			Termine.umorgen[i].subtitel = g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][i].subtitel;
			Termine.umorgen[i].text = {}
			for h = 1, 10 do
				Termine.umorgen[i].text[h] = g_currentMission.FarmingTablet.Calendar.Termine[g_currentMission.environment.currentDay+2][i].text[h];
			end;
			
		end;
		
	end;
	
	local lengUMorgen = table.getn(Termine.umorgen);
	if lengCalenderUMorgen ~= 0 then
		for i = 1, lengCalenderUMorgen do
			Termine.umorgen[i+lengUMorgen] = {};
			Termine.umorgen[i+lengUMorgen].titel = Calendar.ubermorgen[i].titel;
			Termine.umorgen[i+lengUMorgen].subtitel = Calendar.ubermorgen[i].subtitel;
			Termine.umorgen[i+lengUMorgen].text = nil;
		end;
	end;
	
end;

function Calendar:keyEventCalendar(unicode, sym, modifier, isDown) 
	if Calendar.termineShow == false and isDown then
		if buttons.titel then
			if sym == 8 then
				local leng = string.len(self.titel);
				self.titel = string.sub(self.titel, 1, leng-1);
			elseif sym ~= 8 and unicode ~= 0.0 then
				self.titel = self.titel..string.char(unicode);
			end;
		elseif buttons.inhalt then
			for i=1, 10 do
				if self.inhalt[i].active then
					if sym == 8 then
						local leng = string.len(self.inhalt[i].text);
						self.inhalt[i].text = string.sub(self.inhalt[i].text, 1, leng-1);
					elseif sym ~= 8 and unicode ~= 0.0 then
						self.inhalt[i].text = self.inhalt[i].text..string.char(unicode);
					end;
				end;
			end;
			if sym == 13 or sym == 274 and self.inhalt[10].active ~= true then
				local i=1;
				while true do
					if i < 10 then
						if self.inhalt[i].active ~= nil then
							if self.inhalt[i].active then
								self.inhalt[i].active = false;
								self.inhalt[i+1].active = true;
								i = i + 1;
								break;
							end;
							i = i + 1;
							if i == 11 then
								i = 10;
							end;
						end;
					else
						break
					end;
				end;
			elseif sym == 273 and self.inhalt[1].active ~= true then
				local i=1;
				while true and i > 0 and i < 11 do
					if self.inhalt[i].active ~= nil then
						if self.inhalt[i].active and i > 0 then
							self.inhalt[i].active = false;
							self.inhalt[i-1].active = true;
							i = i + 1;
							break;
						end;
						i = i + 1;
					end;
				end;
			end;
		end;
	end;
	
end;

function Calendar:drawCalendar ()
	renderOverlay(FarmingTablet.overlay.background, 0.01, 0.01, 1, 1.5);
	setTextColor(1, 1, 1, 1);
	local hour = g_currentMission.environment.currentHour;
	local minute = g_currentMission.environment.currentMinute
	renderText(0.093, 0.825, 0.03, tostring("Kalender"));
	renderText(0.795, 0.825, 0.03, tostring(hour..":"..minute));
	renderText(0.603, 0.825, 0.03, tostring(Calendar.days[math.mod(string.format("%f", g_currentMission.environment.currentDay), 7)].."  ("..string.format("%.f", string.format("%f", g_currentMission.environment.currentDay))..". Tag)"));
	setTextColor(0, 0, 0, 1);
	
	if Calendar.termineShow and Calendar.termineInhalt == false then
		setTextColor(1, 1, 1, 1);
		renderText(0.163, 0.825, 0.03, tostring(": Übersicht"));
		setTextColor(0, 0, 0, 1);
		renderOverlay(FarmingTablet.overlay.trennstrich, 0.363, 0.25, 0.005, 0.5);
		renderOverlay(FarmingTablet.overlay.trennstrich, 0.641, 0.25, 0.004, 0.5);
		renderText(0.11, 0.761, 0.033, tostring(Calendar.days[math.mod(string.format("%f", g_currentMission.environment.currentDay), 7)].." (Heute)"));
		renderText(0.11, 0.761, 0.033, tostring(Calendar.days[math.mod(string.format("%f", g_currentMission.environment.currentDay), 7)].." (Heute)"));
		renderText(0.388, 0.761, 0.033, tostring(Calendar.days[math.mod(string.format("%f", g_currentMission.environment.currentDay)+1, 7)].." (Morgen)"));
		renderText(0.388, 0.761, 0.033, tostring(Calendar.days[math.mod(string.format("%f", g_currentMission.environment.currentDay)+1, 7)].." (Morgen)"));
		renderText(0.666, 0.761, 0.033, tostring(Calendar.days[math.mod(string.format("%f", g_currentMission.environment.currentDay)+2, 7)].." (Übermorgen)"));
		renderText(0.666, 0.761, 0.033, tostring(Calendar.days[math.mod(string.format("%f", g_currentMission.environment.currentDay)+2, 7)].." (Übermorgen)"));
		
		if buttons.up1 then
			renderOverlay(FarmingTablet.overlay.up_on, 0.09, 0.25, 0.09, 0.04);
		else
			renderOverlay(FarmingTablet.overlay.up, 0.09, 0.25, 0.09, 0.04);
		end;
		if buttons.add1 then
			renderOverlay(FarmingTablet.overlay.blue, 0.184, 0.25, 0.08, 0.04);
		else
			renderOverlay(FarmingTablet.overlay.black, 0.184, 0.25, 0.08, 0.04);
		end;
		if buttons.down1 then
			renderOverlay(FarmingTablet.overlay.down_on, 0.267, 0.25, 0.09, 0.04);
		else
			renderOverlay(FarmingTablet.overlay.down, 0.267, 0.25, 0.09, 0.04);
		end;
		if buttons.up2 then
			renderOverlay(FarmingTablet.overlay.up_on, 0.371, 0.25, 0.09, 0.04);
		else
			renderOverlay(FarmingTablet.overlay.up, 0.371, 0.25, 0.09, 0.04);
		end;
		if buttons.add2 then
			renderOverlay(FarmingTablet.overlay.blue, 0.465, 0.25, 0.08, 0.04);
		else
			renderOverlay(FarmingTablet.overlay.black, 0.465, 0.25, 0.08, 0.04);
		end;
		if buttons.down2 then
			renderOverlay(FarmingTablet.overlay.down_on, 0.548, 0.25, 0.09, 0.04);
		else
			renderOverlay(FarmingTablet.overlay.down, 0.548, 0.25, 0.09, 0.04);
		end;
		if buttons.up3 then
			renderOverlay(FarmingTablet.overlay.up_on, 0.648, 0.25, 0.09, 0.04);
		else
			renderOverlay(FarmingTablet.overlay.up, 0.648, 0.25, 0.09, 0.04);
		end;
		if buttons.add3 then
			renderOverlay(FarmingTablet.overlay.blue, 0.742, 0.25, 0.08, 0.04);
		else
			renderOverlay(FarmingTablet.overlay.black, 0.742, 0.25, 0.08, 0.04);
		end;
		if buttons.down3 then
			renderOverlay(FarmingTablet.overlay.down_on, 0.825, 0.25, 0.09, 0.04);
		else
			renderOverlay(FarmingTablet.overlay.down, 0.825, 0.25, 0.09, 0.04);
		end;
				
		setTextColor(1, 1, 1, 1);
		renderText(0.186, 0.268, 0.02, tostring("Neuer Termin"));
		renderText(0.466, 0.268, 0.02, tostring("Neuer Termin"));
		renderText(0.744, 0.268, 0.02, tostring("Neuer Termin"));
		setTextColor(0, 0, 0, 1);
	
		local lengH = table.getn(Termine.heute);
		o = 1;
		for i = self.startHeute, lengH do
			if o < 10 then
				renderText(0.095, (0.71-(o-1)*0.05), 0.025, tostring(Termine.heute[i].titel..": "..Termine.heute[i].subtitel));
				renderText(0.095, (0.71-(o-1)*0.05), 0.025, tostring(Termine.heute[i].titel));
			end;
			o = o + 1;
		end;
		
		local lengM = table.getn(Termine.morgen);
		o = 1;
		for i = self.startMorgen, lengM do
			if o < 10 then
				renderText(0.373, (0.71-(o-1)*0.05), 0.025, tostring(Termine.morgen[i].titel..": "..Termine.morgen[i].subtitel));
				renderText(0.373, (0.71-(o-1)*0.05), 0.025, tostring(Termine.morgen[i].titel));
			end;
			o = o + 1;
		end;
		
		local lengUM = table.getn(Termine.umorgen);
		o = 1;
		for i = self.startUMorgen, lengUM do
			if o < 10 then
				renderText(0.651, (0.71-(o-1)*0.05), 0.025, tostring(Termine.umorgen[i].titel..": "..Termine.umorgen[i].subtitel));
				renderText(0.651, (0.71-(o-1)*0.05), 0.025, tostring(Termine.umorgen[i].titel));
			end;
			o = o + 1;
		end;
			
		if buttons.windowScreen then
			renderOverlay(FarmingTablet.overlay.window, 0.319, 0.358, 0.5, 0.4);
		end;
		
		
	end;
	if Calendar.termineShow == false and Calendar.termineInhalt == false then
		setTextColor(1, 1, 1, 1);
		renderText(0.163, 0.825, 0.03, tostring(": Termin erstellen"));
		setTextColor(0, 0, 0, 1);
		renderOverlay(FarmingTablet.overlay.addTermin, 0.01, 0.01, 1, 1.5);
		renderText(0.107, 0.756, 0.032, tostring("Titel:"));
		renderText(0.107, 0.646, 0.032, tostring("Inhalt:"));
		if buttons.close then
			renderOverlay(FarmingTablet.overlay.blue, 0.107, 0.25, 0.15, 0.04);
		else
			renderOverlay(FarmingTablet.overlay.black, 0.107, 0.25, 0.15, 0.04);
		end;
		if buttons.retur then
			renderOverlay(FarmingTablet.overlay.blue, 0.267, 0.25, 0.15, 0.04);
		else
			renderOverlay(FarmingTablet.overlay.black, 0.267, 0.25, 0.15, 0.04);
		end;
		if buttons.titel then
			renderOverlay(FarmingTablet.overlay.MarkierungTitel, 0.01, 0.01, 1, 1.5);
		end;
		if buttons.inhalt then
			renderOverlay(FarmingTablet.overlay.MarkierungInhalt, 0.01, 0.01, 1, 1.5);
		end;
		setTextColor(1, 1, 1, 1);
		renderText(0.142, 0.258, 0.029, tostring("Schließen"));
		renderText(0.302, 0.258, 0.029, tostring("Abbrechen"));
		setTextColor(0, 0, 0, 1);
		renderText(0.115, 0.71, 0.03, tostring(self.titel));
		for i=1, 10 do
			renderText(0.115, (0.604-((i-1)*0.03)), 0.03, tostring(self.inhalt[i].text));
		end;
	elseif Calendar.termineInhalt and Calendar.termineShow == false then
		renderOverlay(FarmingTablet.overlay.background, 0.01, 0.01, 1, 1.5);
		if buttons.close then
			renderOverlay(FarmingTablet.overlay.blue, 0.107, 0.25, 0.15, 0.04);
		else
			renderOverlay(FarmingTablet.overlay.black, 0.107, 0.25, 0.15, 0.04);
		end;
		setTextColor(1, 1, 1, 1);
		renderText(0.142, 0.258, 0.029, tostring("Schließen"));
		setTextColor(0, 0, 0, 1);
		if Calendar.activeTerminHeute then 
			renderText(0.12, 0.756, 0.035, tostring(Termine.heute[Calendar.activeTermin].subtitel));
			renderText(0.12, 0.756, 0.035, tostring(Termine.heute[Calendar.activeTermin].subtitel));
			for i=1, 10 do
				if Termine.heute[Calendar.activeTermin].text[i] ~= nil then
					renderText(0.12, (0.7-((i-1)*0.035)), 0.03, tostring(Termine.heute[Calendar.activeTermin].text[i]));
				end;
			end;
		end;
		if Calendar.activeTerminMorgen then 
			renderText(0.12, 0.756, 0.035, tostring(Termine.morgen[Calendar.activeTermin].subtitel));
			renderText(0.12, 0.756, 0.035, tostring(Termine.morgen[Calendar.activeTermin].subtitel));
			for i=1, 10 do
				if Termine.morgen[Calendar.activeTermin].text[i] ~= nil then
					renderText(0.12, (0.7-((i-1)*0.035)), 0.03, tostring(Termine.morgen[Calendar.activeTermin].text[i]));
				end;
			end;
		end;
		if Calendar.activeTerminUmorgen then 
			renderText(0.12, 0.756, 0.035, tostring(Termine.umorgen[Calendar.activeTermin].subtitel));
			renderText(0.12, 0.756, 0.035, tostring(Termine.umorgen[Calendar.activeTermin].subtitel));
			for i=1, 10 do
				if Termine.umorgen[Calendar.activeTermin].text[i] ~= nil then
					renderText(0.12, (0.7-((i-1)*0.035)), 0.03, tostring(Termine.umorgen[Calendar.activeTermin].text[i]));
				end;
			end;
		end;
		
	end;
end;


function Calendar:deleteCalendar() end;
 
 
 
 
 
 
 