AppstoreEvent = {};
AppstoreEvent_mt = Class(AppstoreEvent, Event);

InitEventClass(AppstoreEvent, "AppstoreEvent");

function AppstoreEvent:emptyNew()
    local self = Event:new(AppstoreEvent_mt);
    return self;
end;

function AppstoreEvent:new()
    local self = AppstoreEvent:emptyNew();
    return self;
end;

function AppstoreEvent:readStreamAll(streamId, connection)
	local numApps = streamReadInt32(streamId);
	g_currentMission.FarmingTablet.Appstore.apps = {};
	for i = 1, numApps do
		g_currentMission.FarmingTablet.Appstore.apps[i] = streamReadBool(streamId);
	end;
	self:set(connection);
end;
function AppstoreEvent:writeStreamAll(streamId, connection)
	local numApps = table.getn(g_currentMission.FarmingTablet.Appstore.apps)
	streamWriteInt32(streamId, numApps);
	for i = 1, numApps do
		streamWriteBool(streamId, g_currentMission.FarmingTablet.Appstore.apps[i]);
	end;
end;
function AppstoreEvent:set(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(AppstoreEvent:new());
	end;
end;
function AppstoreEvent:readStream(streamId, connection)
	self:readStreamAll(streamId, connection);	
end;
function AppstoreEvent:readUpdateStream(streamId, connection)
	self:readStreamAll(streamId, connection);
end;
function AppstoreEvent:writeStream(streamId, connection)
	self:writeStreamAll(streamId, connection);	
end;
function AppstoreEvent:writeUpdateStream(streamId, connection)
	self:writeStreamAll(streamId, connection);	
end; 

function AppstoreEvent:sendEvent()
	g_client:getServerConnection():sendEvent(AppstoreEvent:new());
end;

function AppstoreEvent:run(connection)

end;