--[[
Specialization to allow destroy grass or create new fields with an cultivator (toggleable)

Autor: 		Ifko[nator]
Datum: 		14.08.2016
Version:	1.0

History: 	V 1.0 @ 14.08.2016 - intial release
]]

AllowDestroyGrassWithAnCultivator = {};

function AllowDestroyGrassWithAnCultivator.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cultivator, specializations);
end;

function AllowDestroyGrassWithAnCultivator:load(xmlFile)
	self.allowDestroyGrass = false;
	self.allowCreateFields = false;
	
	Cultivator.updateTick = Utils.overwrittenFunction(Cultivator.updateTick, AllowDestroyGrassWithAnCultivator.updateTickCultivator);
end;

function AllowDestroyGrassWithAnCultivator:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self.allowDestroyGrass = not self.allowDestroyGrass;
		end;
		
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self.allowCreateFields = not self.allowCreateFields;
		end;
	end;
end;

function AllowDestroyGrassWithAnCultivator:updateTickCultivator(updateTick, dt)
	self.isCultivatorSpeedLimitActive = false;
    
	if self:getIsActive() then
        self.lastCultivatorArea = 0;
        local showFieldNotOwnedWarning = false;
        
		if self.isServer then
            local hasGroundContact = self:getIsTypedWorkAreaActive(WorkArea.AREATYPE_CULTIVATOR);
            
			if self.cultivatorHasGroundContact ~= hasGroundContact then
                self:raiseDirtyFlags(self.cultivatorGroundContactFlag);
                self.cultivatorHasGroundContact = hasGroundContact;
            end;
        end;
       
		local hasGroundContact = self.cultivatorHasGroundContact;
        self.doGroundManipulation = (hasGroundContact and (not self.onlyActiveWhenLowered or self:isLowered(false)) and self.startActivationTime <= g_currentMission.time);
        local foldAnimTime = self.foldAnimTime;
       
		if self.doGroundManipulation then
            self.isCultivatorSpeedLimitActive = true;
            
			if self.isServer then
                local workAreasSend, showWarning, _ = self:getTypedNetworkAreas(WorkArea.AREATYPE_CULTIVATOR, true);
                showFieldNotOwnedWarning = showWarning;
                
				if #workAreasSend > 0 then
                    local limitToField = self.cultivatorLimitToField or self.cultivatorForceLimitToField;
                    local limitGrassDestructionToField = self.cultivatorLimitToField or self.cultivatorForceLimitToField;
					
					
					if not g_currentMission:getHasPermission("createFields", self:getOwner()) then
                        limitToField = true;
                        limitGrassDestructionToField = true;
					else
						if self.allowDestroyGrass then
							limitGrassDestructionToField = false;
						end;
						
						if self.allowCreateFields then
							limitToField = false;
							limitGrassDestructionToField = false;
						end;
                    end;
                    
					local dx,dy,dz = localDirectionToWorld(self.cultivatorDirectionNode, 0, 0, 1);
                    local angle = Utils.convertToDensityMapAngle(Utils.getYRotationFromDirection(dx, dz), g_currentMission.terrainDetailAngleMaxValue);
                    local realArea = CultivatorAreaEvent.runLocally(workAreasSend, limitToField, limitGrassDestructionToField, angle);
                    
					g_server:broadcastEvent(CultivatorAreaEvent:new(workAreasSend, limitToField, limitGrassDestructionToField, angle));
                    self.lastCultivatorArea = Utils.areaToHa(realArea, g_currentMission:getFruitPixelsToSqm()); -- 4096px are mapped to 2048m
                    g_currentMission.missionStats:updateStats("hectaresWorked", self.lastCultivatorArea);
                end;
            end;
            
			g_currentMission.missionStats:updateStats("workingDuration", dt/(1000*60));
        end;
		
        if self.isClient then
            if self.doGroundManipulation and self:getLastSpeed() > 3 then
                if self:getIsActiveForSound() then
                    Utils.playSample(self.sampleCultivator, 0, 0, nil);
                end;
            else
                Utils.stopSample(self.sampleCultivator);
            end;
        end;
		
        if self.isServer then
            if showFieldNotOwnedWarning ~= self.showFieldNotOwnedWarning then
                self.showFieldNotOwnedWarning = showFieldNotOwnedWarning;
                self:raiseDirtyFlags(self.cultivatorGroundContactFlag);
            end;
        end;
    end;
end;

function AllowDestroyGrassWithAnCultivator:draw()
	if self:getIsActiveForInput() then
		if self.allowCreateFields then
			g_currentMission:addHelpButtonText(Cultivator.NOT_ALLOW_CREATE_NEW_FIELDS, InputBinding.IMPLEMENT_EXTRA);
		else
			g_currentMission:addHelpButtonText(Cultivator.ALLOW_CREATE_NEW_FIELDS, InputBinding.IMPLEMENT_EXTRA);
			
			if self.allowDestroyGrass then
				g_currentMission:addHelpButtonText(Cultivator.NOT_ALLOW_DESTROY_GRASS, InputBinding.IMPLEMENT_EXTRA3);
			else
				g_currentMission:addHelpButtonText(Cultivator.ALLOW_DESTROY_GRASS, InputBinding.IMPLEMENT_EXTRA3);
			end;
		end;
	end;
end;

function AllowDestroyGrassWithAnCultivator:delete()end;
function AllowDestroyGrassWithAnCultivator:mouseEvent(posX, posY, isDown, isUp, button)end;
function AllowDestroyGrassWithAnCultivator:keyEvent(unicode, sym, modifier, isDown)end;
