--[[
	SetBackLinkageUp_Register.lua
	
	Autor: Ifko[nator]
	Datum: 01.05.2015
]]

SpecializationUtil.registerSpecialization("SetBackLinkageUp", "SetBackLinkageUp", g_currentModDirectory .. "SetBackLinkageUp.lua");

SetBackLinkageUp_Register = {};

function SetBackLinkageUp_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			
			if v ~= nil then
				local allowInsertion = true;
				
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					-- Standard lua's
					
					if vs ~= nil then
						if vs == SpecializationUtil.getSpecialization("drivable") then
							local v_name_string = v.name 
							local point_location = string.find(v_name_string, ".", nil, true)
							
							if point_location ~= nil then
								local _name = string.sub(v_name_string, 1, point_location - 1);
								-- Mod lua's (nicht im dataS Ordner!)
								if rawget(SpecializationUtil.specializations, string.format("%s.SetBackLinkageUp", _name)) ~= nil then
									allowInsertion = false;
								end;
							end;
							
							if allowInsertion then
								table.insert(v.specializations, SpecializationUtil.getSpecialization("SetBackLinkageUp"));
							end;
							
							Drivable.MULTIPLE_MANUAL_ATTACHING_MOD_WARNING_BACKLINKAGE = g_i18n:getText("MULTIPLE_MANUAL_ATTACHING_MOD_WARNING_BACKLINKAGE");
							Drivable.MULTIPLE_MANUAL_ATTACHING_MOD_WARNING_FRONTLINKAGE = g_i18n:getText("MULTIPLE_MANUAL_ATTACHING_MOD_WARNING_FRONTLINKAGE");
							Drivable.SET_FRONT_LINKAGE_DOWN = g_i18n:getText("SET_FRONT_LINKAGE_DOWN");
							Drivable.SET_FRONT_LINKAGE_UP = g_i18n:getText("SET_FRONT_LINKAGE_UP");
							Drivable.SET_BACK_LINKAGE_DOWN = g_i18n:getText("SET_BACK_LINKAGE_DOWN");
							Drivable.SET_BACK_LINKAGE_UP = g_i18n:getText("SET_BACK_LINKAGE_UP");
						end;
					end;
				end;
			end;	
		end;
	end;
end;

function SetBackLinkageUp_Register:deleteMap()end;
function SetBackLinkageUp_Register:keyEvent(unicode, sym, modifier, isDown)end;
function SetBackLinkageUp_Register:mouseEvent(posX, posY, isDown, isUp, button)end;
function SetBackLinkageUp_Register:update(dt)end;
function SetBackLinkageUp_Register:draw()end;

addModEventListener(SetBackLinkageUp_Register);