--[[
Spezialisierung die dafür sorgt, dass die Heckhydraulik angehoben wird, wenn man einen Anhänger mit Kugelkopf anhängt.

Author:		Ifko[nator] 
Co Author:	Marhu
Datum:		13.08.2016
Version:	3.52

History:	v1.0 @ 20.12.2015 - Erste Implementierung in den LS 15
			-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
			v1.1 @ 27.12.2015 - Kleine Anpassungen
			-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
			v2.0 @ 14.01.2016 - Die 'movingTools' und 'movingParts' der Heckhydraulik werden nun auch abgebaut, wenn sich eine Zapfwelle mit dem Traktor verbindet. Großen Dank an Marhu für seine Hilfe!
								Nun wird der Hydraulik Sound von diesem Script nachgeladen, falls der in der Fzg.xml fehlt. (Selbst beim standard New Holland T 8435 fehlt der .. )
								Beim New Holland T 9560 und Case IH Quadtrac 620 bauen sich die Heckhydraulik nicht mehr ab, egal was angegeben wurde. Bei diesen Traktoren stört sie nicht.
			-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
			v3.0 @ 10.04.2016 - Die Zapfwelle rotiert nun bei Güllefässern, Zettern, Ballenpressen, Miststreuer, Schwadern usw. Das kann man auch abstellen. 
								Auch die Drehrichtung, (Zahl mit einem minus in Uhrzeigersinn und ohne gegen den Uhrzeigersinn), maximale Drehgeschwindigkeit und An- und Ausdrehgeschwindigkeit der Zapfwelle kann man festelegen.
								Man kann nun das neue Rotations Limit des Attacher Joints für Kugelkopfanhänger in der modDesc oder Fzg.xml anpassen.
								Man kann nun einstellen, ob sich die Gesamte Heckhydraulik abbauen soll, oder nur die Unterlenker.
								Wenn der Index für die Hintere oder Vodere Zapfwelle am Traktor falsch gedreht sein sollte, wird er nun von diesem Script richtig gedreht.
								Wenn der Index für die Zapfwelle an einem Gerät/Anhänger falsch gedreht sein sollte, wird er nun von diesem Script richtig gedreht.
								Unterstützung für den manualAttaching Mod, (Heckhydraulik wird nur abgebaut, wenn die Zapfwelle auch tatsächlich mit dem Traktor verbunden ist).
								Unterstützung für Geräte die die 'BJR_AttachablePTO.lua' verbaut haben, (Heckhydraulik wird nur abgebaut, wenn die Zapfwelle auch tatsächlich mit dem Traktor verbunden ist).
								Taste zum ankoppeln der Zapfwelle via 'BJR_AttachablePTO.lua' wird von diesem Script von [Q] auf [X] gelegt, um Konflikte mit dem manualAttaching zu vermeiden.
								Unterstützung für Geräte die die 'movingPartsPTO.lua' verbaut haben, (Heckhydraulik wird nur abgebaut, wenn die Zapfwelle auch tatsächlich mit dem Traktor verbunden ist).
								Nun baut sich die Fronthydraulik ab, wenn man einen FL an den Traktor koppelt. Dann kann man auch nichts an die Fronthydraulik ankoppeln.
			-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
			v3.5 @ 12.07.2016 - Man kann nun die Fronthydraulik auch per Tastendruck heben und senken, wenn nichts an der Fronthydraulik angekoppelt ist.
								Man kann nun die Heckhydraulik auch per Tastendruck heben und senken, wenn nichts an der Heckhydraulik oder am Kugelkopf angekoppelt ist.
								Die Zapfwelle kann nun auch vibrieren. Kann man aber in der modDesc einstellen was man will..  Rotieren, Vibrieren oder beides.. ^^
								Das Zugmaul des Traktores baut sich nun ab, wenn sich eine Zapfwelle verbindet oder man ein Gerät ankoppelt. Das geht aber nicht bei allen Traktoren, da das Zugmaul nicht immer ein einzelnes Objekt ist..
								Die Kugelkopfaufhängung des Traktores baut sich nun ab, wenn man ein Gerät ankoppelt. Auch das geht nicht bei allen Traktoren, da die Aufhängung nicht immer ein einzelnes Objekt ist.
			--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		   v3.51 @ 14.07.2015 - Fix Error '.. /zzz_setBackLinkageUp/SetBackLinkageUp.lua:479: attempt to index global 'ManualAttaching' (a nil value)' wenn der 'Manual Attaching' Mod von Wopster nicht im Modordner ist.
		   --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		   v3.52 @ 13.08.2015 - Fix Error '.. /zzz_setBackLinkageUp/SetBackLinkageUp.lua:829: attempt to call method 'getIsAnimationPlaying' (a nil value)' der auftrat wenn das IT Runner DLC nicht installiert war oder nur bei bestimmten Geräten.
		   
Beispiel für den Eintrag in eine Fzg.xml:
	
	<setBackLinkageUp testMode="false">
		<backLinkage> 
			<maxRot>
				25 <!-- Gibt an, wie weit die Heckhydraulik gehoben wird. -->
			</maxRot> 
			
			<rotSpeed>
				0.45 <!-- Gibt die Geschwindigkeit an, mit der die Heckhydraulik gehoben und gesenkt wird. -->
			</rotSpeed> 
			
			<doDismantleBackLinkageIfPTOIsNeeded>
				true <!-- Gibt an, ob die Unterlenker der Heckhydraulik abgebaut werden sollen, wenn sich eine Zapfwelle mit dem Traktor von einem Anhänger mit Kugelkopfaufhängung verbindet. -->
			</doDismantleBackLinkageIfPTOIsNeeded>
			
			<doAllBackLinkageDependentPartsDismantle>
				true <!-- Gibt an, ob sich auch die Zylinder, die zu den Unterlenkern der Heckhydraulik gehören, abbauen sollen, wenn sich die Unterlenker abbauen. -->
			</doAllBackLinkageDependentPartsDismantle> 
			
			<allowLiftSinkBackLinkageManually>
				true <!-- Gibt an, ob man die Heckhydraulik per Tastendruck heben und senken kann, wenn nichts an der Heckhydraulik oder an der Kugelkopfaufhängung angekoppelt ist. -->
			</allowLiftSinkBackLinkageManually>
		</backLinkage>
		
		<frontLinkage> 
			<maxRot>
				22 <!-- Gibt an, wie weit die Fronthydraulik gesenkt wird. -->
			</maxRot> 
			
			<rotSpeed>
				0.45 <!-- Gibt die Geschwindigkeit an, mit der die Fronthydraulik gesenkt und gehoben wird. -->
			</rotSpeed> 

			<doDismantleFrontLinkageIfFrontloaderIsAttached>
				true <!-- Gibt an, ob die Unterlenker der Fronthydraulik abgebaut werden sollen, wenn man einen Frontlader an den Traktor anbaut. -->
			</doDismantleFrontLinkageIfFrontloaderIsAttached> 
			
			<doAllFrontLinkageDependentPartsDismantle>
				true <!-- Gibt an, ob sich auch die Zylinder, die zu den Unterlenkern gehören, abbauen sollen, wenn sich die Unterlenker abbauen. -->
			</doAllFrontLinkageDependentPartsDismantle> 
			
			<allowLiftSinkFrontLinkageManually>
				true <!-- Gibt an, ob man die Fronthydraulik per Tastendruck heben und senken kann, wenn nichts an der Fronthydraulik angekoppelt ist. -->
			</allowLiftSinkFrontLinkageManually>
		</frontLinkage>
		
		<pto> 
			<doRotatePTO>
				false <!-- Gibt an, ob sich die Zapfwelle drehen soll, wenn das Gerät aktiv ist. -->
			</doRotatePTO> 
			
			<doVibratePTO>
				true <!-- Gibt an, ob die Zapfwelle Vibrieren soll, wenn das Gerät aktiv ist. -->
			</doVibratePTO> 
			
			<!--
			Info:

			'doRotatePTO' und 'doVibratePTO' können Zeitgleich auf 'true' eingestellt sein.
			-->
			
			<rotSpeedPTO>
				-0.6 <!-- Gibt an, wie schnell sich die Zapfwelle dreht. Wenn man eine Zahl ohne Minus angibt, dann dreht sie sich gegen den Uhrzeigersinn. -->
			</rotSpeedPTO> 
			
			<fadeTimeTurnOnPTO>
				0.01 <!-- Gibt an, wie schnell die Zapfwelle andreht. -->
			</fadeTimeTurnOnPTO> 
			
			<fadeTimeTurnOffPTO>
				0.007 <!-- Gibt an, wie schnell die Zapfwelle ausdreht. -->
			</fadeTimeTurnOffPTO> 
			
			<vibrateFactorPTO>
				0.0055 <!-- Gibt an, wie stark die Zapfwelle vibriert. -->
			</vibrateFactorPTO> 
			
			<allowOverrideOriginalPTO>
				true <!-- Gibt an, ob die Originale Zapfwelle überschrieben werden darf. Wenn, dann wird eine Zapfwelle mit einem Warnaufkleber geladen. -->
			</allowOverrideOriginalPTO>
		</pto>
		
		<trailerLowAttacher> 
			<newTrailerLowMaxRotLimitY>
				85 <!-- Gibt den maximalen Lenkwinkel für Anhänger mit Kugelkopfaufhängung an. -->
			</newTrailerLowMaxRotLimitY> 
			
			<doSetNewRotLimit>
				true <!-- Gibt an, ob der neue Lenkwinkel verwendet werden soll. -->
			</doSetNewRotLimit> 
			
			<doDismantleTrailerLowAttacherIfWorkToolIsAttached>
				true <!-- Gibt an, ob sich die Kugelkopfaufhängung am Traktor abbauen soll, wenn man etwas an die Heckhydraulik koppelt. ACHTUNG: Das geht nicht bei allen Traktoren! -->
			</doDismantleTrailerLowAttacherIfWorkToolIsAttached>
		</trailerLowAttacher>
		
		<trailerAttacher> 
			<doDismantleTrailerAttacherIfPTOIsNeeded>
				true <!-- Gibt an, ob sich das Zugmaul des Traktors abbauen soll, wenn sich eine Zapfwelle verbindet. ACHTUNG: Das geht nicht bei allen Traktoren! -->
			</doDismantleTrailerAttacherIfPTOIsNeeded> 
			
			<doDismantleTrailerAttacherIfWorkToolIsAttached>
				true <!-- Gibt an, ob sich das Zugmaul des Traktors abbauen soll, wenn man etwas an die Heckhydraulik koppelt. ACHTUNG: Das geht nicht bei allen Traktoren! -->
			</doDismantleTrailerAttacherIfWorkToolIsAttached>
		</trailerAttacher>
	</setBackLinkageUp>
]]

SetBackLinkageUp = {};

local setBackLinkageUp_directory = g_currentModDirectory;

function SetBackLinkageUp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Drivable, specializations);
end;

function SetBackLinkageUp:load(xmlFile)
	local modDesc = loadXMLFile("modDesc", setBackLinkageUp_directory .. "modDesc.xml");
	
	--## modDesc file
	local testMode = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp#testMode"), false);
	
	local maxRotBack = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.setBackLinkageUp.backLinkage.maxRot"), 24);
	local rotSpeedBack = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.setBackLinkageUp.backLinkage.rotSpeed"), 0.4);
	local doDismantleBackLinkageIfPTOIsNeeded = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp.backLinkage.doDismantleBackLinkageIfPTOIsNeeded"), true);
	local doAllBackLinkageDependentPartsDismantle = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp.backLinkage.doAllBackLinkageDependentPartsDismantle"), true);
	local allowLiftSinkBackLinkageManually = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp.backLinkage.allowLiftSinkBackLinkageManually"), true);
	
	local maxRotFront = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.setBackLinkageUp.frontLinkage.maxRot"), 20);
	local rotSpeedFront = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.setBackLinkageUp.frontLinkage.rotSpeed"), 0.4);
	local doAllFrontLinkageDependentPartsDismantle = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp.frontLinkage.doAllFrontLinkageDependentPartsDismantle"), true);
	local doDismantleFrontLinkageIfFrontloaderIsAttached = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp.frontLinkage.doDismantleFrontLinkageIfFrontloaderIsAttached"), true);
	local allowLiftSinkFrontLinkageManually = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp.frontLinkage.allowLiftSinkFrontLinkageManually"), true);
	
	local rotSpeedPTO = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.setBackLinkageUp.pto.rotSpeedPTO"), -0.3);
	local doRotatePTO = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp.pto.doRotatePTO"), true);
	local doVibratePTO = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp.pto.doVibratePTO"), true);
	local fadeTimeTurnOnPTO = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.setBackLinkageUp.pto.fadeTimeTurnOnPTO"), 0.01);
	local fadeTimeTurnOffPTO = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.setBackLinkageUp.pto.fadeTimeTurnOffPTO"), 0.008);
	local vibrateFactorPTO = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.setBackLinkageUp.pto.vibrateFactorPTO"), 0.004);
	
	local newTrailerLowMaxRotLimitY = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.setBackLinkageUp.trailerLowAttacher.newTrailerLowMaxRotLimitY"), 80);
	local doSetNewRotLimit = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp.trailerLowAttacher.doSetNewRotLimit"), true);
	local doDismantleTrailerLowAttacherIfWorkToolIsAttached = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp.trailerLowAttacher.doDismantleTrailerLowAttacherIfWorkToolIsAttached"), true);
	
	local doDismantleTrailerAttacherIfPTOIsNeeded = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp.trailerAttacher.doDismantleTrailerAttacherIfPTOIsNeeded"), true);
	local doDismantleTrailerAttacherIfWorkToolIsAttached = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp.trailerAttacher.doDismantleTrailerAttacherIfWorkToolIsAttached"), true);
	
	--## vehicle xml file
	self.testModeSBLU = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp#testMode"), testMode);
	
	self.maxRotBack = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.setBackLinkageUp.backLinkage.maxRot"), maxRotBack);
	self.rotSpeedBack = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.setBackLinkageUp.backLinkage.rotSpeed"), rotSpeedBack);
	self.doDismantleBackLinkageIfPTOIsNeeded = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.backLinkage.doDismantleBackLinkageIfPTOIsNeeded"), doDismantleBackLinkageIfPTOIsNeeded);
	self.doAllBackLinkageDependentPartsDismantle = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.backLinkage.doAllBackLinkageDependentPartsDismantle"), doAllBackLinkageDependentPartsDismantle);
	self.allowLiftSinkBackLinkageManually = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.backLinkage.allowLiftSinkBackLinkageManually"), allowLiftSinkBackLinkageManually);
	
	self.maxRotFront = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.setBackLinkageUp.frontLinkage.maxRot"), maxRotFront);
	self.rotSpeedFront = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.setBackLinkageUp.frontLinkage.rotSpeed"), rotSpeedFront);
	self.doAllFrontLinkageDependentPartsDismantle = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.frontLinkage.doAllFrontLinkageDependentPartsDismantle"), doAllFrontLinkageDependentPartsDismantle);
	self.doDismantleFrontLinkageIfFrontloaderIsAttached = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.frontLinkage.doDismantleFrontLinkageIfFrontloaderIsAttached"), doDismantleFrontLinkageIfFrontloaderIsAttached);
	self.allowLiftSinkFrontLinkageManually = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.frontLinkage.allowLiftSinkFrontLinkageManually"), allowLiftSinkFrontLinkageManually);
	
	self.rotSpeedPTO = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.setBackLinkageUp.pto.rotSpeedPTO"), rotSpeedPTO);
	self.doRotatePTO = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.pto.doRotatePTO"), doRotatePTO);
	self.doVibratePTO = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.pto.doVibratePTO"), doVibratePTO);
	self.fadeTimeTurnOnPTO = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.setBackLinkageUp.pto.fadeTimeTurnOnPTO"), fadeTimeTurnOnPTO);
	self.fadeTimeTurnOffPTO = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.setBackLinkageUp.pto.fadeTimeTurnOffPTO"), fadeTimeTurnOffPTO);
	self.vibrateFactorPTO = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.setBackLinkageUp.pto.vibrateFactorPTO"), vibrateFactorPTO);
	
	if string.find(self.rotSpeedBack, "-") then	
		local rotSpeedBack = self.rotSpeedBack;
		
		self.rotSpeedBack = tonumber(string.sub(self.rotSpeedBack, 2));
		
		print("Info from the SetBackLinkageUp Script: Found '-' in the Value from rotSpeedBack ('" .. rotSpeedBack .. "')! The Value was set to ('" .. self.rotSpeedBack .. "')!");
	end;
	
	if string.find(self.rotSpeedFront, "-") then	
		local rotSpeedFront = self.rotSpeedFront;
		
		self.rotSpeedFront = tonumber(string.sub(self.rotSpeedFront, 2));
		
		print("Info from the SetBackLinkageUp Script: Found '-' in the Value from rotSpeedFront ('" .. rotSpeedFront .. "')! The Value was set to ('" .. self.rotSpeedFront .. "')!");
	end;
	
	if string.find(self.fadeTimeTurnOnPTO, "-") then	
		local fadeTimeTurnOnPTO = self.fadeTimeTurnOnPTO;
		
		self.fadeTimeTurnOnPTO = tonumber(string.sub(self.fadeTimeTurnOnPTO, 2));
		
		print("Info from the SetBackLinkageUp Script: Found '-' in the Value from fadeTimeTurnOnPTO ('" .. fadeTimeTurnOnPTO .. "')! The Value was set to ('" .. self.fadeTimeTurnOnPTO .. "')!");
	end;
	
	if string.find(self.fadeTimeTurnOffPTO, "-") then	
		local fadeTimeTurnOffPTO = self.fadeTimeTurnOffPTO;
		
		self.fadeTimeTurnOffPTO = tonumber(string.sub(self.fadeTimeTurnOffPTO, 2));
		
		print("Info from the SetBackLinkageUp Script: Found '-' in the Value from fadeTimeTurnOffPTO ('" .. fadeTimeTurnOffPTO .. "')! The Value was set to ('" .. self.fadeTimeTurnOffPTO .. "')!");
	end;
	
	if string.find(self.vibrateFactorPTO, "-") then	
		local vibrateFactorPTO = self.vibrateFactorPTO;
		
		self.vibrateFactorPTO = tonumber(string.sub(self.vibrateFactorPTO, 2));
		
		print("Info from the SetBackLinkageUp Script: Found '-' in the Value from vibrateFactorPTO ('" .. vibrateFactorPTO .. "')! The Value was set to ('" .. self.vibrateFactorPTO .. "')!");
	end;
	
	self.newTrailerLowMaxRotLimitY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.setBackLinkageUp.trailerLowAttacher.newTrailerLowMaxRotLimitY"), newTrailerLowMaxRotLimitY);
	self.doSetNewRotLimit = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.trailerLowAttacher.doSetNewRotLimit"), doSetNewRotLimit);
	self.doDismantleTrailerLowAttacherIfWorkToolIsAttached = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.trailerLowAttacher.doDismantleTrailerLowAttacherIfWorkToolIsAttached"), doDismantleTrailerLowAttacherIfWorkToolIsAttached);
	
	self.doDismantleTrailerAttacherIfPTOIsNeeded = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.trailerAttacher.doDismantleTrailerAttacherIfPTOIsNeeded"), doDismantleTrailerAttacherIfPTOIsNeeded);
	self.doDismantleTrailerAttacherIfWorkToolIsAttached = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.trailerAttacher.doDismantleTrailerAttacherIfWorkToolIsAttached"), doDismantleTrailerAttacherIfWorkToolIsAttached);
	
	if not self.doDismantleBackLinkageIfPTOIsNeeded and self.doAllBackLinkageDependentPartsDismantle then
		self.doDismantleBackLinkageIfPTOIsNeeded = true;
		print("INFO from the 'SetBackLinkageUp' Script: The 'doDismantleBackLinkageIfPTOIsNeeded' TAG was set to 'true' because the 'doAllBackLinkageDependentPartsDismantle' TAG is 'true'!");
	end;
	
	if not self.doDismantleFrontLinkageIfFrontloaderIsAttached and self.doAllFrontLinkageDependentPartsDismantle then
		self.doDismantleFrontLinkageIfFrontloaderIsAttached = true;
		print("INFO from the 'SetBackLinkageUp' Script: The 'doDismantleFrontLinkageIfFrontloaderIsAttached' TAG was set to 'true' because the 'doAllFrontLinkageDependentPartsDismantle' TAG is 'true'!");
	end;
	
	self.findMinus = string.find(self.rotSpeedPTO, "-");
	
	self.allowDismantleBackLinkage = not (string.find(self.configFileName, "newHollandT9560") 
		or string.find(self.configFileName, "caseIHQuadtrac620") 
		or string.find(self.configFileName, "JCB536_70") 
		or string.find(self.configFileName, "MerloP417")
	);
	
	--self.allowDismantleFrontLinkage = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp.frontLinkage#allowDismantleFrontLinkage"), true);
	
	if string.find(self.configFileName, "Fendt9") or string.find(self.configFileName, "Fendt1050") then
		self.maxRotBack = 40;
	end;
	
	if string.find(self.configFileName, "zetorMajor80") then
		self.maxRotFront = 18;
	end;
	
	local giantsSoftware = string.find(self.configFileName, "data") or string.find(self.configFileName, "pdlc");
	local foundGuiltyPerson = "the Modder of this tractor";
	
	if giantsSoftware then
		foundGuiltyPerson = "GIANTS";
	end;
	
	self.backBottomArms = {};
	self.frontBottomArms = {};
	self.attacherTransNodes = {};
	self.attacherTransNodesLow = {};
	
	local bottomArmCount = 0;
	
	while true do
		local baseString = string.format("vehicle.attacherJoints.attacherJoint(%d)", bottomArmCount);
		
		if not hasXMLProperty(xmlFile, baseString) then
			break;
		end;
		
		local backBottomArm = {};
		local frontBottomArm = {};
		local attacherTransNode = {};
		local attacherTransNodeLow = {};
		
		local rotationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseString .. ".bottomArm#rotationNode"));
		local transNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseString .. "#transNode"));
		local jointType = getXMLString(xmlFile, baseString .. "#jointType");
		
		if transNode ~= nil then
			if jointType == "trailer" then
				attacherTransNode.index = transNode;
				
				table.insert(self.attacherTransNodes, attacherTransNode);
			elseif jointType == "trailerLow" then
				attacherTransNodeLow.index = transNode;
				
				table.insert(self.attacherTransNodesLow, attacherTransNodeLow);
			end;
		end;
		
		if rotationNode ~= nil then
			local zScale = getXMLFloat(xmlFile, baseString .. ".bottomArm#zScale");
			
			if zScale ~= nil then
				if zScale == -1 then
					backBottomArm.rotationNode = rotationNode;
					backBottomArm.curRotX, _, _ = getRotation(rotationNode);
					backBottomArm.curRotX = math.deg(backBottomArm.curRotX); --## convert from radians to degrees
					
					if backBottomArm.curRotX > -20 and self.allowDismantleBackLinkage then
						backBottomArm.curRotX = -20;
						setRotation(backBottomArm.rotationNode, math.rad(backBottomArm.curRotX), 0, 0);
						
						self.setNewRotX = true;
					end;
					
					backBottomArm.startRotX = backBottomArm.curRotX;
					self.currentRotSBLU = backBottomArm.startRotX;
					
					table.insert(self.backBottomArms, backBottomArm);
					
					local backPTONode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseString .. "#ptoOutputNode"));
					
					if backPTONode ~= nil then
						local _, rotY, _ = getRotation(backPTONode);
						
						rotY = math.floor(math.deg(rotY)); --## round down and convert from radians to degrees
						
						--print("back pto node rot y = " .. rotY .. " in: " .. self.configFileName);
					
						if rotY ~= 180 then
							local parent = getParent(backPTONode);
							local allowFixPTONode = true;
							
							if parent ~= nil then
								local rotX, rotY, rotZ = getRotation(parent);
						
								rotX, rotY, rotZ = math.floor(math.deg(rotX)), math.floor(math.deg(rotY)), math.floor(math.deg(rotZ)); --## round down and convert from radians to degrees
								
								--print("back pto parent node rot x = " .. rotX .. " rot y = " .. rotY .. " rot z = " .. rotZ);
								
								if (rotX and rotY and rotZ) ~= 0 then
									--## the parent node of the back PTO Node is not to '0, 0, 0' rotatet, stop to apply the rotation fix here!!!
									
									allowFixPTONode = false;
								end;
							end;
							
							if allowFixPTONode then
								--## fix false rotatet back pto index

								setRotation(backPTONode, 0, math.rad(180), 0);
								
								local index = getXMLString(xmlFile, baseString .. "#ptoOutputNode");
									
								print("INFO: In: '" .. self.configFileName .. "' is the index '" .. index .. "' for the back pto false rotatet! The 'SetBackLinkageUp' Script will now rotate this index correct for this vehicle! Thanks to " .. foundGuiltyPerson .. " for this Bug!");
							end;
						end;
					end;
				elseif zScale == 1 then
					local attacherJointIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, baseString .. "#index"));
					
					frontBottomArm.rotationNode = rotationNode;
					frontBottomArm.curRotX, _, _ = getRotation(rotationNode);
					frontBottomArm.curRotX = math.deg(frontBottomArm.curRotX); --## convert from radians to degrees
					frontBottomArm.startRotX = frontBottomArm.curRotX;
					
					if attacherJointIndex ~= nil then
						attacherJointIndex = getParent(attacherJointIndex);
						
						local _, _, transZ = getTranslation(attacherJointIndex);
						
						frontBottomArm.attacherJointIndex = attacherJointIndex;
						frontBottomArm.startTransZ = transZ;
					end;
					
					table.insert(self.frontBottomArms, frontBottomArm);
					
					local frontPTONode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseString .. "#ptoOutputNode"));
				
					if frontPTONode ~= nil then
						local _, rotY, _ = getRotation(frontPTONode);
						
						rotY = math.floor(math.deg(rotY)); --## round down and convert from radians to degrees
						
						--print("front pto node rot y = " .. rotY .. " in: " .. self.configFileName);
					
						if rotY ~= 0 then			
							local parent = getParent(frontPTONode);
							local allowFixPTONode = true;
							
							if parent ~= nil then
								local rotX, rotY, rotZ = getRotation(parent);
						
								rotX, rotY, rotZ = math.floor(math.deg(rotX)), math.floor(math.deg(rotY)), math.floor(math.deg(rotZ)); --## round down and convert from radians to degrees
								
								--print("front pto parent node rot x = " .. rotX .. " rot y = " .. rotY .. " rot z = " .. rotZ);
								
								if (rotX and rotY and rotZ) ~= 0 then
									--## the parent node of the front PTO Node is not to '0, 0, 0' rotatet, stop to apply the rotation fix here!!!
								
									allowFixPTONode = false;
								end;
							end;
							
							if allowFixPTONode then
								--## fix false rotatet front pto index
							
								setRotation(frontPTONode, 0, 0, 0);
								
								local index = getXMLString(xmlFile, baseString .. "#ptoOutputNode");
									
								print("INFO: In: '" .. self.configFileName .. "' is the index '" .. index .. "' for the front pto false rotatet! The 'SetBackLinkageUp' Script will now rotate this index correct for this vehicle! Thanks to " .. foundGuiltyPerson .. " for this Bug!");
							end;
						end;
					end;
				end;
			end;
		end;
		
		bottomArmCount = bottomArmCount + 1;
	end;
	
	if #self.backBottomArms > 0 or #self.frontBottomArms > 0 and self.isClient then
        --print("i run to the moon!!!!!");
		
		local soundFound = hasXMLProperty(xmlFile, "vehicle.hydraulicSound#file");
		
		if soundFound then
			self.sampleHydraulic2 = Utils.loadSample(xmlFile, {}, "vehicle.hydraulicSound", "$data/vehicles/shared/hydraulicUp.wav", self.baseDirectory);
		else
			print("INFO: The hydraulic sound is in: '" .. self.configFileName .. "' missing! The 'SetBackLinkageUp' Script will load the hydraulic sound now for this vehicle! Thanks to " .. foundGuiltyPerson .. " for this Bug!");
			
			self.sampleHydraulic = Utils.loadSample(modDesc, {}, "modDesc.hydraulicSound", "$data/vehicles/shared/hydraulicUp.wav", setBackLinkageUp_directory);
			self.sampleHydraulic2 = Utils.loadSample(modDesc, {}, "modDesc.hydraulicSound", "$data/vehicles/shared/hydraulicUp.wav", setBackLinkageUp_directory);
		end;
	end;
	
	delete(modDesc);
	
	self.currentRotSBLU = 0;
	self.setBackLinkageUp = false;
	self.doBackLinkageDismantle = false;
	self.doFrontLinkageDismantle = false;
	self.allowSkipWarning = false;
	self.setFrontLinkageDown = false;
	self.setBackLinkageUpWasTrue = false;
	
	if InputBinding.BJR_TOGGLE_PTO ~= nil and InputBinding.BJR_TOGGLE_PTO ~= InputBinding.IMPLEMENT_EXTRA2 then
		--## set input for attach PTO with the 'BJR_AttachablePTO.lua' to 'X' to pre event conflicts with the manual attaching mod
		
		InputBinding.BJR_TOGGLE_PTO = InputBinding.IMPLEMENT_EXTRA2;
	end;
	
	self.isWopsterManualAttachingMod = g_currentMission.manualAttachingExtensionLoaded;
	self.isBurnerManualAttachingMod = ManualAttaching and ManualAttaching.modDir;
end;

function SetBackLinkageUp:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local pto = implement.object.attacherJoint.ptoInput or implement.object.movingPartsPTONode;
	local jointDesc = self.attacherJoints[implement.jointDescIndex];
	local implement = implement.object;
	
	if jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if pto ~= nil and self.doDismantleBackLinkageIfPTOIsNeeded and self.isBurnerManualAttachingMod and self.isWopsterManualAttachingMod then
			g_currentMission:showBlinkingWarning(Drivable.MULTIPLE_MANUAL_ATTACHING_MOD_WARNING_BACKLINKAGE, 4500);
			
			self.allowSkipWarning = true;
		else
			self.allowSkipWarning = false;
		end;
		
		if (jointDesc.ptoOutput and jointDesc.ptoOutput.attachNode) ~= nil then
			self.attachedTrailer = {jointIndex = jointDesc.jointIndex, ptoAttachNode = jointDesc.ptoOutput.attachNode, jointDescPTO = jointDesc};
		else
			self.attachedTrailer = {jointIndex = jointDesc.jointIndex};
		end;
		
		if not self.setBackLinkageUp then
			self.setBackLinkageUp = true;
		else
			self.setBackLinkageUpWasTrue = true;
		end;

		self.doBackLinkageDismantle = pto ~= nil and self.doDismantleBackLinkageIfPTOIsNeeded and self.allowDismantleBackLinkage and not (self.isBurnerManualAttachingMod and self.isWopsterManualAttachingMod);
	end;
	
	if jointType == Vehicle.JOINTTYPE_ATTACHABLEFRONTLOADER then
		if self.isBurnerManualAttachingMod and self.isWopsterManualAttachingMod and self.doDismantleFrontLinkageIfFrontloaderIsAttached then
			g_currentMission:showBlinkingWarning(Drivable.MULTIPLE_MANUAL_ATTACHING_MOD_WARNING_FRONTLINKAGE, 4500);
			
			self.allowSkipWarning = true;
		else
			self.attachedFL = {jointIndex = jointDesc.jointIndex};
			self.doFrontLinkageDismantle = self.doDismantleFrontLinkageIfFrontloaderIsAttached; --and self.allowDismantleFrontLinkage;
			self.allowSkipWarning = false;
		end;
	end;
	
	if jointDesc.bottomArm ~= nil then
		if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
			if jointDesc.bottomArm.zScale == -1 then
				if self.attacherTransNodes ~= nil and self.doDismantleTrailerAttacherIfWorkToolIsAttached then
					self.attachedWorkTool = {jointIndex = jointDesc.jointIndex};
					
					for attacherTransNode = 1, #self.attacherTransNodes do
						local transNode = self.attacherTransNodes[attacherTransNode];
						
						if transNode.index ~= nil then
							setVisibility(transNode.index, false);
						end;
					end;
				end;
				
				if self.attacherTransNodesLow ~= nil and self.doDismantleTrailerLowAttacherIfWorkToolIsAttached then
					if self.attachedWorkTool == nil then
						self.attachedWorkTool = {jointIndex = jointDesc.jointIndex};
					end;
					
					for attacherTransNodeLow = 1, #self.attacherTransNodesLow do
						local transNode = self.attacherTransNodesLow[attacherTransNodeLow];
						
						if transNode.index ~= nil then
							setVisibility(transNode.index, false);
						end;
					end;
				end;
					
				if self.backBottomArms ~= nil then
					self.attachedBackTool = {jointIndex = jointDesc.jointIndex};
					
					for bottomArm = 1, #self.backBottomArms do
						local backBottomArm = self.backBottomArms[bottomArm];
						
						if self.setNewRotX then
							jointDesc.bottomArm.curRotX = math.rad(backBottomArm.startRotX);
						end;
							
						if self.setBackLinkageUp then
							jointDesc.bottomArm.rotX = math.rad(self.maxRotFront);
						else
							jointDesc.bottomArm.rotX = math.rad(backBottomArm.startRotX);
						end;
					end;
				end;
			end;
			
			if jointDesc.bottomArm.zScale == 1 and self.frontBottomArms ~= nil then
				self.attachedFrontTool = {jointIndex = jointDesc.jointIndex};
				
				for bottomArm = 1, #self.frontBottomArms do
					local frontBottomArm = self.frontBottomArms[bottomArm];
		
					if self.setFrontLinkageDown then
						jointDesc.bottomArm.rotX = math.rad(self.maxRotFront);
					else
						jointDesc.bottomArm.rotX = math.rad(frontBottomArm.startRotX);
					end;
				end;
			end;
		end;
	end;
	
	if self.attacherJoints ~= nil then
		for attacherJoint = 1, #self.attacherJoints do
			local jointType = self.attacherJoints[attacherJoint].jointType;
			
			if jointType == Vehicle.JOINTTYPE_TRAILERLOW and self.doSetNewRotLimit then
				if self.attacherJoints[attacherJoint].maxRotLimit[2] ~= nil then
					self.attacherJoints[attacherJoint].maxRotLimit[2] = math.rad(math.abs(self.newTrailerLowMaxRotLimitY));
				end;
			end;
		end;
	end;
end;

function SetBackLinkageUp:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointDesc = self.attacherJoints[implement.jointDescIndex];
	
	if self.attachedTrailer ~= nil and jointDesc.jointIndex == self.attachedTrailer.jointIndex then
		if not self.setBackLinkageUpWasTrue then
			self.setBackLinkageUp = false;
		end;
		
		self.doBackLinkageDismantle = false;
		self.attachedTrailer = nil;
	end;
	
	if self.attachedFL ~= nil and jointDesc.jointIndex == self.attachedFL.jointIndex then
		self.doFrontLinkageDismantle = false;
		self.attachedFL = nil;
	end;
	
	if self.attachedWorkTool ~= nil and jointDesc.jointIndex == self.attachedWorkTool.jointIndex then
		if self.attacherTransNodesLow ~= nil then
			for attacherTransNodeLow = 1, #self.attacherTransNodesLow do
				local transNode = self.attacherTransNodesLow[attacherTransNodeLow];
				
				if transNode.index ~= nil then
					setVisibility(transNode.index, true);
				end;
			end;
		end;
		
		self.attachedWorkTool = nil;
	end;
	
	if self.attachedFrontTool ~= nil and jointDesc.jointIndex == self.attachedFrontTool.jointIndex then
		self.attachedFrontTool = nil;
	end;
	
	if self.attachedBackTool ~= nil and jointDesc.jointIndex == self.attachedBackTool.jointIndex then
		self.attachedBackTool = nil;
	end;
end;

local function setAllDependentParts(dependent, dismantle)
	--## Part from Marhu, thank you!
	for _, dependentPart in pairs(dependent.dependentParts) do
		setVisibility(dependentPart.node, dismantle);
		setAllDependentParts(dependentPart, dismantle);
	end;
end;

function SetBackLinkageUp:update(dt)
	local playHydraulicSoundBackLinkage = false;
	local playHydraulicSoundFrontLinkage = false;
	local allowBackLinkageDismantle = false;
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.SET_FRONT_LINKAGE_DOWN_UP) and self.attachedFrontTool == nil and self.attachedFL == nil and self.allowLiftSinkFrontLinkageManually and #self.frontBottomArms > 0 then
			self.setFrontLinkageDown = not self.setFrontLinkageDown;
		end;
		
		if InputBinding.hasEvent(InputBinding.SET_BACK_LINKAGE_DOWN_UP) and self.attachedBackTool == nil and self.attachedTrailer == nil and self.allowLiftSinkBackLinkageManually and #self.backBottomArms > 0 then
			self.setBackLinkageUp = not self.setBackLinkageUp;
		end;
	end;
	
	if self.backBottomArms ~= nil then
		for bottomArm = 1, #self.backBottomArms do
			local backBottomArm = self.backBottomArms[bottomArm];
			
			if backBottomArm.curRotX ~= nil then
				if self.setBackLinkageUp then --and not self.doBackLinkageDismantle then
					backBottomArm.curRotX = math.min(backBottomArm.curRotX + self.rotSpeedBack, self.maxRotBack);
					
					playHydraulicSoundBackLinkage = backBottomArm.curRotX < self.maxRotBack;
					allowBackLinkageDismantle = backBottomArm.curRotX == self.maxRotBack;
				else
					backBottomArm.curRotX = math.max(backBottomArm.curRotX - self.rotSpeedBack, backBottomArm.startRotX);
					
					playHydraulicSoundBackLinkage = backBottomArm.curRotX > backBottomArm.startRotX;
					allowBackLinkageDismantle = playHydraulicSoundBackLinkage;
					self.doBackLinkageDismantle = false;
				end;
				
				if backBottomArm.rotationNode ~= nil and allowBackLinkageDismantle then
					setVisibility(backBottomArm.rotationNode, not self.doBackLinkageDismantle);
				end;
				
				if self.attacherTransNodes ~= nil and self.attachedWorkTool == nil and self.doDismantleTrailerAttacherIfPTOIsNeeded then
					for attacherTransNode = 1, #self.attacherTransNodes do
						local transNode = self.attacherTransNodes[attacherTransNode];
						
						if transNode.index ~= nil then
							setVisibility(transNode.index, getVisibility(backBottomArm.rotationNode));
						end;
					end;
				end;
				
				if self.movingTools ~= nil then
					for movingTool = 1, #self.movingTools do
						local tool = self.movingTools[movingTool];
					
						if self.movingParts ~= nil then
							for movingPart = 1, #self.movingParts do
								local part = self.movingParts[movingPart];
								
								if tool.node == backBottomArm.rotationNode and tool.dependentParts ~= nil then
									for _, dependentTool in pairs(tool.dependentParts) do
										if dependentTool.node == part.node and allowBackLinkageDismantle and self.doAllBackLinkageDependentPartsDismantle then
											setVisibility(dependentTool.node, not self.doBackLinkageDismantle);
											
											--## Part from Marhu, thank you!
											setAllDependentParts(dependentTool, not self.doBackLinkageDismantle);
										end;
									end;
								end;
							end;
						end;
					end;
				end;
				
				if playHydraulicSoundBackLinkage then
					setRotation(backBottomArm.rotationNode, math.rad(backBottomArm.curRotX), 0, 0);
				
					if self.setMovingToolDirty ~= nil then
						self:setMovingToolDirty(backBottomArm.rotationNode);
					end;
				end;
			end;
		end;
	end;
	
	if self.frontBottomArms ~= nil then
		for bottomArm = 1, #self.frontBottomArms do
			local frontBottomArm = self.frontBottomArms[bottomArm];
			
			if frontBottomArm.curRotX ~= nil and not self.doFrontLinkageDismantle then
				if self.setFrontLinkageDown then
					frontBottomArm.curRotX = math.min(frontBottomArm.curRotX + self.rotSpeedFront, self.maxRotFront);
					
					playHydraulicSoundFrontLinkage = frontBottomArm.curRotX < self.maxRotFront;
				else
					frontBottomArm.curRotX = math.max(frontBottomArm.curRotX - self.rotSpeedFront, frontBottomArm.startRotX);
					
					playHydraulicSoundFrontLinkage = frontBottomArm.curRotX > frontBottomArm.startRotX;
				end;
				
				if playHydraulicSoundFrontLinkage then
					setRotation(frontBottomArm.rotationNode, math.rad(frontBottomArm.curRotX), 0, 0);
				
					if self.setMovingToolDirty ~= nil then
						self:setMovingToolDirty(frontBottomArm.rotationNode);
					end;
				end;
			end;
			
			if frontBottomArm.rotationNode ~= nil then	
				setVisibility(frontBottomArm.rotationNode, not self.doFrontLinkageDismantle);
			end;
			
			if frontBottomArm.attacherJointIndex ~= nil then
				local x, y, z;
				
				if self.doFrontLinkageDismantle then	
					x, y, z = 0, 500, 0;
				else
					x, y, z = 0, 0, frontBottomArm.startTransZ;
				end;
				
				setTranslation(frontBottomArm.attacherJointIndex, x, y, z);
				
				--[[if self:getIsActiveForInput() then
					local x, y, z = getTranslation(frontBottomArm.attacherJointIndex);
				
					renderText(0.5, 0.5, 0.02, "attacher joint index trans: x = " .. x .. " y = " .. y .. " z = " .. z);
				end;]]
			end;
			
			if self.movingTools ~= nil then
				for movingTool = 1, #self.movingTools do
					local tool = self.movingTools[movingTool];
				
					if self.movingParts ~= nil then
						for movingPart = 1, #self.movingParts do
							local part = self.movingParts[movingPart];
							
							if tool.node == frontBottomArm.rotationNode and tool.dependentParts ~= nil then
								for _, dependentTool in pairs(tool.dependentParts) do
									if dependentTool.node == part.node and self.doAllFrontLinkageDependentPartsDismantle then
										setVisibility(dependentTool.node, not self.doFrontLinkageDismantle);
										
										--## Part from Marhu, thank you!
										setAllDependentParts(dependentTool, not self.doFrontLinkageDismantle);
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	
	if self:getIsActiveForSound() and self.sampleHydraulic2 ~= nil and self.sampleHydraulic2.sample ~= nil then
        if playHydraulicSoundBackLinkage or playHydraulicSoundFrontLinkage then
            if not self.sampleHydraulic2.isPlaying then
                Utils.playSample(self.sampleHydraulic2, 0, 0, nil);
            end;
        elseif self.sampleHydraulic2.isPlaying then
            Utils.stopSample(self.sampleHydraulic2, true);
        end;
	end;
	
	local object;
	local jointDesc;
	local pto;
	
	if self.attachedImplements ~= nil then
		for _, implement in pairs(self.attachedImplements) do
			object = implement.object;
			jointDesc = self.attacherJoints[implement.jointDescIndex];
			pto = object.attacherJoint.ptoInput;
			
			object.isItRunnerDLC = string.find(object.configFileName, "pdlc/itRunnerPack");
			
			if self:getIsActive() and not string.find(object.configFileName, "KroneKWT11x22") then	
				local allowAnimatePTO = false;
				
				if pto ~= nil then
					allowAnimatePTO = object:getIsPowerTakeoffActive() --## pto Power required
						or self.isTurnedOn --## Combine is on (rotate pto from the Cutter)
						or object.isItRunnerDLC and object.animations["unfoldHand"] ~= nil and object:getIsAnimationPlaying("unfoldHand") --## Lift/Sink IT Runner Container
						or object.isItRunnerDLC and object.animations["unloading"] ~= nil and object:getIsAnimationPlaying("unloading") --## Unload IT Runner Container
						or object.isFilling and SpecializationUtil.hasSpecialization(ManureBarrel, object.specializations) --## Refilling manure barrel
						or object.pipeIsUnloading --## Auger wagon is unloading
						or object.tipState ~= nil and object.tipState ~= Trailer.TIPSTATE_CLOSED --## trailer is unloading
						or object.isInWorkPosition --## Baleloader is in work position
					;	
				end;

				local ptoRootNode;
				local ptoAttachNode;
				
				if (jointDesc.ptoOutput and jointDesc.ptoOutput.rootNode and jointDesc.ptoOutput.attachNode) ~= nil then
					ptoRootNode = jointDesc.ptoOutput.rootNode;
					ptoAttachNode = jointDesc.ptoOutput.attachNode;
				end;
				
				if object.currentRotSpeedPTO == nil then
					object.currentRotSpeedPTO = 0;
				end;
				
				if object.vibrateFactorPTO == nil then
					object.vibrateFactorPTO = 0;
				end;
				
				if (ptoRootNode and ptoAttachNode) ~= nil and jointDesc.ptoActive then
					if object.ptoInput.node ~= nil then --and not SpecializationUtil.hasSpecialization(Mower, object.specializations) then		
						local rotX, rotY, rotZ = getRotation(object.ptoInput.node);
						
						rotX, rotY, rotZ = math.floor(math.deg(rotX)), math.floor(math.deg(rotY)), math.floor(math.deg(rotZ)); --## round down and convert from radians to degrees
						
						--[[if not object.hasPrint then
							print("tool/trailer pto node old rot x = " .. rotX .. " old rot y = " .. rotY .. " old rot z = " .. rotZ .. " in: " .. object.configFileName);
							
							object.hasPrint = true;
						end;]]
						
						if rotY == 0 then	
							if rotX ~= 0 and rotZ ~= 0 then	
								rotX = 180 - rotX;
							end;
							
							if not string.find(rotX, "-") then	
								rotX = -rotX;
							end;
							
							local parent = getParent(object.ptoInput.node);
							
							object.allowFixPTONode = true;
							
							if parent ~= nil then
								local parentRotX, parentRotY, parentRotZ = getRotation(parent);
						
								parentRotX, parentRotY, parentRotZ = math.floor(math.deg(parentRotX)), math.floor(math.deg(parentRotY)), math.floor(math.deg(parentRotZ)); --## round down and convert from radians to degrees
								
								--print("front pto parent node rot x = " ..parentRotX .. " rot y = " .. parentRotY .. " rot z = " .. parentRotZ);
								
								if (parentRotX and parentRotY and parentRotZ) ~= 0 then
									--## the parent node of the PTO Node is not to '0, 0, 0' rotatet, stop to apply the rotation fix here!!!
									--print("the parent node of the PTO Node is not to '0, 0, 0' rotatet, stop to apply the rotation fix here!!! (" .. object.configFileName .. ").");
									
									object.allowFixPTONode = false;
								end;
							end;
							
							if object.allowFixPTONode then
								--## fix false rotatet pto index on all implements/trailers
								
								setRotation(object.ptoInput.node, math.rad(rotX), math.rad(180), 0);
							
								--print("tool/trailer pto node new rot x = " .. rotX .. " new rot y = " .. rotY .. " new rot z = " .. rotZ .. " in: " .. object.configFileName);
							
								object.allowFixPTONode = false;
							end;
						end;
					end;
					
					if (object.ptoInput and object.ptoInput.rootNode) ~= nil then
						ptoRootNode = object.ptoInput.rootNode;
						ptoAttachNode = object.ptoInput.attachNode;
						
						if object.ptoInput.rotSpeed ~= 0 then
							object.ptoInput.rotSpeed = 0;
							--print("set pto rot speed in '" .. object.configFileName .. "' to '" .. object.ptoInput.rotSpeed .. "'.");
						end;
					end;
					
					if self.doRotatePTO and (jointDesc.ptoOutput and jointDesc.ptoOutput.rotation) ~= nil then
						if allowAnimatePTO and self.isMotorStarted then
							if self.findMinus then	
								object.currentRotSpeedPTO = math.max(object.currentRotSpeedPTO - self.fadeTimeTurnOnPTO, self.rotSpeedPTO);
							else
								object.currentRotSpeedPTO = math.min(object.currentRotSpeedPTO + self.fadeTimeTurnOnPTO, self.rotSpeedPTO);
							end;
						else
							if self.findMinus then	
								object.currentRotSpeedPTO = math.min(object.currentRotSpeedPTO + self.fadeTimeTurnOffPTO, 0);
							else
								object.currentRotSpeedPTO = math.max(object.currentRotSpeedPTO - self.fadeTimeTurnOffPTO, 0);
							end;
						end;
						
						jointDesc.ptoOutput.rotation = jointDesc.ptoOutput.rotation + object.currentRotSpeedPTO;
		
						setRotation(ptoRootNode, 0, 0, jointDesc.ptoOutput.rotation);
						setRotation(ptoAttachNode, 0, 0, jointDesc.ptoOutput.rotation);
					end;
				end;
				
				if self.doVibratePTO and (ptoRootNode and ptoAttachNode) ~= nil then				
					if allowAnimatePTO and self.isMotorStarted then		
						object.vibrateFactorPTO = math.min(object.vibrateFactorPTO + 0.0001, self.vibrateFactorPTO);
					else
						object.vibrateFactorPTO = math.max(object.vibrateFactorPTO - 0.00005, 0);
					end;
					
					local ptoRootNodeX, ptoRootNodeY, ptoRootNodeZ = getTranslation(ptoRootNode);
					local ptoAttachNodeX, ptoAttachNodeY, ptoAttachNodeZ = getTranslation(ptoAttachNode);
					
					local ptoRootNodeTranslation = {0, 0, ptoRootNodeZ};
					local ptoAttachNodeTranslation = {0, 0, ptoAttachNodeZ};
					
					if (ptoRootNodeX and ptoRootNodeY) < (object.vibrateFactorPTO / 2) then
						ptoRootNodeTranslation = {ptoRootNodeX + object.vibrateFactorPTO, ptoRootNodeY + object.vibrateFactorPTO, ptoRootNodeZ};
						ptoAttachNodeTranslation = {ptoAttachNodeX + object.vibrateFactorPTO, ptoAttachNodeY + object.vibrateFactorPTO, ptoAttachNodeZ};
					else
						ptoRootNodeTranslation = {ptoRootNodeX - object.vibrateFactorPTO, ptoRootNodeY - object.vibrateFactorPTO, ptoRootNodeZ};
						ptoAttachNodeTranslation = {ptoAttachNodeX - object.vibrateFactorPTO, ptoAttachNodeY - object.vibrateFactorPTO, ptoAttachNodeZ};
					end
					
					setTranslation(ptoRootNode, unpack(ptoRootNodeTranslation));
					setTranslation(ptoAttachNode, unpack(ptoAttachNodeTranslation));
				end;
				
				if self.testModeSBLU and object:getIsActiveForInput() then
					setTextColor(1, 1, 1, 1);
					setTextBold(true);
					setTextAlignment(RenderText.ALIGN_CENTER);
					
					local currentTextPosY = getCorrectTextSize(0.4);
					
					if #self.frontBottomArms > 0 then
						currentTextPosY = getCorrectTextSize(0.38);
					end;
					
					renderText(0.5, currentTextPosY, getCorrectTextSize(0.02), "fade time turn on tool pto = " .. self.fadeTimeTurnOnPTO);
					renderText(0.5, currentTextPosY - getCorrectTextSize(0.02), getCorrectTextSize(0.02), "fade time turn off tool pto = " .. self.fadeTimeTurnOffPTO);
					renderText(0.5, currentTextPosY - getCorrectTextSize(0.04), getCorrectTextSize(0.02), "current rot speed tool pto = " .. object.currentRotSpeedPTO);
					renderText(0.5, currentTextPosY - getCorrectTextSize(0.06), getCorrectTextSize(0.02), "max rot speed tool pto = " .. self.rotSpeedPTO);
					renderText(0.5, currentTextPosY - getCorrectTextSize(0.08), getCorrectTextSize(0.02), "vibrate factor tool pto = " .. object.vibrateFactorPTO);
					
					setTextBold(false);
					setTextAlignment(RenderText.ALIGN_LEFT);
				end;
			end;
		end;
	end;
	
	if self.setBackLinkageUp and self.doDismantleBackLinkageIfPTOIsNeeded and self.allowDismantleBackLinkage then
		if jointDesc ~= nil then	
			if (self.attachedTrailer and self.attachedTrailer.ptoAttachNode and pto) ~= nil then
				if self.isBurnerManualAttachingMod and not self.isWopsterManualAttachingMod then	
					--## Manual attaching support (from: Burner)
					self.doBackLinkageDismantle = getVisibility(self.attachedTrailer.ptoAttachNode);
				elseif not self.isBurnerManualAttachingMod and self.isWopsterManualAttachingMod then
					--## Manual attaching support (from: Wopster)
					self.doBackLinkageDismantle = self.attachedTrailer.jointDescPTO.ptoActive;
				end;
			end;
		end;
		
		if object ~= nil then
			if object.attachablePTO ~= nil then
				--## BJR manual attachable pto support
				self.doBackLinkageDismantle = object.attachablePTO.attached;
			elseif object.movingPartsPTOActive ~= nil and not self.isBurnerManualAttachingMod then
				--## Manual attaching support (from: Wopster) with MovingPartsPTO from rafftnix
				self.doBackLinkageDismantle = object.movingPartsPTOActive;
			end;
		end;
	end;
	
	if g_currentMission.blinkingWarning ~= nil and self.allowSkipWarning and InputBinding.hasEvent(InputBinding.SKIP_WARNING) then
		g_currentMission:showBlinkingWarning("", 0);
		
		self.allowSkipWarning = false;
	end;
end;

function SetBackLinkageUp:delete()
	if self.isClient and self.sampleHydraulic2 ~= nil then
        Utils.deleteSample(self.sampleHydraulic2);
	end;
end;

function SetBackLinkageUp:onDeactivateSounds()
    if self.isClient and self.sampleHydraulic2 ~= nil then
        Utils.stopSample(self.sampleHydraulic2);
	end;
end;

function SetBackLinkageUp:draw()
	if self:getIsActive() then
		if self.testModeSBLU then
			setTextColor(1, 1, 1, 1);
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_CENTER);
			
			local currentTextPosY = getCorrectTextSize(0.5);
			
			if #self.backBottomArms > 0 then
				renderText(getCorrectTextSize(0.5), getCorrectTextSize(0.5), getCorrectTextSize(0.02), "max rot = " .. self.maxRotBack);
				renderText(getCorrectTextSize(0.5), getCorrectTextSize(0.48), getCorrectTextSize(0.02), "current rot = " .. self.currentRotSBLU);
				renderText(getCorrectTextSize(0.5), getCorrectTextSize(0.46), getCorrectTextSize(0.02), "rot speed = " .. self.rotSpeedBack);
				renderText(getCorrectTextSize(0.5), getCorrectTextSize(0.44), getCorrectTextSize(0.02), "do back linkage dismantle = " .. tostring(self.doBackLinkageDismantle));
				renderText(getCorrectTextSize(0.5), getCorrectTextSize(0.42), getCorrectTextSize(0.02), "allow dismantle back linkage = " .. tostring(self.allowDismantleBackLinkage));
				
				currentTextPosY = getCorrectTextSize(0.4);
			end;
			
			if #self.frontBottomArms > 0 then
				renderText(getCorrectTextSize(0.5), currentTextPosY, getCorrectTextSize(0.02), "do front linkage dismantle = " .. tostring(self.doFrontLinkageDismantle));
			end;
			
			setTextBold(false);
			setTextAlignment(RenderText.ALIGN_LEFT);
		end;
		
		if self:getIsActiveForInput() then
			if self.attachedFrontTool == nil and self.attachedFL == nil and self.allowLiftSinkFrontLinkageManually and #self.frontBottomArms > 0 then
				if self.setFrontLinkageDown then
					g_currentMission:addHelpButtonText(Drivable.SET_FRONT_LINKAGE_UP, InputBinding.SET_FRONT_LINKAGE_DOWN_UP);
				else
					g_currentMission:addHelpButtonText(Drivable.SET_FRONT_LINKAGE_DOWN, InputBinding.SET_FRONT_LINKAGE_DOWN_UP);
				end;
			end;
			
			if self.attachedBackTool == nil and self.attachedTrailer == nil and self.allowLiftSinkBackLinkageManually and #self.backBottomArms > 0 then
				if self.setBackLinkageUp then
					g_currentMission:addHelpButtonText(Drivable.SET_BACK_LINKAGE_DOWN, InputBinding.SET_BACK_LINKAGE_DOWN_UP);
				else
					g_currentMission:addHelpButtonText(Drivable.SET_BACK_LINKAGE_UP, InputBinding.SET_BACK_LINKAGE_DOWN_UP);
				end;
			end;
		end;
	end;
	
	if g_currentMission.blinkingWarning ~= nil and self.allowSkipWarning then
		--g_currentMission:addExtraPrintText(Drivable.SKIP_WARNING);
	end;
end;

function SetBackLinkageUp:mouseEvent(posX, posY, isDown, isUp, button)end;
function SetBackLinkageUp:keyEvent(unicode, sym, modifier, isDown)end;