--[[
Spezialisierung die dafür sorgt, dass die standard Zapfwelle mit einer neuen getauscht wird.

Author:		Ifko[nator] 
Datum:		06.02.2016
Version:	1.0

History:	v1.0 @ 06.02.2016 - Erste Implementierung in den LS 15
]]


local newPTO_directory = g_currentModDirectory;
local currentModName = g_currentModName;
local modsDirectory = g_modsDirectory;

local modDesc = loadXMLFile("modDesc", newPTO_directory .. "modDesc.xml");
	
local newYellowPTOFilename = Utils.getFilename("PTO/powerTakeoff.i3d", newPTO_directory);
local newBlackPTOFilename = Utils.getFilename("PTO/powerTakeoffBlack.i3d", newPTO_directory);

local allowOverrideOriginalPTO = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp#allowOverrideOriginalPTO"), true);

--## Double Filename fix for mods. Inspired from the 'BaleExtension' Mod by Upsidedown.
local fixLoadSharedI3DFile = Utils.loadSharedI3DFile;
function Utils.loadSharedI3DFile(filename, baseDir, ...)
	local pos = string.find(filename, ":/", 1);
	if pos ~= nil then	
		baseDir = "";
	end;
	
	pos = string.find(filename, ":/", 3);
	
	if pos ~= nil then		
		filename = string.sub(filename, pos - 1);
	end;
	
	pos = string.find(filename, "/" .. currentModName .. "/PTO/");
	if pos ~= nil then
		if not fileExists(Utils.getNoNil(baseDir, "") .. filename) then
			baseDir = "";
			filename = modsDirectory .. string.sub(filename, pos + 1);
		end;
	end;
	
	local fixedFilename = fixLoadSharedI3DFile(filename, baseDir, ...);

	return fixedFilename;
end;

local oldloadSharedI3DFile = Utils.loadSharedI3DFile;
Utils.loadSharedI3DFile = function (filename, baseDir, ...)
	if allowOverrideOriginalPTO then
		if filename == "$data/vehicles/shared/powerTakeoff.i3d" then
			if newYellowPTOFilename ~= nil then
				filename = newYellowPTOFilename;
			end;
		elseif filename == "$data/vehicles/shared/powerTakeoffBlack.i3d" then
			if newBlackPTOFilename ~= nil then
				filename = newBlackPTOFilename;
			end;
		end;
	end;
	
	local newPTO_filename = oldloadSharedI3DFile(filename, baseDir, ...);
	
	return newPTO_filename;
end;