--[[
Spezialisierung zum rendern der Anzahl von verbleibenden Ballen für Folie und Garn auf den Bildschirm.

Author:	Ifko[nator]
Datum:	28.07.2016

Version:	v3.6

History:	v1.0 @ 18.09.2015 - initial implementation
			-------------------------------------------------------------------------------------------------------------------------
			v2.0 @ 29.09.2015 - the timing of the net wrap consumption has been adjusted, little bit dirty but it works
							  -	set correct rotation for the bale in the bale chamber --## removed in v3.5!
							  - bales will now added to the ingame stats, also the already pressed bales --## removed in v3.5!
			-------------------------------------------------------------------------------------------------------------------------
			v3.0 @ 03.10.2015 - set correct rotation for the middle net roll --## removed in v3.5!
							  - animated pickup roll when baler is filling --## removed in v3.5!
							  - bug fix for the case, the main chamber door is opening and the wrapper table is not rotated forwards --## removed in v3.5!
							  - bug fix for load the wrong bale size, little bit dirty but it works --## removed in v3.5!
			-------------------------------------------------------------------------------------------------------------------------
			v3.5 @ 22.07.2016 - support for the V2 of the Krone Ultima and removed some fixes, they are not longer needed here
			-------------------------------------------------------------------------------------------------------------------------
			v3.6 @ 28.07.2016 - add multifruit support for klee_windrow, luzerene_windrow, triticale_windrow, oat_windrow, rye_windrow, dinkel_windrow, sunflower_windrow and rape_windrow when avaiable on the current Map 
								info: more windrows can be in the modDesc file added
								fix for the pickup roll.. Now they will only rotate on filling
]]

KroneUltimaExtension = {};

local kroneUltimaExtension_directory = g_currentModDirectory;

local modDesc = loadXMLFile("modDesc", kroneUltimaExtension_directory .. "modDesc.xml");
local version = Utils.getNoNil(getXMLString(modDesc, "modDesc.version"), "!!! --->>> Missing 'version' attribute in modDesc file! <<<--- !!!");

print("### Krone Ultima Extension by Ifko[nator] in der Version: '" .. version .. "' erfolgreich geladen!");

delete(modDesc);

function KroneUltimaExtension.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Ultima, specializations);
end;

function KroneUltimaExtension:preLoad(xmlFile)
	if g_currentMission.ultimaExtensionCompatibleToV3 ~= nil then
		--## Info for BM Modding: Set 'g_currentMission.ultimaExtensionCompatibleToV3' in your Ultima.lua to false, to simply Stop my Script, if it makes Problems with an newer Version of your Baler.
		return;
	end;
	
	--## add new fillTypes to the KroneUltimaCF155XC.xml.
	
	local windrowsToAdd = "";
	local number = 4;
	
	local fileNameGrass = {};
	local fileNameGrassForWrapping = {};
	local wrappedFileNameGrass = {};
	
	fileNameGrass[0] = "bales/Bale130Grass.i3d";
	fileNameGrass[1] = "bales/Bale140Grass.i3d";
	fileNameGrass[2] = "bales/Bale150Grass.i3d";
	
	fileNameGrassForWrapping[0] = "bales/Bale130GrassWrap.i3d";
	fileNameGrassForWrapping[1] = "bales/Bale140GrassWrap.i3d";
	fileNameGrassForWrapping[2] = "bales/Bale150GrassWrap.i3d";
	
	wrappedFileNameGrass[0] = "bales/Bale130Silage.i3d";
	wrappedFileNameGrass[1] = "bales/Bale140Silage.i3d";
	wrappedFileNameGrass[2] = "bales/Bale150Silage.i3d";
	
	local fileNameStraw = {};
	
	fileNameStraw[0] = "bales/Bale130Straw.i3d";
	fileNameStraw[1] = "bales/Bale140Straw.i3d";
	fileNameStraw[2] = "bales/Bale150Straw.i3d";
	
	local modDesc = loadXMLFile("modDesc", kroneUltimaExtension_directory .. "modDesc.xml");
	local addBaleNumber = 0;
	
	while true do
		local setKey = "vehicle.Ultima.pickupEffects.pickupEffect(" .. tostring(number) .. ")";
		local getKey = "modDesc.ultima.addBale(" .. tostring(addBaleNumber) .. ")";
		
		if not hasXMLProperty(modDesc, getKey) then
			break;
		end;
		
		local fillType = Utils.getNoNil(getXMLString(modDesc, getKey .. "#fillType"), "No windrow given!");
		local isStrawBale = Utils.getNoNil(getXMLBool(modDesc, getKey .. "#isStrawBale"), false);
		
		if fillType == "" then
			fillType = "No windrow given!";
		end;
		
		--print("fillType = " .. tostring(fillType) .. " isStrawBale = " .. tostring(isStrawBale));
		
		local checkFillType = Fillable.fillTypeNameToInt[fillType];
		
		if checkFillType ~= nil then
			windrowsToAdd = windrowsToAdd .. " " .. fillType;
			
			setXMLString(xmlFile, setKey .. "#fillType", fillType);
			
			setXMLInt(xmlFile, setKey .. ".effectNode#node", 0);
			setXMLString(xmlFile, setKey .. ".effectNode#linkNode", "0>0|8|0|9");
			setXMLString(xmlFile, setKey .. ".effectNode#position", "0 0 0");
			
			if isStrawBale then
				setXMLString(xmlFile, setKey .. ".effectNode#filename", "kroneUltimaCF155XC/effects/pickupEffectWheat.i3d");	
			else
				setXMLString(xmlFile, setKey .. ".effectNode#filename", "kroneUltimaCF155XC/effects/pickupEffectGrass.i3d");
			end;
	
			for size = 0, 2 do
				local setKey = "vehicle.Ultima.baleSizes.baleSize(" .. tostring(size) .. ").fillTypes.fillType(" .. tostring(number) .. ")";
				
				setXMLString(xmlFile, setKey .. "#Ftype", fillType);

				if isStrawBale then
					setXMLString(xmlFile, setKey .. "#fileName", fileNameStraw[size]);
				else
					setXMLString(xmlFile, setKey .. "#fileName", fileNameGrass[size]);
					setXMLString(xmlFile, setKey .. "#fileNameForWrapping", fileNameGrassForWrapping[size]);
					setXMLString(xmlFile, setKey .. "#wrappedFileName", wrappedFileNameGrass[size]);
				end;
			end;
			
			number = number + 1;
		end;
		
		addBaleNumber = addBaleNumber + 1;
	end;
	
	delete(modDesc);
	
	if windrowsToAdd ~= "" then
		local addedWindrows = string.gsub(windrowsToAdd, "_windrow", "_windrow,");
	
		print("[INFO from the KroneUltimaExtension.lua]: Add now: '" .. string.sub(addedWindrows, 2, (string.len(addedWindrows) - 1)) .. "' to the Krone Ultima.");
		
		setXMLString(xmlFile, "vehicle.fillTypes#fillTypes", "wheat_windrow barley_windrow grass_windrow dryGrass_windrow" .. windrowsToAdd);
	end;
	
	self.loadSpeedRotatingPartFromXML = Utils.overwrittenFunction(self.loadSpeedRotatingPartFromXML, KroneUltimaExtension.loadSpeedRotatingPartFromXML);
end;

function KroneUltimaExtension:load(xmlFile)
	if g_currentMission.ultimaExtensionCompatibleToV3 ~= nil then
		return;
	end;
	
	if not g_currentMission.ultimaExtensionCompatibleToV2 then
		g_currentMission.ultimaExtensionCompatibleToV2 = "Hell yeah! Thanks to BM-Modding for adding this variable in the Ultima.lua!";
	end;
	
	local modDesc = loadXMLFile("modDesc", kroneUltimaExtension_directory .. "modDesc.xml");
	local allowWrapStrawBales = Utils.getNoNil(getXMLBool(modDesc, "modDesc.ultima#allowWrapStrawBales"), true);
	
	if allowWrapStrawBales then
		local wheat_windrow = Fillable.fillTypeNameToInt["wheat_windrow"];
		local barley_windrow = Fillable.fillTypeNameToInt["barley_windrow"];
		local grass_windrow = Fillable.fillTypeNameToInt["grass_windrow"];
		
		local strawBalesToMakeWrapAble = "wheat_windrow, barley_windrow,";
		
		local fileNameForWrapping = {};
		
		fileNameForWrapping[1] = Utils.getFilename("bales/Bale130StrawWrap.i3d", kroneUltimaExtension_directory);
		fileNameForWrapping[2] = Utils.getFilename("bales/Bale140StrawWrap.i3d", kroneUltimaExtension_directory);
		fileNameForWrapping[3] = Utils.getFilename("bales/Bale150StrawWrap.i3d", kroneUltimaExtension_directory);
	
		if (fileNameForWrapping[1] and fileNameForWrapping[2] and fileNameForWrapping[3]) ~= nil then
			for size = 1, 3 do	
				self.baleSizes[size].fillTypes[wheat_windrow].isWrapAble = true;
				self.baleSizes[size].fillTypes[wheat_windrow].fileNameForWrapping = fileNameForWrapping[size];
				self.baleSizes[size].fillTypes[wheat_windrow].wrappedFileName = self.baleSizes[size].fillTypes[grass_windrow].wrappedFileName;
				
				self.baleSizes[size].fillTypes[barley_windrow].isWrapAble = true;
				self.baleSizes[size].fillTypes[barley_windrow].fileNameForWrapping = fileNameForWrapping[size];
				self.baleSizes[size].fillTypes[barley_windrow].wrappedFileName = self.baleSizes[size].fillTypes[grass_windrow].wrappedFileName;
			
			end;
			
			local addBaleNumber = 0;
	
			while true do
				local getKey = "modDesc.ultima.addBale(" .. tostring(addBaleNumber) .. ")";
				
				if not hasXMLProperty(modDesc, getKey) then
					break;
				end;
				
				local fillType = Utils.getNoNil(getXMLString(modDesc, getKey .. "#fillType"), "No windrow given!");
				local isStrawBale = Utils.getNoNil(getXMLBool(modDesc, getKey .. "#isStrawBale"), false);
				
				if fillType == "" then
					fillType = "No windrow given!";
				end;
				
				local checkFillType = Fillable.fillTypeNameToInt[fillType];
				
				if checkFillType ~= nil and isStrawBale then
					strawBalesToMakeWrapAble = strawBalesToMakeWrapAble .. " " .. fillType .. ",";
					
					for size = 1, 3 do	
						self.baleSizes[size].fillTypes[checkFillType].isWrapAble = true;
						self.baleSizes[size].fillTypes[checkFillType].fileNameForWrapping = fileNameForWrapping[size];
						self.baleSizes[size].fillTypes[checkFillType].wrappedFileName = self.baleSizes[size].fillTypes[grass_windrow].wrappedFileName;
					end;
				end;
				
				addBaleNumber = addBaleNumber + 1;
			end;
			
			print("[INFO from the KroneUltimaExtension.lua]: Enable wrapping now for: '" .. string.sub(strawBalesToMakeWrapAble, 0, (string.len(strawBalesToMakeWrapAble) - 1)) .. "' with the Krone Ultima.");
		else
			print("[ERROR from the KroneUltimaExtension.lua]: Cant load Bales for Straw wrapping! Disable wrapping for Strawbales now!");
		end;
	end;
	
	self.hudPosYCamOff = Utils.getNoNil(getXMLString(modDesc, "modDesc.ultima#hudPosYCamOff"), 0.356);
	self.hudPosYCamOn = Utils.getNoNil(getXMLString(modDesc, "modDesc.ultima#hudPosYCamOn"), 0.53);
	self.hudPosY = self.hudPosYCamOff;
	self.hudPosYHideGUI = g_currentMission.vehicleHudPosY + g_currentMission.vehicleBaseHudHeight + g_currentMission.hudBackgroundHeight;
	
	delete(modDesc);
	
	self.hudWidth = 0.0335;
	self.hudHeight = 0.045;
	
	self.hudFoilPosX = 0.826;
	self.hudNetPosX = 0.915;
	
	self.hudOverlayFoilFilename = Utils.getFilename("baleFoil.dds", kroneUltimaExtension_directory);
	self.hudOverlayFoilCamOffOverlay = Overlay:new("hudOverlayFoilCamOffOverlay", self.hudOverlayFoilFilename, self.hudFoilPosX, self.hudPosYCamOff, self.hudWidth, self.hudHeight);
	self.hudOverlayFoilCamOnOverlay = Overlay:new("hudOverlayFoilCamOnOverlay", self.hudOverlayFoilFilename, self.hudFoilPosX, self.hudPosYCamOn, self.hudWidth, self.hudHeight);
	self.hudOverlayFoilHideGUIOverlay = Overlay:new("hudOverlayFoilHideGUIOverlay", self.hudOverlayFoilFilename, self.hudFoilPosX, self.hudPosYHideGUI, self.hudWidth, self.hudHeight);
	
	self.hudOverlayNetFilename = Utils.getFilename("baleNet.dds", kroneUltimaExtension_directory);
	self.hudOverlayNetCamOffOverlay = Overlay:new("hudOverlayNetCamOffOverlay", self.hudOverlayNetFilename, self.hudNetPosX, self.hudPosYCamOff, self.hudWidth, self.hudHeight);
	self.hudOverlayNetCamOnOverlay = Overlay:new("hudOverlayNetCamOnOverlay", self.hudOverlayNetFilename, self.hudNetPosX, self.hudPosYCamOn, self.hudWidth, self.hudHeight);
	self.hudOverlayNetHideGUIOverlay = Overlay:new("hudOverlayNetHideGUIOverlay", self.hudOverlayNetFilename, self.hudNetPosX, self.hudPosYHideGUI, self.hudWidth, self.hudHeight);
	
	self.hudBackgroundWidth = g_currentMission.hudBackgroundWidth + 1;
	
	self.hudOverlayBackgroundFilename = Utils.getFilename("background.dds", kroneUltimaExtension_directory);
	self.hudOverlayBackgroundCamOff = Overlay:new("hudOverlayBackgroundCamOff", self.hudOverlayBackgroundFilename, self.hudFoilPosX, self.hudPosYCamOff, self.hudBackgroundWidth, self.hudHeight);
	self.hudOverlayBackgroundCamOn = Overlay:new("hudOverlayBackgroundCamOn", self.hudOverlayBackgroundFilename, self.hudFoilPosX, self.hudPosYCamOn, self.hudBackgroundWidth, self.hudHeight);
	self.hudOverlayBackgroundHideGUI = Overlay:new("hudOverlayBackgroundHideGUI", self.hudOverlayBackgroundFilename, self.hudFoilPosX, self.hudPosYHideGUI, self.hudBackgroundWidth, self.hudHeight);

	self.netBindingStart = Utils.appendedFunction(self.netBindingStart, KroneUltimaExtension.netBindingStart);
	self.dropBaleStart = Utils.appendedFunction(self.dropBaleStart, KroneUltimaExtension.dropBaleStart);
	
	self.netPerBale = 0;
	
	self.showFoilAndNetHud = true;
	
	for _, workArea in pairs(self.workAreas) do
		--print("--## set Tanslation for workArea start");
		setTranslation(workArea.start, 1.5, 0, 0);
		--print("--## set Tanslation for workArea width");
		setTranslation(workArea.width, -1.5, 0, 0);
		--print("--## set Tanslation for workArea height");
		setTranslation(workArea.height, 1.5, 0, -0.75);
	end;
	
	self.getIsSpeedRotatingPartActive = Utils.overwrittenFunction(self.getIsSpeedRotatingPartActive, KroneUltimaExtension.getIsSpeedRotatingPartActive);
end;

function KroneUltimaExtension:loadSpeedRotatingPartFromXML(superFunc, speedRotatingPart, xmlFile, key)
    --print("--## using: 'KroneUltimaExtension:loadSpeedRotatingPartFromXML'.");
	
	if superFunc ~= nil then
        if not superFunc(self, speedRotatingPart, xmlFile, key) then
            return false;
        end;
    end;
	
    speedRotatingPart.rotateOnlyIfFillLevelIncreased = Utils.getNoNil(getXMLBool(xmlFile, key .. "#rotateOnlyIfFillLevelIncreased"), false);
    
	return true;
end

function KroneUltimaExtension:getIsSpeedRotatingPartActive(superFunc, speedRotatingPart)
    --print("--## using: 'KroneUltimaExtension:getIsSpeedRotatingPartActive'.");
	
	if speedRotatingPart.rotateOnlyIfFillLevelIncreased ~= nil and speedRotatingPart.rotateOnlyIfFillLevelIncreased then
		for fillType, effect in pairs(self.pickupEffects) do
			if fillType == self.currentFillType then
				--renderText(0.5, 0.5, 0.02, "effect.isActive = " .. tostring(effect.isActive));		
				
				return effect.isActive;
			end;
		end;
    end;
	
    if superFunc ~= nil then
        return superFunc(self, speedRotatingPart);
    end;
	
    return true;
end;

function KroneUltimaExtension:netBindingStart()
	--print("--## using: 'KroneUltimaExtension:netBindingStart'.");
	
	--## dirty hack do stop the count down of the net wrap bale count when the net bindig starts .. (simply add the net to the net role that was removed from the Ultima.lua)
	if self.isServer then
		if self.netRoleTop.length > 0 then
			self:setNetRoleFillState(self.netRoleTop.length + self.netPerBale);
		end;
	end;
end;

function KroneUltimaExtension:dropBaleStart()
	--print("--## using: 'KroneUltimaExtension:dropBaleStart'.");
	if self.isServer then
		--## now, when the net binding is finished, the counter for the net wrap bales will be set down ..
		self:setNetRoleFillState(self.netRoleTop.length - self.netPerBale);
	end;
end;

function KroneUltimaExtension:update(dt)
	if g_currentMission.ultimaExtensionCompatibleToV3 ~= nil then
		return;
	end;
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_FOIL_AND_NET_COUNTER_HUD) then
			self.showFoilAndNetHud = not self.showFoilAndNetHud;
		end;
	end;
end;

function KroneUltimaExtension:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if g_currentMission.ultimaExtensionCompatibleToV3 ~= nil then
		return nil;
	end;
	
	if not resetVehicles then
		self.showFoilAndNetHud = Utils.getNoNil(getXMLBool(xmlFile, key .. "#showFoilAndNetHud"), self.showFoilAndNetHud);
	end;

	return BaseMission.VEHICLE_LOAD_OK;
end;

function KroneUltimaExtension:getSaveAttributesAndNodes(nodeIdent)
    if g_currentMission.ultimaExtensionCompatibleToV3 ~= nil then
		return nil, nil;
	end;
	
	local attributes = 'showFoilAndNetHud="' .. tostring(self.showFoilAndNetHud) .. '"';

	return attributes, nil;
end;

function KroneUltimaExtension:draw()
	if g_currentMission.ultimaExtensionCompatibleToV3 ~= nil then
		g_currentMission:showBlinkingWarning(Fillable.UltimaExtensionNotCompatibleToV3, 1);
		
		return;
	end;
	
	if self:getIsActive() then
		if self.showFoilAndNetHud then
			g_currentMission:addHelpButtonText(Fillable.HIDE_FOIL_AND_NET_COUNTER_HUD, InputBinding.TOGGLE_FOIL_AND_NET_COUNTER_HUD);
			
			if not self.hud.hideGUI then	
				if self.workCamera ~= nil and self.workCamera.baseElement ~= nil then
					if self.workCamera.baseElement.visibility then
						self.hudOverlayBackgroundCamOn:render();
						self.hudOverlayFoilCamOnOverlay:render();
						self.hudOverlayNetCamOnOverlay:render();
						
						self.hudPosY = self.hudPosYCamOn;
					else
						self.hudOverlayBackgroundCamOff:render();
						self.hudOverlayFoilCamOffOverlay:render();
						self.hudOverlayNetCamOffOverlay:render();
					
						self.hudPosY = self.hudPosYCamOff;
					end;
				end;
			else
				self.hudOverlayBackgroundHideGUI:render();
				self.hudOverlayFoilHideGUIOverlay:render();
				self.hudOverlayNetHideGUIOverlay:render();
			
				self.hudPosY = self.hudPosYHideGUI;
			end;
		
			setTextAlignment(RenderText.ALIGN_CENTER);
			
			local foilLength = self.wrapperFoilHolders[1].remainingFoilLength * 2;
			local foilPerBale = self.baseFoilUsePerBale * self.baleSizes[self.baleSizeIndex].size;		
			local numLeftBalesFoil = math.ceil(foilLength / foilPerBale);
			
			local textSize = getCorrectTextSize(0.028);
			local offsetX = 0.06;
			local offsetY = 0.014;
			
			if numLeftBalesFoil <= 5 then
				setTextColor(0.95, 0, 0, 1);
			else
				setTextColor(1, 1, 1, 1);
			end;
	
			renderText(self.hudFoilPosX + offsetX, self.hudPosY + offsetY, textSize, tostring(numLeftBalesFoil));
	
			self.netPerBale = math.max(1, self.baleSizes[self.baleSizeIndex].size * math.pi * self.numNetWraps);
			
			local numLeftBalesNet = math.floor(self.netRoleTop.length / self.netPerBale);
			
			if numLeftBalesNet <= 5 then
				setTextColor(0.95, 0, 0, 1);
			else
				setTextColor(1, 1, 1, 1);
			end;
			
			setVisibility(self.netRoleTop.role, numLeftBalesNet > 0);
			
			if numLeftBalesNet == 0 then
				self.netRoleTop.length = 0;
				g_currentMission:addExtraPrintText(Fillable.YOU_CAN_REFILL_THE_NET_NOW);
			end;
			
			renderText(self.hudNetPosX + offsetX, self.hudPosY + offsetY, textSize, tostring(numLeftBalesNet));
		else
			g_currentMission:addHelpButtonText(Fillable.SHOW_FOIL_AND_NET_COUNTER_HUD, InputBinding.TOGGLE_FOIL_AND_NET_COUNTER_HUD);
		end;
	end;
	
	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextColor(1, 1, 1, 1);
end;

function KroneUltimaExtension:delete()end;
function KroneUltimaExtension:mouseEvent(posX, posY, isDown, isUp, button)end;
function KroneUltimaExtension:keyEvent(unicode, sym, modifier, isDown)end;