--[[
	KroneUltimaBugFix.lua
	
	Autor: Ifko[nator]
	Datum: 25.07.2016

	Fix errors:
 
	'Error: Running LUA method 'loadSharedI3DFileFinished'.
	C:/Users/USER_NAME/Documents/My Games/FarmingSimulator2015/mods//KroneUltimaCF155XC/specializations/Ultima.lua:1861: attempt to index field 'wrapperCurrentBale' (a nil value)'

	'Error: Running LUA method 'loadSharedI3DFileFinished'.
	C:/Users/USER_NAME/Documents/My Games/FarmingSimulator2015/mods//KroneUltimaCF155XC/specializations/Ultima.lua:1620: attempt to index field 'wrapperCurrentBale' (a nil value)'
]]
	
for index = 1, 20 do --## go through all 20 possible savgames ..
	savegameFolderPath = string.format("%ssavegame%d", getUserProfileAppPath(), index);

	if fileExists(savegameFolderPath .. "/vehicles.xml") then
		--print("found vehicles.xml: " .. savegameFolderPath .. "/vehicles.xml :)");
		local vehicles = loadXMLFile("vehicles", savegameFolderPath .. "/vehicles.xml", "careerVehicles");
		
		local i = 0;
	
		while true do
			local baseString = string.format("careerVehicles.vehicle(%d)", i);
			
			if not hasXMLProperty(vehicles, baseString) then
				break;
			end;
			
			local id = getXMLInt(vehicles, baseString .. "#id");
			local filename = getXMLString(vehicles, baseString .. "#filename");
			
			--[[
			print("----------------------------------- vehicle " .. i .. " -----------------------------------");
			print("id is " .. id);
			print("filename is " .. tostring(filename));
			]]
			
			if string.find(filename, "KroneUltimaCF155XC.xml") then
				local balerState = Utils.getNoNil(getXMLInt(vehicles,  baseString .. "#balerState"), 1);
				local wrapperState = Utils.getNoNil(getXMLInt(vehicles,  baseString .. "#wrapperState"), 1);
				local doSave = wrapperState ~= 1 or balerState ~= 1;
				
				--[[
				print("wrapperState is " .. wrapperState);
				print("balerState is " .. balerState);
				]]
				
				if wrapperState ~= 1 then
					setXMLInt(vehicles,  baseString .. "#wrapperState", 1);
					
					--[[
					print("set wrapperState to " .. getXMLInt(vehicles,  baseString .. "#wrapperState") .. " in " .. savegameFolderPath .. "/vehicles.xml");
				else
					print("set wrapperState not to 1");
					]]
				end;
				
				if balerState ~= 1 then
					setXMLInt(vehicles,  baseString .. "#balerState", 1);
					--[[	
					print("set balerState to " .. getXMLInt(vehicles,  baseString .. "#balerState") .. " in " .. savegameFolderPath .. "/vehicles.xml");
				else
					print("set balerState not to 1");
					]]
				end;
				
				if doSave then
					saveXMLFile(vehicles);
				end;
			end;
			
			--print("");
			
			i = i + 1;
		end;
	end;
end;