--[[
newHelpHudColors

Author:  Ifko[nator]
Date:	 08.05.2015
Version: 2.0

Mit diesem Script kann man das Hilfefenster und die darin enthaltene Schrift in eine neue Farbe einfärben. (Konfigurierbar in der modDesc dieser zip.)

]]

NewHelpHudColor = {};

local currentModDirectory = g_currentModDirectory;

function NewHelpHudColor:loadMap()
	if g_currentMission ~= nil then --## 'g_currentMission' should here NEVER be nil, but save is save ...
		local modDesc = loadXMLFile("modDesc", currentModDirectory .. "modDesc.xml");
		local version = Utils.getNoNil(getXMLString(modDesc, "modDesc.version"), "!!! --->>> Missing 'version' attribute in modDesc file! <<<--- !!!");

		print("");
		print("### NewHelpHudColor Script by Ifko[nator] in der Version: '" .. version .. "' erfolgreich geladen!");
		print("");
		
		self.hudHelpTopOverlay = Utils.getVectorNFromString(Utils.getNoNil(getXMLString(modDesc, "modDesc.newHelpHudColors.hudHelpTopOverlay#color"), "0.0103 0.0103 0.0103 0.9"), 4);
		self.hudHelpContentOverlay = Utils.getVectorNFromString(Utils.getNoNil(getXMLString(modDesc, "modDesc.newHelpHudColors.hudHelpContentOverlay#color"), "0.5105 0.5315 0.5583 1"), 4);
		self.hudHelpTextColor = Utils.getVectorNFromString(Utils.getNoNil(getXMLString(modDesc, "modDesc.newHelpHudColors.hudHelpText#color"), "0.0137 0.016 0.0194 1"), 4)
		self.hudHelpSizeMax = Utils.round(Utils.getNoNil(getXMLFloat(modDesc, "modDesc.newHelpHudColors#hudHelpSizeMax"), 1.25), 2);
		self.hudHelpSizeMin = Utils.round(Utils.getNoNil(getXMLFloat(modDesc, "modDesc.newHelpHudColors#hudHelpSizeMin"), 0.85), 2);
		self.hudHelpSizeStep = Utils.round(Utils.getNoNil(getXMLFloat(modDesc, "modDesc.newHelpHudColors#hudHelpSizeStep"), 0.05), 2);
		
		self.allowChangeTimeAndMoneyHud = Utils.getNoNil(getXMLBool(modDesc, "modDesc.newHelpHudColors#stopChangeTimeAndMoneyHud"), true);
		self.allowChangeHudHelpSize = Utils.getNoNil(getXMLBool(modDesc, "modDesc.newHelpHudColors#allowChangeHudHelpSize"), true);

		delete(modDesc);
		
		if self.allowChangeHudHelpSize then
			if self.hudHelpSizeMax < 1 and not string.find(self.hudHelpSizeMax, "-") then
				local hudHelpSizeMaxOld = self.hudHelpSizeMax;
				
				self.hudHelpSizeMax = 1.25;
			
				print("Info from the NewHelpHudColor Script: The Value from hudHelpSizeMax ('" .. hudHelpSizeMaxOld .. "') is too small! The Value was set to ('" .. self.hudHelpSizeMax .. "')!");
			elseif string.find(self.hudHelpSizeMax, "-") then	
				local hudHelpSizeMaxOld = self.hudHelpSizeMax;
				
				self.hudHelpSizeMax = tonumber(string.sub(self.hudHelpSizeMax, 2));
				
				print("Info from the NewHelpHudColor Script: Found '-' in the Value from hudHelpSizeMax ('" .. hudHelpSizeMaxOld .. "')! The Value was set to ('" .. self.hudHelpSizeMax .. "')!");
			end;
			
			if self.hudHelpSizeMin > 1 then
				local hudHelpSizeMinOld = self.hudHelpSizeMin;
				
				self.hudHelpSizeMin = 0.85;
			
				print("Info from the NewHelpHudColor Script: The Value from hudHelpSizeMin ('" .. hudHelpSizeMinOld .. "') is too big! The Value was set to ('" .. self.hudHelpSizeMin .. "')!");
			elseif string.find(self.hudHelpSizeMin, "-") then	
				local hudHelpSizeMinOld = self.hudHelpSizeMin;
				
				self.hudHelpSizeMin = tonumber(string.sub(self.hudHelpSizeMin, 2));
				
				print("Info from the NewHelpHudColor Script: Found '-' in the Value from hudHelpSizeMin ('" .. hudHelpSizeMinOld .. "')! The Value was set to ('" .. self.hudHelpSizeMin .. "')!");
			end;
			
			if string.find(self.hudHelpSizeStep, "-") then	
				local hudHelpSizeStepOld = self.hudHelpSizeStep;
				
				self.hudHelpSizeStep = tonumber(string.sub(self.hudHelpSizeStep, 2));
				
				print("Info from the NewHelpHudColor Script: Found '-' in the Value from hudHelpSizeStep ('" .. hudHelpSizeStepOld .. "')! The Value was set to ('" .. self.hudHelpSizeStep .. "')!");
			end;
			
			local maxHudHelpSizeStepsUp = (self.hudHelpSizeMax - 1) / self.hudHelpSizeStep;
			local maxHudHelpSizeStepsDown = (1 - self.hudHelpSizeMin) / self.hudHelpSizeStep;
			local startHudHelpSize = self.hudHelpSizeMin + (self.hudHelpSizeStep * maxHudHelpSizeStepsDown);
			
			if string.find(maxHudHelpSizeStepsDown, ".") then
				maxHudHelpSizeStepsDown = math.ceil(maxHudHelpSizeStepsDown);
			end;
			
			self.maxHudHelpSizeSteps = maxHudHelpSizeStepsUp + maxHudHelpSizeStepsDown;
			
			if string.find(self.maxHudHelpSizeSteps, ".") then
				self.maxHudHelpSizeSteps = math.ceil(self.maxHudHelpSizeSteps);
			end;
			
			local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory;
			
			if savegameFolderPath == nil then
				local savegameIndex = g_currentMission.missionInfo.savegameIndex;
				
				savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), savegameIndex);
			end;
			
			if fileExists(savegameFolderPath .. '/careerSavegame.xml') then
				local careerSavegame = loadXMLFile("careerSavegame", savegameFolderPath .. "/careerSavegame.xml");

				self.hudHelpSize = Utils.getNoNil(getXMLFloat(careerSavegame, "careerSavegame#hudHelpSize"), startHudHelpSize);
				self.currentHelpSizeStep = Utils.getNoNil(getXMLFloat(careerSavegame, "careerSavegame#currentHelpSizeStep"), maxHudHelpSizeStepsDown);
				
				if self.hudHelpSize > self.hudHelpSizeMax then
					print("Info from the NewHelpHudColor Script: The Value from hudHelpSize ('" .. self.hudHelpSize .. "') is bigger as the Value from hudHelpSizeMax ('" .. self.hudHelpSizeMax .. "')! The Value was set to ('" .. self.hudHelpSizeMax .. "')!");
					print("Info from the NewHelpHudColor Script: The Value from currentHelpSizeStep ('" .. self.currentHelpSizeStep .. "') was set to ('" .. self.maxHudHelpSizeSteps .. "') to prevent conflicts!");
					
					self.hudHelpSize = self.hudHelpSizeMax;
					self.currentHelpSizeStep = self.maxHudHelpSizeSteps;
				elseif self.hudHelpSize < self.hudHelpSizeMin then
					print("Info from the NewHelpHudColor Script: The Value from hudHelpSize ('" .. self.hudHelpSize .. "') is smaller as the Value from hudHelpSizeMin ('" .. self.hudHelpSizeMin .. "')! The Value was set to ('" .. self.hudHelpSizeMin .. "')!");
					print("Info from the NewHelpHudColor Script: The Value from currentHelpSizeStep ('" .. self.currentHelpSizeStep .. "') was set to ('0') to prevent conflicts!");
					
					self.hudHelpSize = self.hudHelpSizeMin;
					self.currentHelpSizeStep = 0;
				end;
				
				if self.currentHelpSizeStep > self.maxHudHelpSizeSteps then
					print("Info from the NewHelpHudColor Script: The Value from currentHelpSizeStep ('" .. self.currentHelpSizeStep .. "') is bigger as the Value from maxHudHelpSizeSteps ('" .. self.maxHudHelpSizeSteps .. "')! The Value was set to ('" .. self.maxHudHelpSizeSteps .. "')!");
					print("Info from the NewHelpHudColor Script: The Value from hudHelpSize ('" .. self.hudHelpSize .. "') was set to ('" .. self.hudHelpSizeMax .. "') to prevent conflicts!");
					
					self.currentHelpSizeStep = self.maxHudHelpSizeSteps;
					self.hudHelpSize = self.hudHelpSizeMax;
				elseif self.currentHelpSizeStep < 0 then
					print("Info from the NewHelpHudColor Script: The Value from currentHelpSizeStep ('" .. self.currentHelpSizeStep .. "') is smaller as ('0')! The Value was set to ('0')!");
					print("Info from the NewHelpHudColor Script: The Value from hudHelpSize ('" .. self.hudHelpSize .. "') was set to ('" .. self.hudHelpSizeMin .. "') to prevent conflicts!");
					
					self.currentHelpSizeStep = 0;
					self.hudHelpSize = self.hudHelpSizeMin;
				end;
	
				delete(careerSavegame);
			else
				self.hudHelpSize = startHudHelpSize;
				self.currentHelpSizeStep = maxHudHelpSizeStepsDown;
			end;
			
			self.hudHelpTextSizeOld = g_currentMission.hudHelpTextSize;
			self.hudHelpTextLineSpacingOld = g_currentMission.hudHelpTextLineSpacing;
			self.hudHelpTextMaxHeightOld = g_currentMission.hudHelpTextMaxHeight;
			self.hudHelpTextPosX1Old = g_currentMission.hudHelpTextPosX1;
			self.hudHelpTextPosX2Old = g_currentMission.hudHelpTextPosX2;
			self.hudHelpContentWidthOld = g_currentMission.hudHelpContentWidth;
			self.hudHelpContentHeightOld = g_currentMission.hudHelpContentHeight;
			
			g_careerScreen.saveSavegame = Utils.appendedFunction(g_careerScreen.saveSavegame, NewHelpHudColor.saveSavegame);
		end;
		
		g_currentMission.hudHelpTopTextSize = 0;

		g_currentMission.hudHelpTopOverlay:setColor(self.hudHelpTopOverlay[1], self.hudHelpTopOverlay[2], self.hudHelpTopOverlay[3], self.hudHelpTopOverlay[4]);
		g_currentMission.hudHelpContentOverlay:setColor(self.hudHelpContentOverlay[1], self.hudHelpContentOverlay[2], self.hudHelpContentOverlay[3], self.hudHelpContentOverlay[4]);
		g_currentMission.hudWarningBaseOverlay:setColor(self.hudHelpContentOverlay[1], self.hudHelpContentOverlay[2], self.hudHelpContentOverlay[3], self.hudHelpContentOverlay[4]);
		g_currentMission.hudHelpTextColor = {self.hudHelpTextColor[1], self.hudHelpTextColor[2], self.hudHelpTextColor[3], self.hudHelpTextColor[4]};
		g_currentMission.hudHelpSeperatorOverlay:setColor(self.hudHelpTextColor[1], self.hudHelpTextColor[2], self.hudHelpTextColor[3], self.hudHelpTextColor[4]);
		
		if self.allowChangeTimeAndMoneyHud then
			self.timeTextSize = g_currentMission.timeTextSize;
			self.moneyTextSize = g_currentMission.moneyTextSize;
			self.timeScaleTextSize = g_currentMission.timeScaleTextSize;
			
			g_currentMission.timeTextSize = 0;
			g_currentMission.moneyTextSize = 0;
			g_currentMission.timeScaleTextSize = 0;

			g_currentMission.timeScaleIconOverlay:setColor(self.hudHelpTextColor[1], self.hudHelpTextColor[2], self.hudHelpTextColor[3], self.hudHelpTextColor[4]);
			g_currentMission.timeScaleOverlay:setColor(self.hudHelpTextColor[1], self.hudHelpTextColor[2], self.hudHelpTextColor[3], self.hudHelpTextColor[4]);
			
			g_currentMission.weatherTimeBackgroundOverlay:setColor(self.hudHelpContentOverlay[1], self.hudHelpContentOverlay[2], self.hudHelpContentOverlay[3], self.hudHelpContentOverlay[4]);
			g_currentMission.moneyBackgroundOverlay:setColor(self.hudHelpTopOverlay[1], self.hudHelpTopOverlay[2], self.hudHelpTopOverlay[3], self.hudHelpTopOverlay[4]);
		end;
	end;
end;

function NewHelpHudColor:saveSavegame()
	local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory;
	
	if savegameFolderPath == nil then
		local savegameIndex = g_currentMission.missionInfo.savegameIndex;
	
		savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), savegameIndex);
	end;

	if fileExists(savegameFolderPath .. '/careerSavegame.xml') then 
		local careerSavegame = loadXMLFile("careerSavegame", savegameFolderPath .. "/careerSavegame.xml");
	
		setXMLFloat(careerSavegame, "careerSavegame#hudHelpSize", NewHelpHudColor.hudHelpSize);
		setXMLFloat(careerSavegame, "careerSavegame#currentHelpSizeStep", NewHelpHudColor.currentHelpSizeStep);
		
		saveXMLFile(careerSavegame);
		delete(careerSavegame);
	end;
end;

function NewHelpHudColor:update(dt)
	if g_currentMission ~= nil and g_currentMission.isRunning and g_currentMission.showHudEnv and g_gui.currentGui == nil then
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(unpack(g_currentMission.hudHelpTextColor));
		setTextBold(true);
		
		if self.allowChangeHudHelpSize then	
			local addValue = 0.95;
			local addValueTextPosX2AndWidth = 1.2;
			local addValueTextSize;
			
			if self.hudHelpSize == 1 then
				addValueTextSize = 1.1;
			else
				addValueTextSize = 1.25;
			end;
			
			if not hasMapRunFirstTime then
				g_currentMission.hudHelpTextSize = self.hudHelpTextSizeOld * (self.hudHelpSize * addValueTextSize);
				g_currentMission.hudHelpTextLineSpacing = self.hudHelpTextLineSpacingOld * (self.hudHelpSize * addValue);
				g_currentMission.hudHelpTextPosX1 = self.hudHelpTextPosX1Old * (self.hudHelpSize * addValue);
				g_currentMission.hudHelpTextPosX2 = self.hudHelpTextPosX2Old * (self.hudHelpSize * addValue * addValueTextPosX2AndWidth);
				g_currentMission.hudHelpContentWidth = self.hudHelpContentWidthOld * (self.hudHelpSize * addValue * addValueTextPosX2AndWidth);
				g_currentMission.hudHelpContentHeight = self.hudHelpContentHeightOld * (self.hudHelpSize * addValue);
				
				hasMapRunFirstTime = true;
			end;
			
			if g_currentMission.player.isControlled then --## player is NOT in a vehicle to pre event conflicts with inputs of a vehicle e.g.: Frontloader ...
				local currentInputUp = InputBinding.SET_HELP_HUD_SIZE_UP_MODIFIER;
				local currentInputDown = InputBinding.SET_HELP_HUD_SIZE_DOWN_MODIFIER;
				
				if InputBinding.isPressed(InputBinding.SET_HELP_HUD_SIZE_UP_MODIFIER) or InputBinding.isPressed(InputBinding.SET_HELP_HUD_SIZE_UP) then
					currentInputUp = InputBinding.SET_HELP_HUD_SIZE_UP;
				
					if InputBinding.hasEvent(InputBinding.SET_HELP_HUD_SIZE_UP) then	
						if self.hudHelpSize < self.hudHelpSizeMax then
							self.hudHelpSize = self.hudHelpSize + self.hudHelpSizeStep;
							self.currentHelpSizeStep = self.currentHelpSizeStep + 1;
						end;
					end;
				elseif InputBinding.isPressed(InputBinding.SET_HELP_HUD_SIZE_DOWN_MODIFIER) or InputBinding.isPressed(InputBinding.SET_HELP_HUD_SIZE_DOWN) then
					currentInputDown = InputBinding.SET_HELP_HUD_SIZE_DOWN;
					
					if InputBinding.hasEvent(InputBinding.SET_HELP_HUD_SIZE_DOWN) then	
						if self.hudHelpSize > self.hudHelpSizeMin then
							self.hudHelpSize = self.hudHelpSize - self.hudHelpSizeStep;
							self.currentHelpSizeStep = self.currentHelpSizeStep - 1;
						end;
					end;
				end;
				
				if ((InputBinding.isPressed(InputBinding.SET_HELP_HUD_SIZE_UP_MODIFIER) or InputBinding.isPressed(InputBinding.SET_HELP_HUD_SIZE_UP)) and self.hudHelpSize < self.hudHelpSizeMax) 
					or ((InputBinding.isPressed(InputBinding.SET_HELP_HUD_SIZE_DOWN_MODIFIER) or InputBinding.isPressed(InputBinding.SET_HELP_HUD_SIZE_DOWN)) and self.hudHelpSize > self.hudHelpSizeMin)
				then
					g_currentMission:addExtraPrintText(string.format(g_i18n:getText("CURRENT_HELP_HUD_SIZE_STEP"), self.currentHelpSizeStep, self.maxHudHelpSizeSteps));
				end;
				
				g_currentMission.hudHelpTextSize = self.hudHelpTextSizeOld * (self.hudHelpSize * addValueTextSize);
				g_currentMission.hudHelpTextLineSpacing = self.hudHelpTextLineSpacingOld * (self.hudHelpSize * addValue);
				g_currentMission.hudHelpTextPosX1 = self.hudHelpTextPosX1Old * (self.hudHelpSize * addValue);
				g_currentMission.hudHelpTextPosX2 = self.hudHelpTextPosX2Old * (self.hudHelpSize * addValue * addValueTextPosX2AndWidth);
				g_currentMission.hudHelpContentWidth = self.hudHelpContentWidthOld * (self.hudHelpSize * addValue * addValueTextPosX2AndWidth);
				g_currentMission.hudHelpContentHeight = self.hudHelpContentHeightOld * (self.hudHelpSize * addValue);
		
				if self.hudHelpSize < self.hudHelpSizeMax then	
					g_currentMission:addHelpButtonText(g_i18n:getText("SET_HELP_HUD_SIZE_UP"), currentInputUp);
				else
					self.currentHelpSizeStep = self.maxHudHelpSizeSteps;
				end;
				
				if self.hudHelpSize > self.hudHelpSizeMin then
					g_currentMission:addHelpButtonText(g_i18n:getText("SET_HELP_HUD_SIZE_DOWN"), currentInputDown);
				else
					self.currentHelpSizeStep = 0;
				end;
			end;
		end;
			
		if g_currentMission.showHelpText and not g_currentMission.ingameMap:getIsFullSize() then
			renderText(g_currentMission.hudHelpTextPosX1, g_currentMission.hudHelpTopOverlay.y + (g_currentMission.hudHelpTopOverlay.height - g_currentMission.hudHelpTextSize) / 2 + 0.003, g_currentMission.hudHelpTextSize, string.upper(g_i18n:getText("Controls")));
		end;
		
		
		if self.allowChangeTimeAndMoneyHud then
			local minutes = string.format("%02d", g_currentMission.environment.currentMinute);
			local hours = string.format("%02d", g_currentMission.environment.currentHour);
			local currentTime = hours .. ":" .. minutes;
			
			local weatherWidth = g_currentMission.weatherTimeBackgroundWidth;
			
			if not g_currentMission.showWeatherForecast then
				weatherWidth = g_currentMission.timeBackgroundWidth;
			end;
			
			setTextAlignment(RenderText.ALIGN_RIGHT);
			setTextBold(false);
			
			if g_currentMission.renderTime then
				local offset = 0.021;
				
				if RealTime then
					offset = 0.017;
				end;
				
				renderText(g_currentMission.weatherTimeBackgroundOverlay.x + weatherWidth / g_screenWidth + 0.092, g_currentMission.weatherTimeBackgroundOverlay.y + offset, self.timeTextSize, currentTime);
			end;
			
			local money = g_i18n:formatNumber(g_currentMission.missionStats.money);
			
			g_currentMission.moneyBackgroundWidth = getTextWidth(self.moneyTextSize, '"' .. money .. '"') + 0.028;
			
			renderText(g_currentMission.moneyBackgroundOverlay.x + g_currentMission.moneyBackgroundWidth - g_currentMission.moneyBackgroundXOffsetRight, g_currentMission.moneyBackgroundOverlay.y + 0.025, self.moneyTextSize, money);
			
			setTextAlignment(RenderText.ALIGN_CENTER);
			
			timeScale = g_i18n:formatNumber(g_currentMission.missionStats.timeScale);
			
			renderText(g_currentMission.timeScaleOverlay.x + 0.005, g_currentMission.timeScaleOverlay.y - 0.022, self.timeScaleTextSize, timeScale);
		end;
		
		g_currentMission.hudHelpContentOverlay:setDimension(g_currentMission.hudHelpContentWidth, g_currentMission.hudHelpContentHeight);
		g_currentMission.hudHelpTopOverlay:setDimension(g_currentMission.hudHelpContentWidth, g_currentMission.hudHelpContentHeight);
		g_currentMission.hudHelpSeperatorOverlay:setDimension(g_currentMission.hudHelpContentWidth - 0.015, nil);
		
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(1, 1, 1, 1);
	end;
end;

function NewHelpHudColor:draw()end;
function NewHelpHudColor:keyEvent(unicode, sym, modifier, isDown)end;
function NewHelpHudColor:mouseEvent(posX, posY, isDown, isUp, button)end;
function NewHelpHudColor:deleteMap()end;

addModEventListener(NewHelpHudColor);