--[[
newHelpHudColors

Author:  Ifko[nator]
Date:	 22.04.2015
Version: 1.6

Mit diesem Script kann man das Hilfefenster und die darin enthaltene Schrift in eine neue Farbe einfärben. (Konfigurierbar in der modDesc dieser zip.)

TO DO: Unterstüzung für das Uhr-hud.
]]

NewHelpHudColor = {};

local currentModDirectory = g_currentModDirectory;

function NewHelpHudColor:loadMap()
	if g_currentMission ~= nil then --## 'g_currentMission' should here NEVER be nil, but save is save ...
		local modDesc = loadXMLFile("modDesc", currentModDirectory .. "modDesc.xml");
		local version = Utils.getNoNil(getXMLString(modDesc, "modDesc.version"), "!!! --->>> Missing 'version' attribute in modDesc file! <<<--- !!!");

		print("");
		print("### NewHelpHudColor Script by Ifko[nator] in der Version: '" .. version .. "' erfolgreich geladen!");
		print("");
		
		self.hudHelpTopOverlay = Utils.getVectorNFromString(Utils.getNoNil(getXMLString(modDesc, "modDesc.newHelpHudColors.hudHelpTopOverlay#color"), "0.0103 0.0103 0.0103 0.9"), 4);
		self.hudHelpContentOverlay = Utils.getVectorNFromString(Utils.getNoNil(getXMLString(modDesc, "modDesc.newHelpHudColors.hudHelpContentOverlay#color"), "0.5105 0.5315 0.5583 1"), 4);
		self.hudHelpTextColor = Utils.getVectorNFromString(Utils.getNoNil(getXMLString(modDesc, "modDesc.newHelpHudColors.hudHelpText#color"), "0.0137 0.016 0.0194 1"), 4)
		self.hudHelpSizeMax = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.newHelpHudColors#hudHelpSizeMax"), 1.25);
		self.hudHelpSizeStep = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.newHelpHudColors#hudHelpSizeStep"), 0.05);
		
		delete(modDesc);
		
		if self.hudHelpSizeMax < 1 then
			print("Info from the NewHelpHudColor Script: The Value from hudHelpSizeMax ('" .. self.hudHelpSizeMax .. "') is too small! The Value was set to '1.25'!");
			self.hudHelpSizeMax = 1.25;
		end;
		
		self.hudHelpSize = 1;
		self.currentHelpSizeStep = 0;
		
		self.maxHudHelpSizeSteps = math.ceil((self.hudHelpSizeMax - 1) / self.hudHelpSizeStep);
		
		self.hudHelpTextSizeOld = g_currentMission.hudHelpTextSize
		self.hudHelpTextLineSpacingOld = g_currentMission.hudHelpTextLineSpacing
		self.hudHelpTextMaxHeightOld = g_currentMission.hudHelpTextMaxHeight
		self.hudHelpTextPosX1Old = g_currentMission.hudHelpTextPosX1
		self.hudHelpTextPosX2Old = g_currentMission.hudHelpTextPosX2
		self.hudHelpContentWidthOld = g_currentMission.hudHelpContentWidth 
		self.hudHelpContentHeightOld = g_currentMission.hudHelpContentHeight
		
		g_currentMission.hudHelpTopTextSize = 0;
		--[[## This works but how are the render commands for the money and the time??
		g_currentMission.moneyTextSize = 0;
		g_currentMission.timeTextSize = 0;
		]]
		
		g_currentMission.hudHelpTopOverlay:setColor(self.hudHelpTopOverlay[1], self.hudHelpTopOverlay[2], self.hudHelpTopOverlay[3], self.hudHelpTopOverlay[4]);
		g_currentMission.hudHelpContentOverlay:setColor(self.hudHelpContentOverlay[1], self.hudHelpContentOverlay[2], self.hudHelpContentOverlay[3], self.hudHelpContentOverlay[4]);
		g_currentMission.hudWarningBaseOverlay:setColor(self.hudHelpContentOverlay[1], self.hudHelpContentOverlay[2], self.hudHelpContentOverlay[3], self.hudHelpContentOverlay[4]);
		g_currentMission.hudHelpTextColor = {self.hudHelpTextColor[1], self.hudHelpTextColor[2], self.hudHelpTextColor[3], self.hudHelpTextColor[4]};
		g_currentMission.hudHelpSeperatorOverlay:setColor(self.hudHelpTextColor[1], self.hudHelpTextColor[2], self.hudHelpTextColor[3], self.hudHelpTextColor[4]);
		
		--[[## This will work, but i dont know how i chnage the text color for the money and time. I think this is impossible...
		
		g_currentMission.weatherTimeBackgroundOverlay:setColor(self.hudHelpContentOverlay[1], self.hudHelpContentOverlay[2], self.hudHelpContentOverlay[3], self.hudHelpContentOverlay[4]);
		g_currentMission.moneyBackgroundOverlay:setColor(self.hudHelpTopOverlay[1], self.hudHelpTopOverlay[2], self.hudHelpTopOverlay[3], self.hudHelpTopOverlay[4]);
		]]
	end;
end;

function NewHelpHudColor:update(dt)
	if g_currentMission ~= nil and g_currentMission.showHelpText and not g_currentMission.ingameMap:getIsFullSize() and g_currentMission.isRunning and g_gui.currentGui == nil then
		local addValue = 0.95;
		local addValueText;
		
		if self.hudHelpSize == 1 then
			addValueText = 1.1;
		else
			addValueText = 1.25;
		end;
		
		if hasMapRunFirstTime == nil then
			g_currentMission.hudHelpTextSize = self.hudHelpTextSizeOld * (self.hudHelpSize * addValueText);
			g_currentMission.hudHelpTextLineSpacing = self.hudHelpTextLineSpacingOld * (self.hudHelpSize * addValue);
			g_currentMission.hudHelpTextPosX1 = self.hudHelpTextPosX1Old * (self.hudHelpSize * addValue);
			g_currentMission.hudHelpTextPosX2 = self.hudHelpTextPosX2Old * (self.hudHelpSize * addValue);
			g_currentMission.hudHelpContentWidth = self.hudHelpContentWidthOld * (self.hudHelpSize * addValue);
			g_currentMission.hudHelpContentHeight = self.hudHelpContentHeightOld * (self.hudHelpSize * addValue);
			
			hasMapRunFirstTime = true;
		end;
		
		if g_currentMission.player.isControlled then --## player is NOT in a vehicle to pre event conflicts with inputs of a vehicle e.g.: Frontloader ...
			local currentInput = InputBinding.SET_HELP_HUD_SIZE_MODIFIER;
			
			if InputBinding.isPressed(InputBinding.SET_HELP_HUD_SIZE_MODIFIER) or InputBinding.isPressed(InputBinding.SET_HELP_HUD_SIZE_UP) then
				currentInput = InputBinding.SET_HELP_HUD_SIZE_UP;
			
				if InputBinding.hasEvent(InputBinding.SET_HELP_HUD_SIZE_UP) then	
					if self.hudHelpSize < self.hudHelpSizeMax then
						self.hudHelpSize = self.hudHelpSize + self.hudHelpSizeStep;
						self.currentHelpSizeStep = self.currentHelpSizeStep + 1;
					else
						self.hudHelpSize = 1;
						self.currentHelpSizeStep = 0;
					end;
				end;
				
				g_currentMission.hudHelpTextSize = self.hudHelpTextSizeOld * (self.hudHelpSize * addValueText);
				g_currentMission.hudHelpTextLineSpacing = self.hudHelpTextLineSpacingOld * (self.hudHelpSize * addValue);
				g_currentMission.hudHelpTextPosX1 = self.hudHelpTextPosX1Old * (self.hudHelpSize * addValue);
				g_currentMission.hudHelpTextPosX2 = self.hudHelpTextPosX2Old * (self.hudHelpSize * addValue);
				g_currentMission.hudHelpContentWidth = self.hudHelpContentWidthOld * (self.hudHelpSize * addValue);
				g_currentMission.hudHelpContentHeight = self.hudHelpContentHeightOld * (self.hudHelpSize * addValue);
				
				g_currentMission:addExtraPrintText(string.format(g_i18n:getText("CURRENT_HELP_HUD_SIZE_STEP"), self.currentHelpSizeStep, self.maxHudHelpSizeSteps));
			end;
	
			g_currentMission:addHelpButtonText(g_i18n:getText("SET_HELP_HUD_SIZE_UP"), currentInput);
		end;

		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(unpack(g_currentMission.hudHelpTextColor));
		setTextBold(true);
		renderText(g_currentMission.hudHelpTextPosX1, g_currentMission.hudHelpTopOverlay.y + (g_currentMission.hudHelpTopOverlay.height - g_currentMission.hudHelpTextSize)/2, g_currentMission.hudHelpTextSize, string.upper(g_i18n:getText("Controls")));
		
		g_currentMission.hudHelpContentOverlay:setDimension(g_currentMission.hudHelpContentWidth, nil);
		g_currentMission.hudHelpTopOverlay:setDimension(g_currentMission.hudHelpContentWidth, nil);
		g_currentMission.hudHelpSeperatorOverlay:setDimension(g_currentMission.hudHelpContentWidth - 0.015, nil);
		
		setTextColor(1, 1, 1, 1);
		setTextBold(false);
	end;
end;

function NewHelpHudColor:draw()end;
function NewHelpHudColor:keyEvent(unicode, sym, modifier, isDown)end;
function NewHelpHudColor:mouseEvent(posX, posY, isDown, isUp, button)end;
function NewHelpHudColor:deleteMap()end;

addModEventListener(NewHelpHudColor);