--[[
newHelpHudColors

Author:  Ifko[nator]
Date:	 17.04.2015
Version: 1.5

Mit diesem Script kann man das Hilfefenster und die darin enthaltene Schrift in eine neue Farbe einfärben. (Konfigurierbar in der modDesc dieser zip.)

TO DO: Unterstüzung für das Uhr-hud.
]]

local modDesc = loadXMLFile("modDesc", g_currentModDirectory .. "modDesc.xml");
local version = getXMLString(modDesc, "modDesc.version");

print("### NewHelpHudColor Script by Ifko[nator] in der Version: '" .. version .. "' erfolgreich geladen!");

NewHelpHudColor = {};

function NewHelpHudColor:loadMap()
	self.hudHelpTopOverlay = Utils.getVectorNFromString(Utils.getNoNil(getXMLString(modDesc, "modDesc.newHelpHudColors.hudHelpTopOverlay#color"), "0.0103 0.0103 0.0103 0.9"), 4);
	self.hudHelpContentOverlay = Utils.getVectorNFromString(Utils.getNoNil(getXMLString(modDesc, "modDesc.newHelpHudColors.hudHelpContentOverlay#color"), "0.5105 0.5315 0.5583 1"), 4);
	self.hudHelpTextColor = Utils.getVectorNFromString(Utils.getNoNil(getXMLString(modDesc, "modDesc.newHelpHudColors.hudHelpText#color"), "0.0137 0.016 0.0194 1"), 4)
	self.hudHelpSizeMax = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.newHelpHudColors#hudHelpSizeMax"), 1.25);
	
	if self.hudHelpSizeMax < 1 then
		print("Info fro the NewHelpHudColor Script: The Value from hudHelpSizeMax ('" .. self.hudHelpSizeMax .."') is too small! The Value was set to '1.25'!");
		self.hudHelpSizeMax = 1.25;
	end;
	
	
	if g_currentMission ~= nil then --## should here NEVER be nil, but save is save ...
		self.hudHelpSize = 1;
		
		self.hudHelpTextSizeOld = g_currentMission.hudHelpTextSize
		self.hudHelpTextLineSpacingOld = g_currentMission.hudHelpTextLineSpacing
		self.hudHelpTextMaxHeightOld = g_currentMission.hudHelpTextMaxHeight
		self.hudHelpTextPosX1Old = g_currentMission.hudHelpTextPosX1
		self.hudHelpTextPosX2Old = g_currentMission.hudHelpTextPosX2
		self.hudHelpContentWidthOld = g_currentMission.hudHelpContentWidth 
		self.hudHelpContentHeightOld = g_currentMission.hudHelpContentHeight
		
		g_currentMission.hudHelpTopOverlay:setColor(self.hudHelpTopOverlay[1], self.hudHelpTopOverlay[2], self.hudHelpTopOverlay[3], self.hudHelpTopOverlay[4]);
		g_currentMission.hudHelpContentOverlay:setColor(self.hudHelpContentOverlay[1], self.hudHelpContentOverlay[2], self.hudHelpContentOverlay[3], self.hudHelpContentOverlay[4]);
		g_currentMission.hudWarningBaseOverlay:setColor(self.hudHelpContentOverlay[1], self.hudHelpContentOverlay[2], self.hudHelpContentOverlay[3], self.hudHelpContentOverlay[4]);
		g_currentMission.hudHelpTextColor = {self.hudHelpTextColor[1], self.hudHelpTextColor[2], self.hudHelpTextColor[3], self.hudHelpTextColor[4]};
		g_currentMission.hudHelpSeperatorOverlay:setColor(self.hudHelpTextColor[1], self.hudHelpTextColor[2], self.hudHelpTextColor[3], self.hudHelpTextColor[4]);
		
		--[[## This will work, but i dont know how i chnage the text color for the money and time. I think this is impossible...
		
		g_currentMission.weatherTimeBackgroundOverlay:setColor(self.hudHelpContentOverlay[1], self.hudHelpContentOverlay[2], self.hudHelpContentOverlay[3], self.hudHelpContentOverlay[4]);
		g_currentMission.moneyBackgroundOverlay:setColor(self.hudHelpTopOverlay[1], self.hudHelpTopOverlay[2], self.hudHelpTopOverlay[3], self.hudHelpTopOverlay[4]);
		]]
	end;
end;

function NewHelpHudColor:update(dt)
	if g_currentMission ~= nil then --## should here NEVER be nil, but save is save ...
		local addValue = 0.95;
		
		if hasMapRunFirstTime == nil then
			g_currentMission.hudHelpTextSize = self.hudHelpTextSizeOld * (self.hudHelpSize + 0.125);
			g_currentMission.hudHelpTextLineSpacing = self.hudHelpTextLineSpacingOld * (self.hudHelpSize * addValue);
			g_currentMission.hudHelpTextPosX1 = self.hudHelpTextPosX1Old * (self.hudHelpSize * addValue);
			g_currentMission.hudHelpTextPosX2 = self.hudHelpTextPosX2Old * (self.hudHelpSize * addValue);
			g_currentMission.hudHelpContentWidth = self.hudHelpContentWidthOld * (self.hudHelpSize * addValue);
			g_currentMission.hudHelpContentHeight = self.hudHelpContentHeightOld * (self.hudHelpSize * addValue);
			
			hasMapRunFirstTime = true;
		end;
		
		if InputBinding.hasEvent(InputBinding.SET_HELP_HUD_SIZE) then	
			if self.hudHelpSize < self.hudHelpSizeMax then
				self.hudHelpSize = self.hudHelpSize + 0.05;
			else
				self.hudHelpSize = 1;
			end;
			
			g_currentMission.hudHelpTextSize = self.hudHelpTextSizeOld * (self.hudHelpSize + 0.125);
			g_currentMission.hudHelpTextLineSpacing = self.hudHelpTextLineSpacingOld * (self.hudHelpSize * addValue);
			g_currentMission.hudHelpTextPosX1 = self.hudHelpTextPosX1Old * (self.hudHelpSize * addValue);
			g_currentMission.hudHelpTextPosX2 = self.hudHelpTextPosX2Old * (self.hudHelpSize * addValue);
			g_currentMission.hudHelpContentWidth = self.hudHelpContentWidthOld * (self.hudHelpSize * addValue);
			g_currentMission.hudHelpContentHeight = self.hudHelpContentHeightOld * (self.hudHelpSize * addValue);
		end;
	
		g_currentMission:addHelpButtonText(g_i18n:getText("SET_HELP_HUD_SIZE"), InputBinding.SET_HELP_HUD_SIZE);
		
		g_currentMission.hudHelpTopTextSize = 0;
		
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(unpack(g_currentMission.hudHelpTextColor));
		setTextBold(true);
		renderText(g_currentMission.hudHelpTextPosX1, g_currentMission.hudHelpTopOverlay.y + (g_currentMission.hudHelpTopOverlay.height - g_currentMission.hudHelpTextSize)/2, g_currentMission.hudHelpTextSize, string.upper(g_i18n:getText("Controls")));
		
		g_currentMission.hudHelpContentOverlay:setDimension(g_currentMission.hudHelpContentWidth, helpTextsHeight);
		g_currentMission.hudHelpTopOverlay:setDimension(g_currentMission.hudHelpContentWidth, nil);
		g_currentMission.hudHelpSeperatorOverlay:setDimension(g_currentMission.hudHelpContentWidth - 0.01, nil);
	
		setTextColor(1, 1, 1, 1);
		setTextBold(false);
	end;
end;

function NewHelpHudColor:draw()end;
function NewHelpHudColor:keyEvent(unicode, sym, modifier, isDown)end;
function NewHelpHudColor:mouseEvent(posX, posY, isDown, isUp, button)end;
function NewHelpHudColor:deleteMap()end;

addModEventListener(NewHelpHudColor);