FrontLinkage = {};

function FrontLinkage.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function FrontLinkage:load(xmlFile)
	self.frontLinkageBottomArmRotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkageBottomArm#rotationNode"));
	setRotation(self.frontLinkageBottomArmRotNode, math.rad(-50), math.rad(0), math.rad(0)); 
end;

function FrontLinkage:delete()
end;

function FrontLinkage:readStream(streamId, connection)
end;

function FrontLinkage:writeStream(streamId, connection)
end;

function FrontLinkage:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FrontLinkage:keyEvent(unicode, sym, modifier, isDown)
end;

function FrontLinkage:update(dt)
end;

function FrontLinkage:updateTick(dt)
end;

function FrontLinkage:draw()
end;

function FrontLinkage:onLeave()
end;

function FrontLinkage:onEnter()
end;

function FrontLinkage:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;
		if jointIndex == 2 then
			setRotation(self.frontLinkageBottomArmRotNode, math.rad(0), math.rad(0), math.rad(0)); 
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 3 then
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 4 then
		end;
	end;

	self.updateJoint = true;
end;

function FrontLinkage:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;
		if jointIndex == 2 then
			setRotation(self.frontLinkageBottomArmRotNode, math.rad(-50), math.rad(0), math.rad(0)); 
		end;
	end;
	
	self.updateJoint = true;
end;

function FrontLinkage:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
	
    return false;
end;
