--
-- AttachableCombine_fix
-- Specialization for using correct speedlimit on attachable combines with trailer attacher
--
-- @author  Stefan Maurus	
-- @date  2015-11-01

-- Copyright © Stefan Maurus, www.stefanmaurus.de

AttachableCombine_fix = {};

function AttachableCombine_fix.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end

function AttachableCombine_fix:load(xmlFile)
	self.getSpeedLimit = AttachableCombine_fix.getSpeedLimit;
end

function AttachableCombine_fix:delete()
end

function AttachableCombine_fix:mouseEvent(posX, posY, isDown, isUp, button)
end

function AttachableCombine_fix:keyEvent(unicode, sym, modifier, isDown)
end

function AttachableCombine_fix:update(dt)
end

function AttachableCombine_fix:updateTick(dt)
end

function AttachableCombine_fix:draw()
end

function AttachableCombine_fix:getSpeedLimit(onlyIfWorking)
    local limit = math.huge;
	local doCheckSpeedLimit = self:doCheckSpeedLimit();
	if onlyIfWorking == nil or (onlyIfWorking and doCheckSpeedLimit) then
		limit = self.speedLimit;
	end;
	
	return limit, doCheckSpeedLimit;
end;