--[[
	BrakeLightsExtension_Register.lua
	
	Autor: Ifko[nator]
	Datum: 11.08.2015
]]

SpecializationUtil.registerSpecialization("brakeLightsExtension", "BrakeLightsExtension", g_currentModDirectory.."BrakeLightsExtension.lua")

BrakeLightsExtension_Register = {};

function BrakeLightsExtension_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					-- Standard lua's
					if vs ~= nil and (vs == SpecializationUtil.getSpecialization("drivable") or vs == SpecializationUtil.getSpecialization("attachable")) then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							-- Mod lua's (nicht im dataS Ordner!)
							if rawget(SpecializationUtil.specializations, string.format("%s.brakeLightsExtension", _name)) ~= nil then
								allowInsertion = false;
							end;
						end;
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("brakeLightsExtension"));
						end;
					end;
				end;
			end;	
		end;
	end;
end;

function BrakeLightsExtension_Register:deleteMap()end;
function BrakeLightsExtension_Register:keyEvent(unicode, sym, modifier, isDown)end;
function BrakeLightsExtension_Register:mouseEvent(posX, posY, isDown, isUp, button)end;
function BrakeLightsExtension_Register:update(dt)end;
function BrakeLightsExtension_Register:draw()end;

addModEventListener(BrakeLightsExtension_Register);