--[[
Spezialisierung die die Bremslichter beim Stillstand des Fahrzeuges sichtbar macht.

Author:		Ifko[nator]
Datum:		10.02.2016
Version:	v1.8

History:	v1.0 @ 11.08.2015 - initial implementation
			v1.1 @ 12.08.2015 - support for more as one trailer. The brake lights are now on all attached trailers visible, if the attacher vehicle is not movig.
			V1.2 @ 24.09.2015 - support for all attachables, wich have no brake lights, for example: weights.
			V1.5 @ 23.11.2015 - last fixes for public release
			V1.8 @ 10.02.2016 - mp fix
]]

BrakeLightsExtension = {};

function BrakeLightsExtension.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization((Drivable or Attachable), specializations)
end;

function BrakeLightsExtension:load(xmlFile)
	self.standBrakeLights = {};
	local numStandBrakeLights = 0;

	while true do
        local parameter = string.format("vehicle.brakeLights.brakeLight(%d)", numStandBrakeLights);
		if not hasXMLProperty(xmlFile, parameter) then
            break;
        end;
        
		local standBrakeLightOriginal = Utils.indexToObject(self.components, getXMLString(xmlFile, parameter .. "#index"));
		if standBrakeLightOriginal ~= nil then
            --## simply clone the brake light. The cloned brake light will be visible, if the vehicle is not moving.
			local standBrakeLight = clone(standBrakeLightOriginal, true, false, false);
			setVisibility(standBrakeLight, false);
            table.insert(self.standBrakeLights, standBrakeLight);
        end;
        
		numStandBrakeLights = numStandBrakeLights + 1;
    end;
	
	--self.updateWheels = false;
	self.doBrake = false;
end;

function BrakeLightsExtension:update(dt)
	for _, standBrakeLight in pairs(self.standBrakeLights) do
		if self:getIsActive() then
			if SpecializationUtil.hasSpecialization(Drivable, self.specializations) then
				--## drivable vehicle
				
				--[[## nope, this is not the right one for this .. Flicker of the brake lights when the tractor is bounce and not moving..
				local wheelSpeed = getWheelShapeAxleSpeed(self.wheels[1].node, self.wheels[1].wheelShape);
				
				if self.isEntered then
					setTextAlignment(RenderText.ALIGN_CENTER) 
					renderText(0.5, 0.5, 0.025, "Current wheel speed = '" .. wheelSpeed .. "'.");
				end;
				
				if wheelSpeed < 0.0015 then
					self.updateWheels = false;
				else
					self.updateWheels = true;
				end;
				]]
				
				local someoneIsInTheVehicle; 
				
				if self.cp ~= nil and self.modFM == nil then
					someoneIsInTheVehicle = self.cp.isDriving or self.isEntered or self.isControlled or self.isHired;
				elseif self.cp ~= nil and self.modFM ~= nil then
					someoneIsInTheVehicle = self.cp.isDriving or self.modFM.FollowState ~= FollowMe.STATE_NONE or self.isEntered or self.isControlled or self.isHired;
				elseif self.cp == nil and self.modFM ~= nil then
					someoneIsInTheVehicle = self.modFM.FollowState ~= FollowMe.STATE_NONE or self.isEntered or self.isControlled or self.isHired;
				else
					someoneIsInTheVehicle = self.isEntered or self.isControlled or self.isHired; 
				end;
	
				--## moving direction is much better as the wheel speed for this
				
				local movingDirection;
				
				if self.isEntered then
					movingDirection = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
					
					if InputBinding.isAxisZero(movingDirection) then
						--## controller
						movingDirection = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
					end;
				else
					movingDirection = 0;
				end;
				
				local cruiseControlIsOff;
				
				if self.isHired then
					if self.isHirableBlocked then
						if self.cruiseControl.state == Drivable.CRUISECONTROL_STATE_OFF then
							cruiseControlIsOff = Drivable.CRUISECONTROL_STATE_OFF;
						else
							cruiseControlIsOff = Drivable.CRUISECONTROL_STATE_ACTIVE;
						end;
					else
						cruiseControlIsOff = Drivable.CRUISECONTROL_STATE_OFF;
					end;
				elseif self.cp ~= nil and self.cp.isDriving then
					if not self.cp.TrafficBrake then
						if self.cruiseControl.state == Drivable.CRUISECONTROL_STATE_OFF then
							cruiseControlIsOff = Drivable.CRUISECONTROL_STATE_OFF;
						else
							cruiseControlIsOff = Drivable.CRUISECONTROL_STATE_ACTIVE;
						end;
					else
						cruiseControlIsOff = Drivable.CRUISECONTROL_STATE_OFF;
					end;
				else
					cruiseControlIsOff = Drivable.CRUISECONTROL_STATE_OFF;
				end;
				
				--[[
				if self.isEntered then
					setTextAlignment(RenderText.ALIGN_CENTER) 
					renderText(0.5, 0.5, 0.025, "Current moving direction = '" .. movingDirection .. "'.");
				end;
				]]
	
				if someoneIsInTheVehicle and self.isMotorStarted and movingDirection == 0 and self.lastSpeedReal < 0.9/3600 and self.cruiseControl.state == cruiseControlIsOff then --not self.updateWheels then -- and self.motor.lastMotorRpm == self.motor.minRpm then
					setVisibility(standBrakeLight, true);
					self.doBrake = true;
				else
					setVisibility(standBrakeLight, false);
					self.doBrake = false;
				end;
			elseif SpecializationUtil.hasSpecialization(Attachable, self.specializations) then
				--## attachable vehicle
				if self.attacherVehicle ~= nil and self.attacherVehicle:getIsActive() and self.attacherVehicle.doBrake then
					setVisibility(standBrakeLight, true);
					self.doBrake = true;
				else
					setVisibility(standBrakeLight, false);
					self.doBrake = false;
				end;
			end;
		else
			setVisibility(standBrakeLight, false);
		end;
	end;
	
	--## support for all attachables, wich have no brake lights, for example: weights.
	if SpecializationUtil.hasSpecialization(Attachable, self.specializations) then
		if #self.standBrakeLights == 0 then
			if self.attacherVehicle ~= nil and self.attacherVehicle:getIsActive() and self.attacherVehicle.doBrake then
				self.doBrake = true;
			else
				self.doBrake = false;
			end;
		end;
	end;
end;

function BrakeLightsExtension:draw()end;
function BrakeLightsExtension:delete()end;
function BrakeLightsExtension:mouseEvent(posX, posY, isDown, isUp, button)end;
function BrakeLightsExtension:keyEvent(unicode, sym, modifier, isDown)end;