--[[
Spezialisierung die dafür sorgt, dass die Heckhydraulik angehoben wird, wenn man einen Anhänger mit Kugelkopf anhängt.

Author:		Ifko[nator]
Datum:		27.12.2015
Version:	1.1

Version:	v1.0
History:	v1.0 @ 20.12.2015 - initial implementation
			v1.1 @ 27.12.2015 - small fixes
]]

SetBackLinkageUp = {};

local setBackLinkageUp_directory = g_currentModDirectory;

function SetBackLinkageUp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Drivable, specializations);
end;

function SetBackLinkageUp:load(xmlFile)
	local modDesc = loadXMLFile("modDesc", setBackLinkageUp_directory .. "modDesc.xml");
	
	--## modDesc file
	self.maxRotGlobal = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.setBackLinkageUp#maxRot"), 25);
	self.rotSpeedGlobal = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.setBackLinkageUp#rotSpeed"), 0.4);
	self.testModeGlobal = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp#testMode"), false);
	self.doDismantleBackLinkageIfPTOIsNeededGlobal = Utils.getNoNil(getXMLBool(modDesc, "modDesc.setBackLinkageUp#doDismantleBackLinkageIfPTOIsNeeded"), true);

	delete(modDesc);
	
	--## vehicle xml file
	self.maxRotSBLU = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.setBackLinkageUp#maxRot"), self.maxRotGlobal);
	self.rotSpeedSBLU = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.setBackLinkageUp#rotSpeed"), self.rotSpeedGlobal);
	self.testModeSBLU = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp#testMode"), self.testModeGlobal);
	self.doDismantleBackLinkageIfPTOIsNeeded = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.setBackLinkageUp#doDismantleBackLinkageIfPTOIsNeeded"), self.doDismantleBackLinkageIfPTOIsNeededGlobal);
	
	self.currentRotSBLU = 0;
	self.allowSetUpSBLU = false;
	
	self.bottomArms = {};
	
	local count = 0;
	
	while true do
		local baseString = string.format("vehicle.attacherJoints.attacherJoint(%d)", count);
		
		if not hasXMLProperty(xmlFile, baseString) then
			break;
		end;
		
		local bottomArm = {};
		
		local rotationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseString .. ".bottomArm#rotationNode"));
		
		if rotationNode ~= nil then
			bottomArm.zScale = Utils.getNoNil(getXMLFloat(xmlFile, baseString .. ".bottomArm#zScale"), 1);
			
			if bottomArm.zScale == -1 then
				bottomArm.bottomArmNode = rotationNode;
				bottomArm.rotX, _, _ = getRotation(rotationNode);
				bottomArm.rotX = math.deg(bottomArm.rotX); --## convert from radians to degrees
				bottomArm.rotXStart = bottomArm.rotX;
				self.currentRotSBLU = bottomArm.rotX;
				
				table.insert(self.bottomArms, bottomArm);
			end;
		else
			break;
		end;
		
		count = count + 1;
	end;
	
	if self.isClient then
        self.sampleHydraulic2 = Utils.loadSample(xmlFile, {}, "vehicle.hydraulicSound", nil, self.baseDirectory);
	end;
	
	self.doBackLinkageDismantle = false;
end;

function SetBackLinkageUp:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local pto = implement.object.attacherJoint.ptoInput or implement.object.ppcFillLevel;
	
	if jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		local jointDesc = self.attacherJoints[implement.jointDescIndex];
		
		self.attachedTrailer = {
			jointIndex = jointDesc.jointIndex,
			implement = implement,
			object = object
		};
		
		self.allowSetUpSBLU = true;
		
		if pto ~= nil and self.doDismantleBackLinkageIfPTOIsNeeded then
			self.doBackLinkageDismantle = true;
		end;
	end;

	if self.attacherJoints ~= nil then
		for attacherJoint = 1, #self.attacherJoints do
			local jointType = self.attacherJoints[attacherJoint].jointType;
			
			if jointType == Vehicle.JOINTTYPE_TRAILERLOW then
				if self.attacherJoints[attacherJoint].maxRotLimit[2] ~= nil and self.attacherJoints[attacherJoint].maxRotLimit[2] < 85 then
					self.attacherJoints[attacherJoint].maxRotLimit[2] = math.rad(math.abs(85));
				end;
			end;
		end;
	end;
end;

function SetBackLinkageUp:detachImplement(implementIndex)
	local jointType = self.attachedImplements[implementIndex].object.attacherJoint.jointType;
	
	--if jointType == Vehicle.JOINTTYPE_TRAILERLOW then
	if self.attachedTrailer ~= nil then
		local implement = self.attachedImplements[implementIndex];
		jointDesc = self.attacherJoints[implement.jointDescIndex];

		if jointDesc.jointIndex == self.attachedTrailer.jointIndex then
			self.allowSetUpSBLU = false;
			self.doBackLinkageDismantle = false;
			self.attachedTrailer = nil;
		end;
	end;
end;

function SetBackLinkageUp:update(dt)
	local playHydraulicSound = false;
	
	if self:getIsActive() then
		if self.isEntered and self.testModeSBLU and #self.bottomArms > 0 then
			setTextAlignment(RenderText.ALIGN_CENTER);
			renderText(0.5, 0.5, 0.02, "max rot = " .. self.maxRotSBLU);
			renderText(0.5, 0.48, 0.02, "current rot = " .. self.currentRotSBLU);
			renderText(0.5, 0.46, 0.02, "rot speed = " .. self.rotSpeedSBLU);
			renderText(0.5, 0.44, 0.02, "do back linkage dismantle = " .. tostring(self.doBackLinkageDismantle));
		end;
	end;
	
	if self.bottomArms ~= nil then
		for bottomArm = 1, #self.bottomArms do
			local backBottomArm = self.bottomArms[bottomArm];
			
			if backBottomArm.zScale == -1 then
				if (backBottomArm.bottomArmNode and backBottomArm.rotX) ~= nil then
					if self.allowSetUpSBLU then
						if backBottomArm.rotX < self.maxRotSBLU then
							backBottomArm.rotX = backBottomArm.rotX + self.rotSpeedSBLU;
							playHydraulicSound = true;
						else
							backBottomArm.rotX = self.maxRotSBLU;
							setVisibility(backBottomArm.bottomArmNode, not self.doBackLinkageDismantle);
						end;
					else
						if backBottomArm.rotX > backBottomArm.rotXStart then
							backBottomArm.rotX = backBottomArm.rotX - self.rotSpeedSBLU;
							playHydraulicSound = true;
							setVisibility(backBottomArm.bottomArmNode, not self.doBackLinkageDismantle);
						else
							backBottomArm.rotX = backBottomArm.rotXStart;
						end;
					end;
					
					if self:getIsActive() and self.isEntered and self.testModeSBLU then
						self.currentRotSBLU = backBottomArm.rotX;
					end;
					
					if playHydraulicSound then
						setRotation(backBottomArm.bottomArmNode, math.rad(backBottomArm.rotX), 0, 0);
					
						if self.setMovingToolDirty ~= nil then
							self:setMovingToolDirty(backBottomArm.bottomArmNode);
						end;
					end;
				end;
			end;
		end;
	end;
	
	if self:getIsActiveForSound() and self.sampleHydraulic2 ~= nil and self.sampleHydraulic2.sample ~= nil then
        if playHydraulicSound then
            if not self.sampleHydraulic2.isPlaying then
                Utils.playSample(self.sampleHydraulic2, 0, 0, nil);
            end;
        elseif self.sampleHydraulic2.isPlaying then
            Utils.stopSample(self.sampleHydraulic2, true);
        end;
	end;
end;

function SetBackLinkageUp:delete()
	if self.isClient and self.sampleHydraulic2 ~= nil then
        Utils.deleteSample(self.sampleHydraulic2);
	end;
end;

function SetBackLinkageUp:onDeactivateSounds()
    if self.isClient and self.sampleHydraulic2 ~= nil then
        Utils.stopSample(self.sampleHydraulic2);
	end;
end;

function SetBackLinkageUp:mouseEvent(posX, posY, isDown, isUp, button)end;
function SetBackLinkageUp:keyEvent(unicode, sym, modifier, isDown)end;
function SetBackLinkageUp:draw()end;