--[[
Extension for the 'FlieglMain' Specialization for the car.

Author: Ifko[nator]
Date: 21.12.2015
Version: 1.0

History: v 1.0 @ 21.12.2015 - intial release

Website: http://www.modding-welt.com/index.php/BoardList
]]

FlieglMain_Extension_Car = {};

local currentModName = g_currentModName;

function FlieglMain_Extension_Car.prerequisitesPresent(specializations)
	if SpecializationUtil.hasSpecialization(FlieglMain, specializations) then
		return true;
	else
		print("[ERROR from the FlieglMain_Extension_Car.lua]: Missing the specialization 'FlieglMain' in '" .. currentModName .. "'. Script is stopped now!");
		return false;
	end;
end;

function FlieglMain_Extension_Car:load(xmlFile)
	self.spanngurt = {};
	
	self.spanngurt.transportboxen = {};
	self.spanngurt.transportboxen.box1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteTransportboxen.box1#index"));
	
	self.spanngurt.siliermittelTanks = {};
	self.spanngurt.siliermittelTanks.tank1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fliegl.spanngurte.spanngurteSiliermittelTanks.tank1#index"));
end;

function FlieglMain_Extension_Car:delete()
end;

function FlieglMain_Extension_Car:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FlieglMain_Extension_Car:keyEvent(unicode, sym, modifier, isDown)
end;

function FlieglMain_Extension_Car:update(dt)
end;

function FlieglMain_Extension_Car:updateTick(dt)
	if self.choosenProductType[self.productType][1] == g_i18n:getText("TRANSPORTBOX") then
		setVisibility(self.spanngurt.transportboxen.box1, self.fillLevel == 1);
	else
		setVisibility(self.spanngurt.transportboxen.box1, false);
	end;
	
	if self.choosenProductType[self.productType][1] == g_i18n:getText("SILAGE_ADDITIVES_TANK") then
		setVisibility(self.spanngurt.siliermittelTanks.tank1, self.fillLevel == 1);
	else
		setVisibility(self.spanngurt.siliermittelTanks.tank1, false);
	end;
end;

function FlieglMain_Extension_Car:draw()
end;